/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraCommand;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.TeeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTrigger {
    static final Logger logger = LoggerFactory.getLogger(CommandTrigger.class);
    static final AraraLocalization localization = AraraLocalization.getInstance();
    private List<AraraCommand> commands;
    private boolean showVerboseOutput;
    private long executionTimeout;

    public CommandTrigger(List<AraraCommand> commands) {
        this.commands = commands;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setVerbose(boolean verbose) {
        this.showVerboseOutput = verbose;
    }

    public boolean execute() throws AraraException {
        logger.info(localization.getMessage("Log_ReadyToRunCommands"));
        for (AraraCommand currentAraraCommand : this.commands) {
            System.out.print(localization.getMessage("Msg_RunningCommand", currentAraraCommand.getName()).concat(" "));
            if (this.showVerboseOutput) {
                System.out.println("\n");
            }
            logger.info(localization.getMessage("Log_CommandName", currentAraraCommand.getName()));
            logger.trace(localization.getMessage("Log_Command", currentAraraCommand.getCommand()));
            if (!this.runCommand(currentAraraCommand)) {
                System.out.println(localization.getMessage("Msg_Failure"));
                logger.warn(localization.getMessage("Log_CommandFailure", currentAraraCommand.getName()));
                return false;
            }
            System.out.println(localization.getMessage("Msg_Success"));
            logger.info(localization.getMessage("Log_CommandSuccess", currentAraraCommand.getName()));
            if (!this.showVerboseOutput) continue;
            System.out.println("");
        }
        logger.info(localization.getMessage("Log_AllCommandsSuccess"));
        return true;
    }

    private boolean runCommand(AraraCommand command) throws AraraException {
        ByteArrayOutputStream stringLogger = new ByteArrayOutputStream();
        try {
            PumpStreamHandler streamHandler;
            String query = command.getCommand();
            CommandLine commandLine = CommandLine.parse(query);
            if (this.showVerboseOutput) {
                TeeOutputStream tee = new TeeOutputStream(System.out, stringLogger);
                streamHandler = new PumpStreamHandler(tee, tee, System.in);
            } else {
                TeeOutputStream tee = new TeeOutputStream(stringLogger);
                streamHandler = new PumpStreamHandler(tee);
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler(streamHandler);
            if (this.executionTimeout > 0L) {
                ExecuteWatchdog watchDog = new ExecuteWatchdog(this.executionTimeout);
                executor.setWatchdog(watchDog);
            }
            ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
            executor.setProcessDestroyer(processDestroyer);
            int exitValue = executor.execute(commandLine);
            if (this.showVerboseOutput) {
                System.out.print(localization.getMessage("Msg_Status").concat(" "));
            }
            logger.trace(localization.getMessage("Log_OutputLogging"));
            logger.trace(stringLogger.toString());
            return exitValue == 0;
        }
        catch (ExecuteException executeException) {
            logger.trace(localization.getMessage("Log_OutputLogging"));
            logger.trace(stringLogger.toString());
            return false;
        }
        catch (IOException ioException) {
            logger.error(localization.getMessage("Log_CommandNotFound", command.getName(), command.getCommand()));
            throw new AraraException(localization.getMessage("Error_CommandNotFound", command.getName(), command.getCommand()));
        }
    }
}

