'\"
'\" Generated from file 'cron\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2016 Sean Woods <yoda@etoyoc\&.com>
'\"
.TH "cron" n 2\&.0 tcllib "cron"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cron \- Tool for automating the period callback of commands
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBcron  ?2\&.0?\fR
.sp
\fB::cron::at\fR \fI?processname?\fR \fItimecode\fR \fIcommand\fR
.sp
\fB::cron::cancel\fR \fIprocessname\fR
.sp
\fB::cron::every\fR \fIprocessname\fR \fIfrequency\fR \fIcommand\fR
.sp
\fB::cron::in\fR \fI?processname?\fR \fItimecode\fR \fIcommand\fR
.sp
\fB::cron::object_coroutine\fR \fIobject\fR \fIcoroutine\fR \fI?info?\fR
.sp
\fB::cron::sleep\fR \fImilliseconds\fR
.sp
\fB::cron::task delete\fR \fIprocess\fR
.sp
\fB::cron::task exists\fR \fIprocess\fR
.sp
\fB::cron::task info\fR \fIprocess\fR
.sp
\fB::cron::task set\fR \fIprocess\fR \fIfield\fR \fIvalue\fR \fI?field\&.\&.\&.?\fR \fI?value\&.\&.\&.?\fR
.sp
\fB::cron::wake\fR \fI?who?\fR
.sp
\fB::cron::clock_step\fR \fImilleseconds\fR
.sp
\fB::cron::clock_delay\fR \fImilleseconds\fR
.sp
\fB::cron::clock_sleep\fR \fIseconds\fR \fI?offset?\fR
.sp
\fB::cron::clock_set\fR \fInewtime\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBcron\fR package provides a Pure-tcl set of tools to allow
programs to schedule tasks to occur at regular intervals\&. Rather than
force each task to issue it's own call to the event loop, the cron
system mimics the cron utility in Unix: on task periodically checks to
see if something is to be done, and issues all commands for a given
time step at once\&.
.PP
Changes in version 2\&.0
.PP
While cron was originally designed to handle time scales > 1 second, the
latest version's internal understand time granularity down to the millisecond,
making it easier to integrate with other timed events\&.
Version 2\&.0 also understands how to properly integrate coroutines and objects\&.
It also adds a facility for an external (or script driven) clock\&. Note that vwait style events
won't work very well with an external clock\&.
.SH COMMANDS
.TP
\fB::cron::at\fR \fI?processname?\fR \fItimecode\fR \fIcommand\fR
This command registers a \fIcommand\fR to be called at the time specified by \fItimecode\fR\&.
If \fItimecode\fR is expressed as an integer, the timecode is assumed to be in unixtime\&. All
other inputs will be interpreted by \fBclock scan\fR and converted to unix time\&.
This task can be modified by subsequent calls to
this package's commands by referencing \fIprocessname\fR\&. If \fIprocessname\fR exists,
it will be replaced\&.
If \fIprocessname\fR is not given, one is generated and returned by the command\&.
.CS


::cron::at start_coffee {Tomorrow at 9:00am}  {remote::exec::coffeepot power on}
::cron::at shutdown_coffee {Tomorrow at 12:00pm}  {remote::exec::coffeepot power off}

.CE
.TP
\fB::cron::cancel\fR \fIprocessname\fR
This command unregisters the process \fIprocessname\fR and cancels any pending commands\&.
Note: processname can be a process created by either \fB::cron::at\fR or \fB::cron::every\fR\&.
.CS


::cron::cancel check_mail

.CE
.TP
\fB::cron::every\fR \fIprocessname\fR \fIfrequency\fR \fIcommand\fR
This command registers a \fIcommand\fR to be called at the interval of \fIfrequency\fR\&.
\fIfrequency\fR is given in seconds\&. This task can be modified by subsequent calls to
this package's commands by referencing \fIprocessname\fR\&. If \fIprocessname\fR exists,
it will be replaced\&.
.CS


::cron::every check_mail 900  ::imap_client::check_mail
::cron::every backup_db  3600 {::backup_procedure ::mydb}

.CE
.TP
\fB::cron::in\fR \fI?processname?\fR \fItimecode\fR \fIcommand\fR
This command registers a \fIcommand\fR to be called after a delay of time specified by \fItimecode\fR\&.
\fItimecode\fR is expressed as an seconds\&.
This task can be modified by subsequent calls to
this package's commands by referencing \fIprocessname\fR\&. If \fIprocessname\fR exists,
it will be replaced\&.
If \fIprocessname\fR is not given, one is generated and returned by the command\&.
.TP
\fB::cron::object_coroutine\fR \fIobject\fR \fIcoroutine\fR \fI?info?\fR
This command registers a \fIcoroutine\fR, associated with \fIobject\fR to be called
given the parameters of \fIinfo\fR\&. If now parameters are given, the coroutine is assumed
to be an idle task which will self-terminate\&. \fIinfo\fR can be given in any form compadible with
\fB::cron::task set\fR
.TP
\fB::cron::sleep\fR \fImilliseconds\fR
When run within a coroutine, this command will register the coroutine for a callback
at the appointed time, and immediately yield\&.
.sp
If the ::cron::time variable is > 0 this command will advance the internal time,
100ms at a time\&.
.sp
In all other cases this command will generate a fictious variable, generate an
after call, and vwait the variable:
.CS


set eventid [incr ::cron::eventcount]
set var ::cron::event_#$eventid
set $var 0
::after $ms "set $var 1"
::vwait $var
::unset $var

.CE
.sp
Usage:
.CS


::cron::sleep 250

.CE
.TP
\fB::cron::task delete\fR \fIprocess\fR
Delete the process specified the \fIprocess\fR
.TP
\fB::cron::task exists\fR \fIprocess\fR
Returns true if \fIprocess\fR is registered with cron\&.
.TP
\fB::cron::task info\fR \fIprocess\fR
Returns a dict describing \fIprocess\fR\&. See \fB::cron::task set\fR for a description of the options\&.
.TP
\fB::cron::task set\fR \fIprocess\fR \fIfield\fR \fIvalue\fR \fI?field\&.\&.\&.?\fR \fI?value\&.\&.\&.?\fR
.sp
If \fIprocess\fR does not exist, it is created\&. Options Include:
.RS
\fBcommand\fR
If \fBcoroutine\fR is black, a global command which implements this process\&. If \fBcoroutine\fR is not
black, the command to invoke to create or recreate the coroutine\&.
\fBcoroutine\fR
The name of the coroutine (if any) which implements this process\&.
\fBfrequency\fR
If -1, this process is terminated after the next event\&. If 0 this process should be called during every
idle event\&. If positive, this process should generate events periodically\&. The frequency is an interger number
of milleseconds between events\&.
\fBobject\fR
The object associated with this process or coroutine\&.
\fBscheduled\fR
If non-zero, the absolute time from the epoch (in milleseconds) that this process will trigger an event\&.
If zero, and the \fBfrequency\fR is also zero, this process is called every idle loop\&.
\fBrunning\fR
A boolean flag\&. If true it indicates the process never returned or yielded during the event loop,
and will not be called again until it does so\&.
.RE
.TP
\fB::cron::wake\fR \fI?who?\fR
Wake up cron, and arrange for its event loop to be run during the next Idle cycle\&.
.CS


::cron::wake {I just did something important}

.CE
.PP
.PP
Several utility commands are provided that are used internally within cron and for
testing cron, but may or may not be useful in the general cases\&.
.TP
\fB::cron::clock_step\fR \fImilleseconds\fR
.sp
Return a clock time absolute to the epoch which falls on the next
border between one second and the next for the value of \fImilleseconds\fR
.TP
\fB::cron::clock_delay\fR \fImilleseconds\fR
.sp
Return a clock time absolute to the epoch which falls on the next
border between one second and the next \fImilleseconds\fR in the future\&.
.TP
\fB::cron::clock_sleep\fR \fIseconds\fR \fI?offset?\fR
.sp
Return a clock time absolute to the epoch which falls exactly \fIseconds\fR in
the future\&. If offset is given it may be positive or negative, and will shift
the final time to before or after the second would flip\&.
.TP
\fB::cron::clock_set\fR \fInewtime\fR
.sp
Sets the internal clock for cron\&. This command will advance the time in 100ms
increment, triggering events, until the internal time catches up with \fInewtime\fR\&.
.sp
\fInewtime\fR is expressed in absolute milleseconds since the beginning of the epoch\&.
.PP
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIodie\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
cron, odie
.SH CATEGORY
System
.SH COPYRIGHT
.nf
Copyright (c) 2016 Sean Woods <yoda@etoyoc\&.com>

.fi