/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.mpp.TimescaleUnits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimescaleUtility {
    private int m_weekStartDay = 2;

    public final ArrayList<DateRange> createTimescale(Date date, TimescaleUnits timescaleUnits, int n) {
        int n2;
        int n3;
        int n4;
        ArrayList<DateRange> arrayList = new ArrayList<DateRange>(n);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (timescaleUnits) {
            case MINUTES: {
                n4 = 12;
                n3 = 1;
                break;
            }
            case HOURS: {
                n4 = 11;
                n3 = 1;
                break;
            }
            case WEEKS: {
                calendar.set(7, this.m_weekStartDay);
                n4 = 6;
                n3 = 7;
                break;
            }
            case THIRDS_OF_MONTHS: {
                calendar.set(5, 1);
                n4 = 6;
                n3 = 10;
                break;
            }
            case MONTHS: {
                calendar.set(5, 1);
                n4 = 2;
                n3 = 1;
                break;
            }
            case QUARTERS: {
                n2 = calendar.get(2);
                int n5 = n2 / 3;
                int n6 = n5 * 3;
                calendar.set(5, 1);
                calendar.set(2, n6);
                n4 = 2;
                n3 = 3;
                break;
            }
            case HALF_YEARS: {
                n2 = calendar.get(2);
                int n5 = n2 / 6;
                int n6 = n5 * 6;
                calendar.set(5, 1);
                calendar.set(2, n6);
                n4 = 2;
                n3 = 6;
                break;
            }
            case YEARS: {
                calendar.set(5, 1);
                calendar.set(2, 0);
                n4 = 1;
                n3 = 1;
                break;
            }
            default: {
                n4 = 6;
                n3 = 1;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            Date date2 = calendar.getTime();
            if (timescaleUnits == TimescaleUnits.THIRDS_OF_MONTHS && (n2 + 1) % 3 == 0) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.set(5, 1);
                calendar.add(2, 1);
            } else {
                calendar.add(n4, n3);
            }
            calendar.add(14, -1);
            arrayList.add(new DateRange(date2, calendar.getTime()));
            calendar.add(14, 1);
        }
        return arrayList;
    }

    public void setWeekStartDay(int n) {
        this.m_weekStartDay = n;
    }

    public int getWeekStartDay() {
        return this.m_weekStartDay;
    }
}

