/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.AstaDataType;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.common.NumberHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SqliteResultSetRow
extends MapRow {
    public SqliteResultSetRow(ResultSet resultSet, Map<String, Integer> map) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Object object;
            String string = entry.getKey().toUpperCase();
            int n = entry.getValue();
            switch (n) {
                case -7: 
                case 16: {
                    object = resultSet.getBoolean(string);
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    object = resultSet.getString(string);
                    break;
                }
                case 91: {
                    Object object2 = resultSet.getString(string);
                    if (object2 == null || ((String)object2).isEmpty()) {
                        object = null;
                        break;
                    }
                    object = resultSet.getDate(string);
                    break;
                }
                case 93: {
                    Object object2 = resultSet.getTimestamp(string);
                    if (object2 != null) {
                        object = new Date(((Timestamp)object2).getTime());
                        break;
                    }
                    object = null;
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    object = NumberHelper.getDouble(resultSet.getDouble(string));
                    break;
                }
                case 4: 
                case 5: {
                    object = resultSet.getInt(string);
                    break;
                }
                case -5: {
                    object = resultSet.getLong(string);
                    break;
                }
                case -4: 
                case -3: {
                    object = resultSet.getBytes(string);
                    break;
                }
                case 1111: {
                    object = resultSet.getObject(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + n + " for column " + string);
                }
            }
            if (resultSet.wasNull()) {
                object = null;
            }
            this.m_map.put(string, object);
        }
    }

    @Override
    public Duration getDuration(String string) {
        Number number;
        String string2 = this.getString(string);
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Unexpected duration value");
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Unexpected duration value: " + string2);
        }
        String string3 = AstaDataType.parseString(stringArray[2]);
        try {
            number = AstaDataType.parseDouble(string3);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Unexpected duration value", parseException);
        }
        return Duration.getInstance(NumberHelper.getDouble(number), TimeUnit.HOURS);
    }
}

