/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.configuration.Dictionary;
import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.gantt.link_routing.DefaultGanttLinkRouting;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.graph.LinkRouting;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;

public class GanttParamsImpl
implements GanttParams,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2314555242629487089L;
    protected NodeModelCache cache;
    protected BarStyles barStyles;
    protected GraphicConfiguration configuration;
    protected Font columnHeaderFont;
    protected LinkRouting routing = new DefaultGanttLinkRouting();
    protected CoordinatesConverter coord;
    protected Rectangle printBounds;
    protected boolean rightPartVisible = true;
    protected boolean leftPartVisible = true;
    protected int rowHeight;
    protected boolean supportLeftAndRightParts = false;

    public GanttParamsImpl() {
        this.configuration = GraphicConfiguration.getInstance();
        this.barStyles = (BarStyles)Dictionary.get("BarStylesCategory", "standard");
        this.columnHeaderFont = new Font("Default", 0, 10);
        this.routing = new DefaultGanttLinkRouting();
        this.rowHeight = this.configuration.getRowHeight();
    }

    public GraphicConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GraphicConfiguration graphicConfiguration) {
        this.configuration = graphicConfiguration;
    }

    public BarStyles getBarStyles() {
        return this.barStyles;
    }

    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public void setCache(NodeModelCache nodeModelCache) {
        this.cache = nodeModelCache;
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
    }

    public LinkRouting getRouting() {
        return this.routing;
    }

    public void setRouting(LinkRouting linkRouting) {
        this.routing = linkRouting;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public Rectangle getGanttBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), (int)Math.ceil(this.coord.getWidth()), this.getRowHeight() * this.cache.getSize());
    }

    public Rectangle getDrawingBounds() {
        return this.getGanttBounds();
    }

    public Font getColumnHeaderFont() {
        return this.columnHeaderFont;
    }

    public void setColumnHeaderFont(Font font) {
        this.columnHeaderFont = font;
    }

    public boolean useTextures() {
        return false;
    }

    public Rectangle getPrintBounds() {
        return this.printBounds;
    }

    public void setPrintBounds(Rectangle rectangle) {
        this.printBounds = rectangle;
        this.updateDrawingBounds();
    }

    public void updateDrawingBounds() {
    }

    public int getPrintCols() {
        return (int)Math.ceil(this.getGanttBounds().getWidth() / this.getPrintBounds().getWidth());
    }

    public int getPrintRows() {
        return (int)Math.ceil(this.getGanttBounds().getHeight() / this.getPrintBounds().getHeight());
    }

    public boolean isLeftPartVisible() {
        return this.leftPartVisible;
    }

    public void setLeftPartVisible(boolean bl) {
        this.leftPartVisible = bl;
    }

    public boolean isRightPartVisible() {
        return this.rightPartVisible;
    }

    public void setRightPartVisible(boolean bl) {
        this.rightPartVisible = bl;
    }

    public boolean isSupportLeftAndRightParts() {
        return this.supportLeftAndRightParts;
    }

    public void setSupportLeftAndRightParts(boolean bl) {
        this.supportLeftAndRightParts = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public GraphParams createSafePrintCopy() {
        GanttParamsImpl ganttParamsImpl = (GanttParamsImpl)this.clone();
        if (ganttParamsImpl.printBounds != null) {
            ganttParamsImpl.printBounds = (Rectangle)ganttParamsImpl.printBounds.clone();
        }
        return ganttParamsImpl;
    }
}

