/*
 * Decompiled with CFR 0.152.
 */
package lucee.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lucee.commons.io.res.Resource;
import lucee.loader.util.Util;

public class Pack200Util {
    public static void pack2Jar(InputStream is, Resource jar, boolean closeIS) throws IOException {
        if (!jar.exists()) {
            jar.createFile(false);
        }
        Pack200Util.pack2Jar(is, jar.getOutputStream(), closeIS, true);
    }

    public static void pack2Jar(Resource p200, OutputStream os, boolean closeOS) throws IOException {
        Pack200Util.pack2Jar(p200.getInputStream(), os, true, closeOS);
    }

    public static void pack2Jar(Resource p200, Resource jar) throws IOException {
        if (!jar.exists()) {
            jar.createFile(false);
        }
        Pack200Util.pack2Jar(p200.getInputStream(), jar.getOutputStream(), true, true);
    }

    public static void pack2Jar(File p200, File jar) throws IOException {
        if (!jar.exists()) {
            jar.createNewFile();
        }
        Pack200Util.pack2Jar(new FileInputStream(p200), new FileOutputStream(jar), true, true);
    }

    public static void jar2pack(InputStream is, Resource p200, boolean closeIS) throws IOException {
        if (!p200.exists()) {
            p200.createFile(false);
        }
        Pack200Util.jar2pack(is, p200.getOutputStream(), closeIS, true);
    }

    public static void jar2pack(Resource jar, OutputStream os, boolean closeOS) throws IOException {
        Pack200Util.jar2pack(jar.getInputStream(), os, true, closeOS);
    }

    public static void jar2pack(Resource jar, Resource p200) throws IOException {
        if (!p200.exists()) {
            p200.createFile(false);
        }
        Pack200Util.jar2pack(jar.getInputStream(), p200.getOutputStream(), true, true);
    }

    public static void jar2pack(File jar, File p200) throws IOException {
        if (!p200.exists()) {
            p200.createNewFile();
        }
        Pack200Util.jar2pack(new FileInputStream(jar), new FileOutputStream(p200), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack2Jar(InputStream is, OutputStream os, boolean closeIS, boolean closeOS) throws IOException {
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        SortedMap p = unpacker.properties();
        p.put("unpack.deflate.hint", "true");
        is = new GZIPInputStream(is);
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream(os);
            unpacker.unpack(is, jos);
            jos.finish();
        }
        finally {
            if (closeIS) {
                Util.closeEL(is);
            }
            if (closeOS) {
                Util.closeEL(jos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jar2pack(InputStream is, OutputStream os, boolean closeIS, boolean closeOS) throws IOException {
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap p = packer.properties();
        p.put("pack.effort", "7");
        p.put("pack.segment.limit", "-1");
        p.put("pack.keep.file.order", "false");
        p.put("pack.modification.time", "latest");
        p.put("pack.deflate.hint", "false");
        p.put("pack.code.attribute.LineNumberTable", "strip");
        p.put("pack.unknown.attribute", "error");
        JarInputStream jis = null;
        os = new GZIPOutputStream(os);
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new DevNullOutputStream()));
            jis = new JarInputStream(is);
            packer.pack(jis, os);
        }
        catch (Throwable throwable) {
            System.setErr(err);
            if (closeIS) {
                Util.closeEL(jis);
            }
            if (closeOS) {
                Util.closeEL(os);
            }
            throw throwable;
        }
        System.setErr(err);
        if (closeIS) {
            Util.closeEL(jis);
        }
        if (closeOS) {
            Util.closeEL(os);
        }
    }

    public static final class DevNullOutputStream
    extends OutputStream
    implements Serializable {
        private DevNullOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(int b) {
        }
    }
}

