/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011aBN\u0005\u0003o=\u0011A\u0001V5nK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001bO\u001fD\u0013\ta\u0014BA\u0005Gk:\u001cG/[8ocA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>lWn\u001c8\n\u0005\t{$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011\u0001\u0002R\u0005\u0003\u000b&\u0011A!\u00168ji\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0012\"\u0013&L\u00196su\nU)\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bG\u0001\u00049\u0002\"B\u000fG\u0001\u0004y\u0002\"\u0002\u0014G\u0001\u00049\u0002\"\u0002\u0015G\u0001\u00049\u0002\"\u0002\u0016G\u0001\u0004Y\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"\u0002\u001bG\u0001\u0004)\u0004\"B\u001dG\u0001\u0004Q\u0004bB*\u0001\u0005\u0004%\t\u0005V\u0001\u000bY><w-\u001a:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013)\u0016a\u00037pO\u001e,'OT1nK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-A\bti\u0006$8/\u00168eKJd\u00170\u001b8h+\u0005\u0011\u0007\u0003\u0002\u0005dK\u0016L!\u0001Z\u0005\u0003\rQ+\b\u000f\\33!\t\u0001c-\u0003\u0002h\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001c\u001d;biN,f\u000eZ3sYfLgn\u001a\u0011\t\u000b-\u0004A\u0011\u00017\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015DqA\u001c\u0001A\u0002\u0013%q.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gf\u000b1A\\5p\u0013\t)(O\u0001\u0006CsR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005\rK\bb\u0002>w\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0004B\u0002?\u0001A\u0003&\u0001/A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003b\u0002@\u0001\u0001\u0004%Ia\\\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004\u0005yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002D\u0003\u000bAqA_@\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0015\u00029\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u00055\u0001\u0001\"\u0001\u0003\u0003\u001f\tQa\u00197fC:$B!!\u0005\u0002\u0018A\u0019\u0001\"a\u0005\n\u0007\u0005U\u0011B\u0001\u0003M_:<\u0007\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0011\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002$\u0001!\tAAA\u0013\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1)a\n\u00020\u0005\u0015\u0013\u0011\n\u0005\b\u0007\u0005\u0005\u0002\u0019AA\u0015!\r\u0001\u00131F\u0005\u0004\u0003[\u0011!a\u0001'pO\"A\u0011\u0011GA\u0011\u0001\u0004\t\u0019$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0004A\u0005\u0005\u0013bAA\"\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013\u0011\u0005a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005-\u0013\u0011\u0005a\u0001\u0003#\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0002\u0002R\u0005I1\r\\3b]&sGo\u001c\u000b\f\u0007\u0006M\u0013qKA.\u0003?\n\t\u0007C\u0004\u0002V\u00055\u0003\u0019A\u001f\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002Z\u00055\u0003\u0019AA \u0003\u0019\u0019x.\u001e:dK\"A\u0011QLA'\u0001\u0004\ty$\u0001\u0003eKN$\bbBA$\u0003\u001b\u0002\ra\b\u0005\t\u0003G\ni\u00051\u0001\u0002f\u0005i!/\u001a;bS:$U\r\\3uKN\u00042\u0001CA4\u0013\r\tI'\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\n1b\u001a:po\n+hMZ3sgR\t1\tC\u0004\u0002t\u0001!\t!a\u001c\u0002\u001dI,7\u000f^8sK\n+hMZ3sg\"A\u0011q\u000f\u0001\u0005\u0002\t\tI(A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0005\u0002|\u0005M\u00151TAP!\u0019\ti(!$\u000249!\u0011qPAE\u001d\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC+\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003\u0017K\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0003MSN$(bAAF\u0013!A\u0011\u0011GA;\u0001\u0004\t)\n\u0005\u0004\u00026\u0005]\u0015qH\u0005\u0005\u00033\u000b9D\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\ti*!\u001eA\u0002]\tq!\\1y'&TX\rC\u0004\u0002\"\u0006U\u0004\u0019A\f\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u0011\u0005\u0015\u0006\u0001\"\u0001\u0003\u0003O\u000baBY;jY\u0012|eMZ:fi6\u000b\u0007\u000f\u0006\u0006\u0002\u0012\u0005%\u00161VAX\u0003gCqaAAR\u0001\u0004\tI\u0003\u0003\u0005\u0002.\u0006\r\u0006\u0019AA\t\u0003\u0015\u0019H/\u0019:u\u0011!\t\t,a)A\u0002\u0005E\u0011aA3oI\"9\u0011qIAR\u0001\u0004y\u0002bBA\\\u0001\u0011%\u0011\u0011X\u0001\u0019EVLG\u000eZ(gMN,G/T1q\r>\u00148+Z4nK:$H\u0003CA\t\u0003w\u000bi,!1\t\u000f\u0005U\u0013Q\u0017a\u0001{!A\u0011qXA[\u0001\u0004\ty$A\u0004tK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013Q\u0017a\u0001?\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return (CleanerStats)this.statsUnderlying()._1();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    public ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    });
                    log = cleanable.log();
                    this.info((Function0<String>)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    });
                    long upperBoundOffset = log.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap()) + 1L;
                    this.stats().indexDone();
                    option = log.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - log.config().deleteRetentionMs();
            }
            long deleteHorizonMs = l;
            this.info((Function0<String>)new Serializable(this, log, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$1.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.groupSegmentsBySize(log.logSegments(0L, endOffset), log.config().segmentSize(), log.config().maxIndexSize()).foreach((Function1)new Serializable(this, log, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach((Function1)new Serializable(this, log, map, deleteHorizonMs, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)new Serializable(this, old, retainDeletes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong((long)this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = old$1;
                            this.retainDeletes$1 = retainDeletes$1;
                        }
                    });
                    this.$outer.cleanInto(this.log$3.topicAndPartition(), old, this.cleaned$1, this.map$2, retainDeletes);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$11) {
                            return x$11.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            });
            log.replaceSegments(cleaned, segments);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map, boolean retainDeletes) {
        IntRef position = new IntRef(0);
        while (position.elem < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = new IntRef(0);
            messages.foreach(new Serializable(this, source, map, retainDeletes, position, messagesRead){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final LogSegment source$1;
                private final OffsetMap map$3;
                private final boolean retainDeletes$2;
                private final IntRef position$1;
                private final IntRef messagesRead$1;

                public final void apply(MessageAndOffset entry2) {
                    boolean obsoleteDelete;
                    ++this.messagesRead$1.elem;
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.position$1.elem += size2;
                    this.$outer.stats().readMessage(size2);
                    ByteBuffer key = entry2.message().key();
                    Predef$.MODULE$.require(key != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanInto$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Found null key in log segment %s which is marked as dedupe.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.source$1.log().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    long foundOffset = this.map$3.get(key);
                    boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
                    boolean bl = obsoleteDelete = !this.retainDeletes$2 && entry2.message().isNull();
                    if (!redundant && !obsoleteDelete) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                        this.$outer.stats().recopyMessage(size2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                    this.map$3 = map$3;
                    this.retainDeletes$2 = retainDeletes$2;
                    this.position$1 = position$1;
                    this.messagesRead$1 = messagesRead$1;
                }
            });
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIoBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append((Object)BoxesRunTime.boxToInteger((int)this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List list;
            List list2;
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)list2.head()}));
            long logSize = ((LogSegment)list2.head()).size();
            int indexSize = ((LogSegment)list2.head()).index().sizeInBytes();
            list2 = (List)list2.tail();
            while (!list2.isEmpty() && logSize + ((LogSegment)list2.head()).size() < (long)maxSize && indexSize + ((LogSegment)list2.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)list2.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)list2.head()).size();
                indexSize += ((LogSegment)list2.head()).index().sizeInBytes();
                list2 = (List)list2.tail();
            }
            list = list.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public long buildOffsetMap(Log log, long start, long end, OffsetMap map) {
        map.clear();
        Seq dirty = log.logSegments(start, end).toSeq();
        this.info((Function0<String>)new Serializable(this, log, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Seq dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        });
        LongRef offset = new LongRef(((LogSegment)dirty.head()).baseOffset());
        Predef$.MODULE$.require(offset.elem == start, (Function0)new Serializable(this, log, start, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final LongRef offset$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.offset$1.elem), this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.offset$1 = offset$1;
            }
        });
        long minStopOffset = (long)((double)start + (double)map.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty.foreach((Function1)new Serializable(this, log, map, offset, minStopOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final OffsetMap map$1;
            private final LongRef offset$1;
            private final long minStopOffset$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$2.topicAndPartition());
                if (segment.baseOffset() <= this.minStopOffset$1 || this.map$1.utilization() < this.$outer.kafka$log$Cleaner$$dupBufferLoadFactor) {
                    this.offset$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicAndPartition(), segment, this.map$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.map$1 = map$1;
                this.offset$1 = offset$1;
                this.minStopOffset$1 = minStopOffset$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        });
        return offset.elem;
    }

    public long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map) {
        IntRef position = new IntRef(0);
        LongRef offset = new LongRef(segment.baseOffset());
        while (position.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position.elem;
            messages.foreach(new Serializable(this, map, position, offset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final OffsetMap map$4;
                private final IntRef position$2;
                private final LongRef offset$2;

                public final void apply(MessageAndOffset entry2) {
                    Message message = entry2.message();
                    Predef$.MODULE$.require(message.hasKey());
                    int size2 = MessageSet$.MODULE$.entrySize(message);
                    this.position$2.elem += size2;
                    this.map$4.put(message.key(), entry2.offset());
                    this.offset$2.elem = entry2.offset();
                    this.$outer.stats().indexMessage(size2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.map$4 = map$4;
                    this.position$2 = position$2;
                    this.offset$2 = offset$2;
                }
            });
            if (position.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.statsUnderlying = new Tuple2((Object)new CleanerStats(time), (Object)new CleanerStats(time));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

