/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lang.DisposedException;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.uno.RuntimeException;

public class JobQueue {
    private static final boolean DEBUG = false;
    protected Job _head;
    protected Job _tail;
    protected ThreadId _threadId;
    protected int _ref_count = 0;
    protected boolean _createThread;
    protected boolean _createThread_now;
    protected Thread _worker_thread;
    protected Object _disposeId;
    protected Object _doDispose = null;
    protected Throwable _throwable;
    protected JobQueue _async_jobQueue;
    protected JobQueue _sync_jobQueue;
    protected boolean _active = false;
    protected JavaThreadPoolFactory _javaThreadPoolFactory;

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = ThreadId.createFresh();
        this._sync_jobQueue = javaThreadPoolFactory.getJobQueue(threadId);
        if (this._sync_jobQueue == null) {
            this._sync_jobQueue = new JobQueue(javaThreadPoolFactory, threadId, true);
            this._sync_jobQueue.acquire();
        }
        this._sync_jobQueue._async_jobQueue = this;
        this._createThread = true;
        this._createThread_now = true;
        this.acquire();
    }

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId, boolean bl) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = threadId;
        this._createThread = bl;
        this._createThread_now = bl;
    }

    ThreadId getThreadId() {
        return this._threadId;
    }

    synchronized void acquire() {
        if (this._ref_count <= 0 && this._sync_jobQueue == null) {
            this._javaThreadPoolFactory.addJobQueue(this);
        }
        ++this._ref_count;
    }

    synchronized void release() {
        --this._ref_count;
        if (this._ref_count <= 0) {
            if (this._sync_jobQueue == null) {
                this._javaThreadPoolFactory.removeJobQueue(this);
            }
            if (this._sync_jobQueue != null) {
                this._sync_jobQueue._async_jobQueue = null;
                this._sync_jobQueue.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job removeJob(int n) {
        Job job = null;
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            boolean bl = false;
            while (!(this._head != null || n != 0 && bl)) {
                if (this._doDispose == this._disposeId) {
                    this._doDispose = null;
                    throw (DisposedException)new DisposedException().initCause(this._throwable);
                }
                this.notifyAll();
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                }
                bl = true;
            }
            if (this._head != null) {
                Job job2 = this._head;
                this._head = this._head._next;
                if (this._head == null) {
                    this._tail = null;
                }
                job = job2;
                this._active = true;
            }
        }
        if (job != null && this._async_jobQueue != null) {
            jobQueue = this._async_jobQueue;
            synchronized (jobQueue) {
                while (this._async_jobQueue._active || this._async_jobQueue._head != null) {
                    if (this._doDispose == this._disposeId) {
                        this._doDispose = null;
                        throw (DisposedException)new DisposedException().initCause(this._throwable);
                    }
                    try {
                        this._async_jobQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                    }
                }
            }
        }
        return job;
    }

    synchronized void putJob(Job job, Object object) {
        if (this._tail != null) {
            this._tail._next = job;
        } else {
            this._head = job;
        }
        this._tail = job;
        if (this._worker_thread == null && this._createThread && this._createThread_now) {
            this.acquire();
            this._createThread_now = false;
            new JobDispatcher(object).start();
        }
        this.notifyAll();
    }

    Object enter(Object object) throws Throwable {
        return this.enter(0, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enter(int n, Object object) throws Throwable {
        boolean bl = false;
        Object object2 = this._disposeId;
        this._disposeId = object;
        Object object3 = null;
        Thread thread = this._worker_thread;
        this._worker_thread = Thread.currentThread();
        while (!bl) {
            Job job = null;
            try {
                job = this.removeJob(n);
                if (job != null) {
                    try {
                        object3 = job.execute();
                    }
                    finally {
                        this._active = false;
                    }
                    if (!job.isRequest()) {
                        job.dispose();
                        bl = true;
                    }
                    job = null;
                    continue;
                }
                bl = true;
            }
            finally {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    if (job != null || bl && this._head == null) {
                        this._worker_thread = thread;
                        this._createThread_now = true;
                        this._disposeId = object2;
                        if (this._sync_jobQueue != null) {
                            this.notifyAll();
                        }
                    } else {
                        bl = false;
                    }
                }
            }
        }
        return object3;
    }

    synchronized void dispose(Object object, Throwable throwable) {
        if (this._sync_jobQueue == null) {
            this._doDispose = object;
            this._throwable = throwable;
            this.notifyAll();
        }
    }

    class JobDispatcher
    extends Thread {
        Object _disposeId;

        JobDispatcher(Object object) {
            super("JobDispatcher");
            this._disposeId = object;
        }

        ThreadId getThreadId() {
            return JobQueue.this._threadId;
        }

        public void run() {
            try {
                JobQueue.this.enter(2000, this._disposeId);
            }
            catch (Throwable throwable) {
                if (JobQueue.this._head != null || JobQueue.this._active) {
                    System.err.println(this.getClass().getName() + " - exception occurred:" + throwable);
                    throwable.printStackTrace(System.err);
                }
            }
            finally {
                JobQueue.this.release();
            }
        }
    }
}

