/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontFamily;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class AWTFontRegistry
implements FontRegistry {
    private static FontCache secondLevelCache;
    private HashMap fontFamilyCache = new HashMap();

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    public void initialize() {
    }

    public FontCache getSecondLevelCache() {
        return AWTFontRegistry.internalGetSecondLevelCache();
    }

    public FontMetricsFactory createMetricsFactory() {
        return new AWTFontMetricsFactory();
    }

    public FontFamily getFontFamily(String name) {
        AWTFontFamily fontFamily = (AWTFontFamily)this.fontFamilyCache.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        AWTFontFamily awtFontFamily = new AWTFontFamily(name);
        this.fontFamilyCache.put(name, awtFontFamily);
        return awtFontFamily;
    }

    public String[] getRegisteredFamilies() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return genv.getAvailableFontFamilyNames();
    }

    public String[] getAllRegisteredFamilies() {
        return this.getRegisteredFamilies();
    }
}

