/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.report.ReportDataFactory;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.i18n.DefaultResourceBundleFactory;
import org.jfree.report.i18n.ResourceBundleFactory;
import org.jfree.report.util.ReportParameters;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class DefaultReportJob
implements ReportJob {
    private ReportStructureRoot report;
    private ReportDataFactory dataFactory;
    private ReportParameters parameters;
    private ModifiableConfiguration configuration;
    private ResourceBundleFactory resourceBundleFactory = new DefaultResourceBundleFactory();
    private String name;

    public DefaultReportJob(ReportStructureRoot reportStructureRoot) {
        this.report = reportStructureRoot;
        ReportDataFactory reportDataFactory = reportStructureRoot.getDataFactory();
        if (reportDataFactory != null) {
            this.dataFactory = reportDataFactory.derive();
        }
        this.parameters = new ReportParameters(reportStructureRoot.getInputParameters());
        this.configuration = new HierarchicalConfiguration(reportStructureRoot.getConfiguration());
    }

    public ModifiableConfiguration getConfiguration() {
        return this.configuration;
    }

    public ReportParameters getParameters() {
        return this.parameters;
    }

    public ReportStructureRoot getReportStructureRoot() {
        return this.report;
    }

    public ReportDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(ReportDataFactory reportDataFactory) {
        this.dataFactory = reportDataFactory;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultReportJob defaultReportJob = (DefaultReportJob)super.clone();
        if (this.dataFactory != null) {
            defaultReportJob.dataFactory = this.dataFactory.derive();
        }
        defaultReportJob.parameters = (ReportParameters)this.parameters.clone();
        defaultReportJob.configuration = (ModifiableConfiguration)this.configuration.clone();
        return defaultReportJob;
    }

    public ReportJob derive() {
        try {
            return (ReportJob)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("A report job should always be cloneable.");
        }
    }

    public synchronized void close() {
        if (this.dataFactory != null) {
            this.dataFactory.close();
        }
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

