/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParcelDescriptor {
    public static final String PARCEL_DESCRIPTOR_NAME = "parcel-descriptor.xml";
    private static final byte[] EMPTY_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<parcel xmlns:parcel=\"scripting.dtd\" language=\"Java\">\n</parcel>".getBytes();
    private Document document = null;
    private String language = null;
    private final Map<String, String> languagedepprops = new HashMap<String, String>(3);

    public ParcelDescriptor() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }

    private ParcelDescriptor(Document document) {
        this.document = document;
        this.initLanguageProperties();
    }

    public ParcelDescriptor(InputStream inputStream) throws IOException {
        this(XMLParserFactory.getParser().parse(inputStream));
    }

    public ParcelDescriptor(File file) throws IOException {
        this(file, "Java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParcelDescriptor(File file, String string) throws IOException {
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.document = XMLParserFactory.getParser().parse(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        this.setLanguage(string);
        this.initLanguageProperties();
    }

    public void write(OutputStream outputStream) throws IOException {
        XMLParserFactory.getParser().write(this.document, outputStream);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getLanguage() {
        if (this.language == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.language = element.getAttribute("language");
        }
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
        if (this.document != null) {
            try {
                Element element = this.document.getDocumentElement();
                element.setAttribute("language", string);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public ScriptEntry[] getScriptEntries() {
        int n;
        NodeList nodeList;
        ArrayList<ScriptEntry> arrayList = new ArrayList<ScriptEntry>();
        if (this.document == null || (nodeList = this.document.getElementsByTagName("script")) == null || (n = nodeList.getLength()) == 0) {
            return new ScriptEntry[0];
        }
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2;
            String string;
            String string2 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Element element = (Element)nodeList.item(i);
            String string3 = element.getAttribute("language");
            NodeList nodeList3 = element.getElementsByTagName("locale");
            if (nodeList3 != null && (nodeList3 = nodeList3.item(0).getChildNodes()) != null) {
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    if (!nodeList3.item(j).getNodeName().equals("description")) continue;
                    CharacterData characterData = (CharacterData)nodeList3.item(j).getFirstChild();
                    string2 = characterData.getData().trim();
                }
            }
            if ((nodeList3 = element.getElementsByTagName("functionname")) == null) {
                string = "";
            } else {
                Element element2 = (Element)nodeList3.item(0);
                string = element2.getAttribute("value");
            }
            nodeList3 = element.getElementsByTagName("languagedepprops");
            if (nodeList3 != null && nodeList3.getLength() > 0 && (nodeList2 = ((Element)nodeList3.item(0)).getElementsByTagName("prop")) != null) {
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string4 = element3.getAttribute("name");
                    String string5 = element3.getAttribute("value");
                    hashMap.put(string4, string5);
                }
            }
            ScriptEntry scriptEntry = new ScriptEntry(string3, string, hashMap, string2);
            arrayList.add(scriptEntry);
        }
        return arrayList.toArray(new ScriptEntry[arrayList.size()]);
    }

    public void setScriptEntries(ScriptEntry[] scriptEntryArray) {
        this.clearEntries();
        for (ScriptEntry scriptEntry : scriptEntryArray) {
            this.addScriptEntry(scriptEntry);
        }
    }

    public void setScriptEntries(Iterator<ScriptEntry> iterator) {
        this.clearEntries();
        while (iterator.hasNext()) {
            this.addScriptEntry(iterator.next());
        }
    }

    private String getLanguageProperty(String string) {
        return this.languagedepprops.get(string);
    }

    private void initLanguageProperties() {
        int n;
        NodeList nodeList = this.document.getElementsByTagName("languagedepprops");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = 0; i < n; ++i) {
                int n2;
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getElementsByTagName("prop");
                if (nodeList2 == null || (n2 = nodeList2.getLength()) == 0) continue;
                for (int j = 0; j < n2; ++j) {
                    Element element2 = (Element)nodeList2.item(j);
                    String string = element2.getAttribute("name");
                    String string2 = element2.getAttribute("value");
                    if (this.getLanguageProperty(string) != null) continue;
                    this.languagedepprops.put(string, string2);
                }
            }
        }
    }

    private void clearEntries() {
        int n;
        Element element = this.document.getDocumentElement();
        NodeList nodeList = this.document.getElementsByTagName("script");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = n - 1; i >= 0; --i) {
                try {
                    element.removeChild(nodeList.item(i));
                    continue;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeScriptEntry(ScriptEntry scriptEntry) {
        int n;
        Element element = this.document.getDocumentElement();
        NodeList nodeList = this.document.getElementsByTagName("script");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = n - 1; i >= 0; --i) {
                try {
                    Element element2;
                    Element element3 = (Element)nodeList.item(i);
                    String string = "";
                    NodeList nodeList2 = element3.getElementsByTagName("functionname");
                    if (nodeList2 == null || !(string = (element2 = (Element)nodeList2.item(0)).getAttribute("value")).equals(scriptEntry.getLanguageName())) continue;
                    element.removeChild(element3);
                    continue;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
    }

    public void addScriptEntry(ScriptEntry scriptEntry) {
        Element element = this.document.getDocumentElement();
        Element element2 = this.document.createElement("script");
        element2.setAttribute("language", scriptEntry.getLanguage());
        Element element3 = this.document.createElement("locale");
        element3.setAttribute("lang", "en");
        Element element4 = this.document.createElement("displayname");
        element4.setAttribute("value", scriptEntry.getLogicalName());
        element3.appendChild(element4);
        element4 = this.document.createElement("description");
        String string = scriptEntry.getDescription();
        if (string == null || string.length() == 0) {
            string = scriptEntry.getLogicalName();
        }
        element4.appendChild(this.document.createTextNode(string));
        element3.appendChild(element4);
        element2.appendChild(element3);
        element3 = this.document.createElement("logicalname");
        element3.setAttribute("value", scriptEntry.getLogicalName());
        element2.appendChild(element3);
        element3 = this.document.createElement("functionname");
        element3.setAttribute("value", scriptEntry.getLanguageName());
        element2.appendChild(element3);
        if (this.languagedepprops != null && !this.languagedepprops.isEmpty()) {
            element3 = this.document.createElement("languagedepprops");
            Iterator<String> iterator = this.languagedepprops.keySet().iterator();
            while (iterator.hasNext()) {
                element4 = this.document.createElement("prop");
                String string2 = iterator.next();
                element4.setAttribute("name", string2);
                element4.setAttribute("value", this.languagedepprops.get(string2));
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

