/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerModule;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerSorter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ResolverFactory {
    private static final String AUTO_PREFIX = "org.jfree.layouting.resolver.auto.";
    private static final String COMPUTED_PREFIX = "org.jfree.layouting.resolver.computed.";
    private static final String PERCENTAGE_PREFIX = "org.jfree.layouting.resolver.percentages.";
    private static ResolverFactory factory;
    private ResolveHandlerModule[] handlers = null;
    private StyleKeyRegistry registry = StyleKeyRegistry.getRegistry();

    public static synchronized ResolverFactory getInstance() {
        if (factory == null) {
            factory = new ResolverFactory();
            factory.registerDefaults();
        }
        return factory;
    }

    private ResolverFactory() {
    }

    public void registerDefaults() {
        ArrayList<ResolveHandlerModule> arrayList = new ArrayList<ResolveHandlerModule>();
        HashMap hashMap = this.loadModules(AUTO_PREFIX);
        HashMap hashMap2 = this.loadModules(COMPUTED_PREFIX);
        HashMap hashMap3 = this.loadModules(PERCENTAGE_PREFIX);
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap.keySet());
        hashSet.addAll(hashMap2.keySet());
        hashSet.addAll(hashMap3.keySet());
        for (StyleKey styleKey : hashSet) {
            ResolveHandler resolveHandler = (ResolveHandler)hashMap.get(styleKey);
            ResolveHandler resolveHandler2 = (ResolveHandler)hashMap2.get(styleKey);
            ResolveHandler resolveHandler3 = (ResolveHandler)hashMap3.get(styleKey);
            arrayList.add(new ResolveHandlerModule(styleKey, resolveHandler, resolveHandler2, resolveHandler3));
        }
        this.handlers = arrayList.toArray(new ResolveHandlerModule[arrayList.size()]);
        this.handlers = ResolveHandlerSorter.sort(this.handlers);
    }

    private HashMap loadModules(String string) {
        HashMap<StyleKey, ResolveHandler> hashMap = new HashMap<StyleKey, ResolveHandler>();
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(string);
        int n = string.length();
        while (iterator.hasNext()) {
            String string2;
            ResolveHandler resolveHandler;
            String string3 = (String)iterator.next();
            String string4 = string3.substring(n).toLowerCase();
            StyleKey styleKey = this.registry.findKeyByName(string4);
            if (styleKey == null || (resolveHandler = (ResolveHandler)ObjectUtilities.loadAndInstantiate((String)(string2 = configuration.getConfigProperty(string3)), ResolverFactory.class, ResolveHandler.class)) == null) continue;
            hashMap.put(styleKey, resolveHandler);
        }
        return hashMap;
    }

    public void performResolve(LayoutProcess layoutProcess, LayoutElement layoutElement) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        for (int i = 0; i < this.handlers.length; ++i) {
            ResolveHandler resolveHandler;
            ResolveHandler resolveHandler2;
            ResolveHandlerModule resolveHandlerModule = this.handlers[i];
            StyleKey styleKey = resolveHandlerModule.getKey();
            CSSValue cSSValue = layoutContext.getValue(styleKey);
            ResolveHandler resolveHandler3 = resolveHandlerModule.getAutoValueHandler();
            if (resolveHandler3 != null && cSSValue instanceof CSSAutoValue) {
                resolveHandler3.resolve(layoutProcess, layoutElement, styleKey);
            }
            if ((resolveHandler2 = resolveHandlerModule.getComputedValueHandler()) != null) {
                resolveHandler2.resolve(layoutProcess, layoutElement, styleKey);
            }
            if ((resolveHandler = resolveHandlerModule.getPercentagesValueHandler()) == null) continue;
            resolveHandler.resolve(layoutProcess, layoutElement, styleKey);
        }
    }
}

