/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;

public class ListenerList<T> {
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WeakListener<T>> weakListeners = new CopyOnWriteArrayList();

    protected ListenerList() {
    }

    public synchronized void addWeakListener(T t) {
        if (this.ensureNotInList(t)) {
            while (this.weakListeners.remove(new WeakListener<Object>(null))) {
            }
            this.weakListeners.add(new WeakListener<T>(t));
        }
    }

    public synchronized void addListener(T t) {
        if (this.ensureNotInList(t)) {
            this.listeners.add(t);
        }
    }

    private boolean ensureNotInList(T t) {
        CheckParameterUtil.ensureParameterNotNull(t, "listener");
        if (this.containsListener(t)) {
            this.failAdd(t);
            return false;
        }
        return true;
    }

    protected void failAdd(T t) {
        throw new IllegalArgumentException(MessageFormat.format("Listener {0} (instance of {1}) was already registered.", t, t.getClass().getName()));
    }

    private boolean containsListener(T t) {
        return this.listeners.contains(t) || this.weakListeners.contains(new WeakListener<T>(t));
    }

    public synchronized void removeListener(T t) {
        if (!this.listeners.remove(t) && !this.weakListeners.remove(new WeakListener<T>(t))) {
            this.failRemove(t);
        }
    }

    protected void failRemove(T t) {
        throw new IllegalArgumentException(MessageFormat.format("Listener {0} (instance of {1}) was not registered before or already removed.", t, t.getClass().getName()));
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void fireEvent(EventFirerer<T> eventFirerer) {
        for (T object : this.listeners) {
            eventFirerer.fire(object);
        }
        for (WeakListener weakListener : this.weakListeners) {
            Object t = weakListener.listener.get();
            if (t == null) continue;
            eventFirerer.fire(t);
        }
    }

    public static <T> ListenerList<T> create() {
        if (Logging.isTraceEnabled()) {
            return new TracingListenerList();
        }
        return new ListenerList<T>();
    }

    public static <T> ListenerList<T> createUnchecked() {
        return new UncheckedListenerList();
    }

    private static class UncheckedListenerList<T>
    extends ListenerList<T> {
        private UncheckedListenerList() {
        }

        @Override
        protected void failAdd(T t) {
            Logging.warn("Listener was alreaady added: {0}", t);
        }

        @Override
        protected void failRemove(T t) {
            Logging.warn("Listener was removed twice or not added: {0}", t);
        }
    }

    public static class TracingListenerList<T>
    extends ListenerList<T> {
        private final HashMap<T, StackTraceElement[]> listenersAdded = new HashMap();
        private final HashMap<T, StackTraceElement[]> listenersRemoved = new HashMap();

        protected TracingListenerList() {
        }

        @Override
        public synchronized void addListener(T t) {
            super.addListener(t);
            this.listenersRemoved.remove(t);
            this.listenersAdded.put(t, Thread.currentThread().getStackTrace());
        }

        @Override
        public synchronized void addWeakListener(T t) {
            super.addWeakListener(t);
            this.listenersRemoved.remove(t);
            this.listenersAdded.put(t, Thread.currentThread().getStackTrace());
        }

        @Override
        public synchronized void removeListener(T t) {
            super.removeListener(t);
            this.listenersAdded.remove(t);
            this.listenersRemoved.put(t, Thread.currentThread().getStackTrace());
        }

        @Override
        protected void failAdd(T t) {
            Logging.trace("Previous addition of the listener");
            TracingListenerList.dumpStack(this.listenersAdded.get(t));
            super.failAdd(t);
        }

        @Override
        protected void failRemove(T t) {
            Logging.trace("Previous removal of the listener");
            TracingListenerList.dumpStack(this.listenersRemoved.get(t));
            super.failRemove(t);
        }

        private static void dumpStack(StackTraceElement ... stackTraceElementArray) {
            if (stackTraceElementArray == null) {
                Logging.trace("  - (no trace recorded)");
            } else {
                Stream.of(stackTraceElementArray).limit(20L).forEach(stackTraceElement -> Logging.trace(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " line " + stackTraceElement.getLineNumber()));
            }
        }
    }

    private static final class WeakListener<T> {
        private final WeakReference<T> listener;

        WeakListener(T t) {
            this.listener = new WeakReference<T>(t);
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass() == WeakListener.class) {
                return Objects.equals(this.listener.get(), ((WeakListener)object).listener.get());
            }
            return false;
        }

        public int hashCode() {
            Object t = this.listener.get();
            if (t == null) {
                return 0;
            }
            return t.hashCode();
        }

        public String toString() {
            return "WeakListener [listener=" + this.listener + ']';
        }
    }

    @FunctionalInterface
    public static interface EventFirerer<T> {
        public void fire(T var1);
    }
}

