/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public final class Geometry {
    private Geometry() {
    }

    public static Set<Node> addIntersections(List<Way> list, boolean bl, List<Command> list2) {
        Object object;
        int n;
        int n2 = list.size();
        ArrayList[] arrayListArray = new ArrayList[n2];
        BBox[] bBoxArray = new BBox[n2];
        boolean[] blArray = new boolean[n2];
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (int i = 0; i < n2; ++i) {
            arrayListArray[i] = new ArrayList<Node>(list.get(i).getNodes());
            bBoxArray[i] = Geometry.getNodesBounds(arrayListArray[i]);
            blArray[i] = false;
        }
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        DataSet dataSet = list.get(0).getDataSet();
        NodePositionComparator nodePositionComparator = new NodePositionComparator();
        for (n = 0; n < n2; ++n) {
            for (int i = n; i < n2; ++i) {
                if (!bBoxArray[n].intersects(bBoxArray[i])) continue;
                object = arrayListArray[n];
                ArrayList arrayList = arrayListArray[i];
                int n3 = 0;
                while (n3 + 1 < object.size()) {
                    int n4;
                    int n5 = n4 = n != i ? 0 : n3 + 2;
                    while (n5 + 1 < arrayList.size()) {
                        Node node = (Node)object.get(n3);
                        Node node2 = (Node)object.get(n3 + 1);
                        Node node3 = (Node)arrayList.get(n5);
                        Node node4 = (Node)arrayList.get(n5 + 1);
                        int n6 = 0;
                        if (node == node3 || node == node4) {
                            ++n6;
                            if (n != i || n3 != 0 || n5 != arrayList.size() - 2) {
                                linkedHashSet.add(node);
                            }
                        }
                        if (node2 == node3 || node2 == node4) {
                            ++n6;
                            linkedHashSet.add(node2);
                        }
                        if (n6 == 0) {
                            EastNorth eastNorth = Geometry.getSegmentSegmentIntersection(node.getEastNorth(), node2.getEastNorth(), node3.getEastNorth(), node4.getEastNorth());
                            if (eastNorth != null) {
                                Node node5;
                                if (bl) {
                                    linkedHashSet.add(node3);
                                    return linkedHashSet;
                                }
                                Node node6 = node5 = new Node(Main.getProjection().eastNorth2latlon(eastNorth));
                                boolean bl2 = false;
                                boolean bl3 = false;
                                if (nodePositionComparator.compare(node5, node) == 0) {
                                    node6 = node;
                                } else if (nodePositionComparator.compare(node5, node2) == 0) {
                                    node6 = node2;
                                } else {
                                    bl2 = true;
                                }
                                if (nodePositionComparator.compare(node5, node3) == 0) {
                                    node6 = node3;
                                } else if (nodePositionComparator.compare(node5, node4) == 0) {
                                    node6 = node4;
                                } else {
                                    bl3 = true;
                                }
                                if (bl2) {
                                    object.add(n3 + 1, node6);
                                    blArray[n] = true;
                                    if (i == n) {
                                        ++n5;
                                    }
                                }
                                if (bl3) {
                                    arrayList.add(n5 + 1, node6);
                                    blArray[i] = true;
                                    ++n5;
                                }
                                linkedHashSet.add(node6);
                                if (node6 == node5) {
                                    list2.add(osmDataLayer != null ? new AddCommand(osmDataLayer, (OsmPrimitive)node6) : new AddCommand(dataSet, (OsmPrimitive)node6));
                                }
                            }
                        } else if (bl && !linkedHashSet.isEmpty()) {
                            return linkedHashSet;
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
        }
        for (n = 0; n < list.size(); ++n) {
            if (!blArray[n]) continue;
            Way way = list.get(n);
            object = new Way(way);
            ((Way)object).setNodes(arrayListArray[n]);
            list2.add(new ChangeCommand(way, (OsmPrimitive)object));
        }
        return linkedHashSet;
    }

    private static BBox getNodesBounds(List<Node> list) {
        BBox bBox = new BBox(list.get(0));
        for (Node node : list) {
            bBox.add(node);
        }
        return bBox;
    }

    public static boolean isToTheRightSideOfLine(Node node, Node node2, Node node3, Node node4) {
        boolean bl = Geometry.angleIsClockwise(node, node2, node3);
        boolean bl2 = Geometry.angleIsClockwise(node, node2, node4);
        boolean bl3 = Geometry.angleIsClockwise(node2, node3, node4);
        if (bl) {
            return bl2 && bl3;
        }
        return bl2 || bl3;
    }

    public static boolean angleIsClockwise(Node node, Node node2, Node node3) {
        return Geometry.angleIsClockwise(node.getEastNorth(), node2.getEastNorth(), node3.getEastNorth());
    }

    public static EastNorth getSegmentSegmentIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "p1");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "p2");
        CheckParameterUtil.ensureValidCoordinates(eastNorth3, "p3");
        CheckParameterUtil.ensureValidCoordinates(eastNorth4, "p4");
        double d = eastNorth.getX();
        double d2 = eastNorth.getY();
        double d3 = eastNorth2.getX();
        double d4 = eastNorth2.getY();
        double d5 = eastNorth3.getX();
        double d6 = eastNorth3.getY();
        double d7 = eastNorth4.getX();
        double d8 = eastNorth4.getY();
        if (!Line2D.linesIntersect(d, d2, d3, d4, d5, d6, d7, d8)) {
            return null;
        }
        double d9 = d3 - d;
        double d10 = d5 - d7;
        double d11 = d5 - d;
        double d12 = d4 - d2;
        double d13 = d6 - d8;
        double d14 = d6 - d2;
        double d15 = d9 * d13 - d12 * d10;
        double d16 = d13 * d11 - d10 * d14;
        double d17 = d9 * d14 - d12 * d11;
        double d18 = Math.abs(d16) + Math.abs(d17);
        if (Math.abs(d15) > 1.0E-12 * d18) {
            double d19 = d16 / d15;
            double d20 = d17 / d15;
            if (d19 > -1.0E-8 && d19 < 1.00000001 && d20 > -1.0E-8 && d20 < 1.00000001) {
                if (d19 < 0.0) {
                    d19 = 0.0;
                }
                if (d19 > 1.0) {
                    d19 = 1.0;
                }
                return new EastNorth(d + d9 * d19, d2 + d12 * d19);
            }
            return null;
        }
        return null;
    }

    public static EastNorth getLineLineIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "p1");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "p2");
        CheckParameterUtil.ensureValidCoordinates(eastNorth3, "p3");
        CheckParameterUtil.ensureValidCoordinates(eastNorth4, "p4");
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth4.getY() - eastNorth3.getY();
        double d4 = eastNorth3.getX() - eastNorth4.getX();
        double d5 = d * d4 - d3 * d2;
        if (d5 == 0.0) {
            return null;
        }
        double d6 = (eastNorth4.getX() - eastNorth.getX()) * (eastNorth3.getY() - eastNorth.getY()) - (eastNorth3.getX() - eastNorth.getX()) * (eastNorth4.getY() - eastNorth.getY());
        return new EastNorth(d2 * d6 / d5 + eastNorth.getX(), -d * d6 / d5 + eastNorth.getY());
    }

    public static boolean segmentsParallel(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "p1");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "p2");
        CheckParameterUtil.ensureValidCoordinates(eastNorth3, "p3");
        CheckParameterUtil.ensureValidCoordinates(eastNorth4, "p4");
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth4.getY() - eastNorth3.getY();
        double d4 = eastNorth3.getX() - eastNorth4.getX();
        double d5 = d * d4 - d3 * d2;
        return Math.abs(d5 /= Math.sqrt(d * d + d2 * d2) * Math.sqrt(d3 * d3 + d4 * d4)) < 0.001;
    }

    private static EastNorth closestPointTo(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(eastNorth, "p1");
        CheckParameterUtil.ensureParameterNotNull(eastNorth2, "p2");
        CheckParameterUtil.ensureParameterNotNull(eastNorth3, "point");
        double d = eastNorth2.getX() - eastNorth.getX();
        double d2 = eastNorth2.getY() - eastNorth.getY();
        if (d == 0.0 && d2 == 0.0) {
            return eastNorth;
        }
        double d3 = eastNorth3.getX() - eastNorth.getX();
        double d4 = eastNorth3.getY() - eastNorth.getY();
        double d5 = (d3 * d + d4 * d2) / (d * d + d2 * d2);
        if (bl && d5 <= 0.0) {
            return eastNorth;
        }
        if (bl && d5 >= 1.0) {
            return eastNorth2;
        }
        return eastNorth.interpolate(eastNorth2, d5);
    }

    public static EastNorth closestPointToSegment(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        return Geometry.closestPointTo(eastNorth, eastNorth2, eastNorth3, true);
    }

    public static EastNorth closestPointToLine(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        return Geometry.closestPointTo(eastNorth, eastNorth2, eastNorth3, false);
    }

    public static boolean angleIsClockwise(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "commonNode");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "firstNode");
        CheckParameterUtil.ensureValidCoordinates(eastNorth3, "secondNode");
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth3.getY() - eastNorth.getY();
        double d3 = eastNorth2.getX() - eastNorth.getX();
        double d4 = eastNorth3.getX() - eastNorth.getX();
        return d * d4 - d3 * d2 > 0.0;
    }

    public static Area getArea(List<Node> list) {
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = true;
        for (Node node : list) {
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) continue;
            if (bl) {
                ((Path2D)double_).moveTo(eastNorth.getX(), eastNorth.getY());
                bl = false;
                continue;
            }
            ((Path2D)double_).lineTo(eastNorth.getX(), eastNorth.getY());
        }
        if (!bl) {
            double_.closePath();
        }
        return new Area(double_);
    }

    public static Path2D buildPath2DLatLon(List<Node> list, Path2D path2D) {
        Path2D path2D2 = path2D != null ? path2D : new Path2D.Double();
        boolean bl = true;
        for (Node node : list) {
            if (bl) {
                path2D2.moveTo(node.lon(), node.lat());
                bl = false;
                continue;
            }
            path2D2.lineTo(node.lon(), node.lat());
        }
        if (!bl) {
            path2D2.closePath();
        }
        return path2D2;
    }

    public static Area getAreaLatLon(Relation relation) {
        MapFrame mapFrame = MainApplication.getMap();
        Multipolygon multipolygon = mapFrame == null || mapFrame.mapView == null ? new Multipolygon(relation) : MultipolygonCache.getInstance().get(relation);
        Path2D.Double double_ = new Path2D.Double();
        double_.setWindingRule(0);
        for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
            Geometry.buildPath2DLatLon(polyData.getNodes(), double_);
            for (Multipolygon.PolyData polyData2 : polyData.getInners()) {
                Geometry.buildPath2DLatLon(polyData2.getNodes(), double_);
            }
        }
        return new Area(double_);
    }

    public static PolygonIntersection polygonIntersection(List<Node> list, List<Node> list2) {
        Area area = Geometry.getArea(list);
        Area area2 = Geometry.getArea(list2);
        return Geometry.polygonIntersection(area, area2);
    }

    public static PolygonIntersection polygonIntersection(Area area, Area area2) {
        return Geometry.polygonIntersection(area, area2, 1.0);
    }

    public static PolygonIntersection polygonIntersection(Area area, Area area2, double d) {
        Area area3 = new Area(area);
        area3.intersect(area2);
        Rectangle rectangle = area3.getBounds();
        if (area3.isEmpty() || rectangle.getHeight() * rectangle.getWidth() <= d) {
            return PolygonIntersection.OUTSIDE;
        }
        if (area2.getBounds2D().contains(area.getBounds2D()) && area3.equals(area)) {
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (area.getBounds2D().contains(area2.getBounds2D()) && area3.equals(area2)) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node node, List<Node> list) {
        if (list.size() < 2) {
            return false;
        }
        Node node2 = list.get(list.size() - 1);
        if (!node2.isLatLonKnown()) {
            return false;
        }
        boolean bl = false;
        for (Node node3 : list) {
            Node node4;
            Node node5;
            if (node3.equals(node2)) continue;
            if (!node3.isLatLonKnown()) {
                return false;
            }
            if (node3.getEastNorth().getY() > node2.getEastNorth().getY()) {
                node5 = node2;
                node4 = node3;
            } else {
                node5 = node3;
                node4 = node2;
            }
            EastNorth eastNorth = node.getEastNorth();
            EastNorth eastNorth2 = node2.getEastNorth();
            EastNorth eastNorth3 = node3.getEastNorth();
            EastNorth eastNorth4 = node5.getEastNorth();
            EastNorth eastNorth5 = node4.getEastNorth();
            if (eastNorth != null && eastNorth2 != null && eastNorth3 != null && eastNorth4 != null && eastNorth5 != null && eastNorth3.getY() < eastNorth.getY() == eastNorth.getY() <= eastNorth2.getY() && (eastNorth.getX() - eastNorth4.getX()) * (eastNorth5.getY() - eastNorth4.getY()) < (eastNorth5.getX() - eastNorth4.getX()) * (eastNorth.getY() - eastNorth4.getY())) {
                bl = !bl;
            }
            node2 = node3;
        }
        return bl;
    }

    public static double closedWayArea(Way way) {
        return Geometry.getAreaAndPerimeter(way.getNodes(), Projections.getProjectionByCode("EPSG:54008")).getArea();
    }

    public static double multipolygonArea(Relation relation) {
        double d = 0.0;
        MapFrame mapFrame = MainApplication.getMap();
        Multipolygon multipolygon = mapFrame == null || mapFrame.mapView == null ? new Multipolygon(relation) : MultipolygonCache.getInstance().get(relation);
        for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
            d += polyData.getAreaAndPerimeter(Projections.getProjectionByCode("EPSG:54008")).getArea();
        }
        return d;
    }

    public static Double computeArea(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Way && ((Way)osmPrimitive).isClosed()) {
            return Geometry.closedWayArea((Way)osmPrimitive);
        }
        if (osmPrimitive instanceof Relation && ((Relation)osmPrimitive).isMultipolygon() && !((Relation)osmPrimitive).hasIncompleteMembers()) {
            return Geometry.multipolygonArea((Relation)osmPrimitive);
        }
        return null;
    }

    public static boolean isClockwise(Way way) {
        return Geometry.isClockwise(way.getNodes());
    }

    public static boolean isClockwise(List<Node> list) {
        int n = list.size();
        if (n < 3 || list.get(0) != list.get(n - 1)) {
            throw new IllegalArgumentException("Way must be closed to check orientation.");
        }
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            Node node = list.get(i - 1);
            Node node2 = list.get(i % n);
            d += node.lon() * node2.lat();
            d -= node2.lon() * node.lat();
        }
        return d < 0.0;
    }

    public static double getSegmentAngle(EastNorth eastNorth, EastNorth eastNorth2) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "p1");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "p2");
        return Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
    }

    public static double getCornerAngle(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, "p1");
        CheckParameterUtil.ensureValidCoordinates(eastNorth2, "p2");
        CheckParameterUtil.ensureValidCoordinates(eastNorth3, "p3");
        Double d = Geometry.getSegmentAngle(eastNorth2, eastNorth) - Geometry.getSegmentAngle(eastNorth2, eastNorth3);
        if (d <= -Math.PI) {
            d = d + Math.PI * 2;
        }
        if (d > Math.PI) {
            d = d - Math.PI * 2;
        }
        return d;
    }

    public static EastNorth getCentroid(List<Node> list) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); ++i) {
            EastNorth eastNorth = list.get(i).getEastNorth();
            EastNorth eastNorth2 = list.get((i + 1) % list.size()).getEastNorth();
            if (eastNorth == null || eastNorth2 == null || !eastNorth.isValid() || !eastNorth2.isValid()) continue;
            BigDecimal bigDecimal4 = BigDecimal.valueOf(eastNorth.east());
            BigDecimal bigDecimal5 = BigDecimal.valueOf(eastNorth.north());
            BigDecimal bigDecimal6 = BigDecimal.valueOf(eastNorth2.east());
            BigDecimal bigDecimal7 = BigDecimal.valueOf(eastNorth2.north());
            BigDecimal bigDecimal8 = bigDecimal4.multiply(bigDecimal7, MathContext.DECIMAL128).subtract(bigDecimal5.multiply(bigDecimal6, MathContext.DECIMAL128));
            bigDecimal = bigDecimal.add(bigDecimal8, MathContext.DECIMAL128);
            bigDecimal3 = bigDecimal3.add(bigDecimal8.multiply(bigDecimal4.add(bigDecimal6, MathContext.DECIMAL128), MathContext.DECIMAL128));
            bigDecimal2 = bigDecimal2.add(bigDecimal8.multiply(bigDecimal5.add(bigDecimal7, MathContext.DECIMAL128), MathContext.DECIMAL128));
        }
        BigDecimal bigDecimal9 = new BigDecimal(3, MathContext.DECIMAL128);
        if ((bigDecimal = bigDecimal.multiply(bigDecimal9, MathContext.DECIMAL128)).compareTo(BigDecimal.ZERO) != 0) {
            bigDecimal2 = bigDecimal2.divide(bigDecimal, MathContext.DECIMAL128);
            bigDecimal3 = bigDecimal3.divide(bigDecimal, MathContext.DECIMAL128);
        }
        return new EastNorth(bigDecimal3.doubleValue(), bigDecimal2.doubleValue());
    }

    public static EastNorth getCenter(List<Node> list) {
        int n = list.size();
        if (n < 3) {
            return null;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            EastNorth eastNorth = list.get(i).getEastNorth();
            EastNorth eastNorth2 = list.get((i + 1) % n).getEastNorth();
            dArray[i] = eastNorth.east() - eastNorth2.east();
            dArray2[i] = eastNorth.north() - eastNorth2.north();
            double d = Math.sqrt(dArray[i] * dArray[i] + dArray2[i] * dArray2[i]);
            if (d == 0.0) {
                return null;
            }
            int n2 = i;
            dArray[n2] = dArray[n2] / d;
            int n3 = i;
            dArray2[n3] = dArray2[n3] / d;
            double d2 = (eastNorth.east() + eastNorth2.east()) / 2.0;
            double d3 = (eastNorth.north() + eastNorth2.north()) / 2.0;
            dArray3[i] = -(dArray[i] * d2 + dArray2[i] * d3);
        }
        double d = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
            d4 += dArray[i] * dArray2[i];
            d5 += dArray2[i] * dArray2[i];
            d6 -= dArray[i] * dArray3[i];
            d7 -= dArray2[i] * dArray3[i];
        }
        double d8 = d * d5 - d4 * d4;
        if (Math.abs(d8) < 1.0E-5) {
            return null;
        }
        double d9 = d5 / d8;
        double d10 = -d4 / d8;
        double d11 = d / d8;
        double d12 = d9 * d6 + d10 * d7;
        double d13 = d10 * d6 + d11 * d7;
        return new EastNorth(d12, d13);
    }

    public static boolean isNodeInsideMultiPolygon(Node node, Relation relation, Predicate<Way> predicate) {
        return Geometry.isPolygonInsideMultiPolygon(Collections.singletonList(node), relation, predicate);
    }

    public static boolean isPolygonInsideMultiPolygon(List<Node> list, Relation relation, Predicate<Way> predicate) {
        Pair<List<MultipolygonBuilder.JoinedPolygon>, List<MultipolygonBuilder.JoinedPolygon>> pair;
        try {
            pair = MultipolygonBuilder.joinWays(relation);
        }
        catch (MultipolygonBuilder.JoinedPolygonCreationException joinedPolygonCreationException) {
            Logging.trace(joinedPolygonCreationException);
            Logging.debug("Invalid multipolygon " + relation);
            return false;
        }
        for (MultipolygonBuilder.JoinedPolygon joinedPolygon : (List)pair.a) {
            if (!(list.size() == 1 ? Geometry.nodeInsidePolygon(list.get(0), joinedPolygon.getNodes()) : EnumSet.of(PolygonIntersection.FIRST_INSIDE_SECOND, PolygonIntersection.CROSSING).contains((Object)Geometry.polygonIntersection(list, joinedPolygon.getNodes())))) continue;
            boolean bl = false;
            for (MultipolygonBuilder.JoinedPolygon joinedPolygon2 : (List)pair.b) {
                if (Geometry.polygonIntersection(joinedPolygon2.getNodes(), joinedPolygon.getNodes()) != PolygonIntersection.FIRST_INSIDE_SECOND || !(list.size() == 1 ? Geometry.nodeInsidePolygon(list.get(0), joinedPolygon2.getNodes()) : Geometry.polygonIntersection(list, joinedPolygon2.getNodes()) == PolygonIntersection.FIRST_INSIDE_SECOND)) continue;
                bl = true;
                break;
            }
            if (bl || predicate != null && !predicate.test(joinedPolygon.ways.get(0))) continue;
            return true;
        }
        return false;
    }

    public static AreaAndPerimeter getAreaAndPerimeter(List<Node> list) {
        return Geometry.getAreaAndPerimeter(list, null);
    }

    public static AreaAndPerimeter getAreaAndPerimeter(List<Node> list, Projection projection) {
        Projection projection2;
        CheckParameterUtil.ensureParameterNotNull(list, "nodes");
        double d = 0.0;
        double d2 = 0.0;
        Projection projection3 = projection2 = projection == null ? Main.getProjection() : projection;
        if (!list.isEmpty()) {
            boolean bl = list.get(0) == list.get(list.size() - 1);
            int n = bl ? list.size() - 1 : list.size();
            EastNorth eastNorth = list.get(0).getEastNorth(projection2);
            for (int i = 1; i <= n; ++i) {
                Node node = list.get(i == n ? 0 : i);
                EastNorth eastNorth2 = node.getEastNorth(projection2);
                if (eastNorth != null && eastNorth2 != null) {
                    d += eastNorth.east() * eastNorth2.north() - eastNorth2.east() * eastNorth.north();
                    d2 += eastNorth.distance(eastNorth2);
                }
                eastNorth = eastNorth2;
            }
        }
        return new AreaAndPerimeter(Math.abs(d) / 2.0, d2);
    }

    public static class AreaAndPerimeter {
        private final double area;
        private final double perimeter;

        public AreaAndPerimeter(double d, double d2) {
            this.area = d;
            this.perimeter = d2;
        }

        public double getArea() {
            return this.area;
        }

        public double getPerimeter() {
            return this.perimeter;
        }
    }

    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

