/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;

public class MarkerSessionImporter
implements SessionLayerImporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Layer load(Element element, SessionReader.ImportSupport importSupport, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        String string = element.getAttribute("version");
        if (!"0.1".equals(string)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for marker layer is not supported. Expected: 0.1", string));
        }
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("file/text()");
            String string2 = (String)xPathExpression.evaluate(element, XPathConstants.STRING);
            if (string2 == null || string2.isEmpty()) {
                throw new IllegalDataException(I18n.tr("File name expected for layer no. {0}", importSupport.getLayerIndex()));
            }
            try (InputStream inputStream = importSupport.getInputStream(string2);){
                Layer layer;
                GpxImporter.GpxImporterData gpxImporterData = GpxImporter.loadLayers(inputStream, importSupport.getFile(string2), importSupport.getLayerName(), null, progressMonitor);
                importSupport.addPostLayersTask(gpxImporterData.getPostLayerTask());
                GpxLayer gpxLayer = null;
                List<SessionReader.LayerDependency> list = importSupport.getLayerDependencies();
                if (!list.isEmpty() && (layer = list.get(0).getLayer()) instanceof GpxLayer) {
                    gpxLayer = (GpxLayer)layer;
                }
                if ((layer = gpxImporterData.getMarkerLayer()) != null) {
                    layer.fromLayer = gpxLayer;
                }
                Layer layer2 = layer;
                return layer2;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalDataException(xPathExpressionException);
        }
    }
}

