/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public class AdvancedKeyPressDetector
implements AWTEventListener {
    private final Set<Integer> set = new TreeSet<Integer>();
    private KeyEvent releaseEvent;
    private Timer timer;
    private final List<KeyPressReleaseListener> keyListeners = new CopyOnWriteArrayList<KeyPressReleaseListener>();
    @Deprecated
    private final List<ModifierListener> modifierListeners = new CopyOnWriteArrayList<ModifierListener>();
    private final ListenerList<ModifierExListener> modifierExListeners = ListenerList.create();
    @Deprecated
    private int previousModifiers;
    private int previousModifiersEx;
    private boolean enabled = true;

    public void addKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.add(keyPressReleaseListener);
    }

    @Deprecated
    public void addModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.add(modifierListener);
    }

    public void addModifierExListener(ModifierExListener modifierExListener) {
        this.modifierExListeners.addListener(modifierExListener);
    }

    public void removeKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.remove(keyPressReleaseListener);
    }

    @Deprecated
    public void removeModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.remove(modifierListener);
    }

    public void removeModifierExListener(ModifierExListener modifierExListener) {
        this.modifierExListeners.removeListener(modifierExListener);
    }

    public void register() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Logging.warn(securityException);
        }
        this.timer = new Timer(0, actionEvent -> {
            this.timer.stop();
            if (this.set.remove(this.releaseEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                    keyPressReleaseListener.doKeyReleased(this.releaseEvent);
                }
            }
        });
    }

    public void unregister() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.set.clear();
        if (!this.keyListeners.isEmpty()) {
            Logging.warn(I18n.tr("Some of the key listeners forgot to remove themselves: {0}", new Object[0]), this.keyListeners.toString());
        }
        if (!this.modifierListeners.isEmpty()) {
            Logging.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierListeners.toString());
        }
        if (this.modifierExListeners.hasListeners()) {
            Logging.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierExListeners.toString());
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Logging.warn(securityException);
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        if (Logging.isTraceEnabled()) {
            Logging.trace("AdvancedKeyPressDetector enabled={0} => processKeyEvent({1}) from {2}", this.enabled, keyEvent, new Exception().getStackTrace()[2]);
        }
        if (keyEvent.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(keyEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                    Logging.trace("{0} => doKeyPressed({1})", keyPressReleaseListener, keyEvent);
                    keyPressReleaseListener.doKeyPressed(keyEvent);
                }
            }
        } else if (keyEvent.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(keyEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                    for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                        Logging.trace("{0} => doKeyReleased({1})", keyPressReleaseListener, keyEvent);
                        keyPressReleaseListener.doKeyReleased(keyEvent);
                    }
                }
            } else {
                this.releaseEvent = keyEvent;
                this.timer.restart();
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        int n;
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n2 = keyEvent.getModifiers();
        if (this.previousModifiers != n2) {
            this.previousModifiers = n2;
            for (ModifierListener modifierListener : this.modifierListeners) {
                modifierListener.modifiersChanged(n2);
            }
        }
        if (this.previousModifiersEx != (n = keyEvent.getModifiersEx())) {
            this.previousModifiersEx = n;
            this.modifierExListeners.fireEvent(modifierExListener -> modifierExListener.modifiersExChanged(n));
        }
        this.processKeyEvent(keyEvent);
    }

    public boolean isKeyPressed(int n) {
        return this.set.contains(n);
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
        if (Logging.isTraceEnabled()) {
            Logging.trace("AdvancedKeyPressDetector enabled={0} from {1}", bl, new Exception().getStackTrace()[1]);
        }
    }

    private static boolean isFocusInMainWindow() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component != null && SwingUtilities.getWindowAncestor(component) instanceof JFrame;
    }
}

