/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ButtonColumn;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class CacheContentsPanel
extends JPanel {
    public CacheContentsPanel() {
        super(new GridBagLayout());
        MainApplication.worker.submit(() -> {
            this.addToPanel(TMSLayer.getCache(), "TMS");
            this.addToPanel(WMSLayer.getCache(), "WMS");
            this.addToPanel(WMTSLayer.getCache(), "WMTS");
        });
    }

    private void addToPanel(CacheAccess<String, BufferedImageCacheEntry> cacheAccess, String string) {
        Long l = CacheContentsPanel.getCacheSize(cacheAccess);
        DefaultTableModel defaultTableModel = CacheContentsPanel.getTableModel(cacheAccess);
        GuiHelper.runInEDT(() -> {
            this.add((Component)new JLabel(I18n.tr("{0} cache, total cache size: {1} bytes", string, l)), GBC.eol().insets(5, 5, 0, 0));
            this.add((Component)new JScrollPane(CacheContentsPanel.getTableForCache(cacheAccess, defaultTableModel)), GBC.eol().fill(1));
        });
    }

    private static Long getCacheSize(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        ICacheStats iCacheStats = cacheAccess.getStatistics();
        for (IStats iStats : iCacheStats.getAuxiliaryCacheStats()) {
            for (IStatElement<?> iStatElement : iStats.getStatElements()) {
                Object obj;
                if (!"Data File Length".equals(iStatElement.getName()) || !((obj = iStatElement.getData()) instanceof Long)) continue;
                return (Long)obj;
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public static String[][] getCacheStats(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        Object object;
        Object object222;
        Set set = cacheAccess.getCacheControl().getKeySet();
        ConcurrentHashMap<String, int[]> concurrentHashMap = new ConcurrentHashMap<String, int[]>();
        for (Object object222 : set) {
            String[] object3 = object222.split(":", 2);
            if (object3.length == 2) {
                object = (int[])concurrentHashMap.get(object3[0]);
                if (object == null) {
                    concurrentHashMap.put(object3[0], new int[]{1});
                    continue;
                }
                object[0] = object[0] + 1;
                continue;
            }
            Logging.warn("Could not parse the key: {0}. No colon found", object222);
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            arrayList.add(new Pair(entry.getKey(), ((int[])entry.getValue())[0]));
        }
        arrayList.sort(Comparator.comparing(pair -> (Integer)pair.b, Comparator.reverseOrder()));
        object222 = new String[arrayList.size()][3];
        boolean bl = false;
        object = arrayList.iterator();
        while (object.hasNext()) {
            void var5_9;
            Pair pair2 = (Pair)object.next();
            object222[var5_9] = new String[]{(String)pair2.a, ((Integer)pair2.b).toString(), I18n.tr("Clear", new Object[0])};
            ++var5_9;
        }
        return object222;
    }

    private static JTable getTableForCache(final CacheAccess<String, BufferedImageCacheEntry> cacheAccess, final TableModel tableModel) {
        final JTable jTable = new JTable(tableModel);
        ButtonColumn buttonColumn = new ButtonColumn(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.convertRowIndexToModel(jTable.getEditingRow());
                tableModel.setValueAt("0", n, 1);
                cacheAccess.remove(jTable.getValueAt(n, 0).toString() + ':');
            }
        });
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(buttonColumn);
        tableColumn.setCellEditor(buttonColumn);
        return jTable;
    }

    private static DefaultTableModel getTableModel(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        return new DefaultTableModel(CacheContentsPanel.getCacheStats(cacheAccess), new String[]{I18n.tr("Cache name", new Object[0]), I18n.tr("Object Count", new Object[0]), I18n.tr("Clear", new Object[0])}){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 2;
            }
        };
    }
}

