/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PartiallyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;
import org.openstreetmap.josm.gui.util.RotationAngle;

public class AreaIconElement
extends StyleElement {
    private final MapImage iconImage;
    private final RotationAngle iconImageAngle;
    private final PositionForAreaStrategy iconPosition;

    protected AreaIconElement(Cascade cascade, MapImage mapImage, RotationAngle rotationAngle, PositionForAreaStrategy positionForAreaStrategy) {
        super(cascade, 4.8f);
        this.iconImage = Objects.requireNonNull(mapImage, "iconImage");
        this.iconImageAngle = Objects.requireNonNull(rotationAngle, "iconImageAngle");
        this.iconPosition = Objects.requireNonNull(positionForAreaStrategy, "iconPosition");
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        if (styledMapRenderer.isShowIcons()) {
            styledMapRenderer.drawAreaIcon(osmPrimitive, this.iconImage, styledMapRenderer.isInactiveMode() || osmPrimitive.isDisabled(), bl, bl3, this.iconImageAngle.getRotationAngle(osmPrimitive), this.iconPosition);
        }
    }

    public static AreaIconElement create(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapImage mapImage = NodeElement.createIcon(environment);
        if (mapImage != null) {
            RotationAngle rotationAngle = NodeElement.createRotationAngle(environment);
            Keyword keyword = cascade.get("icon-position", null, Keyword.class);
            PositionForAreaStrategy positionForAreaStrategy = PositionForAreaStrategy.forKeyword(keyword, PartiallyInsideAreaStrategy.INSTANCE);
            return new AreaIconElement(cascade, mapImage, rotationAngle, positionForAreaStrategy);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.iconImage == null ? 0 : this.iconImage.hashCode());
        n = 31 * n + (this.iconImageAngle == null ? 0 : this.iconImageAngle.hashCode());
        n = 31 * n + (this.iconPosition == null ? 0 : this.iconPosition.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AreaIconElement areaIconElement = (AreaIconElement)object;
        return Objects.equals(this.iconImage, areaIconElement.iconImage) && Objects.equals(this.iconImageAngle, areaIconElement.iconImageAngle) && Objects.equals(this.iconPosition, areaIconElement.iconPosition);
    }

    @Override
    public String toString() {
        return "AreaIconElement{" + super.toString() + "iconImage=[" + this.iconImage + "] iconImageAngle=[" + this.iconImageAngle + "]}";
    }
}

