/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TemplatedWMSTileSource;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class WMSLayer
extends AbstractCachedTileSourceLayer<AbstractWMSTileSource> {
    private static final String PREFERENCE_PREFIX = "imagery.wms";
    public static final IntegerProperty PROP_IMAGE_SIZE;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM;
    private static final String CACHE_REGION_NAME = "WMS";
    private final List<String> serverProjections;

    public WMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        CheckParameterUtil.ensureThat(imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS, "ImageryType is WMS");
        CheckParameterUtil.ensureParameterNotNull(imageryInfo.getUrl(), "info.url");
        TemplatedWMSTileSource.checkUrl(imageryInfo.getUrl());
        this.serverProjections = new ArrayList<String>(imageryInfo.getServerProjections());
    }

    @Override
    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings(PREFERENCE_PREFIX);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(super.getMenuEntries()));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new Layer.LayerSaveAction(this));
        arrayList.add(new Layer.LayerSaveAsAction(this));
        arrayList.add(new BookmarkWmsAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    @Override
    protected AbstractWMSTileSource getTileSource() {
        TemplatedWMSTileSource templatedWMSTileSource = new TemplatedWMSTileSource(this.info, this.chooseProjection(Main.getProjection()));
        this.info.setAttribution(templatedWMSTileSource);
        return templatedWMSTileSource;
    }

    @Override
    public Collection<String> getNativeProjections() {
        return this.serverProjections;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        super.projectionChanged(projection, projection2);
        Projection projection3 = this.chooseProjection(projection2);
        if (!Objects.equals(((AbstractWMSTileSource)this.tileSource).getTileProjection(), projection3)) {
            ((AbstractWMSTileSource)this.tileSource).setTileProjection(projection3);
        }
    }

    private Projection chooseProjection(Projection projection) {
        if (this.serverProjections.contains(projection.toCode())) {
            return projection;
        }
        for (String string : this.serverProjections) {
            Projection projection2 = Projections.getProjectionByCode(string);
            if (projection2 == null) continue;
            Logging.info(I18n.tr("Reprojecting layer {0} from {1} to {2}. For best image quality and performance, switch to one of the supported projections: {3}", this.getName(), projection2.toCode(), Main.getProjection().toCode(), Utils.join(", ", this.getNativeProjections())));
            return projection2;
        }
        Logging.warn(I18n.tr("Unable to find supported projection for layer {0}. Using {1}.", this.getName(), projection.toCode()));
        return projection;
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    static {
        new TileSourceDisplaySettings(PREFERENCE_PREFIX);
        PROP_IMAGE_SIZE = new IntegerProperty("imagery.wms.imageSize", 512);
        PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wms.default_autozoom", true);
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }
}

