/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayerImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("wms", "wms", I18n.tr("WMS Files (*.wms)", new Object[0]));

    public WMSLayerImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        EastNorth eastNorth;
        ImageryInfo imageryInfo;
        block17: {
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            imageryInfo = null;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
                int n = objectInputStream.readInt();
                if (n < 5) {
                    throw new InvalidClassException(I18n.tr("Unsupported WMS file version; found {0}, expected {1}", n, 5));
                }
                if (n == 5) {
                    objectInputStream.readInt();
                    objectInputStream.readInt();
                    eastNorth = null;
                    int n2 = objectInputStream.readInt();
                    double d = objectInputStream.readDouble();
                    String string = (String)objectInputStream.readObject();
                    String string2 = (String)objectInputStream.readObject();
                    imageryInfo = new ImageryInfo(string);
                    imageryInfo.setExtendedUrl(string2);
                    imageryInfo.setPixelPerDegree(d);
                    imageryInfo.setTileSize(n2);
                    break block17;
                }
                if (n == 6) {
                    eastNorth = (EastNorth)objectInputStream.readObject();
                    ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = Preferences.deserializeStruct((Map)objectInputStream.readObject(), ImageryInfo.ImageryPreferenceEntry.class);
                    imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    break block17;
                }
                throw new InvalidClassException(I18n.tr("Unsupported WMS file version; found {0}, expected {1}", n, 6));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalDataException(classNotFoundException);
            }
        }
        ImageryLayer imageryLayer = ImageryLayer.create(imageryInfo);
        GuiHelper.runInEDT(() -> {
            MainApplication.getLayerManager().addLayer(imageryLayer);
            if (eastNorth != null) {
                MainApplication.getMap().mapView.zoomTo(eastNorth);
            }
        });
    }
}

