/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files", new Object[0]), false);

    public NMEAImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String string = file.getName();
        try (InputStream inputStream = Compression.getUncompressedFileInputStream(file);){
            NmeaReader nmeaReader = new NmeaReader(inputStream);
            if (nmeaReader.getNumberOfCoordinates() > 0) {
                nmeaReader.data.storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(nmeaReader.data, string, true);
                File file2 = file;
                GuiHelper.runInEDT(() -> {
                    MainApplication.getLayerManager().addLayer(gpxLayer);
                    if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                        MarkerLayer markerLayer = new MarkerLayer(nmeaReader.data, I18n.tr("Markers from {0}", string), file2, gpxLayer);
                        if (!markerLayer.data.isEmpty()) {
                            MainApplication.getLayerManager().addLayer(markerLayer);
                        }
                    }
                });
            }
            NMEAImporter.showNmeaInfobox(nmeaReader.getNumberOfCoordinates() > 0, nmeaReader);
        }
    }

    private static void showNmeaInfobox(boolean bl, NmeaReader nmeaReader) {
        StringBuilder stringBuilder = new StringBuilder(160).append("<html>").append(I18n.tr("Coordinates imported: {0}", nmeaReader.getNumberOfCoordinates())).append("<br>").append(I18n.tr("Malformed sentences: {0}", nmeaReader.getParserMalformed())).append("<br>").append(I18n.tr("Checksum errors: {0}", nmeaReader.getParserChecksumErrors())).append("<br>");
        if (!bl) {
            stringBuilder.append(I18n.tr("Unknown sentences: {0}", nmeaReader.getParserUnknown())).append("<br>");
        }
        stringBuilder.append(I18n.tr("Zero coordinates: {0}", nmeaReader.getParserZeroCoordinates())).append("</html>");
        if (bl) {
            SwingUtilities.invokeLater(() -> new Notification("<h3>" + I18n.tr("NMEA import success:", new Object[0]) + "</h3>" + stringBuilder.toString()).setIcon(1).show());
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuilder.toString(), I18n.tr("NMEA import failure!", new Object[0]), 0, null);
        }
    }

    public static GpxImporter.GpxImporterData loadLayers(InputStream inputStream, File file, String string, String string2) throws IOException {
        NmeaReader nmeaReader = new NmeaReader(inputStream);
        boolean bl = nmeaReader.getNumberOfCoordinates() > 0;
        nmeaReader.data.storageFile = file;
        return GpxImporter.loadLayers(nmeaReader.data, bl, string, string2);
    }
}

