/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public abstract class FileImporter
implements Comparable<FileImporter> {
    public final ExtensionFileFilter filter;
    private boolean enabled;

    public FileImporter(ExtensionFileFilter extensionFileFilter) {
        this.filter = extensionFileFilter;
        this.enabled = true;
    }

    public boolean acceptFile(File file) {
        return this.filter.acceptName(file.getName());
    }

    public boolean isBatchImporter() {
        return false;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import ''{0}''.", file.getName()));
    }

    public void importData(List<File> list, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import files.", new Object[0]));
    }

    public boolean importDataHandleExceptions(File file, ProgressMonitor progressMonitor) {
        try {
            Logging.info("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            this.importData(file, progressMonitor);
            return true;
        }
        catch (IllegalDataException illegalDataException) {
            Throwable throwable = illegalDataException.getCause();
            if (throwable instanceof ImportCancelException) {
                FileImporter.displayCancel(throwable);
            } else {
                FileImporter.displayError(file, illegalDataException);
            }
            return false;
        }
        catch (IOException iOException) {
            FileImporter.displayError(file, iOException);
            return false;
        }
        catch (LinkageError | RuntimeException throwable) {
            BugReportExceptionHandler.handleException(throwable);
            return false;
        }
    }

    private static void displayError(File file, Exception exception) {
        Logging.error(exception);
        HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), Utils.escapeReservedCharactersHTML(exception.getMessage())), I18n.tr("Error", new Object[0]), 0, null);
    }

    private static void displayCancel(Throwable throwable) {
        GuiHelper.runInEDTAndWait(() -> {
            Notification notification = new Notification(throwable.getMessage());
            notification.setIcon(1);
            notification.setDuration(Notification.TIME_SHORT);
            notification.show();
        });
    }

    public boolean importDataHandleExceptions(List<File> list, ProgressMonitor progressMonitor) {
        try {
            Logging.info("Open " + list.size() + " files");
            this.importData(list, progressMonitor);
            return true;
        }
        catch (IOException | IllegalDataException exception) {
            Logging.error(exception);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read files.<br>Error is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(exception.getMessage())), I18n.tr("Error", new Object[0]), 0, null);
            return false;
        }
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public int compareTo(FileImporter fileImporter) {
        return Double.compare(this.getPriority(), fileImporter.getPriority());
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

