/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Optional;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class SaveLayerTask
extends AbstractIOTask {
    private final SaveLayerInfo layerInfo;
    private final ProgressMonitor parentMonitor;

    protected SaveLayerTask(SaveLayerInfo saveLayerInfo, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(saveLayerInfo, "layerInfo");
        this.layerInfo = saveLayerInfo;
        this.parentMonitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
    }

    @Override
    public void run() {
        try {
            this.parentMonitor.subTask(I18n.tr("Saving layer to ''{0}'' ...", this.layerInfo.getFile().toString()));
            if (!SaveAction.doSave(this.layerInfo.getLayer(), this.layerInfo.getFile(), this.layerInfo.isDoCheckSaveConditions())) {
                this.setFailed(true);
                return;
            }
            if (!this.isCanceled()) {
                this.layerInfo.getLayer().onPostSaveToFile();
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            Logging.error(runtimeException);
            this.setLastException(runtimeException);
        }
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
    }
}

