/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.DownloadFileTask;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CustomConfigurator {
    private static StringBuilder summary = new StringBuilder();
    private static boolean busy;

    private CustomConfigurator() {
    }

    public static void log(String string, Object ... objectArray) {
        summary.append(String.format(string, objectArray));
    }

    public static void log(String string) {
        summary.append(string).append('\n');
    }

    public static void log(Exception exception, String string) {
        summary.append(string).append(' ').append(Logging.getErrorMessage(exception)).append('\n');
    }

    public static String getLog() {
        return summary.toString();
    }

    public static void resetLog() {
        summary = new StringBuilder();
    }

    public static void readXML(String string, String string2) {
        CustomConfigurator.readXML(new File(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readXML(File file, Preferences preferences) {
        Class<CustomConfigurator> clazz = CustomConfigurator.class;
        synchronized (CustomConfigurator.class) {
            busy = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            new XMLCommandProcessor(preferences).openAndReadXML(file);
            clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                CustomConfigurator.class.notifyAll();
                busy = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static void readXML(File file) {
        CustomConfigurator.readXML(file, Main.pref);
    }

    public static void downloadFile(String string, String string2, String string3) {
        CustomConfigurator.processDownloadOperation(string, string2, CustomConfigurator.getDirectoryByAbbr(string3), true, false);
    }

    public static void downloadAndUnpackFile(String string, String string2, String string3) {
        CustomConfigurator.processDownloadOperation(string, string2, CustomConfigurator.getDirectoryByAbbr(string3), true, true);
    }

    public static void processDownloadOperation(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4 = string3;
        if (string2.contains("..") || string2.startsWith("/") || string2.contains(":")) {
            return;
        }
        File file = new File(string4, string2);
        DownloadFileTask downloadFileTask = new DownloadFileTask(Main.parent, string, file, bl, bl2);
        MainApplication.worker.submit(downloadFileTask);
        CustomConfigurator.log("Info: downloading file from %s to %s in background ", string3, file.getAbsolutePath());
        if (bl2) {
            CustomConfigurator.log("and unpacking it");
        } else {
            CustomConfigurator.log("");
        }
    }

    public static void messageBox(String string, String string2) {
        char c = (string == null || string.isEmpty() ? "plain" : string).charAt(0);
        switch (c) {
            case 'i': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Information", new Object[0]), 1);
                break;
            }
            case 'w': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Warning", new Object[0]), 2);
                break;
            }
            case 'e': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Error", new Object[0]), 0);
                break;
            }
            case 'q': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Question", new Object[0]), 3);
                break;
            }
            case 'p': {
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Message", new Object[0]), -1);
                break;
            }
            default: {
                Logging.warn("Unsupported messageBox type: " + c);
            }
        }
    }

    public static int askForOption(String string, String string2) {
        if (!string2.isEmpty()) {
            return JOptionPane.showOptionDialog(Main.parent, string, "Question", 1, 3, null, string2.split(";"), 0);
        }
        return JOptionPane.showOptionDialog(Main.parent, string, "Question", 1, 3, null, null, 2);
    }

    public static String askForText(String string) {
        String string2 = JOptionPane.showInputDialog(Main.parent, string, I18n.tr("Enter text", new Object[0]), 3);
        return string2 != null ? string2.trim() : null;
    }

    public static void exportPreferencesKeysToFile(String string, boolean bl, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, stringArray);
        CustomConfigurator.exportPreferencesKeysToFile(string, bl, hashSet);
    }

    public static void exportPreferencesKeysByPatternToFile(String string, boolean bl, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Setting<?>> map = Main.pref.getAllSettings();
        for (String string3 : map.keySet()) {
            if (!string3.matches(string2)) continue;
            arrayList.add(string3);
        }
        CustomConfigurator.exportPreferencesKeysToFile(string, bl, arrayList);
    }

    public static void exportPreferencesKeysToFile(String string, boolean bl, Collection<String> collection) {
        Object object;
        Object object2;
        Element element = null;
        Document document = null;
        Document document2 = null;
        try {
            object2 = Main.pref.toXML(true);
            object = Utils.newSafeDOMBuilder();
            document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(((String)object2).getBytes(StandardCharsets.UTF_8)));
            document2 = ((DocumentBuilder)object).newDocument();
            element = document.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            Logging.log(Logging.LEVEL_WARN, "Error getting preferences to save:", exception);
        }
        if (element == null || document2 == null) {
            return;
        }
        try {
            Object object3;
            object2 = document2.createElement("config");
            document2.appendChild((Node)object2);
            object = document2.createElement("preferences");
            object.setAttribute("operation", bl ? "append" : "replace");
            object2.appendChild((Node)object);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string2;
                object3 = nodeList.item(i);
                if (object3.getNodeType() != 1 || !collection.contains(string2 = ((Element)object3).getAttribute("key"))) continue;
                Node node = document2.importNode((Node)object3, true);
                object.appendChild(node);
            }
            File file = new File(string);
            object3 = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object3).setOutputProperty("indent", "yes");
            ((Transformer)object3).transform(new DOMSource(document2), new StreamResult(file.toURI().getPath()));
        }
        catch (TransformerException | TransformerFactoryConfigurationError | DOMException throwable) {
            Logging.warn("Error saving preferences part:");
            Logging.error(throwable);
        }
    }

    public static void deleteFile(String string, String string2) {
        String string3 = CustomConfigurator.getDirectoryByAbbr(string2);
        if (string3 == null) {
            CustomConfigurator.log("Error: Can not find base, use base=cache, base=prefs or base=plugins attribute.");
            return;
        }
        CustomConfigurator.log("Delete file: %s\n", string);
        if (string.contains("..") || string.startsWith("/") || string.contains(":")) {
            return;
        }
        File file = new File(string3, string);
        if (file.exists()) {
            CustomConfigurator.deleteFileOrDirectory(file);
        }
    }

    public static void deleteFileOrDirectory(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                CustomConfigurator.deleteFileOrDirectory(file2);
            }
        }
        if (!Utils.deleteFile(file)) {
            CustomConfigurator.log("Warning: Can not delete file " + file.getPath());
        }
    }

    public static void pluginOperation(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        Collections.addAll(arrayList, string.toLowerCase(Locale.ENGLISH).split(";"));
        Collections.addAll(arrayList2, string2.toLowerCase(Locale.ENGLISH).split(";"));
        Collections.addAll(arrayList3, string3.toLowerCase(Locale.ENGLISH).split(";"));
        arrayList.remove("");
        arrayList2.remove("");
        arrayList3.remove("");
        if (!arrayList.isEmpty()) {
            CustomConfigurator.log("Plugins install: " + arrayList);
        }
        if (!arrayList2.isEmpty()) {
            CustomConfigurator.log("Plugins turn off: " + arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            CustomConfigurator.log("Plugins delete: " + arrayList3);
        }
        ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask();
        Runnable runnable = () -> {
            if (readLocalPluginInformationTask.isCanceled()) {
                return;
            }
            Class<CustomConfigurator> clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                try {
                    while (busy) {
                        CustomConfigurator.class.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logging.log(Logging.LEVEL_WARN, "InterruptedException while reading local plugin information", interruptedException);
                    Thread.currentThread().interrupt();
                }
                SwingUtilities.invokeLater(() -> {
                    Object object;
                    List<PluginInformation> list4 = readLocalPluginInformationTask.getAvailablePlugins();
                    ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>();
                    ArrayList<PluginInformation> arrayList2 = new ArrayList<PluginInformation>();
                    ArrayList<PluginInformation> arrayList3 = new ArrayList<PluginInformation>();
                    for (PluginInformation iterator : list4) {
                        String string = iterator.name.toLowerCase(Locale.ENGLISH);
                        if (arrayList.contains(string)) {
                            arrayList.add(iterator);
                        }
                        if (arrayList2.contains(string)) {
                            arrayList2.add(iterator);
                        }
                        if (!arrayList3.contains(string)) continue;
                        arrayList3.add(iterator);
                    }
                    if (!arrayList.isEmpty()) {
                        object = new PluginDownloadTask(Main.parent, arrayList, I18n.tr("Installing plugins", new Object[0]));
                        MainApplication.worker.submit((Runnable)object);
                    }
                    object = new ArrayList<String>(Main.pref.getCollection("plugins"));
                    for (PluginInformation pluginInformation : arrayList) {
                        if (object.contains(pluginInformation.name)) continue;
                        object.add(pluginInformation.name);
                    }
                    for (PluginInformation pluginInformation : arrayList2) {
                        object.remove(pluginInformation.name);
                    }
                    for (PluginInformation pluginInformation : arrayList3) {
                        object.remove(pluginInformation.name);
                        new File(Main.pref.getPluginsDirectory(), pluginInformation.name + ".jar").deleteOnExit();
                    }
                    Main.pref.putCollection("plugins", (Collection<String>)object);
                });
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        };
        MainApplication.worker.submit(readLocalPluginInformationTask);
        MainApplication.worker.submit(runnable);
    }

    private static String getDirectoryByAbbr(String string) {
        String string2 = "prefs".equals(string) || string.isEmpty() ? Main.pref.getPreferencesDirectory().getAbsolutePath() : ("cache".equals(string) ? Main.pref.getCacheDirectory().getAbsolutePath() : ("plugins".equals(string) ? Main.pref.getPluginsDirectory().getAbsolutePath() : null));
        return string2;
    }

    public static class XMLCommandProcessor {
        private Preferences mainPrefs;
        private final Map<String, Element> tasksMap = new HashMap<String, Element>();
        private boolean lastV;
        private ScriptEngine engine;

        public void openAndReadXML(File file) {
            CustomConfigurator.log("-- Reading custom preferences from " + file.getAbsolutePath() + " --");
            try {
                String string = file.getParentFile().getAbsolutePath();
                if (string != null) {
                    this.engine.eval("scriptDir='" + XMLCommandProcessor.normalizeDirName(string) + "';");
                }
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                    this.openAndReadXML(bufferedInputStream);
                }
            }
            catch (IOException | SecurityException | ScriptException exception) {
                CustomConfigurator.log(exception, "Error reading custom preferences:");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void openAndReadXML(InputStream inputStream) {
            try {
                Document document = Utils.parseSafeDOM(inputStream);
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    this.processXML(document);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                CustomConfigurator.log(exception, "Error reading custom preferences:");
            }
            {
                CustomConfigurator.log("-- Reading complete --");
                return;
            }
        }

        public XMLCommandProcessor(Preferences preferences) {
            try {
                this.mainPrefs = preferences;
                CustomConfigurator.resetLog();
                this.engine = new ScriptEngineManager().getEngineByName("JavaScript");
                this.engine.eval("API={}; API.pref={}; API.fragments={};");
                this.engine.eval("homeDir='" + XMLCommandProcessor.normalizeDirName(Main.pref.getPreferencesDirectory().getAbsolutePath()) + "';");
                this.engine.eval("josmVersion=" + Version.getInstance().getVersion() + ';');
                String string = CustomConfigurator.class.getName();
                this.engine.eval("API.messageBox=" + string + ".messageBox");
                this.engine.eval("API.askText=function(text) { return String(" + string + ".askForText(text));}");
                this.engine.eval("API.askOption=" + string + ".askForOption");
                this.engine.eval("API.downloadFile=" + string + ".downloadFile");
                this.engine.eval("API.downloadAndUnpackFile=" + string + ".downloadAndUnpackFile");
                this.engine.eval("API.deleteFile=" + string + ".deleteFile");
                this.engine.eval("API.plugin =" + string + ".pluginOperation");
                this.engine.eval("API.pluginInstall = function(names) { " + string + ".pluginOperation(names,'','');}");
                this.engine.eval("API.pluginUninstall = function(names) { " + string + ".pluginOperation('',names,'');}");
                this.engine.eval("API.pluginDelete = function(names) { " + string + ".pluginOperation('','',names);}");
            }
            catch (ScriptException scriptException) {
                CustomConfigurator.log("Error: initializing script engine: " + scriptException.getMessage());
                Logging.error(scriptException);
            }
        }

        private void processXML(Document document) {
            this.processXmlFragment(document.getDocumentElement());
        }

        private void processXmlFragment(Element element) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            block30: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string = node.getNodeName();
                Element element2 = (Element)node;
                switch (string) {
                    case "var": {
                        this.setVar(element2.getAttribute("name"), this.evalVars(element2.getAttribute("value")));
                        continue block30;
                    }
                    case "task": {
                        this.tasksMap.put(element2.getAttribute("name"), element2);
                        continue block30;
                    }
                    case "runtask": {
                        if (!this.processRunTaskElement(element2)) continue block30;
                        return;
                    }
                    case "ask": {
                        this.processAskElement(element2);
                        continue block30;
                    }
                    case "if": {
                        this.processIfElement(element2);
                        continue block30;
                    }
                    case "else": {
                        this.processElseElement(element2);
                        continue block30;
                    }
                    case "break": {
                        return;
                    }
                    case "plugin": {
                        XMLCommandProcessor.processPluginInstallElement(element2);
                        continue block30;
                    }
                    case "messagebox": {
                        this.processMsgBoxElement(element2);
                        continue block30;
                    }
                    case "preferences": {
                        this.processPreferencesElement(element2);
                        continue block30;
                    }
                    case "download": {
                        this.processDownloadElement(element2);
                        continue block30;
                    }
                    case "delete": {
                        this.processDeleteElement(element2);
                        continue block30;
                    }
                    case "script": {
                        this.processScriptElement(element2);
                        continue block30;
                    }
                    default: {
                        CustomConfigurator.log("Error: Unknown element " + string);
                    }
                }
            }
        }

        private void processPreferencesElement(Element element) {
            String string = this.evalVars(element.getAttribute("operation"));
            String string2 = this.evalVars(element.getAttribute("id"));
            if ("delete-keys".equals(string)) {
                String string3 = this.evalVars(element.getAttribute("pattern"));
                String string4 = this.evalVars(element.getAttribute("key"));
                PreferencesUtils.deletePreferenceKey(string4, this.mainPrefs);
                PreferencesUtils.deletePreferenceKeyByPattern(string3, this.mainPrefs);
                return;
            }
            Preferences preferences = this.readPreferencesFromDOMElement(element);
            PreferencesUtils.showPrefs(preferences);
            if (!string2.isEmpty()) {
                try {
                    String string5 = "API.fragments['" + string2 + "']";
                    this.engine.eval(string5 + "={};");
                    PreferencesUtils.loadPrefsToJS(this.engine, preferences, string5, false);
                }
                catch (ScriptException scriptException) {
                    CustomConfigurator.log(scriptException, "Error: can not load preferences fragment:");
                }
            }
            if ("replace".equals(string)) {
                CustomConfigurator.log("Preferences replace: %d keys: %s\n", preferences.getAllSettings().size(), preferences.getAllSettings().keySet().toString());
                PreferencesUtils.replacePreferences(preferences, this.mainPrefs);
            } else if ("append".equals(string)) {
                CustomConfigurator.log("Preferences append: %d keys: %s\n", preferences.getAllSettings().size(), preferences.getAllSettings().keySet().toString());
                PreferencesUtils.appendPreferences(preferences, this.mainPrefs);
            } else if ("delete-values".equals(string)) {
                PreferencesUtils.deletePreferenceValues(preferences, this.mainPrefs);
            }
        }

        private void processDeleteElement(Element element) {
            String string = this.evalVars(element.getAttribute("path"));
            String string2 = this.evalVars(element.getAttribute("base"));
            CustomConfigurator.deleteFile(string, string2);
        }

        private void processDownloadElement(Element element) {
            String string = this.evalVars(element.getAttribute("base"));
            String string2 = CustomConfigurator.getDirectoryByAbbr(string);
            if (string2 == null) {
                CustomConfigurator.log("Error: Can not find directory to place file, use base=cache, base=prefs or base=plugins attribute.");
                return;
            }
            String string3 = this.evalVars(element.getAttribute("path"));
            if (string3.contains("..") || string3.startsWith("/") || string3.contains(":")) {
                return;
            }
            String string4 = this.evalVars(element.getAttribute("url"));
            if (string4.isEmpty() || string3.isEmpty()) {
                CustomConfigurator.log("Error: Please specify url=\"where to get file\" and path=\"where to place it\"");
                return;
            }
            String string5 = this.evalVars(element.getAttribute("unzip"));
            String string6 = this.evalVars(element.getAttribute("mkdir"));
            CustomConfigurator.processDownloadOperation(string4, string3, string2, "true".equals(string6), "true".equals(string5));
        }

        private static void processPluginInstallElement(Element element) {
            String string = element.getAttribute("install");
            String string2 = element.getAttribute("remove");
            String string3 = element.getAttribute("delete");
            CustomConfigurator.pluginOperation(string, string2, string3);
        }

        private void processMsgBoxElement(Element element) {
            String string = this.evalVars(element.getAttribute("text"));
            String string2 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (!string2.isEmpty()) {
                string = string2;
            }
            String string3 = this.evalVars(element.getAttribute("type"));
            CustomConfigurator.messageBox(string3, string);
        }

        private void processAskElement(Element element) {
            String string;
            String string2;
            String string3 = this.evalVars(element.getAttribute("text"));
            String string4 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (!string4.isEmpty()) {
                string3 = string4;
            }
            if ((string2 = element.getAttribute("var")).isEmpty()) {
                string2 = "result";
            }
            if ("true".equals(string = this.evalVars(element.getAttribute("input")))) {
                this.setVar(string2, CustomConfigurator.askForText(string3));
            } else {
                String string5 = this.evalVars(element.getAttribute("options"));
                String string6 = this.evalVars(element.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".options"));
                if (!string6.isEmpty()) {
                    string5 = string6;
                }
                this.setVar(string2, String.valueOf(CustomConfigurator.askForOption(string3, string5)));
            }
        }

        public void setVar(String string, String string2) {
            try {
                this.engine.eval(string + "='" + string2 + "';");
            }
            catch (ScriptException scriptException) {
                CustomConfigurator.log(scriptException, String.format("Error: Can not assign variable: %s=%s :", string, string2));
            }
        }

        private void processIfElement(Element element) {
            String string = this.evalVars(element.getAttribute("test"));
            boolean bl = false;
            if ("true".equals(string) || "false".equals(string)) {
                this.processXmlFragment(element);
                bl = true;
            } else {
                CustomConfigurator.log("Error: Illegal test expression in if: %s=%s\n", element.getAttribute("test"), string);
            }
            this.lastV = bl;
        }

        private void processElseElement(Element element) {
            if (!this.lastV) {
                this.processXmlFragment(element);
            }
        }

        private boolean processRunTaskElement(Element element) {
            String string = element.getAttribute("name");
            Element element2 = this.tasksMap.get(string);
            if (element2 == null) {
                CustomConfigurator.log("Error: Can not execute task " + string);
                return true;
            }
            CustomConfigurator.log("EXECUTING TASK " + string);
            this.processXmlFragment(element2);
            return false;
        }

        private void processScriptElement(Element element) {
            String string = element.getChildNodes().item(0).getTextContent();
            CustomConfigurator.log("Processing script...");
            try {
                PreferencesUtils.modifyPreferencesByScript(this.engine, this.mainPrefs, string);
            }
            catch (ScriptException scriptException) {
                CustomConfigurator.messageBox("e", scriptException.getMessage());
                CustomConfigurator.log(scriptException, "JS error:");
            }
            CustomConfigurator.log("Script finished");
        }

        private String evalVars(String string) {
            Matcher matcher = Pattern.compile("\\$\\{([^\\}]*)\\}").matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                try {
                    String string2 = this.engine.eval(matcher.group(1)).toString();
                    matcher.appendReplacement(stringBuffer, string2);
                }
                catch (ScriptException scriptException) {
                    CustomConfigurator.log(scriptException, String.format("Error: Can not evaluate expression %s :", matcher.group(1)));
                }
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        private Preferences readPreferencesFromDOMElement(Element element) {
            Preferences preferences = new Preferences();
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                CharArrayWriter charArrayWriter = new CharArrayWriter(8192);
                StreamResult streamResult = new StreamResult(charArrayWriter);
                transformer.transform(new DOMSource(element), streamResult);
                String string = this.evalVars(charArrayWriter.toString());
                CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
                preferences.fromXML(charArrayReader);
            }
            catch (IOException | XMLStreamException | TransformerException exception) {
                CustomConfigurator.log(exception, "Error: can not read XML fragment:");
            }
            return preferences;
        }

        private static String normalizeDirName(String string) {
            String string2 = string.replace('\\', '/');
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
    }
}

