/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.LanguageInfo;

public final class HelpUtil {
    private HelpUtil() {
    }

    public static String getWikiBaseUrl() {
        return Main.pref.get("help.baseurl", Main.getJOSMWebsite());
    }

    public static String getWikiBaseHelpUrl() {
        return HelpUtil.getWikiBaseUrl() + "/wiki";
    }

    public static String getHelpTopicUrl(String string) {
        if (string == null) {
            return null;
        }
        String string2 = HelpUtil.getWikiBaseHelpUrl();
        string2 = string2.replaceAll("\\/+$", "");
        string = string.replace(" ", "%20");
        string = string.replaceAll("^\\/+", "/");
        return string2 + string;
    }

    public static String getHelpTopicEditUrl(String string) {
        String string2 = HelpUtil.getHelpTopicUrl(string);
        if (string2 != null) {
            string2 = string2.replaceAll("#[^#]*$", "");
        }
        return string2 + "?action=edit";
    }

    public static String extractRelativeHelpTopic(String string) {
        String string2;
        String string3 = HelpUtil.extractAbsoluteHelpTopic(string);
        if (string3 == null) {
            return null;
        }
        String string4 = HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH);
        if (string4 != null) {
            string4 = string4.replaceAll("^\\/+", "");
        }
        if (string.matches(string2 = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + string4)) {
            return string3.substring(string2.length());
        }
        return null;
    }

    public static String extractAbsoluteHelpTopic(String string) {
        if (string == null || !string.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
            return null;
        }
        String string2 = string.substring(HelpUtil.getWikiBaseHelpUrl().length());
        String string3 = HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH);
        if (string3 == null || string2.startsWith(string3)) {
            return string2;
        }
        String string4 = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + string3.replaceAll("^\\/+", "");
        if (string2.matches(string4)) {
            return string2;
        }
        return null;
    }

    private static String getHelpTopicPrefix(LanguageInfo.LocaleType localeType) {
        String string = LanguageInfo.getWikiLanguagePrefix(localeType);
        if (string == null) {
            return string;
        }
        string = '/' + string + Main.pref.get("help.pathhelp", "/Help").replaceAll("^\\/+", "");
        return string.replaceAll("\\/+", "\\/");
    }

    public static String buildAbsoluteHelpTopic(String string, LanguageInfo.LocaleType localeType) {
        String string2 = HelpUtil.getHelpTopicPrefix(localeType);
        if (string2 == null || string == null || string.trim().isEmpty() || "/".equals(string.trim())) {
            return string2;
        }
        string2 = string2 + '/' + string;
        return string2.replaceAll("\\/+", "\\/");
    }

    public static String getContextSpecificHelpTopic(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Helpful) {
            return ((Helpful)object).helpTopic();
        }
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            if (jMenu.getClientProperty("help") != null) {
                return (String)jMenu.getClientProperty("help");
            }
            return null;
        }
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.getClientProperty("help") != null) {
                return (String)abstractButton.getClientProperty("help");
            }
            return HelpUtil.getContextSpecificHelpTopic(abstractButton.getAction());
        }
        if (object instanceof Action) {
            return (String)((Action)object).getValue("help");
        }
        if (object instanceof JComponent && ((JComponent)object).getClientProperty("help") != null) {
            return (String)((JComponent)object).getClientProperty("help");
        }
        if (object instanceof Component) {
            return HelpUtil.getContextSpecificHelpTopic(((Component)object).getParent());
        }
        return null;
    }

    private static Action getHelpAction() {
        if (MainApplication.getMenu() != null) {
            return MainApplication.getMenu().help;
        }
        return HelpAction.createWithoutShortcut();
    }

    public static void setHelpContext(JComponent jComponent, String string) {
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "help");
        jComponent.getActionMap().put("help", HelpUtil.getHelpAction());
        jComponent.putClientProperty("help", string == null ? "/" : string);
    }

    public static String ht(String string) {
        return string;
    }
}

