/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetQueryTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class BookmarkList
extends JList<Bookmark> {
    public static final IntegerProperty MAX_CHANGESET_BOOKMARKS = new IntegerProperty("bookmarks.changesets.max-entries", 15);

    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public final void load() {
        int n;
        Iterator iterator;
        Collection<Collection<String>> collection;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        if (josmUserIdentityManager.isFullyIdentified()) {
            try {
                defaultListModel.addElement(new HomeLocationBookmark());
            }
            catch (IllegalStateException illegalStateException) {
                Logging.info(illegalStateException.getMessage());
                Logging.trace(illegalStateException);
            }
        }
        if ((collection = Main.pref.getArray("bookmarks", null)) != null) {
            LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
            for (Collection<String> object2 : collection) {
                try {
                    linkedList.add(new Bookmark(object2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("Error reading bookmark entry: %s", illegalArgumentException.getMessage()), illegalArgumentException);
                }
            }
            Collections.sort(linkedList);
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Bookmark bookmark = (Bookmark)iterator.next();
                defaultListModel.addElement(bookmark);
            }
        }
        if ((n = MAX_CHANGESET_BOOKMARKS.get().intValue()) > 0 && !josmUserIdentityManager.isAnonymous() && (iterator = josmUserIdentityManager.getUserInfo()) != null) {
            ChangesetCacheManager changesetCacheManager = ChangesetCacheManager.getInstance();
            int n2 = ((UserInfo)((Object)iterator)).getId();
            int n3 = 0;
            for (int i = 0; i < changesetCacheManager.getModel().getRowCount() && n3 < n; ++i) {
                Changeset changeset = changesetCacheManager.getModel().getValueAt(i, 0);
                if (changeset.getUser().getId() != (long)n2 || changeset.getBounds() == null) continue;
                defaultListModel.addElement(new ChangesetBookmark(changeset));
                ++n3;
            }
        }
    }

    public final void save() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
            if (object instanceof HomeLocationBookmark || object instanceof ChangesetBookmark) continue;
            String[] stringArray = new String[5];
            Bookmark bookmark = (Bookmark)object;
            stringArray[0] = bookmark.getName();
            Bounds bounds = bookmark.getArea();
            stringArray[1] = String.valueOf(bounds.getMinLat());
            stringArray[2] = String.valueOf(bounds.getMinLon());
            stringArray[3] = String.valueOf(bounds.getMaxLat());
            stringArray[4] = String.valueOf(bounds.getMaxLon());
            linkedList.add(Arrays.asList(stringArray));
        }
        Main.pref.putArray("bookmarks", linkedList);
    }

    public void refreshChangesetBookmarks() {
        int n = MAX_CHANGESET_BOOKMARKS.get();
        if (n > 0) {
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            for (int i = defaultListModel.getSize() - 1; i >= 0; --i) {
                if (!(defaultListModel.get(i) instanceof ChangesetBookmark)) continue;
                defaultListModel.remove(i);
            }
            ChangesetQuery changesetQuery = ChangesetQuery.forCurrentUser();
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetQueryTask changesetQueryTask = new ChangesetQueryTask(this, changesetQuery);
                ChangesetCacheManager.getInstance().runDownloadTask(changesetQueryTask);
                MainApplication.worker.submit(() -> {
                    if (changesetQueryTask.isCanceled() || changesetQueryTask.isFailed()) {
                        return;
                    }
                    GuiHelper.runInEDT(() -> ((Set)changesetQueryTask.getDownloadedData()).stream().filter(changeset -> changeset.getBounds() != null).sorted(Comparator.reverseOrder()).limit(n).forEachOrdered(changeset -> defaultListModel.addElement(new ChangesetBookmark((Changeset)changeset))));
                });
            }
        }
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer<Bookmark> {
        BookmarkCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark bookmark) {
            Bounds bounds = bookmark.getArea();
            StringBuilder stringBuilder = new StringBuilder(128);
            if (bounds != null) {
                stringBuilder.append("<html>min[latitude,longitude]=<strong>[").append(bounds.getMinLat()).append(',').append(bounds.getMinLon()).append("]</strong><br>max[latitude,longitude]=<strong>[").append(bounds.getMaxLat()).append(',').append(bounds.getMaxLon()).append("]</strong></html>");
            }
            return stringBuilder.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Bookmark> jList, Bookmark bookmark, int n, boolean bl, boolean bl2) {
            this.renderColor(bl);
            this.setIcon(bookmark.getIcon());
            this.setText(bookmark.getName());
            this.setToolTipText(this.buildToolTipText(bookmark));
            return this;
        }
    }

    public static class ChangesetBookmark
    extends Bookmark {
        public ChangesetBookmark(Changeset changeset) {
            this.setName(String.format("%d - %tF - %s", changeset.getId(), changeset.getCreatedAt(), changeset.getComment()));
            this.setIcon(ImageProvider.get("data", "changeset", ImageProvider.ImageSizes.SMALLICON));
            this.setArea(changeset.getBounds());
        }
    }

    public static class HomeLocationBookmark
    extends Bookmark {
        public HomeLocationBookmark() {
            this.setName(I18n.tr("Home location", new Object[0]));
            this.setIcon(ImageProvider.get("help", "home", ImageProvider.ImageSizes.SMALLICON));
            UserInfo userInfo = JosmUserIdentityManager.getInstance().getUserInfo();
            if (userInfo == null) {
                throw new IllegalStateException("User not identified");
            }
            LatLon latLon = userInfo.getHome();
            if (latLon == null) {
                throw new IllegalStateException("User home location not set");
            }
            int n = userInfo.getHomeZoom();
            if (n <= 3) {
                n = 15;
            }
            Projection projection = Projections.getProjectionByCode("EPSG:3857");
            this.setArea(MapViewState.createDefaultState(430, 400).usingProjection(projection).usingScale(Selector.GeneralSelector.level2scale(n) / 100.0).usingCenter(projection.latlon2eastNorth(latLon)).getViewArea().getLatLonBoundsBox());
        }
    }

    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;
        private ImageIcon icon;

        public Bookmark(Collection<String> collection) {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            if (arrayList.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.name = (String)arrayList.get(0);
            this.area = new Bounds(Double.parseDouble((String)arrayList.get(1)), Double.parseDouble((String)arrayList.get(2)), Double.parseDouble((String)arrayList.get(3)), Double.parseDouble((String)arrayList.get(4)));
        }

        public Bookmark() {
            this(null, null);
        }

        public Bookmark(Bounds bounds) {
            this(null, bounds);
        }

        protected Bookmark(String string, Bounds bounds) {
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.name = string;
            this.area = bounds;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark bookmark) {
            return this.name.toLowerCase(Locale.ENGLISH).compareTo(bookmark.name.toLowerCase(Locale.ENGLISH));
        }

        public int hashCode() {
            return Objects.hash(this.name, this.area);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Bookmark bookmark = (Bookmark)object;
            return Objects.equals(this.name, bookmark.name) && Objects.equals(this.area, bookmark.area);
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setArea(Bounds bounds) {
            this.area = bounds;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon imageIcon) {
            this.icon = imageIcon;
        }
    }
}

