/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class WayConnectionTypeCalculator {
    private static final int UNCONNECTED = Integer.MIN_VALUE;
    private List<RelationMember> members;
    private int firstGroupIdx;
    private int lastForwardWay;
    private int lastBackwardWay;
    private boolean onewayBeginning;

    public List<WayConnectionType> updateLinks(List<RelationMember> list) {
        this.members = list;
        ArrayList<WayConnectionType> arrayList = new ArrayList<WayConnectionType>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(null);
        }
        this.firstGroupIdx = 0;
        this.lastForwardWay = Integer.MIN_VALUE;
        this.lastBackwardWay = Integer.MIN_VALUE;
        this.onewayBeginning = false;
        WayConnectionType wayConnectionType = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                wayConnectionType = this.updateLinksFor(arrayList, wayConnectionType, i);
                continue;
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                int n = i;
                throw BugReport.intercept(runtimeException).put("i", i).put("member", () -> (RelationMember)list.get(n)).put("con", arrayList);
            }
        }
        this.makeLoopIfNeeded(arrayList, list.size() - 1);
        return arrayList;
    }

    private WayConnectionType updateLinksFor(List<WayConnectionType> list, WayConnectionType wayConnectionType, int n) {
        RelationMember relationMember = this.members.get(n);
        if (WayConnectionTypeCalculator.isNoHandleableWay(relationMember)) {
            if (n > 0) {
                this.makeLoopIfNeeded(list, n - 1);
            }
        } else {
            WayConnectionType wayConnectionType2 = this.computeNextWayConnection(list, wayConnectionType, n, relationMember);
            if (!wayConnectionType2.linkPrev) {
                if (n > 0) {
                    this.makeLoopIfNeeded(list, n - 1);
                }
                this.firstGroupIdx = n;
            }
            return wayConnectionType2;
        }
        list.set(n, new WayConnectionType());
        this.firstGroupIdx = n;
        return wayConnectionType;
    }

    private static boolean isNoHandleableWay(RelationMember relationMember) {
        return !relationMember.isWay() || relationMember.getWay() == null || relationMember.getWay().isIncomplete();
    }

    private WayConnectionType computeNextWayConnection(List<WayConnectionType> list, WayConnectionType wayConnectionType, int n, RelationMember relationMember) {
        WayConnectionType wayConnectionType2 = new WayConnectionType(false);
        wayConnectionType2.linkPrev = n > 0 && list.get(n - 1) != null && list.get(n - 1).isValid();
        wayConnectionType2.direction = WayConnectionType.Direction.NONE;
        if (RelationSortUtils.isOneway(relationMember)) {
            this.handleOneway(wayConnectionType, n, wayConnectionType2);
        }
        if (wayConnectionType2.linkPrev) {
            if (this.lastBackwardWay != Integer.MIN_VALUE && this.lastForwardWay != Integer.MIN_VALUE) {
                this.determineOnewayConnectionType(list, relationMember, n, wayConnectionType2);
                if (!wayConnectionType2.linkPrev) {
                    this.firstGroupIdx = n;
                }
            }
            if (wayConnectionType != null && !RelationSortUtils.isOneway(relationMember)) {
                wayConnectionType2.direction = this.determineDirection(n - 1, wayConnectionType.direction, n);
                boolean bl = wayConnectionType2.linkPrev = wayConnectionType2.direction != WayConnectionType.Direction.NONE;
            }
        }
        if (!wayConnectionType2.linkPrev) {
            wayConnectionType2.direction = this.determineDirectionOfFirst(n, relationMember);
            if (RelationSortUtils.isOneway(relationMember)) {
                wayConnectionType2.isOnewayLoopForwardPart = true;
                this.lastForwardWay = n;
            }
        }
        wayConnectionType2.linkNext = false;
        if (wayConnectionType != null) {
            wayConnectionType.linkNext = wayConnectionType2.linkPrev;
        }
        list.set(n, wayConnectionType2);
        return wayConnectionType2;
    }

    private void handleOneway(WayConnectionType wayConnectionType, int n, WayConnectionType wayConnectionType2) {
        if (wayConnectionType != null && wayConnectionType.isOnewayTail) {
            wayConnectionType2.isOnewayHead = true;
        }
        if (this.lastBackwardWay == Integer.MIN_VALUE && this.lastForwardWay == Integer.MIN_VALUE) {
            wayConnectionType2.isOnewayHead = true;
            this.lastForwardWay = n - 1;
            this.lastBackwardWay = n - 1;
            this.onewayBeginning = true;
        }
    }

    private void makeLoopIfNeeded(List<WayConnectionType> list, int n) {
        boolean bl = false;
        if (n == this.firstGroupIdx) {
            bl = this.determineDirection(n, WayConnectionType.Direction.FORWARD, n) == WayConnectionType.Direction.FORWARD;
        } else if (n >= 0) {
            boolean bl2 = bl = this.determineDirection(n, list.get((int)n).direction, this.firstGroupIdx) == list.get((int)this.firstGroupIdx).direction;
        }
        if (bl) {
            for (int i = this.firstGroupIdx; i <= n; ++i) {
                list.get((int)i).isLoop = true;
            }
        }
    }

    private WayConnectionType.Direction determineDirectionOfFirst(int n, RelationMember relationMember) {
        WayConnectionType.Direction direction = RelationSortUtils.roundaboutType(relationMember);
        if (direction != WayConnectionType.Direction.NONE) {
            return direction;
        }
        if (RelationSortUtils.isOneway(relationMember)) {
            if (RelationSortUtils.isBackward(relationMember)) {
                return WayConnectionType.Direction.BACKWARD;
            }
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.FORWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.BACKWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private void determineOnewayConnectionType(List<WayConnectionType> list, RelationMember relationMember, int n, WayConnectionType wayConnectionType) {
        WayConnectionType.Direction direction;
        WayConnectionType.Direction direction2 = this.determineDirection(this.lastForwardWay, list.get((int)this.lastForwardWay).direction, n);
        if (this.onewayBeginning) {
            direction = this.lastBackwardWay < 0 ? this.determineDirection(this.firstGroupIdx, WayConnectionTypeCalculator.reverse(list.get((int)this.firstGroupIdx).direction), n, true) : this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
            if (direction != WayConnectionType.Direction.NONE) {
                this.onewayBeginning = false;
            }
        } else {
            direction = this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
        }
        if (RelationSortUtils.isOneway(relationMember)) {
            if (direction != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction;
                this.lastBackwardWay = n;
                wayConnectionType.isOnewayLoopBackwardPart = true;
            }
            if (direction2 != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction2;
                this.lastForwardWay = n;
                wayConnectionType.isOnewayLoopForwardPart = true;
            }
            if (direction2 == WayConnectionType.Direction.NONE && direction == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
                if (RelationSortUtils.isOneway(relationMember)) {
                    wayConnectionType.isOnewayHead = true;
                    this.lastForwardWay = n - 1;
                    this.lastBackwardWay = n - 1;
                } else {
                    this.lastForwardWay = Integer.MIN_VALUE;
                    this.lastBackwardWay = Integer.MIN_VALUE;
                }
                this.onewayBeginning = true;
            }
            if (direction2 != WayConnectionType.Direction.NONE && direction != WayConnectionType.Direction.NONE) {
                if (n + 1 < this.members.size() && this.determineDirection(n, direction2, n + 1) != WayConnectionType.Direction.NONE) {
                    wayConnectionType.isOnewayLoopBackwardPart = false;
                    wayConnectionType.direction = direction2;
                } else {
                    wayConnectionType.isOnewayLoopForwardPart = false;
                    wayConnectionType.direction = direction;
                }
                wayConnectionType.isOnewayTail = true;
            }
        } else {
            this.lastForwardWay = Integer.MIN_VALUE;
            this.lastBackwardWay = Integer.MIN_VALUE;
            if (direction2 == WayConnectionType.Direction.NONE || direction == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
            }
        }
    }

    private static WayConnectionType.Direction reverse(WayConnectionType.Direction direction) {
        if (direction == WayConnectionType.Direction.FORWARD) {
            return WayConnectionType.Direction.BACKWARD;
        }
        if (direction == WayConnectionType.Direction.BACKWARD) {
            return WayConnectionType.Direction.FORWARD;
        }
        return direction;
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2) {
        return this.determineDirection(n, direction, n2, false);
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2, boolean bl) {
        if (this.members == null || n < 0 || n2 < 0 || n >= this.members.size() || n2 >= this.members.size() || direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = this.members.get(n2);
        Way way = null;
        Way way2 = null;
        if (relationMember.isWay()) {
            way = relationMember.getWay();
        }
        if (relationMember2.isWay()) {
            way2 = relationMember2.getWay();
        }
        if (way == null || way2 == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Node> list = new ArrayList<Node>();
        switch (direction) {
            case FORWARD: {
                list.add(way.lastNode());
                break;
            }
            case BACKWARD: {
                list.add(way.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                list = way.getNodes();
                break;
            }
        }
        for (Node node : list) {
            if (node == null) continue;
            if (RelationSortUtils.roundaboutType(this.members.get(n2)) != WayConnectionType.Direction.NONE) {
                for (Node node2 : way2.getNodes()) {
                    if (node != node2) continue;
                    return RelationSortUtils.roundaboutType(this.members.get(n2));
                }
                continue;
            }
            if (RelationSortUtils.isOneway(relationMember2)) {
                if (node == RelationNodeMap.firstOnewayNode(relationMember2) && !bl) {
                    if (RelationSortUtils.isBackward(relationMember2)) {
                        return WayConnectionType.Direction.BACKWARD;
                    }
                    return WayConnectionType.Direction.FORWARD;
                }
                if (!bl || node != RelationNodeMap.lastOnewayNode(relationMember2)) continue;
                if (RelationSortUtils.isBackward(relationMember2)) {
                    return WayConnectionType.Direction.FORWARD;
                }
                return WayConnectionType.Direction.BACKWARD;
            }
            if (node == way2.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (node != way2.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }
}

