/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class MergeAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction,
Layer.MultiLayerAction {
    private transient Layer layer;
    private transient List<Layer> layers;
    private final LayerListDialog.LayerListModel model;

    public MergeAction(Layer layer, LayerListDialog.LayerListModel layerListModel) {
        this(layer, null, layerListModel);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
    }

    public MergeAction(List<Layer> list, LayerListDialog.LayerListModel layerListModel) {
        this(null, list, layerListModel);
        CheckParameterUtil.ensureParameterNotNull(list, "layers");
    }

    private MergeAction(Layer layer, List<Layer> list, LayerListDialog.LayerListModel layerListModel) {
        this.layer = layer;
        this.layers = list;
        this.model = layerListModel;
        this.putValue("Name", I18n.tr("Merge", new Object[0]));
        new ImageProvider("dialogs", "mergedown").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#MergeLayer"));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MergeLayerAction mergeLayerAction = MainApplication.getMenu().merge;
        if (this.layer != null) {
            mergeLayerAction.merge(this.layer);
        } else if (this.layers != null) {
            mergeLayerAction.merge(this.layers);
        } else if (this.model.getSelectedLayers().size() == 1) {
            Layer layer = this.model.getSelectedLayers().get(0);
            mergeLayerAction.merge(layer);
        } else {
            mergeLayerAction.merge(this.model.getSelectedLayers());
        }
    }

    @Override
    public void updateEnabledState() {
        if (this.layer == null && this.layers == null) {
            if (this.model.getSelectedLayers().isEmpty()) {
                this.setEnabled(false);
            } else if (this.model.getSelectedLayers().size() > 1) {
                this.setEnabled(this.supportLayers(this.model.getSelectedLayers()));
            } else {
                Layer layer = this.model.getSelectedLayers().get(0);
                List<Layer> list = this.model.getPossibleMergeTargets(layer);
                this.setEnabled(!list.isEmpty());
            }
        } else if (this.layer != null) {
            List<Layer> list = this.model.getPossibleMergeTargets(this.layer);
            this.setEnabled(!list.isEmpty());
        } else {
            this.setEnabled(this.supportLayers(this.layers));
        }
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        if (list.isEmpty()) {
            return false;
        }
        Layer layer = list.get(0);
        List<Layer> list2 = list.subList(1, list.size());
        return this.model.getPossibleMergeTargets(layer).containsAll(list2);
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public MergeAction getMultiLayerAction(List<Layer> list) {
        return new MergeAction(list, this.model);
    }
}

