/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class UrlBasedQueryPanel
extends JPanel {
    private final JosmTextField tfUrl = new JosmTextField();
    private final JLabel lblValid = new JLabel();

    public UrlBasedQueryPanel() {
        this.build();
    }

    protected JPanel buildURLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.tfUrl, gridBagConstraints);
        this.tfUrl.getDocument().addDocumentListener(new ChangetQueryUrlValidator());
        this.tfUrl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                UrlBasedQueryPanel.this.tfUrl.selectAll();
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.lblValid, gridBagConstraints);
        this.lblValid.setPreferredSize(new Dimension(20, 20));
        return jPanel;
    }

    protected JPanel buildHelpPanel() {
        String string = OsmApi.getOsmApi().getBaseUrl();
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html><body>" + I18n.tr("Please enter or paste an URL to retrieve changesets from the OSM API.", new Object[0]) + "<p><strong>" + I18n.tr("Examples", new Object[0]) + "</strong></p><ul><li><a href=\"" + Main.getOSMWebsite() + "/history?open=true\">" + Main.getOSMWebsite() + "/history?open=true</a></li><li><a href=\"" + string + "/changesets?open=true\">" + string + "/changesets?open=true</a></li></ul>" + I18n.tr("Note that changeset queries are currently always submitted to ''{0}'', regardless of the host, port and path of the URL entered below.", string) + "</body></html>");
        htmlPanel.getEditorPane().addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                this.tfUrl.setText(hyperlinkEvent.getDescription());
                this.tfUrl.requestFocusInWindow();
            }
        });
        return htmlPanel;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.buildHelpPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.buildURLPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    protected boolean isValidChangesetQueryUrl(String string) {
        return this.buildChangesetQuery(string) != null;
    }

    protected ChangesetQuery buildChangesetQuery(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string2 = uRL.getPath();
        if (string2 == null || !string2.endsWith("/changesets")) {
            return null;
        }
        try {
            return ChangesetQuery.buildFromUrlQuery(uRL.getQuery());
        }
        catch (ChangesetQuery.ChangesetQueryUrlException changesetQueryUrlException) {
            Logging.warn(changesetQueryUrlException);
            return null;
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        String string = this.tfUrl.getText().trim();
        return this.buildChangesetQuery(string);
    }

    public void startUserInput() {
        this.tfUrl.requestFocusInWindow();
    }

    class ChangetQueryUrlValidator
    implements DocumentListener {
        ChangetQueryUrlValidator() {
        }

        protected String getCurrentFeedback() {
            String string = (String)UrlBasedQueryPanel.this.lblValid.getClientProperty("valid");
            return string == null ? "none" : string;
        }

        protected void feedbackValid() {
            if ("valid".equals(this.getCurrentFeedback())) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("dialogs", "valid"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "valid");
        }

        protected void feedbackInvalid() {
            if ("invalid".equals(this.getCurrentFeedback())) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(I18n.tr("This changeset query URL is invalid", new Object[0]));
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "invalid");
        }

        protected void feedbackNone() {
            UrlBasedQueryPanel.this.lblValid.setIcon(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "none");
        }

        protected void validate() {
            String string = UrlBasedQueryPanel.this.tfUrl.getText();
            if (string.trim().isEmpty()) {
                this.feedbackNone();
                return;
            }
            if (UrlBasedQueryPanel.this.isValidChangesetQueryUrl(string = string.trim())) {
                this.feedbackValid();
            } else {
                this.feedbackInvalid();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validate();
        }
    }
}

