/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DateValidator
extends AbstractTextComponentValidator {
    public DateValidator(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    public static DateValidator decorate(JTextComponent jTextComponent) {
        return new DateValidator(jTextComponent);
    }

    @Override
    public boolean isValid() {
        return this.getDate() != null;
    }

    public String getStandardTooltipTextAsHtml() {
        return "<html>" + this.getStandardTooltipText() + "</html>";
    }

    public String getStandardTooltipText() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        return I18n.tr("Please enter a date in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(zonedDateTime), DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).format(zonedDateTime), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(zonedDateTime), DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).format(zonedDateTime));
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            String string = "<html>The current value isn't a valid date.<br>" + this.getStandardTooltipText() + "</html>";
            this.feedbackInvalid(string);
            return;
        }
        String string = "<html>" + this.getStandardTooltipText() + "</html>";
        this.feedbackValid(string);
    }

    public LocalDate getDate() {
        for (FormatStyle formatStyle : FormatStyle.values()) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(formatStyle);
            try {
                return LocalDate.parse(this.getComponent().getText(), dateTimeFormatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
                Logging.trace(dateTimeParseException);
            }
        }
        return null;
    }
}

