/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetAware;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.DownloadChangesetContentAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetDetailPanel
extends JPanel
implements PropertyChangeListener,
ChangesetAware {
    private final JosmTextField tfID = new JosmTextField(10);
    private final JosmTextArea taComment = new JosmTextArea(5, 40);
    private final JosmTextField tfOpen = new JosmTextField(10);
    private final JosmTextField tfUser = new JosmTextField("");
    private final JosmTextField tfCreatedOn = new JosmTextField(20);
    private final JosmTextField tfClosedOn = new JosmTextField(20);
    private final DownloadChangesetContentAction actDownloadChangesetContent = new DownloadChangesetContentAction(this);
    private final UpdateChangesetAction actUpdateChangesets = new UpdateChangesetAction();
    private final RemoveFromCacheAction actRemoveFromCache = new RemoveFromCacheAction();
    private final SelectInCurrentLayerAction actSelectInCurrentLayer = new SelectInCurrentLayerAction();
    private final ZoomInCurrentLayerAction actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
    private transient Changeset currentChangeset;

    protected JPanel buildActionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.actRemoveFromCache);
        this.actRemoveFromCache.initProperties(this.currentChangeset);
        jToolBar.add(this.actUpdateChangesets);
        this.actUpdateChangesets.initProperties(this.currentChangeset);
        jToolBar.add(this.actDownloadChangesetContent);
        this.actDownloadChangesetContent.initProperties();
        jToolBar.add(this.actSelectInCurrentLayer);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actSelectInCurrentLayer);
        jToolBar.add(this.actZoomInCurrentLayerAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(ChangesetDetailPanel.this.actSelectInCurrentLayer);
                MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(ChangesetDetailPanel.this.actZoomInCurrentLayerAction);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                MainApplication.getLayerManager().removeActiveLayerChangeListener(ChangesetDetailPanel.this.actSelectInCurrentLayer);
                MainApplication.getLayerManager().removeActiveLayerChangeListener(ChangesetDetailPanel.this.actZoomInCurrentLayerAction);
            }
        });
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected JPanel buildDetailViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 2, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("ID:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfID, gridBagConstraints);
        this.tfID.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Comment:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.taComment, gridBagConstraints);
        this.taComment.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Open/Closed:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfOpen, gridBagConstraints);
        this.tfOpen.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Created by:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfUser, gridBagConstraints);
        this.tfUser.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Created on:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfCreatedOn, gridBagConstraints);
        this.tfCreatedOn.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Closed on:", new Object[0])), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfClosedOn, gridBagConstraints);
        this.tfClosedOn.setEditable(false);
        return jPanel;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildDetailViewPanel(), "Center");
        this.add((Component)this.buildActionButtonPanel(), "West");
    }

    protected void clearView() {
        this.tfID.setText("");
        this.taComment.setText("");
        this.tfOpen.setText("");
        this.tfUser.setText("");
        this.tfCreatedOn.setText("");
        this.tfClosedOn.setText("");
    }

    protected void updateView(Changeset changeset) {
        if (changeset == null) {
            return;
        }
        this.tfID.setText(Integer.toString(changeset.getId()));
        this.taComment.setText(changeset.getComment());
        String string = changeset.isOpen() ? I18n.trc("changeset.state", "Open") : I18n.trc("changeset.state", "Closed");
        this.tfOpen.setText(string);
        string = changeset.getUser() == null ? I18n.tr("anonymous", new Object[0]) : changeset.getUser().getName();
        this.tfUser.setText(string);
        DateFormat dateFormat = DateUtils.getDateTimeFormat(3, 3);
        Date date = changeset.getCreatedAt();
        Date date2 = changeset.getClosedAt();
        this.tfCreatedOn.setText(date == null ? "" : dateFormat.format(date));
        this.tfClosedOn.setText(date2 == null ? "" : dateFormat.format(date2));
    }

    public ChangesetDetailPanel() {
        this.build();
    }

    protected void setCurrentChangeset(Changeset changeset) {
        this.currentChangeset = changeset;
        if (changeset == null) {
            this.clearView();
        } else {
            this.updateView(changeset);
        }
        this.actDownloadChangesetContent.initProperties();
        this.actUpdateChangesets.initProperties(this.currentChangeset);
        this.actRemoveFromCache.initProperties(this.currentChangeset);
        this.actSelectInCurrentLayer.updateEnabledState();
        this.actZoomInCurrentLayerAction.updateEnabledState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.setCurrentChangeset((Changeset)propertyChangeEvent.getNewValue());
    }

    @Override
    public Changeset getCurrentChangeset() {
        return this.currentChangeset;
    }

    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements MainLayerManager.ActiveLayerChangeListener {
        ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            new ImageProvider("dialogs/autoscale", "selection").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Zoom to the objects in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToZoomTo() {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.currentChangeset.getId(), MainApplication.getLayerManager().getEditLayer().getName()), I18n.tr("Nothing to zoom to", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : osmDataLayer.data.allPrimitives()) {
                if (!osmPrimitive.isUsable() || osmPrimitive.getChangesetId() != ChangesetDetailPanel.this.currentChangeset.getId()) continue;
                hashSet.add(osmPrimitive);
            }
            if (hashSet.isEmpty()) {
                this.alertNoPrimitivesToZoomTo();
                return;
            }
            osmDataLayer.data.setSelected(hashSet);
            AutoScaleAction.zoomToSelection();
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getEditLayer() != null && ChangesetDetailPanel.this.currentChangeset != null);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            this.updateEnabledState();
        }
    }

    class SelectInCurrentLayerAction
    extends AbstractAction
    implements MainLayerManager.ActiveLayerChangeListener {
        SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            new ImageProvider("dialogs", "select").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Select the primitives in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToSelect() {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.currentChangeset.getId(), Utils.escapeReservedCharactersHTML(MainApplication.getLayerManager().getEditLayer().getName())), I18n.tr("Nothing to select", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : osmDataLayer.data.allPrimitives()) {
                if (!osmPrimitive.isUsable() || osmPrimitive.getChangesetId() != ChangesetDetailPanel.this.currentChangeset.getId()) continue;
                hashSet.add(osmPrimitive);
            }
            if (hashSet.isEmpty()) {
                this.alertNoPrimitivesToSelect();
                return;
            }
            osmDataLayer.data.setSelected(hashSet);
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getEditLayer() != null && ChangesetDetailPanel.this.currentChangeset != null);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            this.updateEnabledState();
        }
    }

    class UpdateChangesetAction
    extends AbstractAction {
        UpdateChangesetAction() {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Update the changeset from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ChangesetDetailPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = new ChangesetHeaderDownloadTask(ChangesetDetailPanel.this, Collections.singleton(ChangesetDetailPanel.this.currentChangeset.getId()));
            MainApplication.worker.submit(new PostDownloadHandler(changesetHeaderDownloadTask, changesetHeaderDownloadTask.download()));
        }

        public void initProperties(Changeset changeset) {
            this.setEnabled(changeset != null && !Main.isOffline(OnlineResource.OSM_API));
        }
    }

    class RemoveFromCacheAction
    extends AbstractAction {
        RemoveFromCacheAction() {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Remove the changeset in the detail view panel from the local cache", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ChangesetDetailPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetCache.getInstance().remove(ChangesetDetailPanel.this.currentChangeset);
        }

        public void initProperties(Changeset changeset) {
            this.setEnabled(changeset != null);
        }
    }
}

