/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class LatLonDialog
extends ExtendedDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    public JTabbedPane tabs;
    private JosmTextField tfLatLon;
    private JosmTextField tfEastNorth;
    private LatLon latLonCoordinates;
    private EastNorth eastNorthCoordinates;

    protected JPanel buildLatLon() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfLatLon = new JosmTextField(24);
        jPanel.add((Component)this.tfLatLon, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)new HtmlPanel(Utils.join("<br/>", Arrays.asList(I18n.tr("Enter the coordinates for the new node.", new Object[0]), I18n.tr("You can separate longitude and latitude with space, comma or semicolon.", new Object[0]), I18n.tr("Use positive numbers or N, E characters to indicate North or East cardinal direction.", new Object[0]), I18n.tr("For South and West cardinal directions you can use either negative numbers or S, W characters.", new Object[0]), I18n.tr("Coordinate value can be in one of three formats:", new Object[0]))) + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("<i>degrees</i><tt>&deg;</tt>", new Object[0]), I18n.tr("<i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt>", new Object[0]), I18n.tr("<i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt>", new Object[0]))) + Utils.join("<br/><br/>", Arrays.asList(I18n.tr("Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.", new Object[0]), I18n.tr("You can also use the syntax <tt>lat=\"...\" lon=\"...\"</tt> or <tt>lat=''...'' lon=''...''</tt>.", new Object[0]), I18n.tr("Some examples:", new Object[0]))) + "<table><tr><td>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("49.29918&deg; 19.24788&deg;", "N 49.29918 E 19.24788", "W 49&deg;29.918&#39; S 19&deg;24.788&#39;", "N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;", "49.29918 N, 19.24788 E", "49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E", "49 29 51, 19 24 18", "49 29, 19 24", "E 49 29, N 19 24")) + "</td><td>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("49&deg; 29; 19&deg; 24", "N 49&deg; 29, W 19&deg; 24", "49&deg; 29.5 S, 19&deg; 24.6 E", "N 49 29.918 E 19 15.88", "49 29.4 19 24.5", "-49 29.4 N -19 24.5 W", "48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E", "lat=\"49.29918\" lon=\"19.24788\"", "lat='49.29918' lon='19.24788'")) + "</td></tr></table>"), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier latLonInputVerifier = new LatLonInputVerifier();
        this.tfLatLon.getDocument().addDocumentListener(latLonInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfLatLon.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    private JPanel buildEastNorth() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Projected coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfEastNorth = new JosmTextField(24);
        jPanel.add((Component)this.tfEastNorth, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)new HtmlPanel(I18n.tr("Enter easting and northing (x and y) separated by space, comma or semicolon.", new Object[0])), GBC.eol().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill().weight(1.0, 1.0));
        EastNorthInputVerifier eastNorthInputVerifier = new EastNorthInputVerifier();
        this.tfEastNorth.getDocument().addDocumentListener(eastNorthInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfEastNorth.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    protected void build() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18n.tr("Lat/Lon", new Object[0]), this.buildLatLon());
        this.tabs.addTab(I18n.tr("East/North", new Object[0]), this.buildEastNorth());
        this.tabs.getModel().addChangeListener(changeEvent -> {
            switch (this.tabs.getModel().getSelectedIndex()) {
                case 0: {
                    this.parseLatLonUserInput();
                    break;
                }
                case 1: {
                    this.parseEastNorthUserInput();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        });
        this.setContent(this.tabs, false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                LatLonDialog.this.tfLatLon.requestFocusInWindow();
            }
        });
    }

    public LatLonDialog(Component component, String string, String string2) {
        super(component, string, I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("ok", "cancel");
        this.configureContextsensitiveHelp(string2, true);
        this.build();
        this.setCoordinates(null);
    }

    public boolean isLatLon() {
        return this.tabs.getModel().getSelectedIndex() == 0;
    }

    public void setCoordinates(LatLon latLon) {
        LatLon latLon2 = Optional.ofNullable(latLon).orElse(LatLon.ZERO);
        this.tfLatLon.setText(latLon2.latToString(CoordinateFormat.getDefaultFormat()) + ' ' + latLon2.lonToString(CoordinateFormat.getDefaultFormat()));
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(latLon2);
        this.tfEastNorth.setText(Double.toString(eastNorth.east()) + ' ' + Double.toString(eastNorth.north()));
        this.latLonCoordinates = latLon2;
        this.eastNorthCoordinates = eastNorth;
        this.setOkEnabled(true);
    }

    public LatLon getCoordinates() {
        if (this.isLatLon()) {
            return this.latLonCoordinates;
        }
        if (this.eastNorthCoordinates == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(this.eastNorthCoordinates);
    }

    public LatLon getLatLonCoordinates() {
        return this.latLonCoordinates;
    }

    public EastNorth getEastNorthCoordinates() {
        return this.eastNorthCoordinates;
    }

    protected void setErrorFeedback(JosmTextField josmTextField, String string) {
        josmTextField.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        josmTextField.setToolTipText(string);
        josmTextField.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JosmTextField josmTextField, String string) {
        josmTextField.setBorder(UIManager.getBorder("TextField.border"));
        josmTextField.setToolTipText(string);
        josmTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    protected void parseLatLonUserInput() {
        LatLon latLon;
        try {
            latLon = LatLon.parse(this.tfLatLon.getText());
            if (!LatLon.isValidLat(latLon.lat()) || !LatLon.isValidLon(latLon.lon())) {
                latLon = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
            latLon = null;
        }
        if (latLon == null) {
            this.setErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = latLon;
            this.setOkEnabled(true);
        }
    }

    protected void parseEastNorthUserInput() {
        EastNorth eastNorth;
        try {
            eastNorth = LatLonDialog.parseEastNorth(this.tfEastNorth.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
            eastNorth = null;
        }
        if (eastNorth == null) {
            this.setErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.eastNorthCoordinates = eastNorth;
            this.setOkEnabled(true);
        }
    }

    private void setOkEnabled(boolean bl) {
        if (this.buttons != null && !this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        String string = this.getClass().getName() + ".geometry";
        if (bl) {
            new WindowGeometry(string, WindowGeometry.centerInWindow(this.getParent(), this.getSize())).applySafe(this);
        } else {
            new WindowGeometry(this).remember(string);
        }
        super.setVisible(bl);
    }

    public static EastNorth parseEastNorth(String string) {
        String[] stringArray = string.split("[;, ]+");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            return new EastNorth(d, d2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getLatLonText() {
        return this.tfLatLon.getText();
    }

    public void setLatLonText(String string) {
        this.tfLatLon.setText(string);
    }

    public String getEastNorthText() {
        return this.tfEastNorth.getText();
    }

    public void setEastNorthText(String string) {
        this.tfEastNorth.setText(string);
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JosmTextField) {
                JosmTextField josmTextField = (JosmTextField)component;
                josmTextField.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class EastNorthInputVerifier
    implements DocumentListener {
        EastNorthInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }
    }
}

