/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractTagPaster
extends AbstractOsmDataPaster {
    AbstractTagPaster(DataFlavor dataFlavor) {
        super(dataFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) throws UnsupportedFlavorException, IOException {
        Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
        if (collection.isEmpty()) {
            return false;
        }
        return this.importTagsOn(transferSupport, collection);
    }

    @Override
    public boolean importTagsOn(TransferHandler.TransferSupport transferSupport, Collection<? extends OsmPrimitive> collection) throws UnsupportedFlavorException, IOException {
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(collection, this.getTags(transferSupport));
        AbstractTagPaster.commitCommands(collection, Collections.singletonList(changePropertyCommand));
        return true;
    }

    protected static void commitCommands(Collection<? extends OsmPrimitive> collection, List<Command> list) {
        if (!list.isEmpty()) {
            String string = I18n.trn("Pasting {0} tag", "Pasting {0} tags", list.size(), list.size());
            String string2 = I18n.trn("to {0} object", "to {0} objects", collection.size(), collection.size());
            String string3 = string + ' ' + string2;
            MainApplication.undoRedo.add(new SequenceCommand(string3, list));
        }
    }

    protected abstract Map<String, String> getTags(TransferHandler.TransferSupport var1) throws UnsupportedFlavorException, IOException;
}

