/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.data;

import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.TagTransferData;

public class PrimitiveTagTransferData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor FLAVOR = new DataFlavor(TagTransferData.class, "OSM Primitive Tags");
    private final EnumMap<OsmPrimitiveType, TagCollection> tags = new EnumMap(OsmPrimitiveType.class);
    private final EnumMap<OsmPrimitiveType, Integer> counts = new EnumMap(OsmPrimitiveType.class);

    public PrimitiveTagTransferData(Collection<? extends PrimitiveData> collection) {
        for (OsmPrimitiveType object : OsmPrimitiveType.dataValues()) {
            this.tags.put(object, new TagCollection());
        }
        for (PrimitiveData primitiveData : collection) {
            this.tags.get((Object)primitiveData.getType()).add(TagCollection.from(primitiveData));
            this.counts.merge(primitiveData.getType(), 1, (n, n2) -> n + n2);
        }
    }

    public PrimitiveTagTransferData(PrimitiveTransferData primitiveTransferData) {
        this(primitiveTransferData.getDirectlyAdded());
    }

    public boolean isHeterogeneousSource() {
        return this.counts.size() > 1;
    }

    public TagCollection getForPrimitives(OsmPrimitiveType osmPrimitiveType) {
        return this.tags.get((Object)osmPrimitiveType);
    }

    public int getSourcePrimitiveCount(OsmPrimitiveType osmPrimitiveType) {
        return this.counts.getOrDefault((Object)osmPrimitiveType, 0);
    }

    public Map<OsmPrimitiveType, Integer> getStatistics() {
        return Collections.unmodifiableMap(this.counts);
    }
}

