/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.EditableList;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class TagChecker
extends Test.TagTest {
    public static final String IGNORE_FILE = "resource://data/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/validator/words.cfg";
    private static final Map<String, String> harmonizedKeys = new HashMap<String, String>();
    private static volatile MultiMap<String, String> additionalPresetsValueData;
    private static final List<CheckerData> checkerData;
    private static final List<String> ignoreDataStartsWith;
    private static final List<String> ignoreDataEquals;
    private static final List<String> ignoreDataEndsWith;
    private static final List<Tag> ignoreDataTag;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    protected boolean checkKeys;
    protected boolean checkValues;
    protected boolean checkComplex;
    protected boolean checkFixmes;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected static final int EMPTY_VALUES = 1200;
    protected static final int INVALID_KEY = 1201;
    protected static final int INVALID_VALUE = 1202;
    protected static final int FIXME = 1203;
    protected static final int INVALID_SPACE = 1204;
    protected static final int INVALID_KEY_SPACE = 1205;
    protected static final int INVALID_HTML = 1206;
    protected static final int LONG_VALUE = 1208;
    protected static final int LONG_KEY = 1209;
    protected static final int LOW_CHAR_VALUE = 1210;
    protected static final int LOW_CHAR_KEY = 1211;
    protected static final int MISSPELLED_VALUE = 1212;
    protected static final int MISSPELLED_KEY = 1213;
    protected static final int MULTIPLE_SPACES = 1214;
    protected EditableList sourcesList;
    private static final Set<String> DEFAULT_SOURCES;

    public TagChecker() {
        super(I18n.tr("Tag checker", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    @Override
    public void initialize() throws IOException {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    private static void initializeData() throws IOException {
        checkerData.clear();
        ignoreDataStartsWith.clear();
        ignoreDataEquals.clear();
        ignoreDataEndsWith.clear();
        ignoreDataTag.clear();
        harmonizedKeys.clear();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : Main.pref.getCollection(PREF_SOURCES, DEFAULT_SOURCES)) {
            try {
                CachedFile cachedFile = new CachedFile(string);
                Throwable throwable = null;
                try {
                    BufferedReader bufferedReader = cachedFile.getContentReader();
                    Throwable throwable2 = null;
                    try {
                        String string2;
                        String string3 = null;
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = true;
                        while ((string2 = bufferedReader.readLine()) != null && (bl || !string2.isEmpty())) {
                            Object object;
                            if (string2.startsWith("#")) {
                                if (string2.startsWith("# JOSM TagChecker")) {
                                    bl = true;
                                    if (!DEFAULT_SOURCES.contains(string)) {
                                        Logging.info(I18n.tr("Adding {0} to tag checker", string));
                                    }
                                } else if (string2.startsWith("# JOSM IgnoreTags")) {
                                    bl2 = true;
                                    if (!DEFAULT_SOURCES.contains(string)) {
                                        Logging.info(I18n.tr("Adding {0} to ignore tags", string));
                                    }
                                }
                            } else if (bl2) {
                                if ((string2 = string2.trim()).length() < 4) continue;
                                object = string2.substring(0, 2);
                                string2 = string2.substring(2);
                                switch (object) {
                                    case "S:": {
                                        ignoreDataStartsWith.add(string2);
                                        break;
                                    }
                                    case "E:": {
                                        ignoreDataEquals.add(string2);
                                        break;
                                    }
                                    case "F:": {
                                        ignoreDataEndsWith.add(string2);
                                        break;
                                    }
                                    case "K:": {
                                        ignoreDataTag.add(Tag.ofString(string2));
                                        break;
                                    }
                                    default: {
                                        if (!((String)object).startsWith(";")) {
                                            Logging.warn("Unsupported TagChecker key: " + (String)object);
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bl) {
                                if (!string2.isEmpty()) {
                                    object = new CheckerData();
                                    Object object2 = ((CheckerData)object).getData(string2);
                                    if (object2 == null) {
                                        checkerData.add((CheckerData)object);
                                    } else {
                                        Logging.error(I18n.tr("Invalid tagchecker line - {0}: {1}", object2, string2));
                                    }
                                }
                            } else if (string2.charAt(0) == '+') {
                                string3 = string2.substring(1);
                            } else if (string2.charAt(0) == '-' && string3 != null) {
                                harmonizedKeys.put(TagChecker.harmonizeKey(string2.substring(1)), string3);
                            } else {
                                Logging.error(I18n.tr("Invalid spellcheck line: {0}", string2));
                            }
                            if (!bl3) continue;
                            bl3 = false;
                            if (bl || bl2 || DEFAULT_SOURCES.contains(string)) continue;
                            Logging.info(I18n.tr("Adding {0} to spellchecker", string));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedReader == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedReader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (cachedFile == null) continue;
                    if (throwable != null) {
                        try {
                            cachedFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    cachedFile.close();
                }
            }
            catch (IOException iOException) {
                Logging.error(iOException);
                stringBuilder.append(string).append('\n');
            }
        }
        if (stringBuilder.length() > 0) {
            throw new IOException(I18n.tr("Could not access data file(s):\n{0}", stringBuilder));
        }
    }

    public static void initializePresets() {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> collection = TaggingPresets.getTaggingPresets();
        if (!collection.isEmpty()) {
            additionalPresetsValueData = new MultiMap();
            for (String object : OsmPrimitive.getUninterestingKeys()) {
                additionalPresetsValueData.putVoid(object);
            }
            for (String string : Main.pref.getCollection("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
                additionalPresetsValueData.putVoid(string);
            }
            for (TaggingPreset taggingPreset : collection) {
                for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                    if (taggingPresetItem instanceof KeyedItem) {
                        TagChecker.addPresetValue((KeyedItem)taggingPresetItem);
                        continue;
                    }
                    if (!(taggingPresetItem instanceof CheckGroup)) continue;
                    for (Check check : ((CheckGroup)taggingPresetItem).checks) {
                        TagChecker.addPresetValue(check);
                    }
                }
            }
        }
    }

    private static void addPresetValue(KeyedItem keyedItem) {
        Collection<String> collection = keyedItem.getValues();
        if (keyedItem.key != null && collection != null) {
            harmonizedKeys.put(TagChecker.harmonizeKey(keyedItem.key), keyedItem.key);
        }
    }

    private static boolean containsLow(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= ' ') continue;
            return true;
        }
        return false;
    }

    private static Set<String> getPresetValues(String string) {
        Set<String> set = TaggingPresets.getPresetValues(string);
        if (set != null) {
            return set;
        }
        return additionalPresetsValueData.get(string);
    }

    public static boolean isKeyInPresets(String string) {
        return TagChecker.getPresetValues(string) != null;
    }

    public static boolean isTagInPresets(String string, String string2) {
        Set<String> set = TagChecker.getPresetValues(string);
        return set != null && (set.isEmpty() || set.contains(string2));
    }

    public static List<Tag> getIgnoredTags() {
        return new ArrayList<Tag>(ignoreDataTag);
    }

    public static boolean isTagIgnored(String string, String string2) {
        boolean bl = TagChecker.isTagInPresets(string, string2);
        boolean bl2 = false;
        for (String object : ignoreDataStartsWith) {
            if (!string.startsWith(object)) continue;
            bl2 = true;
        }
        for (String string3 : ignoreDataEquals) {
            if (!string.equals(string3)) continue;
            bl2 = true;
        }
        for (String string4 : ignoreDataEndsWith) {
            if (!string.endsWith(string4)) continue;
            bl2 = true;
        }
        if (!bl) {
            for (Tag tag : ignoreDataTag) {
                if (!string.equals(tag.getKey()) || !string2.equals(tag.getValue())) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        MultiMap<OsmPrimitive, String> multiMap = new MultiMap<OsmPrimitive, String>();
        if (this.checkComplex) {
            TagMap tagMap = osmPrimitive.getKeys();
            for (CheckerData checkerData : TagChecker.checkerData) {
                if (!checkerData.match(osmPrimitive, tagMap)) continue;
                this.errors.add(TestError.builder(this, checkerData.getSeverity(), checkerData.getCode()).message(I18n.tr("Suspicious tag/value combinations", new Object[0]), checkerData.getDescription(), new Object[0]).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "TC");
            }
        }
        for (Map.Entry entry : osmPrimitive.getKeys().entrySet()) {
            String string = I18n.marktr("Key ''{0}'' invalid.");
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (this.checkValues && TagChecker.containsLow(string3) && !multiMap.contains(osmPrimitive, "ICV")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1210).message(I18n.tr("Tag value contains character with code less than 0x20", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "ICV");
            }
            if (this.checkKeys && TagChecker.containsLow(string2) && !multiMap.contains(osmPrimitive, "ICK")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1211).message(I18n.tr("Tag key contains character with code less than 0x20", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "ICK");
            }
            if (this.checkValues && string3 != null && string3.length() > 255 && !multiMap.contains(osmPrimitive, "LV")) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 1208).message(I18n.tr("Tag value longer than allowed", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "LV");
            }
            if (this.checkKeys && string2 != null && string2.length() > 255 && !multiMap.contains(osmPrimitive, "LK")) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 1209).message(I18n.tr("Tag key longer than allowed", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "LK");
            }
            if (this.checkValues && (string3 == null || string3.trim().isEmpty()) && !multiMap.contains(osmPrimitive, "EV")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1200).message(I18n.tr("Tags with empty values", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "EV");
            }
            if (this.checkKeys && string2 != null && string2.indexOf(32) >= 0 && !multiMap.contains(osmPrimitive, "IPK")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1205).message(I18n.tr("Invalid white space in property key", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "IPK");
            }
            if (this.checkValues && string3 != null && (string3.startsWith(" ") || string3.endsWith(" ")) && !multiMap.contains(osmPrimitive, "SPACE")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1204).message(I18n.tr("Property values start or end with white space", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "SPACE");
            }
            if (this.checkValues && string3 != null && string3.contains("  ") && !multiMap.contains(osmPrimitive, "SPACE")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1214).message(I18n.tr("Property values contain multiple white spaces", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "SPACE");
            }
            if (this.checkValues && string3 != null && !string3.equals(Entities.unescape(string3)) && !multiMap.contains(osmPrimitive, "HTML")) {
                this.errors.add(TestError.builder(this, Severity.OTHER, 1206).message(I18n.tr("Property values contain HTML entity", new Object[0]), string, string2).primitives(osmPrimitive).build());
                multiMap.put(osmPrimitive, "HTML");
            }
            if (this.checkValues && string2 != null && string3 != null && !string3.isEmpty() && additionalPresetsValueData != null && !TagChecker.isTagIgnored(string2, string3)) {
                Object object;
                Map<String, String> map;
                String string4;
                if (!TagChecker.isKeyInPresets(string2)) {
                    string4 = TagChecker.harmonizeKey(string2);
                    map = harmonizedKeys.get(string4);
                    if (map != null && !"".equals(map) && !((String)((Object)map)).equals(string2)) {
                        object = TestError.builder(this, Severity.WARNING, 1213).message(I18n.tr("Misspelled property key", new Object[0]), I18n.marktr("Key ''{0}'' looks like ''{1}''."), string2, map).primitives(osmPrimitive);
                        if (osmPrimitive.hasKey((String)((Object)map))) {
                            this.errors.add(((TestError.Builder)object).build());
                        } else {
                            this.errors.add(((TestError.Builder)object).fix(() -> TagChecker.lambda$check$0(osmPrimitive, string2, (String)((Object)map))).build());
                        }
                        multiMap.put(osmPrimitive, "WPK");
                    } else {
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property key", new Object[0]), I18n.marktr("Key ''{0}'' not in presets."), string2).primitives(osmPrimitive).build());
                        multiMap.put(osmPrimitive, "UPK");
                    }
                } else if (!TagChecker.isTagInPresets(string2, string3)) {
                    string4 = TagChecker.harmonizeValue((String)entry.getValue());
                    map = TagChecker.getPossibleValues(TagChecker.getPresetValues(string2));
                    if (map.containsKey(string4)) {
                        object = (String)map.get(string4);
                        this.errors.add(TestError.builder(this, Severity.WARNING, 1212).message(I18n.tr("Misspelled property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' looks like ''{2}''."), entry.getValue(), string2, string4).primitives(osmPrimitive).fix(() -> TagChecker.lambda$check$1(osmPrimitive, string2, (String)object)).build());
                        multiMap.put(osmPrimitive, "WPV");
                    } else {
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets."), entry.getValue(), string2).primitives(osmPrimitive).build());
                        multiMap.put(osmPrimitive, "UPV");
                    }
                }
            }
            if (!this.checkFixmes || string2 == null || string3 == null || string3.isEmpty() || !TagChecker.isFixme(string2, string3) || multiMap.contains(osmPrimitive, "FIXME")) continue;
            this.errors.add(TestError.builder(this, Severity.OTHER, 1203).message(I18n.tr("FIXMES", new Object[0])).primitives(osmPrimitive).build());
            multiMap.put(osmPrimitive, "FIXME");
        }
    }

    private static boolean isFixme(String string, String string2) {
        return string.toLowerCase(Locale.ENGLISH).contains("fixme") || string.contains("todo") || string2.toLowerCase(Locale.ENGLISH).contains("fixme") || string2.contains("check and delete");
    }

    private static Map<String, String> getPossibleValues(Set<String> set) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (set != null) {
            for (String string : set) {
                hashMap.put(string, string);
                if (!string.contains("_")) continue;
                hashMap.put(string.replace("_", ""), string);
            }
        }
        return hashMap;
    }

    private static String harmonizeKey(String string) {
        return Utils.strip(string.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(':', '_').replace(' ', '_'), "-_;:,");
    }

    private static String harmonizeValue(String string) {
        return Utils.strip(string.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_'), "-_;:,");
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Main.pref.getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkComplex && Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes) {
            super.visit(collection);
        }
    }

    @Override
    public void addGui(JPanel jPanel) {
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(this.name + " :"), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words.", new Object[0]));
        jPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckKeysBeforeUpload, gBC);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules.", new Object[0]));
        jPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckComplexBeforeUpload, gBC);
        Collection<String> collection = Main.pref.getCollection(PREF_SOURCES, DEFAULT_SOURCES);
        this.sourcesList = new EditableList(I18n.tr("TagChecker source", new Object[0]));
        this.sourcesList.setItems(collection);
        jPanel.add((Component)new JLabel(I18n.tr("Data sources ({0})", "*.cfg")), GBC.eol().insets(23, 0, 0, 0));
        jPanel.add((Component)this.sourcesList, GBC.eol().fill(2).insets(23, 0, 0, 0));
        ActionListener actionListener = actionEvent -> this.handlePrefEnable();
        this.prefCheckKeys.addActionListener(actionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(actionListener);
        this.prefCheckComplex.addActionListener(actionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(actionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets.", new Object[0]));
        jPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckValuesBeforeUpload, gBC);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for FIXMES.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with FIXME in any property value.", new Object[0]));
        jPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckFixmesBeforeUpload, gBC);
    }

    public void handlePrefEnable() {
        boolean bl = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(bl);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        return Main.pref.putCollection(PREF_SOURCES, this.sourcesList.getItems());
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> arrayList = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            TagMap tagMap = osmPrimitive.getKeys();
            if (tagMap.isEmpty()) continue;
            for (Map.Entry entry : tagMap.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == null || string2.trim().isEmpty()) {
                    arrayList.add(new ChangePropertyCommand(osmPrimitive, string, null));
                    continue;
                }
                if (string2.startsWith(" ") || string2.endsWith(" ") || string2.contains("  ")) {
                    arrayList.add(new ChangePropertyCommand(osmPrimitive, string, Tag.removeWhiteSpaces(string2)));
                    continue;
                }
                if (string.startsWith(" ") || string.endsWith(" ") || string.contains("  ")) {
                    arrayList.add(new ChangePropertyKeyCommand(osmPrimitive, string, Tag.removeWhiteSpaces(string)));
                    continue;
                }
                String string3 = Entities.unescape(string2);
                if (string3.equals(string2)) continue;
                arrayList.add(new ChangePropertyCommand(osmPrimitive, string, string3));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix tags", new Object[0]), arrayList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int n = testError.getCode();
            return n == 1201 || n == 1200 || n == 1204 || n == 1205 || n == 1206 || n == 1212 || n == 1214;
        }
        return false;
    }

    private static /* synthetic */ Command lambda$check$1(OsmPrimitive osmPrimitive, String string, String string2) {
        return new ChangePropertyCommand(osmPrimitive, string, string2);
    }

    private static /* synthetic */ Command lambda$check$0(OsmPrimitive osmPrimitive, String string, String string2) {
        return new ChangePropertyKeyCommand(osmPrimitive, string, string2);
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new ArrayList<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataTag = new ArrayList<Tag>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".source";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        DEFAULT_SOURCES = new HashSet<String>(Arrays.asList(IGNORE_FILE, SPELL_FILE));
    }

    protected static class CheckerData {
        private String description;
        protected List<CheckerElement> data = new ArrayList<CheckerElement>();
        private OsmPrimitiveType type;
        private TagCheckLevel level;
        protected Severity severity;
        private static final Pattern CLEAN_STR_PATTERN = Pattern.compile(" *# *([^#]+) *$");
        private static final Pattern SPLIT_TRIMMED_PATTERN = Pattern.compile(" *: *");
        private static final Pattern SPLIT_ELEMENTS_PATTERN = Pattern.compile(" *&& *");

        protected CheckerData() {
        }

        public String getData(String string) {
            Matcher matcher = CLEAN_STR_PATTERN.matcher(string);
            String string2 = matcher.replaceFirst("").trim();
            try {
                this.description = matcher.group(1);
                if (this.description != null && this.description.isEmpty()) {
                    this.description = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                Logging.error(illegalStateException);
                this.description = null;
            }
            String[] stringArray = SPLIT_TRIMMED_PATTERN.split(string2, 3);
            switch (stringArray[0]) {
                case "way": {
                    this.type = OsmPrimitiveType.WAY;
                    break;
                }
                case "node": {
                    this.type = OsmPrimitiveType.NODE;
                    break;
                }
                case "relation": {
                    this.type = OsmPrimitiveType.RELATION;
                    break;
                }
                case "*": {
                    this.type = null;
                    break;
                }
                default: {
                    return I18n.tr("Could not find element type", new Object[0]);
                }
            }
            if (stringArray.length != 3) {
                return I18n.tr("Incorrect number of parameters", new Object[0]);
            }
            switch (stringArray[1]) {
                case "W": {
                    this.severity = Severity.WARNING;
                    this.level = TagCheckLevel.TAG_CHECK_WARN;
                    break;
                }
                case "E": {
                    this.severity = Severity.ERROR;
                    this.level = TagCheckLevel.TAG_CHECK_ERROR;
                    break;
                }
                case "I": {
                    this.severity = Severity.OTHER;
                    this.level = TagCheckLevel.TAG_CHECK_INFO;
                    break;
                }
                default: {
                    return I18n.tr("Could not find warning level", new Object[0]);
                }
            }
            for (String string3 : SPLIT_ELEMENTS_PATTERN.split(stringArray[2])) {
                try {
                    this.data.add(new CheckerElement(string3));
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.trace(illegalStateException);
                    return I18n.tr("Illegal expression ''{0}''", string3);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    Logging.trace(patternSyntaxException);
                    return I18n.tr("Illegal regular expression ''{0}''", string3);
                }
            }
            return null;
        }

        public boolean match(OsmPrimitive osmPrimitive, Map<String, String> map) {
            if (this.type != null && OsmPrimitiveType.from(osmPrimitive) != this.type) {
                return false;
            }
            for (CheckerElement checkerElement : this.data) {
                if (checkerElement.match(map)) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            if (this.type == null) {
                return this.level.code;
            }
            return this.level.code + this.type.ordinal() + 1;
        }

        protected static class CheckerElement {
            public Object tag;
            public Object value;
            public boolean noMatch;
            public boolean tagAll;
            public boolean valueAll;
            public boolean valueBool;

            private static Pattern getPattern(String string) {
                if (string.endsWith("/i")) {
                    return Pattern.compile(string.substring(1, string.length() - 2), 2);
                }
                if (string.endsWith("/")) {
                    return Pattern.compile(string.substring(1, string.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String string) {
                Matcher matcher = Pattern.compile("(.+)([!=]=)(.+)").matcher(string);
                matcher.matches();
                String string2 = matcher.group(1).trim();
                if ("*".equals(string2)) {
                    this.tagAll = true;
                } else {
                    this.tag = string2.startsWith("/") ? CheckerElement.getPattern(string2) : string2;
                    this.noMatch = "!=".equals(matcher.group(2));
                    string2 = matcher.group(3).trim();
                    if ("*".equals(string2)) {
                        this.valueAll = true;
                    } else if ("BOOLEAN_TRUE".equals(string2)) {
                        this.valueBool = true;
                        this.value = "yes";
                    } else if ("BOOLEAN_FALSE".equals(string2)) {
                        this.valueBool = true;
                        this.value = "no";
                    } else {
                        this.value = string2.startsWith("/") ? CheckerElement.getPattern(string2) : string2;
                    }
                }
            }

            public boolean match(Map<String, String> map) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string;
                    String string2 = entry.getKey();
                    String string3 = string = this.valueBool ? OsmUtils.getNamedOsmBoolean(entry.getValue()) : entry.getValue();
                    if (!this.tagAll && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(string2).matches() : string2.equals(this.tag)) || !this.valueAll && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(string).matches() : string.equals(this.value))) continue;
                    return !this.noMatch;
                }
                return this.noMatch;
            }
        }

        private static enum TagCheckLevel {
            TAG_CHECK_ERROR(1250),
            TAG_CHECK_WARN(1260),
            TAG_CHECK_INFO(1270);

            final int code;

            private TagCheckLevel(int n2) {
                this.code = n2;
            }
        }
    }
}

