/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;

public abstract class SourcePrefHelper {
    private final String pref;

    public SourcePrefHelper(String string) {
        this.pref = string;
    }

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract Map<String, String> serialize(SourceEntry var1);

    public abstract SourceEntry deserialize(Map<String, String> var1);

    public List<SourceEntry> get() {
        Collection<Map<String, String>> collection = Main.pref.getListOfStructs(this.pref, (Collection<Map<String, String>>)null);
        if (collection == null) {
            return new ArrayList<SourceEntry>(this.getDefault());
        }
        ArrayList<SourceEntry> arrayList = new ArrayList<SourceEntry>();
        for (Map<String, String> map : collection) {
            SourceEntry sourceEntry = this.deserialize(new HashMap<String, String>(map));
            if (sourceEntry == null) continue;
            arrayList.add(sourceEntry);
        }
        return arrayList;
    }

    public boolean put(Collection<? extends SourceEntry> collection) {
        Collection<Map<String, String>> collection2;
        boolean bl;
        Collection<Map<String, String>> collection3 = this.serializeList(collection);
        boolean bl2 = bl = Main.pref.getListOfStructs(this.pref, (Collection<Map<String, String>>)null) == null;
        if (bl && collection3.equals(collection2 = this.serializeList(this.getDefault()))) {
            return false;
        }
        return Main.pref.putListOfStructs(this.pref, collection3);
    }

    private Collection<Map<String, String>> serializeList(Collection<? extends SourceEntry> collection) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(collection.size());
        for (SourceEntry sourceEntry : collection) {
            arrayList.add(this.serialize(sourceEntry));
        }
        return arrayList;
    }

    public final Set<String> getActiveUrls() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (SourceEntry sourceEntry : this.get()) {
            if (!sourceEntry.active) continue;
            linkedHashSet.add(sourceEntry.url);
        }
        return linkedHashSet;
    }
}

