/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintPrefHelper
extends SourcePrefHelper {
    public static final MapPaintPrefHelper INSTANCE = new MapPaintPrefHelper();

    public MapPaintPrefHelper() {
        super("mappaint.style.entries");
    }

    @Override
    public List<SourceEntry> get() {
        List<SourceEntry> list = super.get();
        if (this.insertNewDefaults(list)) {
            this.put(list);
        }
        return list;
    }

    private boolean insertNewDefaults(List<SourceEntry> list) {
        boolean bl = false;
        TreeSet<String> treeSet = new TreeSet<String>(Main.pref.getCollection("mappaint.style.known-defaults"));
        Collection<ExtendedSourceEntry> collection = this.getDefault();
        int n = 0;
        for (SourceEntry sourceEntry3 : collection) {
            int n2 = Utils.indexOf(list, sourceEntry2 -> Objects.equals(sourceEntry.url, sourceEntry2.url));
            if (n2 == -1 && !treeSet.contains(sourceEntry3.url)) {
                sourceEntry3.active = false;
                list.add(n, sourceEntry3);
                ++n;
                bl = true;
            } else if (n2 >= n) {
                n = n2 + 1;
            }
            treeSet.add(sourceEntry3.url);
        }
        Main.pref.putCollection("mappaint.style.known-defaults", treeSet);
        list.remove(Utils.find(list, sourceEntry -> "resource://styles/standard/elemstyles.xml".equals(sourceEntry.url)));
        return bl;
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ExtendedSourceEntry extendedSourceEntry = new ExtendedSourceEntry("elemstyles.mapcss", "resource://styles/standard/elemstyles.mapcss");
        extendedSourceEntry.active = true;
        extendedSourceEntry.name = "standard";
        extendedSourceEntry.title = I18n.tr("JOSM default (MapCSS)", new Object[0]);
        extendedSourceEntry.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles", new Object[0]);
        ExtendedSourceEntry extendedSourceEntry2 = new ExtendedSourceEntry("potlatch2.mapcss", "resource://styles/standard/potlatch2.mapcss");
        extendedSourceEntry2.active = false;
        extendedSourceEntry2.name = "standard";
        extendedSourceEntry2.title = I18n.tr("Potlatch 2", new Object[0]);
        extendedSourceEntry2.description = I18n.tr("the main Potlatch 2 style", new Object[0]);
        return Arrays.asList(extendedSourceEntry, extendedSourceEntry2);
    }

    @Override
    public Map<String, String> serialize(SourceEntry sourceEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("url", sourceEntry.url == null ? "" : sourceEntry.url);
        hashMap.put("title", sourceEntry.title == null ? "" : sourceEntry.title);
        hashMap.put("active", Boolean.toString(sourceEntry.active));
        if (sourceEntry.name != null) {
            hashMap.put("ptoken", sourceEntry.name);
        }
        return hashMap;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> map) {
        return new SourceEntry(map.get("url"), map.get("ptoken"), map.get("title"), Boolean.parseBoolean(map.get("active")));
    }
}

