/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBucketPrimitiveStore;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitiveFlagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class DataSet
extends QuadBucketPrimitiveStore
implements Data,
ProjectionChangeListener {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private final Storage<OsmPrimitive> allPrimitives = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash(), true);
    private final Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new Storage.PrimitiveIdHash());
    private final CopyOnWriteArrayList<DataSetListener> listeners = new CopyOnWriteArrayList();
    private Collection<WaySegment> highlightedVirtualNodes = new LinkedList<WaySegment>();
    private Collection<WaySegment> highlightedWaySegments = new LinkedList<WaySegment>();
    private final ListenerList<HighlightUpdateListener> highlightUpdateListeners = ListenerList.create();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private UploadPolicy uploadPolicy;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object selectionLock = new Object();
    private Set<OsmPrimitive> currentSelectedPrimitives = Collections.emptySet();
    private final ListenerList<DataSelectionListener> selectionListeners = ListenerList.create();
    private Area cachedDataSourceArea;
    private List<Bounds> cachedDataSourceBounds;
    private final Collection<DataSource> dataSources = new LinkedList<DataSource>();
    private final ConflictCollection conflicts = new ConflictCollection();
    private final LinkedList<Collection<? extends OsmPrimitive>> selectionHistory = new LinkedList();
    private AutoCompletionManager autocomplete;
    private String version;
    private final Map<String, String> changeSetTags = new HashMap<String, String>();
    private static final Collection<SelectionChangedListener> selListeners = new CopyOnWriteArrayList<SelectionChangedListener>();

    public DataSet() {
        Main.addProjectionChangeListener(this);
        this.addSelectionListener(selectionChangeEvent -> DataSet.fireDreprecatedSelectionChange(selectionChangeEvent.getSelection()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet(DataSet dataSet) {
        this();
        dataSet.getReadLock().lock();
        try {
            Object object;
            HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
            for (Node iterator2 : dataSet.getNodes()) {
                Node node = new Node(iterator2);
                hashMap.put(iterator2, node);
                this.addPrimitive(node);
            }
            for (Way way : dataSet.getWays()) {
                Way way2 = new Way(way);
                hashMap.put(way, way2);
                object = new ArrayList();
                for (Node node : way.getNodes()) {
                    object.add((Node)hashMap.get(node));
                }
                way2.setNodes((List<Node>)object);
                this.addPrimitive(way2);
            }
            Collection<Relation> collection = dataSet.getRelations();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                object = new Relation(relation);
                ((Relation)object).setMembers(null);
                hashMap.put(relation, object);
                this.addPrimitive((OsmPrimitive)object);
            }
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Relation relation = (Relation)iterator2.next();
                object = (Relation)hashMap.get(relation);
                ArrayList arrayList = new ArrayList();
                for (RelationMember relationMember : relation.getMembers()) {
                    arrayList.add(new RelationMember(relationMember.getRole(), (OsmPrimitive)hashMap.get(relationMember.getMember())));
                }
                ((Relation)object).setMembers(arrayList);
            }
            for (DataSource dataSource : dataSet.dataSources) {
                this.dataSources.add(new DataSource(dataSource));
            }
            this.version = dataSet.version;
            this.uploadPolicy = dataSet.uploadPolicy;
        }
        finally {
            dataSet.getReadLock().unlock();
        }
    }

    public synchronized boolean addDataSource(DataSource dataSource) {
        return this.addDataSources(Collections.singleton(dataSource));
    }

    public synchronized boolean addDataSources(Collection<DataSource> collection) {
        boolean bl = this.dataSources.addAll(collection);
        if (bl) {
            this.cachedDataSourceArea = null;
            this.cachedDataSourceBounds = null;
        }
        return bl;
    }

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public LinkedList<Collection<? extends OsmPrimitive>> getSelectionHistory() {
        return this.selectionHistory;
    }

    public void clearSelectionHistory() {
        this.selectionHistory.clear();
    }

    public AutoCompletionManager getAutoCompletionManager() {
        if (this.autocomplete == null) {
            this.autocomplete = new AutoCompletionManager(this);
            this.addDataSetListener(this.autocomplete);
        }
        return this.autocomplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @Deprecated
    public boolean isUploadDiscouraged() {
        return this.uploadPolicy == UploadPolicy.DISCOURAGED || this.uploadPolicy == UploadPolicy.BLOCKED;
    }

    @Deprecated
    public void setUploadDiscouraged(boolean bl) {
        if (this.uploadPolicy != UploadPolicy.BLOCKED) {
            this.uploadPolicy = bl ? UploadPolicy.DISCOURAGED : UploadPolicy.NORMAL;
        }
    }

    public UploadPolicy getUploadPolicy() {
        return this.uploadPolicy;
    }

    public void setUploadPolicy(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
    }

    public Map<String, String> getChangeSetTags() {
        return this.changeSetTags;
    }

    public void addChangeSetTag(String string, String string2) {
        this.changeSetTags.put(string, string2);
    }

    public <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<? super OsmPrimitive> predicate) {
        return new SubclassFilteredCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(Node.class::isInstance);
    }

    @Override
    public List<Node> searchNodes(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Node> list = super.searchNodes(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(Way.class::isInstance);
    }

    @Override
    public List<Way> searchWays(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Way> list = super.searchWays(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<Relation> searchRelations(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Relation> list = super.searchRelations(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(Relation.class::isInstance);
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(osmPrimitive -> true);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted());
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete());
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete() && !(osmPrimitive instanceof Relation));
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(AbstractPrimitive::isModified);
    }

    @Override
    public void addPrimitive(OsmPrimitive osmPrimitive) {
        Objects.requireNonNull(osmPrimitive, "primitive");
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(osmPrimitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", osmPrimitive.toString()));
            }
            this.allPrimitives.add(osmPrimitive);
            osmPrimitive.setDataset(this);
            osmPrimitive.updatePosition();
            super.addPrimitive(osmPrimitive);
            this.firePrimitivesAdded(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
            if (osmPrimitive == null) {
                return;
            }
            this.removePrimitiveImpl(osmPrimitive);
            this.firePrimitivesRemoved(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    private void removePrimitiveImpl(OsmPrimitive osmPrimitive) {
        this.clearSelection(osmPrimitive.getPrimitiveId());
        if (osmPrimitive.isSelected()) {
            throw new DataIntegrityProblemException("Primitive was re-selected by a selection listener: " + osmPrimitive);
        }
        super.removePrimitive(osmPrimitive);
        this.allPrimitives.remove(osmPrimitive);
        osmPrimitive.setDataset(null);
    }

    @Override
    protected void removePrimitive(OsmPrimitive osmPrimitive) {
        this.beginUpdate();
        try {
            this.removePrimitiveImpl(osmPrimitive);
            this.firePrimitivesRemoved(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addSelectionListener(DataSelectionListener dataSelectionListener) {
        this.selectionListeners.addListener(dataSelectionListener);
    }

    public void removeSelectionListener(DataSelectionListener dataSelectionListener) {
        this.selectionListeners.removeListener(dataSelectionListener);
    }

    public static void addSelectionListener(SelectionChangedListener selectionChangedListener) {
        ((CopyOnWriteArrayList)selListeners).addIfAbsent(selectionChangedListener);
    }

    public static void removeSelectionListener(SelectionChangedListener selectionChangedListener) {
        selListeners.remove(selectionChangedListener);
    }

    @Deprecated
    public void fireSelectionChanged() {
        DataSet.fireDreprecatedSelectionChange(this.getAllSelected());
    }

    private static void fireDreprecatedSelectionChange(Collection<? extends OsmPrimitive> collection) {
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        return new SubclassFilteredCollection(this.getSelected(), osmPrimitive -> osmPrimitive instanceof Node || osmPrimitive instanceof Way);
    }

    public Collection<WaySegment> getHighlightedVirtualNodes() {
        return Collections.unmodifiableCollection(this.highlightedVirtualNodes);
    }

    public Collection<WaySegment> getHighlightedWaySegments() {
        return Collections.unmodifiableCollection(this.highlightedWaySegments);
    }

    public void addHighlightUpdateListener(HighlightUpdateListener highlightUpdateListener) {
        this.highlightUpdateListeners.addListener(highlightUpdateListener);
    }

    public void removeHighlightUpdateListener(HighlightUpdateListener highlightUpdateListener) {
        this.highlightUpdateListeners.removeListener(highlightUpdateListener);
    }

    public Collection<OsmPrimitive> getSelected() {
        return new SubclassFilteredCollection(this.getAllSelected(), osmPrimitive -> !osmPrimitive.isDeleted());
    }

    public Collection<OsmPrimitive> getAllSelected() {
        return this.currentSelectedPrimitives;
    }

    public Collection<Node> getSelectedNodes() {
        return new SubclassFilteredCollection(this.getSelected(), Node.class::isInstance);
    }

    public Collection<Way> getSelectedWays() {
        return new SubclassFilteredCollection(this.getSelected(), Way.class::isInstance);
    }

    public Collection<Relation> getSelectedRelations() {
        return new SubclassFilteredCollection(this.getSelected(), Relation.class::isInstance);
    }

    public boolean selectionEmpty() {
        return this.currentSelectedPrimitives.isEmpty();
    }

    public boolean isSelected(OsmPrimitive osmPrimitive) {
        return this.currentSelectedPrimitives.contains(osmPrimitive);
    }

    public void setHighlightedVirtualNodes(Collection<WaySegment> collection) {
        if (this.highlightedVirtualNodes.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedVirtualNodes = collection;
        this.fireHighlightingChanged();
    }

    public void setHighlightedWaySegments(Collection<WaySegment> collection) {
        if (this.highlightedWaySegments.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedWaySegments = collection;
        this.fireHighlightingChanged();
    }

    @Deprecated
    public void setSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        this.setSelected(collection);
    }

    public void setSelected(Collection<? extends PrimitiveId> collection) {
        this.setSelected(collection.stream());
    }

    public void setSelected(PrimitiveId ... primitiveIdArray) {
        this.setSelected(Stream.of(primitiveIdArray).filter(Objects::nonNull));
    }

    private void setSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(set -> new DataSelectionListener.SelectionReplaceEvent(this, (Set<OsmPrimitive>)set, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void addSelected(Collection<? extends PrimitiveId> collection) {
        this.addSelected(collection.stream());
    }

    public void addSelected(PrimitiveId ... primitiveIdArray) {
        this.addSelected(Stream.of(primitiveIdArray));
    }

    private void addSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(set -> new DataSelectionListener.SelectionAddEvent(this, (Set<OsmPrimitive>)set, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void clearSelection(PrimitiveId ... primitiveIdArray) {
        this.clearSelection(Stream.of(primitiveIdArray));
    }

    public void clearSelection(Collection<? extends PrimitiveId> collection) {
        this.clearSelection(collection.stream());
    }

    public void clearSelection() {
        this.setSelected(Stream.empty());
    }

    private void clearSelection(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(set -> new DataSelectionListener.SelectionRemoveEvent(this, (Set<OsmPrimitive>)set, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void toggleSelected(Collection<? extends PrimitiveId> collection) {
        this.toggleSelected(collection.stream());
    }

    public void toggleSelected(PrimitiveId ... primitiveIdArray) {
        this.toggleSelected(Stream.of(primitiveIdArray));
    }

    private void toggleSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(set -> new DataSelectionListener.SelectionToggleEvent(this, (Set<OsmPrimitive>)set, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSelectionChange(Function<Set<OsmPrimitive>, DataSelectionListener.SelectionChangeEvent> function) {
        Object object = this.selectionLock;
        synchronized (object) {
            DataSelectionListener.SelectionChangeEvent selectionChangeEvent = function.apply(this.currentSelectedPrimitives);
            if (selectionChangeEvent.isNop()) {
                return false;
            }
            this.currentSelectedPrimitives = selectionChangeEvent.getSelection();
            this.selectionListeners.fireEvent((T dataSelectionListener) -> dataSelectionListener.selectionChanged(selectionChangeEvent));
            return true;
        }
    }

    public void clearHighlightedVirtualNodes() {
        this.setHighlightedVirtualNodes(new ArrayList<WaySegment>());
    }

    public void clearHighlightedWaySegments() {
        this.setHighlightedWaySegments(new ArrayList<WaySegment>());
    }

    @Override
    public synchronized Area getDataSourceArea() {
        if (this.cachedDataSourceArea == null) {
            this.cachedDataSourceArea = Data.super.getDataSourceArea();
        }
        return this.cachedDataSourceArea;
    }

    @Override
    public synchronized List<Bounds> getDataSourceBounds() {
        if (this.cachedDataSourceBounds == null) {
            this.cachedDataSourceBounds = Data.super.getDataSourceBounds();
        }
        return Collections.unmodifiableList(this.cachedDataSourceBounds);
    }

    @Override
    public synchronized Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    public OsmPrimitive getPrimitiveById(long l, OsmPrimitiveType osmPrimitiveType) {
        return this.getPrimitiveById(new SimplePrimitiveId(l, osmPrimitiveType));
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return primitiveId != null ? this.primitivesMap.get(primitiveId) : null;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
        if (osmPrimitive == null && primitiveId != null) {
            Logging.warn(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this at {2}. This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId()), Main.getJOSMWebsite()}));
            Logging.error(new Exception());
        }
        return osmPrimitive;
    }

    private static void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Way> unlinkNodeFromWays(Node node) {
        HashSet<Way> hashSet = new HashSet<Way>();
        this.beginUpdate();
        try {
            for (Way way : node.getParentWays()) {
                List<Node> list = way.getNodes();
                if (!list.remove(node)) continue;
                if (list.size() < 2) {
                    DataSet.deleteWay(way);
                } else {
                    way.setNodes(list);
                }
                hashSet.add(way);
            }
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relation> unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        this.beginUpdate();
        try {
            for (Relation relation : this.getRelations()) {
                List<RelationMember> list = relation.getMembers();
                Iterator<RelationMember> iterator = list.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    RelationMember relationMember = iterator.next();
                    if (!relationMember.getMember().equals(osmPrimitive)) continue;
                    iterator.remove();
                    bl = true;
                }
                if (!bl) continue;
                relation.setMembers(list);
                hashSet.add(relation);
            }
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    public Set<OsmPrimitive> unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        this.beginUpdate();
        try {
            if (osmPrimitive instanceof Node) {
                hashSet.addAll(this.unlinkNodeFromWays((Node)osmPrimitive));
            }
            hashSet.addAll(this.unlinkPrimitiveFromRelations(osmPrimitive));
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    public boolean isModified() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (!osmPrimitive.isModified()) continue;
            return true;
        }
        return false;
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        this.listeners.addIfAbsent(dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.listeners.remove(dataSetListener);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            List<AbstractDatasetChangedEvent> list = Collections.emptyList();
            if (this.updateCount == 0) {
                list = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
            }
            if (!list.isEmpty()) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
                try {
                    if (list.size() < 30) {
                        for (AbstractDatasetChangedEvent abstractDatasetChangedEvent : list) {
                            this.fireEventToListeners(abstractDatasetChangedEvent);
                        }
                    }
                    if (list.size() == 1000) {
                        this.fireEventToListeners(new DataChangedEvent(this));
                    }
                    this.fireEventToListeners(new DataChangedEvent(this, list));
                }
                finally {
                    this.lock.readLock().unlock();
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        for (DataSetListener dataSetListener : this.listeners) {
            abstractDatasetChangedEvent.fire(dataSetListener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(abstractDatasetChangedEvent);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesAddedEvent(this, collection, bl));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesRemovedEvent(this, collection, bl));
    }

    void fireTagsChanged(OsmPrimitive osmPrimitive, Map<String, String> map) {
        this.fireEvent(new TagsChangedEvent(this, osmPrimitive, map));
    }

    void fireRelationMembersChanged(Relation relation) {
        DataSet.reindexRelation(relation);
        this.fireEvent(new RelationMembersChangedEvent(this, relation));
    }

    void fireNodeMoved(Node node, LatLon latLon, EastNorth eastNorth) {
        this.reindexNode(node, latLon, eastNorth);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive osmPrimitive, int n, int n2) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(osmPrimitive), n, n2));
    }

    void firePrimitiveFlagsChanged(OsmPrimitive osmPrimitive) {
        this.fireEvent(new PrimitiveFlagsChangedEvent(this, osmPrimitive));
    }

    void fireHighlightingChanged() {
        HighlightUpdateListener.HighlightUpdateEvent highlightUpdateEvent = new HighlightUpdateListener.HighlightUpdateEvent(this);
        this.highlightUpdateListeners.fireEvent((T highlightUpdateListener) -> highlightUpdateListener.highlightUpdated(highlightUpdateEvent));
    }

    public void invalidateEastNorthCache() {
        if (Main.getProjection() == null) {
            return;
        }
        this.beginUpdate();
        try {
            for (Node node : this.getNodes()) {
                node.invalidateEastNorthCache();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDeletedPrimitives() {
        this.beginUpdate();
        try {
            Collection collection = this.getPrimitives(osmPrimitive -> osmPrimitive.isDeleted() && (!osmPrimitive.isVisible() || osmPrimitive.isNew()));
            if (!collection.isEmpty()) {
                this.clearSelection(collection.stream().map(AbstractPrimitive::getPrimitiveId));
                for (OsmPrimitive osmPrimitive2 : collection) {
                    this.removePrimitiveImpl(osmPrimitive2);
                }
                this.firePrimitivesRemoved(collection, false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive osmPrimitive : this.allPrimitives) {
                osmPrimitive.setDataset(null);
            }
            super.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (osmPrimitive.isVisible()) continue;
            osmPrimitive.setDeleted(true);
        }
    }

    public void mergeFrom(DataSet dataSet) {
        this.mergeFrom(dataSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeFrom(DataSet dataSet, ProgressMonitor progressMonitor) {
        if (dataSet != null) {
            new DataSetMerger(this, dataSet).merge(progressMonitor);
            DataSet dataSet2 = dataSet;
            synchronized (dataSet2) {
                if (!dataSet.dataSources.isEmpty()) {
                    if (this.dataSources.addAll(dataSet.dataSources)) {
                        this.cachedDataSourceArea = null;
                        this.cachedDataSourceBounds = null;
                    }
                    dataSet.dataSources.clear();
                    dataSet.cachedDataSourceArea = null;
                    dataSet.cachedDataSourceBounds = null;
                }
            }
        }
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        this.invalidateEastNorthCache();
    }

    public synchronized ProjectionBounds getDataSourceBoundingBox() {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : this.dataSources) {
            boundingXYVisitor.visit(dataSource.bounds);
        }
        if (boundingXYVisitor.hasExtend()) {
            return boundingXYVisitor.getBounds();
        }
        return null;
    }

    public static enum UploadPolicy {
        NORMAL("true"),
        DISCOURAGED("false"),
        BLOCKED("never");

        final String xmlFlag;

        private UploadPolicy(String string2) {
            this.xmlFlag = string2;
        }

        public String getXmlFlag() {
            return this.xmlFlag;
        }
    }
}

