/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PurgeCommand
extends Command {
    protected List<OsmPrimitive> toPurge;
    protected Storage<PrimitiveData> makeIncompleteData;
    protected Map<PrimitiveId, PrimitiveData> makeIncompleteDataByPrimId;
    protected final ConflictCollection purgedConflicts = new ConflictCollection();

    public PurgeCommand(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        super(osmDataLayer);
        this.init(collection, collection2);
    }

    public PurgeCommand(DataSet dataSet, Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        super(dataSet);
        this.init(collection, collection2);
    }

    private void init(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        this.toPurge = PurgeCommand.topoSort(collection);
        this.saveIncomplete(collection2);
    }

    protected final void saveIncomplete(Collection<OsmPrimitive> collection) {
        this.makeIncompleteData = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash());
        this.makeIncompleteDataByPrimId = this.makeIncompleteData.foreignKey(new Storage.PrimitiveIdHash());
        for (OsmPrimitive osmPrimitive : collection) {
            this.makeIncompleteData.add(osmPrimitive.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        this.getAffectedDataSet().beginUpdate();
        try {
            this.purgedConflicts.get().clear();
            this.getAffectedDataSet().clearSelection(this.toPurge);
            for (int i = this.toPurge.size() - 1; i >= 0; --i) {
                Object object;
                OsmPrimitive osmPrimitive = this.toPurge.get(i);
                if (this.makeIncompleteDataByPrimId.containsKey(osmPrimitive)) {
                    switch (osmPrimitive.getType()) {
                        case NODE: {
                            object = new NodeData();
                            break;
                        }
                        case WAY: {
                            object = new WayData();
                            break;
                        }
                        case RELATION: {
                            object = new RelationData();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    ((PrimitiveData)object).setId(osmPrimitive.getUniqueId());
                    ((PrimitiveData)object).setIncomplete(true);
                    osmPrimitive.load((PrimitiveData)object);
                    continue;
                }
                this.getAffectedDataSet().removePrimitive((PrimitiveId)osmPrimitive);
                object = this.getAffectedDataSet().getConflicts().getConflictForMy(osmPrimitive);
                if (object == null) continue;
                this.purgedConflicts.add((Conflict<?>)object);
                this.getAffectedDataSet().getConflicts().remove((Conflict<?>)object);
            }
        }
        finally {
            this.getAffectedDataSet().endUpdate();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (this.getAffectedDataSet() == null) {
            return;
        }
        for (OsmPrimitive object : this.toPurge) {
            PrimitiveData primitiveData = this.makeIncompleteDataByPrimId.get(object);
            if (primitiveData != null) {
                if (this.getAffectedDataSet().getPrimitiveById(object) != object) {
                    throw new AssertionError((Object)String.format("Primitive %s has been made incomplete when purging, but it cannot be found on undo.", object));
                }
                object.load(primitiveData);
                continue;
            }
            if (this.getAffectedDataSet().getPrimitiveById(object) != null) {
                throw new AssertionError((Object)String.format("Primitive %s was removed when purging, but is still there on undo", object));
            }
            this.getAffectedDataSet().addPrimitive(object);
        }
        for (Conflict conflict : this.purgedConflicts) {
            this.getAffectedDataSet().getConflicts().add(conflict);
        }
    }

    public static List<OsmPrimitive> topoSort(Collection<OsmPrimitive> collection) {
        Object object;
        Object object3;
        Object object4;
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(hashSet.size());
        HashSet<Object> hashSet2 = new HashSet<Object>(hashSet.size());
        Object object5 = hashSet.iterator();
        block0: while (object5.hasNext()) {
            object4 = (OsmPrimitive)object5.next();
            if (!(object4 instanceof Node)) continue;
            object3 = (Node)object4;
            for (OsmPrimitive object22 : ((OsmPrimitive)object3).getReferrers()) {
                if (!(object22 instanceof Way) || !hashSet.contains(object22)) continue;
                object5.remove();
                hashSet2.add(object3);
                continue block0;
            }
            object5.remove();
            arrayList.add((OsmPrimitive)object3);
        }
        object5 = hashSet.iterator();
        while (object5.hasNext()) {
            object4 = (OsmPrimitive)object5.next();
            if (!(object4 instanceof Way)) continue;
            object3 = (Way)object4;
            object5.remove();
            for (Node node : ((Way)object3).getNodes()) {
                if (!hashSet2.contains(node)) continue;
                hashSet2.remove(node);
                arrayList.add(node);
            }
            arrayList.add((OsmPrimitive)object3);
        }
        if (!hashSet2.isEmpty()) {
            throw new AssertionError((Object)"topo sort algorithm failed (nodes remaining)");
        }
        object5 = hashSet;
        object4 = new HashMap();
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object = (Relation)object3.next();
            object4.put(object, 0);
        }
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object = (Relation)object3.next();
            for (OsmPrimitive osmPrimitive : ((OsmPrimitive)object).getReferrers()) {
                if (!(osmPrimitive instanceof Relation)) {
                    throw new AssertionError();
                }
                Integer n = (Integer)object4.get(osmPrimitive);
                if (n == null) continue;
                object4.put((Relation)osmPrimitive, n + 1);
            }
        }
        object3 = new HashSet();
        object = object5.iterator();
        while (object.hasNext()) {
            Relation relation = (Relation)object.next();
            if (!((Integer)object4.get(relation)).equals(0)) continue;
            object3.add(relation);
        }
        object = new ArrayList(object5.size());
        while (!object3.isEmpty()) {
            OsmPrimitive osmPrimitive;
            Iterator iterator = object3.iterator();
            osmPrimitive = (Relation)iterator.next();
            iterator.remove();
            object.add(osmPrimitive);
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                Relation relation = (Relation)osmPrimitive2;
                Integer n = (Integer)object4.get(relation);
                if (n == null) continue;
                object4.put(relation, n - 1);
                if (n - 1 != 0) continue;
                object3.add(relation);
            }
        }
        if (object.size() != object5.size()) {
            throw new AssertionError((Object)"topo sort algorithm failed");
        }
        arrayList.addAll((Collection<OsmPrimitive>)object);
        return arrayList;
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Purged {0} object", "Purged {0} objects", this.toPurge.size(), this.toPurge.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "purge");
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toPurge;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toPurge, this.makeIncompleteData, this.makeIncompleteDataByPrimId, this.purgedConflicts, this.getAffectedDataSet());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PurgeCommand purgeCommand = (PurgeCommand)object;
        return Objects.equals(this.toPurge, purgeCommand.toPurge) && Objects.equals(this.makeIncompleteData, purgeCommand.makeIncompleteData) && Objects.equals(this.makeIncompleteDataByPrimId, purgeCommand.makeIncompleteDataByPrimId) && Objects.equals(this.purgedConflicts, purgeCommand.purgedConflicts);
    }

    /*
     * WARNING - void declaration
     */
    public static PurgeCommand build(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, List<OsmPrimitive> list) {
        HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>(collection);
        HashSet<OsmPrimitive> hashSet3 = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> hashSet4 = new HashSet<OsmPrimitive>();
        while (!hashSet2.isEmpty()) {
            for (OsmPrimitive hashSet5 : hashSet2) {
                for (OsmPrimitive osmPrimitive : hashSet5.getReferrers()) {
                    if (hashSet2.contains(osmPrimitive) || hashSet3.contains(osmPrimitive) || hashSet4.contains(osmPrimitive) || !(osmPrimitive instanceof Way) && (!(osmPrimitive instanceof Relation) || !hashSet5.isNew())) continue;
                    if (list != null) {
                        list.add(osmPrimitive);
                    }
                    hashSet4.add(osmPrimitive);
                }
                hashSet3.add(hashSet5);
            }
            hashSet2 = hashSet4;
            hashSet4 = new HashSet();
        }
        HashSet hashSet6 = new HashSet();
        block3: for (OsmPrimitive osmPrimitive : hashSet3) {
            if (osmPrimitive.isNew()) continue;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || hashSet3.contains(osmPrimitive2)) continue;
                hashSet6.add(osmPrimitive);
                continue block3;
            }
        }
        if (Main.pref.getBoolean("purge.add_untagged_waynodes", true)) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (OsmPrimitive osmPrimitive : hashSet3) {
                if (!(osmPrimitive instanceof Way)) continue;
                Way way = (Way)osmPrimitive;
                block6: for (Node node : way.getNodes()) {
                    if (node.isTagged() || hashSet3.contains(node)) continue;
                    for (OsmPrimitive osmPrimitive3 : node.getReferrers()) {
                        if (osmPrimitive3 == way || hashSet3.contains(osmPrimitive3)) continue;
                        continue block6;
                    }
                    hashSet.add(node);
                }
            }
            hashSet3.addAll(hashSet);
            if (list != null) {
                list.addAll(hashSet);
            }
        }
        if (Main.pref.getBoolean("purge.add_relations_with_only_incomplete_members", true)) {
            void var9_28;
            HashSet<Relation> hashSet = new HashSet<Relation>();
            for (OsmPrimitive osmPrimitive : hashSet3) {
                for (OsmPrimitive osmPrimitive4 : osmPrimitive.getReferrers()) {
                    if (!(osmPrimitive4 instanceof Relation) || hashSet3.contains(osmPrimitive4) || !PurgeCommand.hasOnlyIncompleteMembers((Relation)osmPrimitive4, hashSet3, hashSet)) continue;
                    hashSet.add((Relation)osmPrimitive4);
                }
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(hashSet);
            boolean bl = false;
            while (var9_28 < arrayList.size()) {
                for (OsmPrimitive osmPrimitive : ((Relation)arrayList.get((int)var9_28)).getReferrers()) {
                    if (hashSet3.contains(osmPrimitive) || !PurgeCommand.hasOnlyIncompleteMembers((Relation)osmPrimitive, hashSet3, arrayList)) continue;
                    arrayList.add((Relation)osmPrimitive);
                }
                ++var9_28;
            }
            HashSet hashSet5 = new HashSet(arrayList);
            hashSet3.addAll(hashSet5);
            if (list != null) {
                list.addAll(hashSet5);
            }
        }
        return osmDataLayer != null ? new PurgeCommand(osmDataLayer, hashSet3, (Collection<OsmPrimitive>)hashSet6) : new PurgeCommand(((OsmPrimitive)hashSet3.iterator().next()).getDataSet(), hashSet3, (Collection<OsmPrimitive>)hashSet6);
    }

    private static boolean hasOnlyIncompleteMembers(Relation relation, Collection<OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember().isIncomplete() || collection.contains(relationMember.getMember()) || collection2.contains(relationMember.getMember())) continue;
            return false;
        }
        return true;
    }
}

