/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class UploadNotesTask {
    private NoteData noteData;

    public void uploadNotes(NoteData noteData, ProgressMonitor progressMonitor) {
        this.noteData = noteData;
        MainApplication.worker.submit(new UploadTask(I18n.tr("Uploading modified notes", new Object[0]), progressMonitor));
    }

    private class UploadTask
    extends PleaseWaitRunnable {
        private boolean isCanceled;
        private final Map<Note, Note> updatedNotes;
        private final Map<Note, Exception> failedNotes;

        UploadTask(String string, ProgressMonitor progressMonitor) {
            super(string, progressMonitor, false);
            this.updatedNotes = new HashMap<Note, Note>();
            this.failedNotes = new HashMap<Note, Exception>();
        }

        @Override
        protected void cancel() {
            Logging.debug("note upload canceled");
            this.isCanceled = true;
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            OsmApi osmApi = OsmApi.getOsmApi();
            for (Note note : UploadNotesTask.this.noteData.getNotes()) {
                if (this.isCanceled) {
                    Logging.info("Note upload interrupted by user");
                    break;
                }
                for (NoteComment noteComment : note.getComments()) {
                    if (!noteComment.isNew()) continue;
                    Logging.debug("found note change to upload");
                    this.processNoteComment(progressMonitor, osmApi, note, noteComment);
                }
            }
        }

        private void processNoteComment(ProgressMonitor progressMonitor, OsmApi osmApi, Note note, NoteComment noteComment) {
            try {
                Note note2;
                if (this.updatedNotes.containsKey(note)) {
                    note = this.updatedNotes.get(note);
                }
                switch (noteComment.getNoteAction()) {
                    case OPENED: {
                        Logging.debug("opening new note");
                        note2 = osmApi.createNote(note.getLatLon(), noteComment.getText(), progressMonitor);
                        break;
                    }
                    case CLOSED: {
                        Logging.debug("closing note {0}", note.getId());
                        note2 = osmApi.closeNote(note, noteComment.getText(), progressMonitor);
                        break;
                    }
                    case COMMENTED: {
                        Logging.debug("adding comment to note {0}", note.getId());
                        note2 = osmApi.addCommentToNote(note, noteComment.getText(), progressMonitor);
                        break;
                    }
                    case REOPENED: {
                        Logging.debug("reopening note {0}", note.getId());
                        note2 = osmApi.reopenNote(note, noteComment.getText(), progressMonitor);
                        break;
                    }
                    default: {
                        note2 = null;
                    }
                }
                this.updatedNotes.put(note, note2);
            }
            catch (OsmTransferException osmTransferException) {
                Logging.error("Failed to upload note to server: {0}", note.getId());
                Logging.error(osmTransferException);
                this.failedNotes.put(note, osmTransferException);
            }
        }

        @Override
        protected void finish() {
            if (Logging.isDebugEnabled()) {
                Logging.debug("finish called in notes upload task. Notes to update: {0}", this.updatedNotes.size());
            }
            UploadNotesTask.this.noteData.updateNotes(this.updatedNotes);
            if (!this.failedNotes.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<Note, Exception> entry : this.failedNotes.entrySet()) {
                    stringBuilder.append(I18n.tr("Note {0} failed: {1}", entry.getKey().getId(), entry.getValue().getMessage())).append('\n');
                }
                Logging.error("Notes failed to upload: " + stringBuilder.toString());
                JOptionPane.showMessageDialog(MainApplication.getMap(), stringBuilder.toString(), I18n.tr("Notes failed to upload", new Object[0]), 0);
                ExceptionDialogUtil.explainException(this.failedNotes.values().iterator().next());
            }
        }
    }
}

