/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmChangeCompressedTask
extends DownloadOsmChangeTask {
    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/.*\\.osc.(gz|bz2?)"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM Change", new Object[0]);
    }

    @Override
    public Future<?> loadUrl(boolean bl, final String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmChangeTask.DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                if (string.matches("https?://.*/.*\\.osc.bz2?")) {
                    return this.reader.parseOsmChangeBzip2(progressMonitor);
                }
                return this.reader.parseOsmChangeGzip(progressMonitor);
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osc.(gz|bz2?))", string);
        return MainApplication.worker.submit(this.downloadTask);
    }
}

