/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer", new Object[0]), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer", new Object[0]), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge", new Object[0])), 77, 5006), true, "action/mergelayer", true);
        this.putValue("help", HelpUtil.ht("/Action/MergeLayer"));
    }

    protected Future<?> doMerge(List<Layer> list, Collection<Layer> collection) {
        Layer layer = MergeLayerAction.askTargetLayer(list);
        if (layer == null) {
            return null;
        }
        Object object = this.getValue("Name");
        return MainApplication.worker.submit(() -> {
            long l = System.currentTimeMillis();
            boolean bl = false;
            for (Layer layer2 : collection) {
                if (layer2 == null || layer2.equals(layer)) continue;
                if (layer2 instanceof OsmDataLayer && layer instanceof OsmDataLayer && ((OsmDataLayer)layer2).isUploadDiscouraged() != ((OsmDataLayer)layer).isUploadDiscouraged() && Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> MergeLayerAction.warnMergingUploadDiscouragedLayers(layer2, layer)))) break;
                layer.mergeFrom(layer2);
                GuiHelper.runInEDTAndWait(() -> this.getLayerManager().removeLayer(layer2));
                bl = true;
            }
            if (bl) {
                this.getLayerManager().setActiveLayer(layer);
                Logging.info(I18n.tr("{0} completed in {1}", object, Utils.getDurationString(System.currentTimeMillis() - l)));
            }
        });
    }

    public Future<?> merge(List<Layer> list) {
        return this.doMerge(list, list);
    }

    public Future<?> merge(Layer layer) {
        if (layer == null) {
            return null;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(layer);
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(layer);
            return null;
        }
        return this.doMerge(list, Collections.singleton(layer));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.merge(this.getSourceLayer());
    }

    @Override
    protected void updateEnabledState() {
        GuiHelper.runInEDT(() -> {
            Layer layer = this.getSourceLayer();
            if (layer == null) {
                this.setEnabled(false);
            } else {
                try {
                    this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(layer).isEmpty());
                }
                catch (IllegalStateException illegalStateException) {
                    this.setEnabled(false);
                    Logging.error(illegalStateException);
                }
            }
        });
    }

    protected Layer getSourceLayer() {
        return this.getLayerManager().getActiveLayer();
    }

    public static final boolean warnMergingUploadDiscouragedLayers(Layer layer, Layer layer2) {
        return GuiHelper.warnUser(I18n.tr("Merging layers with different upload policies", new Object[0]), "<html>" + I18n.tr("You are about to merge data between layers ''{0}'' and ''{1}''.<br /><br />These layers have different upload policies and should not been merged as it.<br />Merging them will result to enforce the stricter policy (upload discouraged) to ''{1}''.<br /><br /><b>This is not the recommended way of merging such data</b>.<br />You should instead check and merge each object, one by one, by using ''<i>Merge selection</i>''.<br /><br />Are you sure you want to continue?", Utils.escapeReservedCharactersHTML(layer.getName()), Utils.escapeReservedCharactersHTML(layer2.getName()), Utils.escapeReservedCharactersHTML(layer2.getName())) + "</html>", ImageProvider.get("dialogs", "mergedown"), I18n.tr("Ignore this hint and merge anyway", new Object[0]));
    }
}

