/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import org.apache.commons.compress.compressors.bzip2.CRC;
import org.apache.commons.compress.compressors.bzip2.Rand;
import org.apache.commons.compress.utils.BitInputStream;
import org.apache.commons.compress.utils.CloseShieldFilterInputStream;

public class BZip2CompressorInputStream
extends CompressorInputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private final CRC crc = new CRC();
    private int nInUse;
    private BitInputStream bin;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private Data data;

    public BZip2CompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public BZip2CompressorInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.bin = new BitInputStream(inputStream == System.in ? new CloseShieldFilterInputStream(inputStream) : inputStream, ByteOrder.BIG_ENDIAN);
        this.decompressConcatenated = bl;
        this.init(true);
        this.initBlock();
    }

    @Override
    public int read() throws IOException {
        if (this.bin != null) {
            int n = this.read0();
            this.count(n < 0 ? -1 : 1);
            return n;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException("offs(" + n + ") < 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len(" + n2 + ") < 0.");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n + ") + len(" + n2 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.bin == null) {
            throw new IOException("stream closed");
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4 && (n3 = this.read0()) >= 0) {
            byArray[n5++] = (byte)n3;
            this.count(1);
        }
        int n6 = n5 == n ? -1 : n5 - n;
        return n6;
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!blArray[i]) continue;
            byArray[n++] = (byte)i;
        }
        this.nInUse = n;
    }

    private int read0() throws IOException {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private int readNextByte(BitInputStream bitInputStream) throws IOException {
        long l = bitInputStream.readBits(8);
        return (int)l;
    }

    private boolean init(boolean bl) throws IOException {
        int n;
        if (null == this.bin) {
            throw new IOException("No InputStream");
        }
        if (!bl) {
            this.bin.clearBitCache();
        }
        if ((n = this.readNextByte(this.bin)) == -1 && !bl) {
            return false;
        }
        int n2 = this.readNextByte(this.bin);
        int n3 = this.readNextByte(this.bin);
        if (n != 66 || n2 != 90 || n3 != 104) {
            throw new IOException(bl ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int n4 = this.readNextByte(this.bin);
        if (n4 < 49 || n4 > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = n4 - 48;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() throws IOException {
        char c;
        char c2;
        char c3;
        char c4;
        char c5;
        char c6;
        BitInputStream bitInputStream;
        block3: {
            bitInputStream = this.bin;
            do {
                c6 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c5 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c4 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c3 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c2 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                if (c6 != '\u0017' || c5 != 'r' || c4 != 'E' || c3 != '8' || c2 != 'P' || c != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (c6 != '1' || c5 != 'A' || c4 != 'Y' || c3 != '&' || c2 != 'S' || c != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = BZip2CompressorInputStream.bsGetInt(bitInputStream);
        boolean bl = this.blockRandomised = BZip2CompressorInputStream.bsR(bitInputStream, 1) == 1;
        if (this.data == null) {
            this.data = new Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() throws IOException {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() throws IOException {
        this.storedCombinedCRC = BZip2CompressorInputStream.bsGetInt(this.bin);
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    @Override
    public void close() throws IOException {
        BitInputStream bitInputStream = this.bin;
        if (bitInputStream != null) {
            try {
                bitInputStream.close();
            }
            finally {
                this.data = null;
                this.bin = null;
            }
        }
    }

    private static int bsR(BitInputStream bitInputStream, int n) throws IOException {
        long l = bitInputStream.readBits(n);
        if (l < 0L) {
            throw new IOException("unexpected end of stream");
        }
        return (int)l;
    }

    private static boolean bsGetBit(BitInputStream bitInputStream) throws IOException {
        return BZip2CompressorInputStream.bsR(bitInputStream, 1) != 0;
    }

    private static char bsGetUByte(BitInputStream bitInputStream) throws IOException {
        return (char)BZip2CompressorInputStream.bsR(bitInputStream, 8);
    }

    private static int bsGetInt(BitInputStream bitInputStream) throws IOException {
        return BZip2CompressorInputStream.bsR(bitInputStream, 32);
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] != n5) continue;
                nArray3[n6++] = n4;
            }
        }
        n5 = 23;
        while (--n5 > 0) {
            nArray2[n5] = 0;
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
        }
        n6 = nArray2[0];
        for (n5 = 1; n5 < 23; ++n5) {
            nArray2[n5] = n6 += nArray2[n5];
        }
        n6 = 0;
        n4 = nArray2[n5];
        for (n5 = n; n5 <= n2; ++n5) {
            int n8 = nArray2[n5 + 1];
            n4 = n8;
            nArray[n5] = (n6 += n8 - n4) - 1;
            n6 <<= 1;
        }
        for (n5 = n + 1; n5 <= n2; ++n5) {
            nArray2[n5] = (nArray[n5 - 1] + 1 << 1) - nArray2[n5];
        }
    }

    private void recvDecodingTables() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        BitInputStream bitInputStream = this.bin;
        Data data = this.data;
        boolean[] blArray = data.inUse;
        byte[] byArray = data.recvDecodingTables_pos;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.selectorMtf;
        int n7 = 0;
        for (n6 = 0; n6 < 16; ++n6) {
            if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
            n7 |= 1 << n6;
        }
        Arrays.fill(blArray, false);
        for (n6 = 0; n6 < 16; ++n6) {
            if ((n7 & 1 << n6) == 0) continue;
            n5 = n6 << 4;
            for (n4 = 0; n4 < 16; ++n4) {
                if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
                blArray[n5 + n4] = true;
            }
        }
        this.makeMaps();
        n6 = this.nInUse + 2;
        n5 = BZip2CompressorInputStream.bsR(bitInputStream, 3);
        n4 = BZip2CompressorInputStream.bsR(bitInputStream, 15);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                ++n2;
            }
            byArray3[n3] = (byte)n2;
        }
        n3 = n5;
        while (--n3 >= 0) {
            byArray[n3] = (byte)n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n = byArray[n2];
            for (n2 = byArray3[n3] & 0xFF; n2 > 0; --n2) {
                byArray[n2] = byArray[n2 - 1];
            }
            byArray[0] = n;
            byArray2[n3] = n;
        }
        char[][] cArray = data.temp_charArray2d;
        for (n2 = 0; n2 < n5; ++n2) {
            n = BZip2CompressorInputStream.bsR(bitInputStream, 5);
            char[] cArray2 = cArray[n2];
            for (int i = 0; i < n6; ++i) {
                while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                    n += BZip2CompressorInputStream.bsGetBit(bitInputStream) ? -1 : 1;
                }
                cArray2[i] = (char)n;
            }
        }
        this.createHuffmanDecodingTables(n6, n5);
    }

    private void createHuffmanDecodingTables(int n, int n2) {
        Data data = this.data;
        char[][] cArray = data.temp_charArray2d;
        int[] nArray = data.minLens;
        int[][] nArray2 = data.limit;
        int[][] nArray3 = data.base;
        int[][] nArray4 = data.perm;
        for (int i = 0; i < n2; ++i) {
            int n3 = 32;
            int n4 = 0;
            char[] cArray2 = cArray[i];
            int n5 = n;
            while (--n5 >= 0) {
                int n6 = cArray2[n5];
                if (n6 > n4) {
                    n4 = n6;
                }
                if (n6 >= n3) continue;
                n3 = n6;
            }
            BZip2CompressorInputStream.hbCreateDecodeTables(nArray2[i], nArray3[i], nArray4[i], cArray[i], n3, n4, n);
            nArray[i] = n3;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        BitInputStream bitInputStream = this.bin;
        this.origPtr = BZip2CompressorInputStream.bsR(bitInputStream, 24);
        this.recvDecodingTables();
        Data data = this.data;
        byte[] byArray = data.ll8;
        int[] nArray = data.unzftab;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.seqToUnseq;
        char[] cArray = data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = data.minLens;
        int[][] nArray3 = data.limit;
        int[][] nArray4 = data.base;
        int[][] nArray5 = data.perm;
        int n = this.blockSize100k * 100000;
        int n2 = 256;
        while (--n2 >= 0) {
            cArray[n2] = (char)n2;
            nArray[n2] = 0;
        }
        n2 = 0;
        int n3 = 49;
        int n4 = this.nInUse + 1;
        int n5 = this.getAndMoveToFrontDecode0(0);
        int n6 = -1;
        int n7 = byArray2[n2] & 0xFF;
        int[] nArray6 = nArray4[n7];
        int[] nArray7 = nArray3[n7];
        int[] nArray8 = nArray5[n7];
        int n8 = nArray2[n7];
        while (n5 != n4) {
            int n9;
            int n10;
            int n11;
            if (n5 == 0 || n5 == 1) {
                n11 = -1;
                n10 = 1;
                while (true) {
                    if (n5 == 0) {
                        n11 += n10;
                    } else {
                        if (n5 != 1) break;
                        n11 += n10 << 1;
                    }
                    if (n3 == 0) {
                        n3 = 49;
                        n7 = byArray2[++n2] & 0xFF;
                        nArray6 = nArray4[n7];
                        nArray7 = nArray3[n7];
                        nArray8 = nArray5[n7];
                        n8 = nArray2[n7];
                    } else {
                        --n3;
                    }
                    n9 = n8;
                    int n12 = BZip2CompressorInputStream.bsR(bitInputStream, n9);
                    while (n12 > nArray7[n9]) {
                        ++n9;
                        n12 = n12 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
                    }
                    n5 = nArray8[n12 - nArray6[n9]];
                    n10 <<= 1;
                }
                n10 = byArray3[cArray[0]];
                int n13 = n10 & 0xFF;
                nArray[n13] = nArray[n13] + (n11 + 1);
                while (n11-- >= 0) {
                    byArray[++n6] = n10;
                }
                if (n6 < n) continue;
                throw new IOException("block overrun");
            }
            if (++n6 >= n) {
                throw new IOException("block overrun");
            }
            n11 = cArray[n5 - 1];
            int n14 = byArray3[n11] & 0xFF;
            nArray[n14] = nArray[n14] + 1;
            byArray[n6] = byArray3[n11];
            if (n5 <= 16) {
                n10 = n5 - 1;
                while (n10 > 0) {
                    cArray[n10--] = cArray[n10];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n5 - 1);
            }
            cArray[0] = n11;
            if (n3 == 0) {
                n3 = 49;
                n7 = byArray2[++n2] & 0xFF;
                nArray6 = nArray4[n7];
                nArray7 = nArray3[n7];
                nArray8 = nArray5[n7];
                n8 = nArray2[n7];
            } else {
                --n3;
            }
            n10 = n8;
            n9 = BZip2CompressorInputStream.bsR(bitInputStream, n10);
            while (n9 > nArray7[n10]) {
                ++n10;
                n9 = n9 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
            }
            n5 = nArray8[n9 - nArray6[n10]];
        }
        this.last = n6;
    }

    private int getAndMoveToFrontDecode0(int n) throws IOException {
        Data data = this.data;
        int n2 = data.selector[n] & 0xFF;
        int[] nArray = data.limit[n2];
        int n3 = data.minLens[n2];
        int n4 = BZip2CompressorInputStream.bsR(this.bin, n3);
        while (n4 > nArray[n3]) {
            ++n3;
            n4 = n4 << 1 | BZip2CompressorInputStream.bsR(this.bin, 1);
        }
        return data.perm[n2][n4 - data.base[n2][n3]];
    }

    private int setupBlock() throws IOException {
        int n;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] nArray = this.data.cftab;
        int[] nArray2 = this.data.initTT(this.last + 1);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n2 = nArray[0];
        for (n = 1; n <= 256; ++n) {
            nArray[n] = n2 += nArray[n];
        }
        n = 0;
        n2 = this.last;
        while (n <= n2) {
            int n3 = byArray[n] & 0xFF;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            nArray2[n4] = n++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(n);
            return n;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            int n;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(n);
            return n;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            int n = this.su_ch2;
            this.crc.updateCRC(n);
            ++this.su_j2;
            this.currentState = 7;
            return n;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < 3) {
            return false;
        }
        if (byArray[0] != 66) {
            return false;
        }
        if (byArray[1] != 90) {
            return false;
        }
        return byArray[2] == 104;
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[6][258];
        final int[][] base = new int[6][258];
        final int[][] perm = new int[6][258];
        final int[] minLens = new int[6];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecode_yy = new char[256];
        final char[][] temp_charArray2d = new char[6][258];
        final byte[] recvDecodingTables_pos = new byte[6];
        int[] tt;
        byte[] ll8;

        Data(int n) {
            this.ll8 = new byte[n * 100000];
        }

        int[] initTT(int n) {
            int[] nArray = this.tt;
            if (nArray == null || nArray.length < n) {
                this.tt = nArray = new int[n];
            }
            return nArray;
        }
    }
}

