Coverage.CoverageListView=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('coverage/coverageListView.css');var columns=[{id:'url',title:Common.UIString('URL'),width:'300px',fixedWidth:false,sortable:true},{id:'type',title:Common.UIString('Type'),width:'45px',fixedWidth:true,sortable:true},{id:'size',title:Common.UIString('Total Bytes'),width:'60px',fixedWidth:true,sortable:true,align:DataGrid.DataGrid.Align.Right},{id:'unusedSize',title:Common.UIString('Unused Bytes'),width:'60px',fixedWidth:true,sortable:true,align:DataGrid.DataGrid.Align.Right,sort:DataGrid.DataGrid.Order.Descending},{id:'bars',title:'',width:'500px',fixedWidth:false,sortable:false}];this._dataGrid=new DataGrid.SortableDataGrid(columns);this._dataGrid.setResizeMethod(DataGrid.DataGrid.ResizeMethod.Last);this._dataGrid.element.classList.add('flex-auto');this._dataGrid.element.addEventListener('dblclick',this._onDoubleClick.bind(this),false);this._dataGrid.element.addEventListener('keydown',this._onKeyDown.bind(this),false);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortingChanged,this);var dataGridWidget=this._dataGrid.asWidget();dataGridWidget.show(this.contentElement);}
update(coverageInfo){var maxSize=coverageInfo.reduce((acc,entry)=>Math.max(acc,entry.size),0);var rootNode=this._dataGrid.rootNode();rootNode.removeChildren();for(var entry of coverageInfo)
rootNode.appendChild(new Coverage.CoverageListView.GridNode(entry,maxSize));this._sortingChanged();}
_onDoubleClick(event){if(!event.target||!(event.target instanceof Node))
return;event.consume(true);this._revealSourceForNode(this._dataGrid.dataGridNodeFromNode(event.target));}
_onKeyDown(event){if(!isEnterKey(event))
return;event.consume(true);this._revealSourceForNode(this._dataGrid.selectedNode);}
_revealSourceForNode(node){if(!node)
return;var coverageInfo=(node)._coverageInfo;var sourceCode=coverageInfo&&Workspace.workspace.uiSourceCodeForURL(coverageInfo.url);if(!sourceCode)
return;Common.Revealer.reveal(sourceCode);}
_sortingChanged(){var columnId=this._dataGrid.sortColumnId();if(!columnId)
return;var sortFunction;switch(columnId){case'url':sortFunction=compareURL;break;case'type':sortFunction=compareNumericField.bind(null,'type');break;case'size':sortFunction=compareNumericField.bind(null,'size');break;case'unusedSize':sortFunction=compareNumericField.bind(null,'unusedSize');break;default:console.assert(false,'Unknown sort field: '+columnId);return;}
this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());function compareURL(a,b){var nodeA=(a);var nodeB=(b);return nodeA._displayURL.localeCompare(nodeB._displayURL);}
function compareNumericField(fieldName,a,b){var nodeA=(a);var nodeB=(b);return nodeA._coverageInfo[fieldName]-nodeB._coverageInfo[fieldName];}}
static _typeToString(type){var types=[];if(type&Coverage.CoverageType.CSS)
types.push(Common.UIString('CSS'));if(type&Coverage.CoverageType.JavaScript)
types.push(Common.UIString('JS'));return types.join('+');}};Coverage.CoverageListView.GridNode=class extends DataGrid.SortableDataGridNode{constructor(coverageInfo,maxSize){super();this._coverageInfo=coverageInfo;this._displayURL=new Common.ParsedURL(coverageInfo.url).displayName;this._maxSize=maxSize;}
createCell(columnId){var cell=this.createTD(columnId);switch(columnId){case'url':cell.title=this._coverageInfo.url;var outer=cell.createChild('div','url-outer');var prefix=outer.createChild('div','url-prefix');var suffix=outer.createChild('div','url-suffix');var splitURL=/^(.*)(\/[^/]*)$/.exec(this._coverageInfo.url);prefix.textContent=splitURL?splitURL[1]:this._coverageInfo.url;suffix.textContent=splitURL?splitURL[2]:'';break;case'type':cell.textContent=Coverage.CoverageListView._typeToString(this._coverageInfo.type);break;case'size':cell.classList.add('numeric-column');cell.textContent=Number.withThousandsSeparator(this._coverageInfo.size||0);break;case'unusedSize':cell.classList.add('numeric-column');cell.textContent=Number.withThousandsSeparator(this._coverageInfo.unusedSize||0);if(this._coverageInfo.size)
cell.title=Math.round(100*this._coverageInfo.unusedSize/this._coverageInfo.size)+'%';break;case'bars':var barContainer=cell.createChild('div','bar-container');var unusedSizeBar=barContainer.createChild('div','bar bar-unused-size');unusedSizeBar.style.width=Math.ceil(100*this._coverageInfo.unusedSize/this._maxSize)+'%';var usedSizeBar=barContainer.createChild('div','bar bar-used-size');usedSizeBar.style.width=Math.ceil(100*this._coverageInfo.usedSize/this._maxSize)+'%';var sizeBar=barContainer.createChild('div','bar bar-slack-size');var slackSize=this._coverageInfo.size-this._coverageInfo.unusedSize-this._coverageInfo.usedSize;sizeBar.style.width=Math.ceil(100*slackSize/this._maxSize)+'%';}
return cell;}};;Coverage.RangeUsage;Coverage.StyleSheetUsage;Coverage.CoverageInfo;Coverage.CoverageType={CSS:(1<<0),JavaScript:(1<<1),};Coverage.CoverageView=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('coverage/coverageView.css');var toolbarContainer=this.contentElement.createChild('div','coverage-toolbar-container');var topToolbar=new UI.Toolbar('coverage-toolbar',toolbarContainer);this._toggleRecordAction=(UI.actionRegistry.action('coverage.toggle-recording'));topToolbar.appendToolbarItem(UI.Toolbar.createActionButton(this._toggleRecordAction));var clearButton=new UI.ToolbarButton(Common.UIString('Clear all'),'largeicon-clear');clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._reset.bind(this));topToolbar.appendToolbarItem(clearButton);this._coverageResultsElement=this.contentElement.createChild('div','coverage-results');this._progressElement=this._coverageResultsElement.createChild('div','progress-view');this._listView=new Coverage.CoverageListView();this._statusToolbarElement=this.contentElement.createChild('div','coverage-toolbar-summary');this._statusMessageElement=this._statusToolbarElement.createChild('div','coverage-message');}
_reset(){Workspace.workspace.uiSourceCodes().forEach(uiSourceCode=>uiSourceCode.removeDecorationsForType(Coverage.CoverageView.LineDecorator.type));this._listView.detach();this._coverageResultsElement.removeChildren();this._progressElement.textContent='';this._coverageResultsElement.appendChild(this._progressElement);this._statusMessageElement.textContent='';}
_toggleRecording(){var enable=!this._toggleRecordAction.toggled();if(enable)
this._startRecording();else
this._stopRecording();}
_startRecording(){this._reset();var mainTarget=SDK.targetManager.mainTarget();if(!mainTarget)
return;var cssModel=mainTarget.model(SDK.CSSModel);var cpuProfilerModel=mainTarget.model(SDK.CPUProfilerModel);if(!cssModel&&!cpuProfilerModel)
return;this._toggleRecordAction.setToggled(true);if(cssModel)
cssModel.startRuleUsageTracking();if(cpuProfilerModel)
cpuProfilerModel.startPreciseCoverage();this._progressElement.textContent=Common.UIString('Recording...');}
async _stopRecording(){this._toggleRecordAction.setToggled(false);this._progressElement.textContent=Common.UIString('Fetching results...');var cssCoverageInfoPromise=this._stopCSSCoverage();var jsCoverageInfoPromise=this._stopJSCoverage();var cssCoverageInfo=await cssCoverageInfoPromise;var jsCoverageInfo=await jsCoverageInfoPromise;this._updateViews(cssCoverageInfo.concat(jsCoverageInfo));}
_updateViews(coverageInfo){coverageInfo=Coverage.CoverageView._coalesceByURL(coverageInfo);this._updateStats(coverageInfo);this._updateGutter(coverageInfo);this._coverageResultsElement.removeChildren();this._listView.update(coverageInfo);this._listView.show(this._coverageResultsElement);}
static _coalesceByURL(coverageInfo){coverageInfo.sort((a,b)=>(a.url||'').localeCompare(b.url));var result=[];for(var entry of coverageInfo){if(!entry.url)
continue;if(result.length&&result.peekLast().url===entry.url){var lastEntry=result.peekLast();lastEntry.size+=entry.size;lastEntry.usedSize+=entry.usedSize;lastEntry.unusedSize+=entry.unusedSize;lastEntry.type|=entry.type;}else{result.push(entry);}}
return result;}
async _stopJSCoverage(){var mainTarget=SDK.targetManager.mainTarget();var cpuProfilerModel=mainTarget?mainTarget.model(SDK.CPUProfilerModel):null;if(!cpuProfilerModel)
return[];var coveragePromise=cpuProfilerModel.takePreciseCoverage();cpuProfilerModel.stopPreciseCoverage();var rawCoverageData=await coveragePromise;return Coverage.CoverageView._processJSCoverage((SDK.DebuggerModel.fromTarget(mainTarget)),rawCoverageData);}
static async _processJSCoverage(debuggerModel,scriptsCoverage){var promises=[];for(var entry of scriptsCoverage){var ranges=[];var script=debuggerModel.scriptForId(entry.scriptId);if(!script)
continue;for(var func of entry.functions){for(var range of func.ranges){var textRange=new Common.TextRange(range.startLineNumber,range.startColumnNumber,range.endLineNumber,range.endColumnNumber);ranges.push({range:textRange,wasUsed:!!range.count});}}
promises.push(Coverage.CoverageView._coverageInfoForText(script,script.lineOffset,script.columnOffset,ranges));}
return Promise.all(promises);}
async _stopCSSCoverage(){var mainTarget=SDK.targetManager.mainTarget();const cssModel=mainTarget&&mainTarget.model(SDK.CSSModel);if(!cssModel)
return Promise.resolve([]);var rawCoverageData=await cssModel.ruleListPromise();return Coverage.CoverageView._processCSSCoverage((cssModel),rawCoverageData);}
static async _processCSSCoverage(cssModel,ruleUsageList){var rulesByStyleSheet=new Map();for(var rule of ruleUsageList){var styleSheetHeader=cssModel.styleSheetHeaderForId(rule.styleSheetId);var ranges=rulesByStyleSheet.get(styleSheetHeader);if(!ranges){ranges=[];rulesByStyleSheet.set(styleSheetHeader,ranges);}
var textRange=new Common.TextRange(rule.range.startLine+styleSheetHeader.startLine,rule.range.startColumn+(rule.range.startLine?0:styleSheetHeader.startColumn),rule.range.endLine+styleSheetHeader.startLine,rule.range.endColumn+(rule.range.endLine?0:styleSheetHeader.startColumn));ranges.push({range:textRange,wasUsed:rule.wasUsed});}
return Promise.all(Array.from(rulesByStyleSheet.entries(),entry=>Coverage.CoverageView._coverageInfoForText(entry[0],entry[0].startLine,entry[0].startColumn,entry[1])));}
static async _coverageInfoForText(contentProvider,startLine,startColumn,ranges){var url=contentProvider.contentURL();var coverageType;if(contentProvider.contentType().isScript())
coverageType=Coverage.CoverageType.JavaScript;else if(contentProvider.contentType().isStyleSheet())
coverageType=Coverage.CoverageType.CSS;else
console.assert(false,`Unexpected resource type ${contentProvider.contentType().name} for ${url}`);var coverageInfo={url:url,ranges:ranges,type:coverageType};var content=await contentProvider.requestContent();if(!content)
return coverageInfo;var text=new Common.Text(content);var offsetRanges=ranges.map(r=>{var range=r.range.relativeTo(startLine,startColumn);return{start:text.offsetFromPosition(range.startLine,range.startColumn),end:text.offsetFromPosition(range.endLine,range.endColumn),wasUsed:r.wasUsed};});var stack=[];offsetRanges.sort((a,b)=>a.start-b.start);for(var entry of offsetRanges){while(stack.length&&stack.peekLast().end<=entry.start)
stack.pop();entry.ownSize=entry.end-entry.start;var top=stack.peekLast();if(top){if(top.end<entry.end){console.assert(false,`Overlapping coverage entries in ${url}: ${top.start}-${top.end} vs. ${entry.start}-${entry.end}`);}
top.ownSize-=entry.ownSize;}
stack.push(entry);}
var usedSize=0;var unusedSize=0;for(var entry of offsetRanges){if(entry.wasUsed)
usedSize+=entry.ownSize;else
unusedSize+=entry.ownSize;}
coverageInfo.size=content.length;coverageInfo.usedSize=usedSize;coverageInfo.unusedSize=unusedSize;return coverageInfo;}
_updateStats(coverageInfo){var total=0;var unused=0;for(var info of coverageInfo){total+=info.size||0;unused+=info.unusedSize||0;}
var percentUnused=total?Math.round(100*unused/total):0;this._statusMessageElement.textContent=Common.UIString('%s of %s bytes are not used. (%d%%)',Number.bytesToString(unused),Number.bytesToString(total),percentUnused);}
_updateGutter(coverageInfo){for(var info of coverageInfo){var uiSourceCode=info.url&&Workspace.workspace.uiSourceCodeForURL(info.url);if(!uiSourceCode)
continue;for(var range of info.ranges)
uiSourceCode.addDecoration(range.range,Coverage.CoverageView.LineDecorator.type,range.wasUsed);}}};Coverage.CoverageView.LineDecorator=class{decorate(uiSourceCode,textEditor){var gutterType='CodeMirror-gutter-coverage';var decorations=uiSourceCode.decorationsForType(Coverage.CoverageView.LineDecorator.type);textEditor.uninstallGutter(gutterType);if(!decorations||!decorations.size)
return;textEditor.installGutter(gutterType,false);for(var decoration of decorations){for(var line=decoration.range().startLine;line<=decoration.range().endLine;++line){var element=createElementWithClass('div');if(decoration.data())
element.className='text-editor-coverage-used-marker';else
element.className='text-editor-coverage-unused-marker';textEditor.setGutterDecoration(line,gutterType,element);}}}};Coverage.CoverageView.LineDecorator.type='coverage';Coverage.CoverageView.RecordActionDelegate=class{handleAction(context,actionId){var coverageViewId='coverage';UI.viewManager.showView(coverageViewId).then(()=>UI.viewManager.view(coverageViewId).widget()).then(widget=>(widget)._toggleRecording());return true;}};;Runtime.cachedResources["coverage/coverageListView.css"]=".data-grid {\n  border: none;\n}\n\n.data-grid td .url-outer {\n  width: 100%;\n  display: inline-flex;\n  justify-content: flex-start;\n}\n\n.data-grid td .url-prefix {\n  overflow-x: hidden;\n  text-overflow: ellipsis;\n}\n\n.data-grid td .url-suffix {\n  flex: none;\n}\n\n.data-grid td .bar {\n  display: inline-block;\n  height: 8px;\n}\n\n.data-grid .selected td .bar {\n  border-top: 1px white solid;\n  border-bottom: 1px white solid;\n}\n\n.data-grid .selected td .bar:last-child {\n  border-right: 1px white solid;\n}\n\n.data-grid .selected td .bar:first-child {\n  border-left: 1px white solid;\n}\n\n.data-grid td .bar-container {\n}\n\n.data-grid td .bar-slack-size {\n  background-color: rgb(150, 150, 200);\n}\n\n.data-grid td .bar-unused-size {\n  background-color: #E57373;\n}\n\n.data-grid td .bar-used-size {\n  background-color: #81C784;\n}\n\n/*# sourceURL=coverage/coverageListView.css */";Runtime.cachedResources["coverage/coverageView.css"]="/*\n * Copyright (c) 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    overflow: hidden;\n}\n\n.coverage-toolbar-container {\n    display: flex;\n    border-bottom: 1px solid #ccc;\n    flex: 0 0;\n}\n\n.coverage-toolbar {\n    display: inline-block;\n}\n\n.coverage-toolbar-summary {\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    padding-left: 5px;\n    flex: 0 0 19px;\n    display: flex;\n    padding-right: 5px;\n}\n\n.coverage-toolbar-summary .coverage-message {\n    padding-top: 2px;\n    padding-left: 1ex;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    overflow: hidden;\n}\n\n.coverage-results {\n    overflow-y: auto;\n    display: flex;\n    flex: auto;\n}\n\n.progress-view {\n    position: absolute;\n    top: 50%;\n    left: 50%;\n    transform: translateX(-50%) translateY(-50%);\n    font-size: 30px;\n}\n\n.coverage-results > div {\n    flex: auto;\n}\n\n/*# sourceURL=coverage/coverageView.css */";