#!/bin/sh
export PATH='/usr/obj/ports/hs-convertible-1.1.1.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: convertible
version: 1.1.1.0
id: convertible-1.1.1.0-9094a83e9ce58ef3a67f72838d63635d
key: conve_3UmehTCvaiX3TqgHXz9C7K
license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: Erik Hesselink <hesselink@gmail.com>
stability: Stable
homepage: http://hackage.haskell.org/package/convertible
synopsis: Typeclasses and instances for converting between types
description:
    convertible provides a typeclass with a single function
    that is designed to help convert between different types: numeric
    values, dates and times, and the like.  The conversions perform bounds
    checking and return a pure Either value.  This means that you need
    not remember which specific function performs the conversion you
    desire.
    .
    Also included in the package are optional instances that provide
    conversion for various numeric and time types, as well as utilities
    for writing your own instances.
    .
    Finally, there is a function that will raise an exception on
    bounds-checking violation, or return a bare value otherwise,
    implemented in terms of the safer function described above.
    .
    Convertible is also used by HDBC 2.0 for handling marshalling of
    data to and from databases.
    .
    Convertible is backed by an extensive test suite and passes tests
    on GHC and Hugs.
category: Data
author: John Goerzen
exposed: True
exposed-modules:
    Data.Convertible Data.Convertible.Base Data.Convertible.Utils
    Data.Convertible.Instances Data.Convertible.Instances.C
    Data.Convertible.Instances.Map Data.Convertible.Instances.Num
    Data.Convertible.Instances.Text Data.Convertible.Instances.Time
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
library-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
data-dir: /usr/local/share/hs-convertible-1.1.1.0
hs-libraries: HSconvertible-1.1.1.0-3UmehTCvaiX3TqgHXz9C7K
depends:
    base-4.8.2.0-998280bdde83e17200455ba43ed33188
    bytestring-0.10.6.0-fd9ecdc10518a92e9e756e845ae35989
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    mtl-2.2.1-3af90341e75ee52dfc4e3143b4e5d219
    old-locale-1.0.0.7-0db938eb141b01f4936a21aef6b843bf
    old-time-1.1.0.3-4494378134a1c0eadea2f9ea5411834e
    text-1.2.1.3-d050b6e0fc32994b2ea423ca0ac22057
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.1.1.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.1.1.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
