/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.ingest.ValueSource;

public final class AppendProcessor
extends AbstractProcessor {
    public static final String TYPE = "append";
    private final TemplateService.Template field;
    private final ValueSource value;

    AppendProcessor(String tag, TemplateService.Template field, ValueSource value) {
        super(tag);
        this.field = field;
        this.value = value;
    }

    public TemplateService.Template getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public void execute(IngestDocument ingestDocument) throws Exception {
        ingestDocument.appendFieldValue(this.field, this.value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final TemplateService templateService;

        public Factory(TemplateService templateService) {
            this.templateService = templateService;
        }

        public AppendProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"field");
            Object value = ConfigurationUtils.readObject((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"value");
            TemplateService.Template compiledTemplate = ConfigurationUtils.compileTemplate((String)AppendProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (TemplateService)this.templateService);
            return new AppendProcessor(processorTag, compiledTemplate, ValueSource.wrap((Object)value, (TemplateService)this.templateService));
        }
    }
}

