/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public class InternalClusterInfoService
extends AbstractComponent
implements ClusterInfoService,
LocalNodeMasterListener,
ClusterStateListener {
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING = Setting.timeSetting("cluster.info.update.interval", TimeValue.timeValueSeconds(30L), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.info.update.timeout", TimeValue.timeValueSeconds(15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue updateFrequency;
    private volatile ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsages;
    private volatile ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsages;
    private volatile ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath;
    private volatile ImmutableOpenMap<String, Long> shardSizes;
    private volatile boolean isMaster = false;
    private volatile boolean enabled;
    private volatile TimeValue fetchTimeout;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final NodeClient client;
    private final List<ClusterInfoService.Listener> listeners = new CopyOnWriteArrayList<ClusterInfoService.Listener>();

    public InternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        super(settings);
        this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
        this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
        this.shardRoutingToDataPath = ImmutableOpenMap.of();
        this.shardSizes = ImmutableOpenMap.of();
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.updateFrequency = INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING.get(settings);
        this.fetchTimeout = INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING.get(settings);
        this.enabled = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING, this::setFetchTimeout);
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, this::setUpdateFrequency);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
        this.clusterService.addLocalNodeMasterListener(this);
        this.clusterService.addListener(this);
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    void setUpdateFrequency(TimeValue updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    @Override
    public void onMaster() {
        block4: {
            this.isMaster = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("I have been elected master, scheduling a ClusterInfoUpdateJob");
            }
            try {
                this.threadPool.schedule(this.updateFrequency, this.executorName(), new SubmitReschedulingClusterInfoUpdatedJob());
                if (this.clusterService.state().getNodes().getDataNodes().size() > 1) {
                    this.threadPool.executor(this.executorName()).execute(() -> this.maybeRefresh());
                }
            }
            catch (EsRejectedExecutionException ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("Couldn't schedule cluster info update task - node might be shutting down", (Throwable)ex);
            }
        }
    }

    @Override
    public void offMaster() {
        this.isMaster = false;
    }

    @Override
    public String executorName() {
        return "management";
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.enabled) {
            return;
        }
        boolean dataNodeAdded = false;
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.isDataNode()) continue;
            dataNodeAdded = true;
            break;
        }
        if (this.isMaster && dataNodeAdded && event.state().getNodes().getDataNodes().size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("data node was added, retrieving new cluster info");
            }
            this.threadPool.executor(this.executorName()).execute(() -> this.maybeRefresh());
        }
        if (this.isMaster && event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                if (!removedNode.isDataNode()) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Removing node from cluster info: {}", (Object)removedNode.getId());
                }
                if (this.leastAvailableSpaceUsages.containsKey(removedNode.getId())) {
                    ImmutableOpenMap.Builder<String, DiskUsage> newMaxUsages = ImmutableOpenMap.builder(this.leastAvailableSpaceUsages);
                    newMaxUsages.remove(removedNode.getId());
                    this.leastAvailableSpaceUsages = newMaxUsages.build();
                }
                if (!this.mostAvailableSpaceUsages.containsKey(removedNode.getId())) continue;
                ImmutableOpenMap.Builder<String, DiskUsage> newMinUsages = ImmutableOpenMap.builder(this.mostAvailableSpaceUsages);
                newMinUsages.remove(removedNode.getId());
                this.mostAvailableSpaceUsages = newMinUsages.build();
            }
        }
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, this.shardSizes, this.shardRoutingToDataPath);
    }

    @Override
    public void addListener(ClusterInfoService.Listener listener) {
        this.listeners.add(listener);
    }

    protected CountDownLatch updateNodeStats(ActionListener<NodesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
        nodesStatsRequest.clear();
        nodesStatsRequest.fs(true);
        nodesStatsRequest.timeout(this.fetchTimeout);
        this.client.admin().cluster().nodesStats(nodesStatsRequest, new LatchedActionListener<NodesStatsResponse>(listener, latch));
        return latch;
    }

    protected CountDownLatch updateIndicesStats(ActionListener<IndicesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.clear();
        indicesStatsRequest.store(true);
        this.client.admin().indices().stats(indicesStatsRequest, new LatchedActionListener<IndicesStatsResponse>(listener, latch));
        return latch;
    }

    private void maybeRefresh() {
        if (this.enabled) {
            this.refresh();
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("Skipping ClusterInfoUpdatedJob since it is disabled");
        }
    }

    public final ClusterInfo refresh() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Performing ClusterInfoUpdateJob");
        }
        CountDownLatch nodeLatch = this.updateNodeStats(new ActionListener<NodesStatsResponse>(){

            @Override
            public void onResponse(NodesStatsResponse nodeStatses) {
                ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvaiableUsages = ImmutableOpenMap.builder();
                ImmutableOpenMap.Builder<String, DiskUsage> newMostAvaiableUsages = ImmutableOpenMap.builder();
                InternalClusterInfoService.fillDiskUsagePerNode(InternalClusterInfoService.this.logger, nodeStatses.getNodes(), newLeastAvaiableUsages, newMostAvaiableUsages);
                InternalClusterInfoService.this.leastAvailableSpaceUsages = newLeastAvaiableUsages.build();
                InternalClusterInfoService.this.mostAvailableSpaceUsages = newMostAvaiableUsages.build();
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    InternalClusterInfoService.this.logger.error("NodeStatsAction timed out for ClusterInfoUpdateJob", (Throwable)e);
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                    }
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
                }
            }
        });
        CountDownLatch indicesLatch = this.updateIndicesStats(new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                ShardStats[] stats = indicesStatsResponse.getShards();
                ImmutableOpenMap.Builder<String, Long> newShardSizes = ImmutableOpenMap.builder();
                ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath = ImmutableOpenMap.builder();
                InternalClusterInfoService.buildShardLevelInfo(InternalClusterInfoService.this.logger, stats, newShardSizes, newShardRoutingToDataPath, InternalClusterInfoService.this.clusterService.state());
                InternalClusterInfoService.this.shardSizes = newShardSizes.build();
                InternalClusterInfoService.this.shardRoutingToDataPath = newShardRoutingToDataPath.build();
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    InternalClusterInfoService.this.logger.error("IndicesStatsAction timed out for ClusterInfoUpdateJob", (Throwable)e);
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                    }
                    InternalClusterInfoService.this.shardSizes = ImmutableOpenMap.of();
                    InternalClusterInfoService.this.shardRoutingToDataPath = ImmutableOpenMap.of();
                }
            }
        });
        try {
            nodeLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Failed to update node information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
        }
        try {
            indicesLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Failed to update shard information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
        }
        ClusterInfo clusterInfo = this.getClusterInfo();
        for (ClusterInfoService.Listener l : this.listeners) {
            try {
                l.onNewInfo(clusterInfo);
            }
            catch (Exception e) {
                this.logger.info("Failed executing ClusterInfoService listener", (Throwable)e);
            }
        }
        return clusterInfo;
    }

    static void buildShardLevelInfo(Logger logger, ShardStats[] stats, ImmutableOpenMap.Builder<String, Long> newShardSizes, ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath, ClusterState state) {
        MetaData meta = state.getMetaData();
        for (ShardStats s : stats) {
            IndexMetaData indexMeta = meta.index(s.getShardRouting().index());
            Settings indexSettings = indexMeta == null ? null : indexMeta.getSettings();
            newShardRoutingToDataPath.put(s.getShardRouting(), s.getDataPath());
            long size = s.getStats().getStore().sizeInBytes();
            String sid = ClusterInfo.shardIdentifierFromRouting(s.getShardRouting());
            if (logger.isTraceEnabled()) {
                logger.trace("shard: {} size: {}", (Object)sid, (Object)size);
            }
            if (indexSettings != null && IndexMetaData.isIndexUsingShadowReplicas(indexSettings)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("shard: {} is using shadow replicas and will be treated as size 0", (Object)sid);
                }
                size = 0L;
            }
            newShardSizes.put(sid, size);
        }
    }

    static void fillDiskUsagePerNode(Logger logger, List<NodeStats> nodeStatsArray, ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvaiableUsages, ImmutableOpenMap.Builder<String, DiskUsage> newMostAvaiableUsages) {
        for (NodeStats nodeStats : nodeStatsArray) {
            if (nodeStats.getFs() == null) {
                logger.warn("Unable to retrieve node FS stats for {}", (Object)nodeStats.getNode().getName());
                continue;
            }
            FsInfo.Path leastAvailablePath = null;
            FsInfo.Path mostAvailablePath = null;
            for (FsInfo.Path info : nodeStats.getFs()) {
                if (leastAvailablePath == null) {
                    assert (mostAvailablePath == null);
                    mostAvailablePath = leastAvailablePath = info;
                    continue;
                }
                if (leastAvailablePath.getAvailable().getBytes() > info.getAvailable().getBytes()) {
                    leastAvailablePath = info;
                    continue;
                }
                if (mostAvailablePath.getAvailable().getBytes() >= info.getAvailable().getBytes()) continue;
                mostAvailablePath = info;
            }
            String nodeId = nodeStats.getNode().getId();
            String nodeName = nodeStats.getNode().getName();
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}], most available: total disk: {}, available disk: {} / least available: total disk: {}, available disk: {}", (Object)nodeId, (Object)mostAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable(), (Object)leastAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable());
            }
            if (leastAvailablePath.getTotal().getBytes() < 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)leastAvailablePath.getTotal().getBytes());
                }
            } else {
                newLeastAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().getBytes(), leastAvailablePath.getAvailable().getBytes()));
            }
            if (mostAvailablePath.getTotal().getBytes() < 0L) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)mostAvailablePath.getTotal().getBytes());
                continue;
            }
            newMostAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().getBytes(), mostAvailablePath.getAvailable().getBytes()));
        }
    }

    public class SubmitReschedulingClusterInfoUpdatedJob
    implements Runnable {
        @Override
        public void run() {
            block3: {
                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                    InternalClusterInfoService.this.logger.trace("Submitting new rescheduling cluster info update job");
                }
                try {
                    InternalClusterInfoService.this.threadPool.executor(InternalClusterInfoService.this.executorName()).execute(() -> {
                        try {
                            InternalClusterInfoService.this.maybeRefresh();
                        }
                        finally {
                            if (InternalClusterInfoService.this.isMaster) {
                                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                                    InternalClusterInfoService.this.logger.trace("Scheduling next run for updating cluster info in: {}", (Object)InternalClusterInfoService.this.updateFrequency.toString());
                                }
                                try {
                                    InternalClusterInfoService.this.threadPool.schedule(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.this.executorName(), this);
                                }
                                catch (EsRejectedExecutionException ex) {
                                    InternalClusterInfoService.this.logger.debug("Reschedule cluster info service was rejected", (Throwable)ex);
                                }
                            }
                        }
                    });
                }
                catch (EsRejectedExecutionException ex) {
                    if (!InternalClusterInfoService.this.logger.isDebugEnabled()) break block3;
                    InternalClusterInfoService.this.logger.debug("Couldn't re-schedule cluster info update task - node might be shutting down", (Throwable)ex);
                }
            }
        }
    }
}

