"""Generated message classes for cloudiot version v1beta1.

Registers and manages IoT (Internet of Things) devices that connect to the
Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudiot'


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
      Next ID: 4
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    """The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: an
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently. This field is GOOGLE_INTERNAL.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudAuditOptions(_messages.Message):
  """Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    isReadPermissionType: True if the log is for a permission of type
      DATA_READ or ADMIN_READ.
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    """The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  isReadPermissionType = _messages.BooleanField(1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)


class CloudiotProjectsLocationsRegistriesCreateRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesCreateRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    parent: The project and cloud region where this device registry must be
      created. For example, `projects/example-project/locations/us-central1`.
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDeleteRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDeleteRequest object.

  Fields:
    name: The name of the device registry. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesConfigVersionsListRequest
  object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
    numVersions: The number of versions to list. Versions are listed in
      decreasing order of the version number. The maximum number of versions
      retained is 10. If this value is zero, it will return all the versions
      available.
  """

  name = _messages.StringField(1, required=True)
  numVersions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudiotProjectsLocationsRegistriesDevicesCreateRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesCreateRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    parent: The name of the device registry where this device should be
      created. For example, `projects/example-project/locations/us-
      central1/registries/my-registry`.
  """

  device = _messages.MessageField('Device', 1)
  parent = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesDeleteRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesDeleteRequest object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesGetRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesGetRequest object.

  Fields:
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesDevicesListRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesListRequest object.

  Fields:
    deviceIds: A list of device string identifiers. If empty, it will ignore
      this field. For example, `['device0', 'device12']`. This field cannot
      hold more than 10,000 entries.
    deviceNumIds: A list of device numerical ids. If empty, it will ignore
      this field. This field cannot hold more than 10,000 entries.
    fieldMask: The fields of the `Device` resource to be returned in the
      response. The fields `id`, and `num_id` are always returned by default,
      along with any other fields specified.
    pageSize: The maximum number of devices to return in the response. If this
      value is zero, the service will select a default size. A call may return
      fewer objects than requested, but if there is a non-empty `page_token`,
      it indicates that more entries are available.
    pageToken: The value returned by the last `ListDevicesResponse`; indicates
      that this is a continuation of a prior `ListDevices` call, and that the
      system should return the next page of data.
    parent: The device registry path. Required. For example, `projects/my-
      project/locations/us-central1/registries/my-registry`.
  """

  deviceIds = _messages.StringField(1, repeated=True)
  deviceNumIds = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.UINT64)
  fieldMask = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)


class CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest(_messages.Message):
  """A
  CloudiotProjectsLocationsRegistriesDevicesModifyCloudToDeviceConfigRequest
  object.

  Fields:
    modifyCloudToDeviceConfigRequest: A ModifyCloudToDeviceConfigRequest
      resource to be passed as the request body.
    name: The name of the device. For example, `projects/p0/locations/us-
      central1/registries/registry0/devices/device0` or `projects/p0/locations
      /us-central1/registries/registry0/devices/{num_id}`.
  """

  modifyCloudToDeviceConfigRequest = _messages.MessageField('ModifyCloudToDeviceConfigRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesDevicesPatchRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesDevicesPatchRequest object.

  Fields:
    device: A Device resource to be passed as the request body.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or `projects/p1/locations
      /us-central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    updateMask: Only updates the `device` fields indicated by this mask. The
      field mask must not be empty, and it must not contain fields that are
      immutable or only set by the server. Mutable top-level fields:
      `credentials` and `enabled_state`
  """

  device = _messages.MessageField('Device', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesGetIamPolicyRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudiotProjectsLocationsRegistriesGetRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesGetRequest object.

  Fields:
    name: The name of the device registry. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
  """

  name = _messages.StringField(1, required=True)


class CloudiotProjectsLocationsRegistriesListRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesListRequest object.

  Fields:
    pageSize: The maximum number of registries to return in the response. If
      this value is zero, the service will select a default size. A call may
      return fewer objects than requested, but if there is a non-empty
      `page_token`, it indicates that more entries are available.
    pageToken: The value returned by the last `ListDeviceRegistriesResponse`;
      indicates that this is a continuation of a prior `ListDeviceRegistries`
      call, and that the system should return the next page of data.
    parent: The project and cloud region path. For example, `projects/example-
      project/locations/us-central1`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudiotProjectsLocationsRegistriesPatchRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesPatchRequest object.

  Fields:
    deviceRegistry: A DeviceRegistry resource to be passed as the request
      body.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
    updateMask: Only updates the `device_registry` fields indicated by this
      mask. The field mask must not be empty, and it must not contain fields
      that are immutable or only set by the server. Mutable top-level fields:
      `event_notification_config` and `mqtt_config`
  """

  deviceRegistry = _messages.MessageField('DeviceRegistry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudiotProjectsLocationsRegistriesSetIamPolicyRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest(_messages.Message):
  """A CloudiotProjectsLocationsRegistriesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Condition(_messages.Message):
  """A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    APPROVER = 3
    JUSTIFICATION_TYPE = 4

  class OpValueValuesEnum(_messages.Enum):
    """An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by any service that owns resources and uses
    the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class CounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  """Write a Data Access (Gin) log"""


class Device(_messages.Message):
  """The device resource.

  Enums:
    EnabledStateValueValuesEnum: If disabled, connections from this device
      will fail. Can be used to temporarily prevent the device from connecting
      if, for example, the sensor is generating bad data and needs
      maintenance.

  Fields:
    config: The most recent device configuration, which is eventually sent
      from the Cloud IoT Core service to the device. If not present on
      creation, the configuration will be initialized with an empty payload
      and version value of `1`. To update this field after creation, use the
      `DeviceManager.ModifyCloudToDeviceConfig` method.
    credentials: The credentials used to authenticate this device. To allow
      credential rotation without interruption, multiple device credentials
      can be bound to this device. No more than 3 credentials can be bound to
      a single device at a time.
    enabledState: If disabled, connections from this device will fail. Can be
      used to temporarily prevent the device from connecting if, for example,
      the sensor is generating bad data and needs maintenance.
    id: The user-defined device identifier. The device ID must be unique
      within a device registry.
    lastConfigAckTime: [Output only] The last time a cloud-to-device config
      version acknowledgment was received from the device.
    lastErrorStatus: [Output only] The error message of the last error, e.g.,
      failed to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp
      of this field. If no errors are present, this will have an empty message
      (whose status code is 0 == OK), otherwise this field is expected to have
      a not-OK status code.
    lastErrorTime: [Output only] The last time an error happened, e.g., failed
      to publish to Cloud Pub/Sub. This field is the timestamp of
      'last_error_status'.
    lastEventTime: [Output only] The last time an event was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    lastHeartbeatTime: [Output only] The last time a heartbeat was received.
      Timestamps are periodically collected and written to storage; they may
      be stale by a few minutes.
    name: The resource path name. For example, `projects/p1/locations/us-
      central1/registries/registry0/devices/dev0` or `projects/p1/locations
      /us-central1/registries/registry0/devices/{num_id}`. When `name` is
      populated as a response from the service, it always ends in the device
      numeric ID.
    numId: [Output only] A server-defined unique numeric ID for the device.
      This is a more compact way to identify devices, and it is globally
      unique.
  """

  class EnabledStateValueValuesEnum(_messages.Enum):
    """If disabled, connections from this device will fail. Can be used to
    temporarily prevent the device from connecting if, for example, the sensor
    is generating bad data and needs maintenance.

    Values:
      UNSPECIFIED_ENABLED_STATE: No enabled state specified. If not specified,
        defaults to enabled.
      DEVICE_ENABLED: Enables a device. By default, devices will be enabled.
      DEVICE_DISABLED: Disables a device.
    """
    UNSPECIFIED_ENABLED_STATE = 0
    DEVICE_ENABLED = 1
    DEVICE_DISABLED = 2

  config = _messages.MessageField('DeviceConfig', 1)
  credentials = _messages.MessageField('DeviceCredential', 2, repeated=True)
  enabledState = _messages.EnumField('EnabledStateValueValuesEnum', 3)
  id = _messages.StringField(4)
  lastConfigAckTime = _messages.StringField(5)
  lastErrorStatus = _messages.MessageField('Status', 6)
  lastErrorTime = _messages.StringField(7)
  lastEventTime = _messages.StringField(8)
  lastHeartbeatTime = _messages.StringField(9)
  name = _messages.StringField(10)
  numId = _messages.IntegerField(11, variant=_messages.Variant.UINT64)


class DeviceConfig(_messages.Message):
  """The device configuration and its metadata. Eventually delivered to
  devices.

  Fields:
    cloudUpdateTime: [Output only] The time when this version state was
      updated in the Cloud IoT Core service. This timestamp is set by the
      server.
    data: The device configuration data.
    deviceAckTime: [Output only] The time when the Cloud IoT Core server
      received the acknowledgment from the device, indicating that the device
      has received this configuration version. If this field is not present,
      the device has not yet acknowledged that it received this version. Note
      that when sending the config to the device, there may have been many
      config versions on the Cloud IoT Core service while the device was
      disconnected; and on connection, only the latest version is sent to the
      device. Some of the versions may never be sent to the device, and
      therefore are never acknowledged. This timestamp is set by the Cloud IoT
      Core service.
    version: [Output only] The version of this update. The version number is
      assigned by the server, and is always greater than zero after device
      creation. The version must be zero on the `CreateDevice` request if a
      `config` is specified; the response of `CreateDevice` will always have a
      value of one.
  """

  cloudUpdateTime = _messages.StringField(1)
  data = _messages.MessageField('DeviceConfigData', 2)
  deviceAckTime = _messages.StringField(3)
  version = _messages.IntegerField(4)


class DeviceConfigData(_messages.Message):
  """The data for a device configuration. Only binary data is currently
  supported.

  Fields:
    binaryData: The configuration sent to the device, as bytes.
  """

  binaryData = _messages.BytesField(1)


class DeviceCredential(_messages.Message):
  """A server-stored device credential used for authentication.

  Fields:
    expirationTime: [Optional] The time at which this credential becomes
      invalid. This credential will be ignored for new client authentication
      requests after this timestamp; however, it will not be automatically
      deleted.
    publicKey: A public key used to verify the signature of JSON Web Tokens
      (JWTs).
  """

  expirationTime = _messages.StringField(1)
  publicKey = _messages.MessageField('PublicKeyCredential', 2)


class DeviceRegistry(_messages.Message):
  """A container for a group of devices.

  Fields:
    eventNotificationConfig: Configuration to notify events received from the
      device.
    id: The identifier of this device registry. For example, `myRegistry`.
    mqttConfig: The configuration of the MQTT broker associated with this
      device registry, including enablement, payload data format type, etc.
    name: The resource path name. For example, `projects/example-
      project/locations/us-central1/registries/my-registry`.
  """

  eventNotificationConfig = _messages.MessageField('NotificationConfig', 1)
  id = _messages.StringField(2)
  mqttConfig = _messages.MessageField('MqttConfig', 3)
  name = _messages.StringField(4)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  """Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class ListDeviceConfigVersionsResponse(_messages.Message):
  """Response for `ListDeviceConfigVersions`.

  Fields:
    deviceConfigs: The device configuration for the last few versions.
      Versions are listed in decreasing order, starting from the most recent
      one.
  """

  deviceConfigs = _messages.MessageField('DeviceConfig', 1, repeated=True)


class ListDeviceRegistriesResponse(_messages.Message):
  """Response for `ListDeviceRegistries`.

  Fields:
    deviceRegistries: The registries that matched the query.
    nextPageToken: If not empty, indicates that there may be more registries
      that match the request; this value should be passed in a new
      `ListDeviceRegistriesRequest`.
  """

  deviceRegistries = _messages.MessageField('DeviceRegistry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDevicesResponse(_messages.Message):
  """Response for `ListDevices`.

  Fields:
    devices: The devices that match the request.
    nextPageToken: If not empty, indicates that there may be more devices that
      match the request; this value should be passed in a new
      `ListDevicesRequest`.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write Increment a streamz
  counter with the specified metric and field names.  Metric names should
  start with a '/', generally be lowercase-only, and end in "_count". Field
  names should not contain an initial slash. The actual exported metric names
  will have "/iam/policy" prepended.  Field names correspond to IAM request
  parameters and field values are their respective values.  At present the
  only supported field names are    - "iam_principal", corresponding to
  IAMContext.principal;    - "" (empty string), resulting in one aggretated
  counter with no field.  Examples:   counter { metric: "/debug_access_count"
  field: "iam_principal" }   ==> increment counter
  /iam/policy/backend_debug_access_count
  {iam_principal=[value of IAMContext.principal]}  At this time we do not
  support: * multiple field names (though this may be supported in the future)
  * decrementing the counter * incrementing it by anything other than 1

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class ModifyCloudToDeviceConfigRequest(_messages.Message):
  """Request for `ModifyCloudToDeviceConfig`.

  Fields:
    data: The configuration data for the device.
    versionToUpdate: The version number to update. If this value is zero, it
      will not check the version number of the server and will always update
      the current version; otherwise, this update will fail if the version
      number found on the server does not match this version number. This is
      used to support multiple simultaneous updates without losing data.
  """

  data = _messages.MessageField('DeviceConfigData', 1)
  versionToUpdate = _messages.IntegerField(2)


class MqttConfig(_messages.Message):
  """The configuration of MQTT for a device registry.

  Enums:
    MqttConfigStateValueValuesEnum: If enabled, allows connections using the
      MQTT protocol. Otherwise any MQTT connection to this registry will fail.

  Fields:
    mqttConfigState: If enabled, allows connections using the MQTT protocol.
      Otherwise any MQTT connection to this registry will fail.
  """

  class MqttConfigStateValueValuesEnum(_messages.Enum):
    """If enabled, allows connections using the MQTT protocol. Otherwise any
    MQTT connection to this registry will fail.

    Values:
      UNSPECIFIED_MQTT_STATE: No MQTT state specified. If not specified, MQTT
        will be enabled by default.
      MQTT_ENABLED: Enables a MQTT connection.
      MQTT_DISABLED: Disables a MQTT connection.
    """
    UNSPECIFIED_MQTT_STATE = 0
    MQTT_ENABLED = 1
    MQTT_DISABLED = 2

  mqttConfigState = _messages.EnumField('MqttConfigStateValueValuesEnum', 1)


class NotificationConfig(_messages.Message):
  """Configuration to forward messages such as telemetry events.

  Fields:
    pubsubTopicName: A Cloud Pub/Sub topic name. For example,
      `projects/myProject/topics/deviceEvents`.
  """

  pubsubTopicName = _messages.StringField(1)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com",           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class PublicKeyCredential(_messages.Message):
  """A public key format and data.

  Enums:
    FormatValueValuesEnum: The format of the key.

  Fields:
    format: The format of the key.
    key: The key data.
  """

  class FormatValueValuesEnum(_messages.Enum):
    """The format of the key.

    Values:
      UNSPECIFIED_PUBLIC_KEY_FORMAT: The format has not been specified. This
        is an invalid default value and must not be used.
      RSA_X509_PEM: An RSA public key wrapped in a X.509v3 certificate
        [RFC5280](https://www.ietf.org/rfc/rfc5280.txt), encoded in base64,
        and wrapped by `-----BEGIN CERTIFICATE-----` and `-----END
        CERTIFICATE-----`. This can be used to verify `RS256` signatures in
        JWT tokens [RFC7518](https://www.ietf.org/rfc/rfc7518.txt).
      ES256_PEM: Public key for the ECDSA algorithm using P-256 and SHA-256,
        encoded in base64, and wrapped by `-----BEGIN PUBLIC KEY-----` and
        `-----END PUBLIC KEY-----`. This can be used to verify JWT tokens with
        the `ES256` algorithm [RFC7518](https://www.ietf.org/rfc/rfc7518.txt).
        This curve is defined in [openssl](https://www.openssl.org/) as the
        `prime256v1` curve.
    """
    UNSPECIFIED_PUBLIC_KEY_FORMAT = 0
    RSA_X509_PEM = 1
    ES256_PEM = 2

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  key = _messages.StringField(2)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries is the same as for members in a Binding (see
      google/iam/v1/policy.proto).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  """Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  """Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in',
    package=u'cloudiot')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'cloudiot')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'cloudiot')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'cloudiot')
