require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET6_ND6_H_)) {
    eval 'sub _NETINET6_ND6_H_ () {1;}' unless defined(&_NETINET6_ND6_H_);
    require 'sys/task.ph';
    eval 'sub ND6_LLINFO_PURGE () {-3;}' unless defined(&ND6_LLINFO_PURGE);
    eval 'sub ND6_LLINFO_NOSTATE () {-2;}' unless defined(&ND6_LLINFO_NOSTATE);
    eval 'sub ND6_LLINFO_INCOMPLETE () {0;}' unless defined(&ND6_LLINFO_INCOMPLETE);
    eval 'sub ND6_LLINFO_REACHABLE () {1;}' unless defined(&ND6_LLINFO_REACHABLE);
    eval 'sub ND6_LLINFO_STALE () {2;}' unless defined(&ND6_LLINFO_STALE);
    eval 'sub ND6_LLINFO_DELAY () {3;}' unless defined(&ND6_LLINFO_DELAY);
    eval 'sub ND6_LLINFO_PROBE () {4;}' unless defined(&ND6_LLINFO_PROBE);
    eval 'sub ND6_IFF_PERFORMNUD () {0x1;}' unless defined(&ND6_IFF_PERFORMNUD);
    eval 'sub ND6_IFF_ACCEPT_RTADV () {0x2;}' unless defined(&ND6_IFF_ACCEPT_RTADV);
    eval 'sub PR_ORIG_RA () {0;}' unless defined(&PR_ORIG_RA);
    eval 'sub PR_ORIG_RR () {1;}' unless defined(&PR_ORIG_RR);
    eval 'sub PR_ORIG_STATIC () {2;}' unless defined(&PR_ORIG_STATIC);
    eval 'sub PR_ORIG_KERNEL () {3;}' unless defined(&PR_ORIG_KERNEL);
    eval 'sub NDPRF_ONLINK () {0x1;}' unless defined(&NDPRF_ONLINK);
    eval 'sub NDPRF_DETACHED () {0x2;}' unless defined(&NDPRF_DETACHED);
    eval 'sub NDPRF_HOME () {0x4;}' unless defined(&NDPRF_HOME);
    eval 'sub MAX_RTR_SOLICITATION_DELAY () {1;}' unless defined(&MAX_RTR_SOLICITATION_DELAY);
    eval 'sub RTR_SOLICITATION_INTERVAL () {4;}' unless defined(&RTR_SOLICITATION_INTERVAL);
    eval 'sub MAX_RTR_SOLICITATIONS () {3;}' unless defined(&MAX_RTR_SOLICITATIONS);
    eval 'sub ND6_INFINITE_LIFETIME () {0xffffffff;}' unless defined(&ND6_INFINITE_LIFETIME);
    eval 'sub ND6_PRIV_MAX_DESYNC_FACTOR () {512;}' unless defined(&ND6_PRIV_MAX_DESYNC_FACTOR);
    eval 'sub ND6_PRIV_VALID_LIFETIME () {604800;}' unless defined(&ND6_PRIV_VALID_LIFETIME);
    eval 'sub ND6_PRIV_PREFERRED_LIFETIME () {86400;}' unless defined(&ND6_PRIV_PREFERRED_LIFETIME);
    if(defined(&_KERNEL)) {
	require 'sys/queue.ph';
	require 'sys/timeout.ph';
	eval 'sub ND_IFINFO {
	    my($ifp) = @_;
    	    eval q(((($ifp)-> $if_afdata[ &AF_INET6])-> &nd_ifinfo));
	}' unless defined(&ND_IFINFO);
	eval 'sub RS_LHCOOKIE {
	    my($ifp) = @_;
    	    eval q((($ifp)-> $if_afdata[ &AF_INET6])-> &rs_lhcookie);
	}' unless defined(&RS_LHCOOKIE);
	eval 'sub ND6_IS_LLINFO_PROBREACH {
	    my($n) = @_;
    	    eval q((($n)-> &ln_state >  &ND6_LLINFO_INCOMPLETE));
	}' unless defined(&ND6_IS_LLINFO_PROBREACH);
	eval 'sub ND6_LLINFO_PERMANENT {
	    my($n) = @_;
    	    eval q((($n)-> ($l$n_rt->{rt_expire}) == 0));
	}' unless defined(&ND6_LLINFO_PERMANENT);
	eval 'sub MAX_REACHABLE_TIME () {3600000;}' unless defined(&MAX_REACHABLE_TIME);
	eval 'sub REACHABLE_TIME () {30000;}' unless defined(&REACHABLE_TIME);
	eval 'sub RETRANS_TIMER () {1000;}' unless defined(&RETRANS_TIMER);
	eval 'sub MIN_RANDOM_FACTOR () {512;}' unless defined(&MIN_RANDOM_FACTOR);
	eval 'sub MAX_RANDOM_FACTOR () {1536;}' unless defined(&MAX_RANDOM_FACTOR);
	eval 'sub ND_COMPUTE_RTIME {
	    my($x) = @_;
    	    eval q(((( &MIN_RANDOM_FACTOR * ($x >> 10)) + ( &arc4random() & (( &MAX_RANDOM_FACTOR -  &MIN_RANDOM_FACTOR) * ($x >> 10)))) /1000));
	}' unless defined(&ND_COMPUTE_RTIME);
	eval 'sub ndpr_raf () { &ndpr_flags;}' unless defined(&ndpr_raf);
	eval 'sub ndpr_raf_onlink () { ($ndpr_flags->{onlink});}' unless defined(&ndpr_raf_onlink);
	eval 'sub ndpr_raf_auto () { ($ndpr_flags->{autonomous});}' unless defined(&ndpr_raf_auto);
	eval 'sub ndpr_raf_router () { ($ndpr_flags->{router});}' unless defined(&ndpr_raf_router);
	eval 'sub nd6log {
	    my($x) = @_;
    	    eval q( &do {  &if ( &nd6_debug)  &log $x; }  &while (0));
	}' unless defined(&nd6log);
	eval 'sub nd_opts_src_lladdr () { ($nd_opt_each->{src_lladdr});}' unless defined(&nd_opts_src_lladdr);
	eval 'sub nd_opts_tgt_lladdr () { ($nd_opt_each->{tgt_lladdr});}' unless defined(&nd_opts_tgt_lladdr);
	eval 'sub nd_opts_pi () { ($nd_opt_each->{pi_beg});}' unless defined(&nd_opts_pi);
	eval 'sub nd_opts_pi_end () { ($nd_opt_each->{pi_end});}' unless defined(&nd_opts_pi_end);
	eval 'sub nd_opts_rh () { ($nd_opt_each->{rh});}' unless defined(&nd_opts_rh);
	eval 'sub nd_opts_mtu () { ($nd_opt_each->{mtu});}' unless defined(&nd_opts_mtu);
	eval 'sub nd_opts_search () { ($nd_opt_each->{search});}' unless defined(&nd_opts_search);
	eval 'sub nd_opts_last () { ($nd_opt_each->{last});}' unless defined(&nd_opts_last);
	eval 'sub nd_opts_done () { ($nd_opt_each->{done});}' unless defined(&nd_opts_done);
    }
}
1;
