/*	$OpenBSD: usbdevs.h,v 1.685 2016/12/15 15:44:46 pirofti Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	OpenBSD: usbdevs,v 1.673 2016/12/15 15:42:05 pirofti Exp 
 */
/* $NetBSD: usbdevs,v 1.322 2003/05/10 17:47:14 hamajima Exp $ */

/*
 * Copyright (c) 1998, 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net) at
 * Carlstedt Research & Technology.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * List of known USB vendors
 *
 * Please note that these IDs do not do anything. Adding an ID here and
 * regenerating the usbdevs.h and usbdevs_data.h only makes a symbolic name
 * available to the source code and does not change any functionality, nor
 * does it make your device available to a specific driver.
 * It will however make the descriptive string available if a device does not
 * provide the string itself.
 *
 * After adding a vendor ID VNDR and a product ID PRDCT you will have the
 * following extra defines:
 * #define USB_VENDOR_VNDR              0x????
 * #define USB_PRODUCT_VNDR_PRDCT       0x????
 *
 * You may have to add these defines to the respective probe routines to
 * make the device recognised by the appropriate device driver.
 */

#define	USB_VENDOR_PLANEX4	0x0053		/* Planex Communications */
#define	USB_VENDOR_UNKNOWN2	0x0105		/* Unknown vendor */
#define	USB_VENDOR_EGALAX2	0x0123		/* eGalax */
#define	USB_VENDOR_UNKNOWN6	0x01e1		/* Unknown vendor */
#define	USB_VENDOR_HUMAX	0x02ad		/* HUMAX */
#define	USB_VENDOR_BWCT	0x03da		/* Bernd Walter Computer Technology */
#define	USB_VENDOR_AOX	0x03e8		/* AOX */
#define	USB_VENDOR_ATMEL	0x03eb		/* Atmel */
#define	USB_VENDOR_MITSUMI	0x03ee		/* Mitsumi */
#define	USB_VENDOR_HP	0x03f0		/* Hewlett Packard */
#define	USB_VENDOR_ADAPTEC	0x03f3		/* Adaptec */
#define	USB_VENDOR_NATIONAL	0x0400		/* National Semiconductor */
#define	USB_VENDOR_ACERLABS	0x0402		/* Acer Labs */
#define	USB_VENDOR_FTDI	0x0403		/* Future Technology Devices */
#define	USB_VENDOR_QUANTA2	0x0408		/* Quanta */
#define	USB_VENDOR_NEC	0x0409		/* NEC */
#define	USB_VENDOR_KODAK	0x040a		/* Eastman Kodak */
#define	USB_VENDOR_VIA	0x040d		/* VIA */
#define	USB_VENDOR_MELCO	0x0411		/* Melco */
#define	USB_VENDOR_LEADTEK	0x0413		/* Leadtek */
#define	USB_VENDOR_CREATIVE	0x041e		/* Creative Labs */
#define	USB_VENDOR_NOKIA2	0x0421		/* Nokia */
#define	USB_VENDOR_ADI	0x0422		/* ADI Systems */
#define	USB_VENDOR_CATC	0x0423		/* Computer Access Technology */
#define	USB_VENDOR_SMC2	0x0424		/* Standard Microsystems */
#define	USB_VENDOR_GRAVIS	0x0428		/* Advanced Gravis Computer */
#define	USB_VENDOR_FUJITSUCOMP	0x0430		/* Fujitsu Component */
#define	USB_VENDOR_TAUGA	0x0436		/* Taugagreining HF */
#define	USB_VENDOR_AMD	0x0438		/* Advanced Micro Devices */
#define	USB_VENDOR_LEXMARK	0x043d		/* Lexmark International */
#define	USB_VENDOR_NANAO	0x0440		/* NANAO */
#define	USB_VENDOR_ALPS	0x044e		/* Alps Electric */
#define	USB_VENDOR_THRUST	0x044f		/* Thrustmaster */
#define	USB_VENDOR_TI	0x0451		/* Texas Instruments */
#define	USB_VENDOR_ANALOGDEVICES	0x0456		/* Analog Devices */
#define	USB_VENDOR_SIS	0x0457		/* Silicon Integrated Systems Corp. */
#define	USB_VENDOR_KYE	0x0458		/* KYE Systems */
#define	USB_VENDOR_DIAMOND2	0x045a		/* Diamond (Supra) */
#define	USB_VENDOR_RENESAS	0x045b		/* Renesas */
#define	USB_VENDOR_MICROSOFT	0x045e		/* Microsoft */
#define	USB_VENDOR_PRIMAX	0x0461		/* Primax Electronics */
#define	USB_VENDOR_MGE	0x0463		/* Eaton (MGE) */
#define	USB_VENDOR_AMP	0x0464		/* AMP */
#define	USB_VENDOR_CHERRY	0x046a		/* Cherry Mikroschalter */
#define	USB_VENDOR_MEGATRENDS	0x046b		/* American Megatrends */
#define	USB_VENDOR_LOGITECH	0x046d		/* Logitech */
#define	USB_VENDOR_BTC	0x046e		/* Behavior Tech. Computer */
#define	USB_VENDOR_PHILIPS	0x0471		/* Philips */
#define	USB_VENDOR_SANYO	0x0474		/* Sanyo Electric */
#define	USB_VENDOR_CONNECTIX	0x0478		/* Connectix */
#define	USB_VENDOR_DELL2	0x047c		/* Dell */
#define	USB_VENDOR_KENSINGTON	0x047d		/* Kensington */
#define	USB_VENDOR_LUCENT	0x047e		/* Lucent */
#define	USB_VENDOR_PLANTRONICS	0x047f		/* Plantronics */
#define	USB_VENDOR_KYOCERA	0x0482		/* Kyocera */
#define	USB_VENDOR_STMICRO	0x0483		/* STMicroelectronics */
#define	USB_VENDOR_FOXCONN	0x0489		/* Foxconn */
#define	USB_VENDOR_YAMAHA	0x0499		/* YAMAHA */
#define	USB_VENDOR_COMPAQ	0x049f		/* Compaq */
#define	USB_VENDOR_HITACHI	0x04a4		/* Hitachi */
#define	USB_VENDOR_ACERP	0x04a5		/* Acer Peripherals */
#define	USB_VENDOR_DAVICOM	0x04a6		/* Davicom */
#define	USB_VENDOR_VISIONEER	0x04a7		/* Visioneer */
#define	USB_VENDOR_CANON	0x04a9		/* Canon */
#define	USB_VENDOR_NIKON	0x04b0		/* Nikon */
#define	USB_VENDOR_IBM	0x04b3		/* IBM */
#define	USB_VENDOR_CYPRESS	0x04b4		/* Cypress Semiconductor */
#define	USB_VENDOR_EPSON	0x04b8		/* Seiko Epson */
#define	USB_VENDOR_RAINBOW	0x04b9		/* Rainbow Technologies */
#define	USB_VENDOR_IODATA	0x04bb		/* I/O Data */
#define	USB_VENDOR_TDK	0x04bf		/* TDK */
#define	USB_VENDOR_3COMUSR	0x04c1		/* U.S. Robotics */
#define	USB_VENDOR_METHODE	0x04c2		/* Methode Electronics Far East */
#define	USB_VENDOR_MAXISWITCH	0x04c3		/* Maxi Switch */
#define	USB_VENDOR_LOCKHEEDMER	0x04c4		/* Lockheed Martin Energy Research */
#define	USB_VENDOR_FUJITSU	0x04c5		/* Fujitsu */
#define	USB_VENDOR_TOSHIBAAM	0x04c6		/* Toshiba America */
#define	USB_VENDOR_MICROMACRO	0x04c7		/* Micro Macro Technologies */
#define	USB_VENDOR_KONICA	0x04c8		/* Konica */
#define	USB_VENDOR_LITEON	0x04ca		/* Lite-On Technology */
#define	USB_VENDOR_FUJIPHOTO	0x04cb		/* Fuji Photo Film */
#define	USB_VENDOR_PHILIPSSEMI	0x04cc		/* Philips Semiconductors */
#define	USB_VENDOR_TATUNG	0x04cd		/* Tatung Co. Of America */
#define	USB_VENDOR_SCANLOGIC	0x04ce		/* ScanLogic */
#define	USB_VENDOR_MYSON	0x04cf		/* Myson Technology */
#define	USB_VENDOR_DIGI2	0x04d0		/* Digi */
#define	USB_VENDOR_ITTCANON	0x04d1		/* ITT Canon */
#define	USB_VENDOR_ALTEC	0x04d2		/* Altec Lansing */
#define	USB_VENDOR_ITUNER	0x04d8		/* Ituner */
#define	USB_VENDOR_HOLTEK	0x04d9		/* Holtek */
#define	USB_VENDOR_PANASONIC	0x04da		/* Panasonic (Matsushita) */
#define	USB_VENDOR_SHARP	0x04dd		/* Sharp */
#define	USB_VENDOR_IIYAMA	0x04e1		/* Iiyama */
#define	USB_VENDOR_SHUTTLE	0x04e6		/* Shuttle Technology */
#define	USB_VENDOR_SAMSUNG2	0x04e8		/* Samsung Electronics */
#define	USB_VENDOR_ANNABOOKS	0x04ed		/* Annabooks */
#define	USB_VENDOR_JVC	0x04f1		/* JVC */
#define	USB_VENDOR_CHICONY	0x04f2		/* Chicony Electronics */
#define	USB_VENDOR_ELAN	0x04f3		/* Elan */
#define	USB_VENDOR_BROTHER	0x04f9		/* Brother Industries */
#define	USB_VENDOR_DALLAS	0x04fa		/* Dallas Semiconductor */
#define	USB_VENDOR_ACER	0x0502		/* Acer */
#define	USB_VENDOR_3COM	0x0506		/* 3Com */
#define	USB_VENDOR_AZTECH	0x0509		/* Aztech Systems */
#define	USB_VENDOR_BELKIN	0x050d		/* Belkin Components */
#define	USB_VENDOR_KAWATSU	0x050f		/* Kawatsu Semiconductor */
#define	USB_VENDOR_APC	0x051d		/* American Power Conversion */
#define	USB_VENDOR_CONNECTEK	0x0522		/* Advanced Connectek USA */
#define	USB_VENDOR_NETCHIP	0x0525		/* NetChip Technology */
#define	USB_VENDOR_ALTRA	0x0527		/* ALTRA */
#define	USB_VENDOR_ATI	0x0528		/* ATI Technologies */
#define	USB_VENDOR_AKS	0x0529		/* Aladdin Knowledge Systems */
#define	USB_VENDOR_UNIACCESS	0x0540		/* Universal Access */
#define	USB_VENDOR_VIEWSONIC	0x0543		/* ViewSonic */
#define	USB_VENDOR_XIRLINK	0x0545		/* Xirlink */
#define	USB_VENDOR_ANCHOR	0x0547		/* Anchor Chips */
#define	USB_VENDOR_SONY	0x054c		/* Sony */
#define	USB_VENDOR_VISION	0x0553		/* VLSI Vision */
#define	USB_VENDOR_ASAHIKASEI	0x0556		/* Asahi Kasei Microsystems */
#define	USB_VENDOR_ATEN	0x0557		/* ATEN International */
#define	USB_VENDOR_SAMSUNG	0x055d		/* Samsung */
#define	USB_VENDOR_MUSTEK	0x055f		/* Mustek Systems */
#define	USB_VENDOR_MUSTEK2	0x0665		/* Mustek Systems */
#define	USB_VENDOR_TELEX	0x0562		/* Telex Communications */
#define	USB_VENDOR_PERACOM	0x0565		/* Peracom Networks */
#define	USB_VENDOR_ALCOR2	0x0566		/* Alcor Micro */
#define	USB_VENDOR_WACOM	0x056a		/* WACOM */
#define	USB_VENDOR_ETEK	0x056c		/* e-TEK Labs */
#define	USB_VENDOR_EIZO	0x056d		/* EIZO */
#define	USB_VENDOR_ELECOM	0x056e		/* Elecom */
#define	USB_VENDOR_XYRATEX	0x0572		/* Xyratex */
#define	USB_VENDOR_HAUPPAUGE	0x0573		/* Hauppauge Computer Works */
#define	USB_VENDOR_BAFO	0x0576		/* BAFO/Quality Computer Accessories */
#define	USB_VENDOR_YEDATA	0x057b		/* Y-E Data */
#define	USB_VENDOR_AVM	0x057c		/* AVM */
#define	USB_VENDOR_QUICKSHOT	0x057f		/* Quickshot */
#define	USB_VENDOR_ROLAND	0x0582		/* Roland */
#define	USB_VENDOR_ROCKFIRE	0x0583		/* Rockfire */
#define	USB_VENDOR_RATOC	0x0584		/* RATOC Systems */
#define	USB_VENDOR_ZYXEL	0x0586		/* ZyXEL Communication */
#define	USB_VENDOR_ALCOR	0x058f		/* Alcor Micro */
#define	USB_VENDOR_OMRON	0x0590		/* OMRON Corporation */
#define	USB_VENDOR_IOMEGA	0x059b		/* Iomega */
#define	USB_VENDOR_ATREND	0x059c		/* A-Trend Technology */
#define	USB_VENDOR_AID	0x059d		/* Advanced Input Devices */
#define	USB_VENDOR_LACIE	0x059f		/* LaCie */
#define	USB_VENDOR_THRUSTMASTER	0x05a4		/* Thrustmaster */
#define	USB_VENDOR_CISCOLINKSYS3	0x05a6		/* Cisco-Linksys */
#define	USB_VENDOR_OMNIVISION	0x05a9		/* OmniVision */
#define	USB_VENDOR_JINGMOLD	0x05af		/* Jing Mold */
#define	USB_VENDOR_INSYSTEM	0x05ab		/* In-System Design */
#define	USB_VENDOR_APPLE	0x05ac		/* Apple Computer */
#define	USB_VENDOR_YCCABLE	0x05ad		/* Y.C. Cable */
#define	USB_VENDOR_DIGI	0x05c5		/* Digi International */
#define	USB_VENDOR_QUALCOMM	0x05c6		/* Qualcomm */
#define	USB_VENDOR_QTRONIX	0x05c7		/* Qtronix */
#define	USB_VENDOR_RICOH	0x05ca		/* Ricoh */
#define	USB_VENDOR_ELSA	0x05cc		/* ELSA */
#define	USB_VENDOR_BRAINBOXES	0x05d1		/* Brainboxes */
#define	USB_VENDOR_ULTIMA	0x05d8		/* Ultima */
#define	USB_VENDOR_AXIOHM	0x05d9		/* Axiohm Transaction Solutions */
#define	USB_VENDOR_MICROTEK	0x05da		/* Microtek */
#define	USB_VENDOR_SUNTAC	0x05db		/* SUN Corporation */
#define	USB_VENDOR_LEXAR	0x05dc		/* Lexar Media */
#define	USB_VENDOR_ADDTRON	0x05dd		/* Addtron */
#define	USB_VENDOR_SYMBOL	0x05e0		/* Symbol Technologies */
#define	USB_VENDOR_GENESYS	0x05e3		/* Genesys Logic */
#define	USB_VENDOR_FUJI	0x05e5		/* Fuji Electric */
#define	USB_VENDOR_KEITHLEY	0x05e6		/* Keithley Instruments */
#define	USB_VENDOR_EIZONANAO	0x05e7		/* EIZO Nanao */
#define	USB_VENDOR_KLSI	0x05e9		/* Kawasaki LSI */
#define	USB_VENDOR_FFC	0x05eb		/* FFC */
#define	USB_VENDOR_ANKO	0x05ef		/* Anko Electronic */
#define	USB_VENDOR_PIENGINEERING	0x05f3		/* P.I. Engineering */
#define	USB_VENDOR_AOC	0x05f6		/* AOC International */
#define	USB_VENDOR_CHIC	0x05fe		/* Chic Technology */
#define	USB_VENDOR_BARCO	0x0600		/* Barco Display Systems */
#define	USB_VENDOR_BRIDGE	0x0607		/* Bridge Information */
#define	USB_VENDOR_SOLIDYEAR	0x060b		/* Solid Year */
#define	USB_VENDOR_BIORAD	0x0614		/* Bio-Rad Laboratories */
#define	USB_VENDOR_MACALLY	0x0618		/* Macally */
#define	USB_VENDOR_ACTLABS	0x061c		/* Act Labs */
#define	USB_VENDOR_ALARIS	0x0620		/* Alaris */
#define	USB_VENDOR_APEX	0x0624		/* Apex */
#define	USB_VENDOR_VIVITAR	0x0636		/* Vivitar */
#define	USB_VENDOR_GUNZE	0x0637		/* Gunze Electronics USA */
#define	USB_VENDOR_AVISION	0x0638		/* Avision */
#define	USB_VENDOR_TEAC	0x0644		/* TEAC */
#define	USB_VENDOR_SGI	0x065e		/* Silicon Graphics */
#define	USB_VENDOR_SANWASUPPLY	0x0663		/* Sanwa Supply */
#define	USB_VENDOR_LINKSYS	0x066b		/* Linksys */
#define	USB_VENDOR_ACERSA	0x066e		/* Acer Semiconductor America */
#define	USB_VENDOR_SIGMATEL	0x066f		/* Sigmatel */
#define	USB_VENDOR_DRAYTEK	0x0675		/* DrayTek */
#define	USB_VENDOR_AIWA	0x0677		/* Aiwa */
#define	USB_VENDOR_ACARD	0x0678		/* ACARD Technology */
#define	USB_VENDOR_PROLIFIC	0x067b		/* Prolific Technology */
#define	USB_VENDOR_SIEMENS	0x067c		/* Siemens */
#define	USB_VENDOR_AVANCELOGIC	0x0680		/* Avance Logic */
#define	USB_VENDOR_SIEMENS2	0x0681		/* Siemens */
#define	USB_VENDOR_MINOLTA	0x0686		/* Minolta */
#define	USB_VENDOR_CHPRODUCTS	0x068e		/* CH Products */
#define	USB_VENDOR_HAGIWARA	0x0693		/* Hagiwara Sys-Com */
#define	USB_VENDOR_CTX	0x0698		/* Chuntex */
#define	USB_VENDOR_ASKEY	0x069a		/* Askey Computer */
#define	USB_VENDOR_SAITEK	0x06a3		/* Saitek */
#define	USB_VENDOR_ALCATELT	0x06b9		/* Alcatel Telecom */
#define	USB_VENDOR_AGFA	0x06bd		/* AGFA-Gevaert */
#define	USB_VENDOR_ASIAMD	0x06be		/* Asia Microelectronic Development */
#define	USB_VENDOR_PHIDGETS	0x06c2		/* Phidgets */
#define	USB_VENDOR_BIZLINK	0x06c4		/* Bizlink International */
#define	USB_VENDOR_KEYSPAN	0x06cd		/* Keyspan */
#define	USB_VENDOR_LIEBERT	0x06da		/* Liebert */
#define	USB_VENDOR_AASHIMA	0x06d6		/* Aashima Technology */
#define	USB_VENDOR_MULTITECH	0x06e0		/* MultiTech */
#define	USB_VENDOR_ADS	0x06e1		/* ADS Technologies */
#define	USB_VENDOR_ALCATELM	0x06e4		/* Alcatel Microelectronics */
#define	USB_VENDOR_SIRIUS	0x06ea		/* Sirius Technologies */
#define	USB_VENDOR_GUILLEMOT	0x06f8		/* Guillemot */
#define	USB_VENDOR_BOSTON	0x06fd		/* Boston Acoustics */
#define	USB_VENDOR_SMC	0x0707		/* Standard Microsystems */
#define	USB_VENDOR_PUTERCOM	0x0708		/* Putercom */
#define	USB_VENDOR_MCT	0x0711		/* MCT */
#define	USB_VENDOR_IMATION	0x0718		/* Imation */
#define	USB_VENDOR_DOMAIN	0x071b		/* Domain Technologies, Inc. */
#define	USB_VENDOR_SUSTEEN	0x0731		/* Susteen */
#define	USB_VENDOR_EICON	0x0734		/* Eicon Networks */
#define	USB_VENDOR_STOLLMANN	0x0742		/* Stollmann */
#define	USB_VENDOR_SYNTECH	0x0745		/* Syntech Information */
#define	USB_VENDOR_DIGITALSTREAM	0x074e		/* Digital Stream */
#define	USB_VENDOR_AUREAL	0x0755		/* Aureal Semiconductor */
#define	USB_VENDOR_IDOWELL	0x075d		/* iDowell */
#define	USB_VENDOR_MIDIMAN	0x0763		/* Midiman */
#define	USB_VENDOR_CYBERPOWER	0x0764		/* CyberPower */
#define	USB_VENDOR_SURECOM	0x0769		/* Surecom Technology */
#define	USB_VENDOR_LINKSYS2	0x077b		/* Linksys */
#define	USB_VENDOR_GRIFFIN	0x077d		/* Griffin Technology */
#define	USB_VENDOR_SANDISK	0x0781		/* SanDisk */
#define	USB_VENDOR_JENOPTIK	0x0784		/* Jenoptik */
#define	USB_VENDOR_LOGITEC	0x0789		/* Logitec */
#define	USB_VENDOR_NOKIA	0x078b		/* Nokia */
#define	USB_VENDOR_BRIMAX	0x078e		/* Brimax */
#define	USB_VENDOR_AXIS	0x0792		/* Axis Communications */
#define	USB_VENDOR_ABL	0x0794		/* ABL Electronics */
#define	USB_VENDOR_SAGEM	0x079b		/* Sagem */
#define	USB_VENDOR_SUNCOMM	0x079c		/* Sun Communications */
#define	USB_VENDOR_ALFADATA	0x079d		/* Alfadata Computer */
#define	USB_VENDOR_NATIONALTECH	0x07a2		/* National Technical Systems */
#define	USB_VENDOR_ONNTO	0x07a3		/* Onnto */
#define	USB_VENDOR_BE	0x07a4		/* Be */
#define	USB_VENDOR_ADMTEK	0x07a6		/* ADMtek */
#define	USB_VENDOR_COREGA	0x07aa		/* Corega */
#define	USB_VENDOR_FREECOM	0x07ab		/* Freecom */
#define	USB_VENDOR_MICROTECH	0x07af		/* Microtech */
#define	USB_VENDOR_MOTOROLA3	0x07b2		/* Motorola */
#define	USB_VENDOR_OLYMPUS	0x07b4		/* Olympus */
#define	USB_VENDOR_ABOCOM	0x07b8		/* AboCom Systems */
#define	USB_VENDOR_KEISOKUGIKEN	0x07c1		/* Keisokugiken */
#define	USB_VENDOR_ONSPEC	0x07c4		/* OnSpec */
#define	USB_VENDOR_APG	0x07c5		/* APG Cash Drawer */
#define	USB_VENDOR_BUG	0x07c8		/* B.U.G. */
#define	USB_VENDOR_ALLIEDTELESYN	0x07c9		/* Allied Telesyn International */
#define	USB_VENDOR_AVERMEDIA	0x07ca		/* AVerMedia Technologies */
#define	USB_VENDOR_SIIG	0x07cc		/* SIIG */
#define	USB_VENDOR_CASIO	0x07cf		/* CASIO */
#define	USB_VENDOR_DLINK2	0x07d1		/* D-Link */
#define	USB_VENDOR_APTIO	0x07d2		/* Aptio Products */
#define	USB_VENDOR_ARASAN	0x07da		/* Arasan Chip Systems */
#define	USB_VENDOR_ALLIEDCABLE	0x07e6		/* Allied Cable */
#define	USB_VENDOR_STSN	0x07ef		/* STSN */
#define	USB_VENDOR_BEWAN	0x07fa		/* Bewan */
#define	USB_VENDOR_ZOOM	0x0803		/* Zoom Telephonics */
#define	USB_VENDOR_BROADLOGIC	0x0827		/* BroadLogic */
#define	USB_VENDOR_HANDSPRING	0x082d		/* Handspring */
#define	USB_VENDOR_ACTIONSTAR	0x0835		/* Action Star Enterprise */
#define	USB_VENDOR_PALM	0x0830		/* Palm Computing */
#define	USB_VENDOR_SOURCENEXT	0x0833		/* SOURCENEXT */
#define	USB_VENDOR_ACCTON	0x083a		/* Accton Technology */
#define	USB_VENDOR_DIAMOND	0x0841		/* Diamond */
#define	USB_VENDOR_NETGEAR	0x0846		/* BayNETGEAR */
#define	USB_VENDOR_TOPRE	0x0853		/* Topre Corporation */
#define	USB_VENDOR_ACTIVEWIRE	0x0854		/* ActiveWire */
#define	USB_VENDOR_BBELECTR	0x0856		/* B&B Electronics */
#define	USB_VENDOR_PORTGEAR	0x085a		/* PortGear */
#define	USB_VENDOR_NETGEAR2	0x0864		/* Netgear */
#define	USB_VENDOR_SYSTEMTALKS	0x086e		/* System Talks */
#define	USB_VENDOR_METRICOM	0x0870		/* Metricom */
#define	USB_VENDOR_ADESSOKBTEK	0x087c		/* ADESSO/Kbtek America */
#define	USB_VENDOR_JATON	0x087d		/* Jaton */
#define	USB_VENDOR_APT	0x0880		/* APT Technologies */
#define	USB_VENDOR_BOCARESEARCH	0x0885		/* Boca Research */
#define	USB_VENDOR_ANDREA	0x08a8		/* Andrea Electronics */
#define	USB_VENDOR_BURRBROWN	0x08bb		/* Burr-Brown Japan */
#define	USB_VENDOR_2WIRE	0x08c8		/* 2Wire */
#define	USB_VENDOR_AIPTEK	0x08ca		/* AIPTEK International */
#define	USB_VENDOR_SMARTBRIDGES	0x08d1		/* SmartBridges */
#define	USB_VENDOR_BILLIONTON	0x08dd		/* Billionton Systems */
#define	USB_VENDOR_GEMPLUS	0x08e6		/* GEMPLUS */
#define	USB_VENDOR_EXTENDED	0x08e9		/* Extended Systems */
#define	USB_VENDOR_MSYSTEMS	0x08ec		/* M-Systems */
#define	USB_VENDOR_DIGIANSWER	0x08fd		/* Digianswer */
#define	USB_VENDOR_AUTHENTEC	0x08ff		/* AuthenTec */
#define	USB_VENDOR_SIEMENS4	0x0908		/* Siemens */
#define	USB_VENDOR_AUDIOTECHNICA	0x0909		/* Audio-Technica */
#define	USB_VENDOR_TRUMPION	0x090a		/* Trumpion Microelectronics */
#define	USB_VENDOR_ALATION	0x0910		/* Alation Systems */
#define	USB_VENDOR_GLOBESPAN	0x0915		/* Globespan */
#define	USB_VENDOR_CONCORDCAMERA	0x0919		/* Concord Camera */
#define	USB_VENDOR_GARMIN	0x091e		/* Garmin International */
#define	USB_VENDOR_GOHUBS	0x0921		/* GoHubs */
#define	USB_VENDOR_BIOMETRIC	0x0929		/* American Biometric Company */
#define	USB_VENDOR_TOSHIBA	0x0930		/* Toshiba Corp */
#define	USB_VENDOR_INTREPIDCS	0x093c		/* Intrepid */
#define	USB_VENDOR_YANO	0x094f		/* Yano */
#define	USB_VENDOR_KINGSTON	0x0951		/* Kingston Technology */
#define	USB_VENDOR_BLUEWATER	0x0956		/* BlueWater Systems */
#define	USB_VENDOR_AGILENT	0x0957		/* Agilent Technologies */
#define	USB_VENDOR_GUDE	0x0959		/* Gude ADS */
#define	USB_VENDOR_PORTSMITH	0x095a		/* Portsmith */
#define	USB_VENDOR_ACERW	0x0967		/* Acer */
#define	USB_VENDOR_ADIRONDACK	0x0976		/* Adirondack Wire & Cable */
#define	USB_VENDOR_BECKHOFF	0x0978		/* Beckhoff */
#define	USB_VENDOR_MINDSATWORK	0x097a		/* Minds At Work */
#define	USB_VENDOR_INTERSIL	0x09aa		/* Intersil */
#define	USB_VENDOR_ALTIUS	0x09b3		/* Altius Solutions */
#define	USB_VENDOR_ARRIS	0x09c1		/* Arris Interactive */
#define	USB_VENDOR_ACTIVCARD	0x09c3		/* ACTIVCARD */
#define	USB_VENDOR_ACTISYS	0x09c4		/* ACTiSYS */
#define	USB_VENDOR_NOVATEL1	0x09d7		/* Novatel */
#define	USB_VENDOR_AFOURTECH	0x09da		/* A-FOUR TECH */
#define	USB_VENDOR_AIMEX	0x09dc		/* AIMEX */
#define	USB_VENDOR_ADDONICS	0x09df		/* Addonics Technologies */
#define	USB_VENDOR_AKAI	0x09e8		/* AKAI professional M.I. */
#define	USB_VENDOR_ARESCOM	0x09f5		/* ARESCOM */
#define	USB_VENDOR_BAY	0x09f9		/* Bay Associates */
#define	USB_VENDOR_ALTERA	0x09fb		/* Altera */
#define	USB_VENDOR_CSR	0x0a12		/* Cambridge Silicon Radio */
#define	USB_VENDOR_TREK	0x0a16		/* Trek Technology */
#define	USB_VENDOR_ASAHIOPTICAL	0x0a17		/* Asahi Optical */
#define	USB_VENDOR_BOCASYSTEMS	0x0a43		/* Boca Systems */
#define	USB_VENDOR_SHANTOU	0x0a46		/* ShanTou */
#define	USB_VENDOR_HIROSE	0x0a47		/* Hirose */
#define	USB_VENDOR_BROADCOM	0x0a5c		/* Broadcom */
#define	USB_VENDOR_GREENHOUSE	0x0a6b		/* GREENHOUSE */
#define	USB_VENDOR_GEOCAST	0x0a79		/* Geocast Network Systems */
#define	USB_VENDOR_DREAMCHEEKY	0x0a81		/* Dream Cheeky */
#define	USB_VENDOR_IDQUANTIQUE	0x0aba		/* id Quantique */
#define	USB_VENDOR_IDTECH	0x0acd		/* ID TECH */
#define	USB_VENDOR_ZYDAS	0x0ace		/* ZyDAS Technology */
#define	USB_VENDOR_CHENSOURCE	0x0ad2		/* Chen-Source */
#define	USB_VENDOR_NEODIO	0x0aec		/* Neodio */
#define	USB_VENDOR_OPTION	0x0af0		/* Option */
#define	USB_VENDOR_TODOS	0x0b0c		/* Todos Data System */
#define	USB_VENDOR_ASUS	0x0b05		/* ASUS */
#define	USB_VENDOR_OCT	0x0b39		/* Omnidirectional Control Technology */
#define	USB_VENDOR_TEKRAM	0x0b3b		/* Tekram Technology */
#define	USB_VENDOR_HAL	0x0b41		/* HAL Corporation */
#define	USB_VENDOR_NEC2	0x0b62		/* NEC */
#define	USB_VENDOR_ATI2	0x0b6f		/* ATI */
#define	USB_VENDOR_KURUSUGAWA	0x0b7e		/* Kurusugawa Electronics */
#define	USB_VENDOR_SMART	0x0b8c		/* Smart Technologies */
#define	USB_VENDOR_ASIX	0x0b95		/* ASIX Electronics */
#define	USB_VENDOR_O2MICRO	0x0b97		/* O2 Micro */
#define	USB_VENDOR_SACOM	0x0ba0		/* System SACOM Industry Co.,Ltd */
#define	USB_VENDOR_USR	0x0baf		/* U.S. Robotics */
#define	USB_VENDOR_AMBIT	0x0bb2		/* Ambit Microsystems */
#define	USB_VENDOR_HTC	0x0bb4		/* HTC */
#define	USB_VENDOR_REALTEK	0x0bda		/* Realtek */
#define	USB_VENDOR_MEI	0x0bed		/* MEI */
#define	USB_VENDOR_ADDONICS2	0x0bf6		/* Addonics Technology */
#define	USB_VENDOR_FSC	0x0bf8		/* Fujitsu Siemens Computers */
#define	USB_VENDOR_AGATE	0x0c08		/* Agate Technologies */
#define	USB_VENDOR_DMI	0x0c0b		/* DMI */
#define	USB_VENDOR_ICOM	0x0c26		/* Icom */
#define	USB_VENDOR_GNOTOMETRICS	0x0c33		/* GN Otometrics */
#define	USB_VENDOR_MICRODIA	0x0c45		/* Microdia / Sonix Technology Co., Ltd. */
#define	USB_VENDOR_SEALEVEL	0x0c52		/* Sealevel System */
#define	USB_VENDOR_JETI	0x0c6c		/* JETI */
#define	USB_VENDOR_EASYDISK	0x0c76		/* EasyDisk */
#define	USB_VENDOR_ELEKTOR	0x0c7d		/* Elektor Electronics */
#define	USB_VENDOR_KYOCERA2	0x0c88		/* Kyocera */
#define	USB_VENDOR_TERRATEC	0x0ccd		/* TerraTec Electronic GmbH */
#define	USB_VENDOR_ZCOM	0x0cde		/* Z-Com */
#define	USB_VENDOR_ATHEROS2	0x0cf3		/* Atheros Communications */
#define	USB_VENDOR_POSIFLEX	0x0d3a		/* Posiflex Technologies */
#define	USB_VENDOR_TANGTOP	0x0d3d		/* Tangtop */
#define	USB_VENDOR_KOBIL	0x0d46		/* Kobil Systems */
#define	USB_VENDOR_SMC3	0x0d5c		/* SMC */
#define	USB_VENDOR_PEN	0x0d7d		/* Pen Drive */
#define	USB_VENDOR_ABC	0x0d8c		/* ABC */
#define	USB_VENDOR_CONCEPTRONIC	0x0d8e		/* Conceptronic */
#define	USB_VENDOR_MSI	0x0db0		/* Micro Star International */
#define	USB_VENDOR_ELCON	0x0db7		/* ELCON Systemtechnik */
#define	USB_VENDOR_UNKNOWN5	0x0dcd		/* Unknown Vendor */
#define	USB_VENDOR_SITECOMEU	0x0df6		/* Sitecom Europe */
#define	USB_VENDOR_MOBILEACTION	0x0df7		/* Mobile Action */
#define	USB_VENDOR_AMIGO	0x0e0b		/* Amigo Technology */
#define	USB_VENDOR_VMWARE	0x0e0f		/* VMware */
#define	USB_VENDOR_SPEEDDRAGON	0x0e55		/* Speed Dragon Multimedia */
#define	USB_VENDOR_CTC	0x0e5e		/* CONWISE Technology */
#define	USB_VENDOR_HAWKING	0x0e66		/* Hawking */
#define	USB_VENDOR_FOSSIL	0x0e67		/* Fossil */
#define	USB_VENDOR_GMATE	0x0e7e		/* G.Mate */
#define	USB_VENDOR_MEDIATEK	0x0e8d		/* MediaTek Inc. */
#define	USB_VENDOR_OTI	0x0ea0		/* Ours Technology */
#define	USB_VENDOR_PILOTECH	0x0eaf		/* Pilotech */
#define	USB_VENDOR_NOVATECH	0x0eb0		/* Nova Tech */
#define	USB_VENDOR_EGALAX	0x0eef		/* eGalax */
#define	USB_VENDOR_ITEGNO	0x0eba		/* iTegno */
#define	USB_VENDOR_NORITAKE	0x0eda		/* Noritake itron Corp */
#define	USB_VENDOR_XIRING	0x0f14		/* XIRING */
#define	USB_VENDOR_AIRPRIME	0x0f3d		/* Airprime */
#define	USB_VENDOR_LARSENBRUSGAARD	0x0fd8		/* Larsen and Brusgaard */
#define	USB_VENDOR_OREGONSCI	0x0fde		/* Oregon Scientific */
#define	USB_VENDOR_UNKNOWN4	0x0fe6		/* Unknown Vendor */
#define	USB_VENDOR_VTECH	0x0f88		/* VTech */
#define	USB_VENDOR_FALCOM	0x0f94		/* Falcom Wireless Communications */
#define	USB_VENDOR_RIM	0x0fca		/* Research In Motion */
#define	USB_VENDOR_DYNASTREAM	0x0fcf		/* Dynastream Innovations */
#define	USB_VENDOR_DVICO	0x0fe9		/* DViCO */
#define	USB_VENDOR_QUALCOMM2	0x1004		/* Qualcomm */
#define	USB_VENDOR_MOTOROLA4	0x100d		/* Motorola */
#define	USB_VENDOR_HP3	0x103c		/* Hewlett Packard */
#define	USB_VENDOR_THURLBY	0x103e		/* Thurlby Thandar Instruments */
#define	USB_VENDOR_GIGABYTE	0x1044		/* GIGABYTE */
#define	USB_VENDOR_YUBICO	0x1050		/* Yubico.com */
#define	USB_VENDOR_MOTOROLA	0x1063		/* Motorola */
#define	USB_VENDOR_CCYU	0x1065		/* CCYU Technology */
#define	USB_VENDOR_HYUNDAI	0x106c		/* Hyundai */
#define	USB_VENDOR_GCTSEMICON	0x1076		/* GCT Semiconductor */
#define	USB_VENDOR_SILABS2	0x10a6		/* Silicon Labs */
#define	USB_VENDOR_USI	0x10ab		/* USI */
#define	USB_VENDOR_LIEBERT2	0x10af		/* Liebert */
#define	USB_VENDOR_PLX	0x10b5		/* PLX */
#define	USB_VENDOR_ASANTE	0x10bd		/* Asante */
#define	USB_VENDOR_SILABS	0x10c4		/* Silicon Labs */
#define	USB_VENDOR_SILABS3	0x10c5		/* Silicon Labs */
#define	USB_VENDOR_SILABS4	0x10ce		/* Silicon Labs */
#define	USB_VENDOR_VELLEMAN	0x10cf		/* Velleman */
#define	USB_VENDOR_MOXA	0x110a		/* Moxa Technologies */
#define	USB_VENDOR_ANALOG	0x1110		/* Analog Devices */
#define	USB_VENDOR_TENX	0x1130		/* Ten X Technology, Inc. */
#define	USB_VENDOR_ISSC	0x1131		/* Integrated System Solution Corp. */
#define	USB_VENDOR_JRC	0x1145		/* Japan Radio Company */
#define	USB_VENDOR_SPHAIRON	0x114b		/* Sphairon Access Systems */
#define	USB_VENDOR_DELORME	0x1163		/* DeLorme */
#define	USB_VENDOR_SERVERWORKS	0x1166		/* ServerWorks */
#define	USB_VENDOR_ACERCM	0x1189		/* Acer Communications & Multimedia */
#define	USB_VENDOR_SIERRA	0x1199		/* Sierra Wireless */
#define	USB_VENDOR_SIEMENS3	0x11f5		/* Siemens */
#define	USB_VENDOR_ALCATEL	0x11f7		/* Alcatel */
#define	USB_VENDOR_INTERBIO	0x1209		/* InterBiometrics */
#define	USB_VENDOR_UNKNOWN3	0x1233		/* Unknown vendor */
#define	USB_VENDOR_TSUNAMI	0x1241		/* Tsunami */
#define	USB_VENDOR_PHEENET	0x124a		/* Pheenet */
#define	USB_VENDOR_RAPTORGAMING	0x1267		/* Raptor Gaming */
#define	USB_VENDOR_TWINMOS	0x126f		/* TwinMOS */
#define	USB_VENDOR_TENDA	0x1286		/* Tenda */
#define	USB_VENDOR_TESTO	0x128d		/* Testo AG */
#define	USB_VENDOR_CREATIVE2	0x1292		/* Creative Labs */
#define	USB_VENDOR_BELKIN2	0x1293		/* Belkin Components */
#define	USB_VENDOR_CYBERTAN	0x129b		/* CyberTAN Technology */
#define	USB_VENDOR_HUAWEI	0x12d1		/* HUAWEI Technologies */
#define	USB_VENDOR_ARANEUS	0x12d8		/* Araneus Information Systems */
#define	USB_VENDOR_TAPWAVE	0x12ef		/* Tapwave */
#define	USB_VENDOR_AINCOMM	0x12fd		/* Aincomm */
#define	USB_VENDOR_MOBILITY	0x1342		/* Mobility */
#define	USB_VENDOR_DICKSMITH	0x1371		/* Dick Smith Electronics */
#define	USB_VENDOR_NETGEAR3	0x1385		/* Netgear */
#define	USB_VENDOR_VALIDITY	0x138a		/* Validity Sensors */
#define	USB_VENDOR_BALTECH	0x13ad		/* Baltech */
#define	USB_VENDOR_CISCOLINKSYS	0x13b1		/* Cisco-Linksys */
#define	USB_VENDOR_SHARK	0x13d2		/* Shark */
#define	USB_VENDOR_AZUREWAVE	0x13d3		/* AsureWave */
#define	USB_VENDOR_NOVATEL	0x1410		/* Novatel */
#define	USB_VENDOR_WISTRONNEWEB	0x1435		/* Wistron NeWeb */
#define	USB_VENDOR_RADIOSHACK	0x1453		/* Radio Shack */
#define	USB_VENDOR_OPENMOKO	0x1457		/* OpenMoko */
#define	USB_VENDOR_HUAWEI3COM	0x1472		/* Huawei 3Com */
#define	USB_VENDOR_ABOCOM2	0x1482		/* AboCom Systems */
#define	USB_VENDOR_SILICOM	0x1485		/* Silicom */
#define	USB_VENDOR_RALINK	0x148f		/* Ralink Technology */
#define	USB_VENDOR_STARTECH	0x14b0		/* StarTech.com */
#define	USB_VENDOR_CONCEPTRONIC2	0x14b2		/* Conceptronic */
#define	USB_VENDOR_SUPERTOP	0x14cd		/* SuperTop */
#define	USB_VENDOR_PLANEX3	0x14ea		/* Planex Communications */
#define	USB_VENDOR_SILICONPORTALS	0x1527		/* Silicon Portals */
#define	USB_VENDOR_UBLOX	0x1546		/* U-blox */
#define	USB_VENDOR_OWEN	0x1555		/* Owen */
#define	USB_VENDOR_OQO	0x1557		/* OQO */
#define	USB_VENDOR_UMEDIA	0x157e		/* U-MEDIA Communications */
#define	USB_VENDOR_FIBERLINE	0x1582		/* Fiberline */
#define	USB_VENDOR_SPARKLAN	0x15a9		/* SparkLAN */
#define	USB_VENDOR_OLIMEX	0x15ba		/* Olimex */
#define	USB_VENDOR_AMIT2	0x15c5		/* AMIT */
#define	USB_VENDOR_TRUST	0x15d9		/* Trust */
#define	USB_VENDOR_SOHOWARE	0x15e8		/* SOHOware */
#define	USB_VENDOR_UMAX	0x1606		/* UMAX Data Systems */
#define	USB_VENDOR_INSIDEOUT	0x1608		/* Inside Out Networks */
#define	USB_VENDOR_GOODWAY	0x1631		/* Good Way Technology */
#define	USB_VENDOR_ENTREGA	0x1645		/* Entrega */
#define	USB_VENDOR_ACTIONTEC	0x1668		/* Actiontec Electronics */
#define	USB_VENDOR_CLIPSAL	0x166a		/* Clipsal */
#define	USB_VENDOR_ATHEROS	0x168c		/* Atheros Communications */
#define	USB_VENDOR_CISCOLINKSYS2	0x167b		/* Cisco-Linksys */
#define	USB_VENDOR_GIGASET	0x1690		/* Gigaset */
#define	USB_VENDOR_GLOBALSUN	0x16ab		/* Global Sun Technology */
#define	USB_VENDOR_VOTI	0x16c0		/* Van Ooijen Technische Informatica */
#define	USB_VENDOR_ANYDATA	0x16d5		/* AnyDATA Inc. */
#define	USB_VENDOR_JABLOTRON	0x16d6		/* Jablotron */
#define	USB_VENDOR_CMOTECH	0x16d8		/* CMOTECH */
#define	USB_VENDOR_WIENERPLEINBAUS	0x16dc		/* WIENER Plein & Baus */
#define	USB_VENDOR_AXESSTEL	0x1726		/* Axesstel */
#define	USB_VENDOR_LINKSYS4	0x1737		/* Linksys */
#define	USB_VENDOR_SENAO	0x1740		/* Senao */
#define	USB_VENDOR_ASUS2	0x1761		/* ASUS */
#define	USB_VENDOR_STRAWBERRYLINUX	0x1774		/* Strawberry linux Co., Ltd. */
#define	USB_VENDOR_SWEEX2	0x177f		/* Sweex */
#define	USB_VENDOR_MECANIQUE	0x1781		/* Mecanique */
#define	USB_VENDOR_KAMSTRUP	0x17a8		/* Kamstrup A/S */
#define	USB_VENDOR_DISPLAYLINK	0x17e9		/* DisplayLink */
#define	USB_VENDOR_LENOVO	0x17ef		/* Lenovo */
#define	USB_VENDOR_WAVESENSE	0x17f4		/* WaveSense */
#define	USB_VENDOR_VAISALA	0x1843		/* VAISALA */
#define	USB_VENDOR_AMIT	0x18c5		/* AMIT */
#define	USB_VENDOR_QCOM	0x18e8		/* Qcom */
#define	USB_VENDOR_ELV	0x18ef		/* ELV */
#define	USB_VENDOR_LINKSYS3	0x1915		/* Linksys */
#define	USB_VENDOR_AVAGO	0x192f		/* Avago */
#define	USB_VENDOR_MEINBERG	0x1938		/* Meinberg Funkuhren */
#define	USB_VENDOR_ZTE	0x19d2		/* ZTE Inc. */
#define	USB_VENDOR_QUANTA	0x1a32		/* Quanta */
#define	USB_VENDOR_TERMINUS	0x1a40		/* Terminus Technology */
#define	USB_VENDOR_ABBOTT	0x1a61		/* Abbott Labs */
#define	USB_VENDOR_BAYER	0x1a79		/* Bayer Health Care */
#define	USB_VENDOR_WCH2	0x1a86		/* QinHeng Electronics */
#define	USB_VENDOR_SEL	0x1adb		/* Schweitzer Engineering Laboratories */
#define	USB_VENDOR_SILABS5	0x1ba4		/* Silicon Labs */
#define	USB_VENDOR_CORSAIR	0x1b1c		/* Corsair */
#define	USB_VENDOR_MATRIXORB	0x1b3d		/* Matrix Orbital */
#define	USB_VENDOR_TORADEX	0x1b67		/* Toradex inc. */
#define	USB_VENDOR_FUSHICAI	0x1b71		/* Fushicai */
#define	USB_VENDOR_OVISLINK	0x1b75		/* OvisLink */
#define	USB_VENDOR_TML	0x1b91		/* The Mobility Lab */
#define	USB_VENDOR_TCTMOBILE	0x1bbb		/* TCT Mobile */
#define	USB_VENDOR_MDS	0x1bc8		/* MDS */
#define	USB_VENDOR_ALTI2	0x1bc9		/* Alti-2 */
#define	USB_VENDOR_SUNPLUS	0x1bcf		/* Sunplus */
#define	USB_VENDOR_WAGO	0x1be3		/* WAGO Kontakttechnik */
#define	USB_VENDOR_LONGCHEER	0x1c9e		/* Longcheer Technology */
#define	USB_VENDOR_DRESDENELEC	0x1cf1		/* Dresden Elektronic */
#define	USB_VENDOR_DREAMLINK	0x1d34		/* Dream Link */
#define	USB_VENDOR_PEGATRON	0x1d4d		/* Pegatron */
#define	USB_VENDOR_OPENMOKO2	0x1d50		/* OpenMoko */
#define	USB_VENDOR_SELUXIT	0x1d6f		/* Seluxit */
#define	USB_VENDOR_METAGEEK	0x1dd5		/* MetaGeek */
#define	USB_VENDOR_FESTO	0x1e29		/* Festo */
#define	USB_VENDOR_MODACOM	0x1eb8		/* Modacom */
#define	USB_VENDOR_AIRTIES	0x1eda		/* AirTies */
#define	USB_VENDOR_VERTEX	0x1fe7		/* Vertex Wireless Co., Ltd. */
#define	USB_VENDOR_LAKESHORE	0x1fb9		/* Lake Shore */
#define	USB_VENDOR_DLINK	0x2001		/* D-Link */
#define	USB_VENDOR_PLANEX2	0x2019		/* Planex Communications */
#define	USB_VENDOR_ENCORE	0x203d		/* Encore */
#define	USB_VENDOR_PARA	0x20b8		/* PARA Industrial */
#define	USB_VENDOR_TRENDNET	0x20f4		/* TRENDnet */
#define	USB_VENDOR_RTSYSTEMS	0x2100		/* RT Systems */
#define	USB_VENDOR_DLINK3	0x2101		/* D-Link */
#define	USB_VENDOR_VIALABS	0x2109		/* VIA Labs */
#define	USB_VENDOR_MOTOROLA2	0x22b8		/* Motorola */
#define	USB_VENDOR_ARDUINO	0x2341		/* Arduino SA */
#define	USB_VENDOR_TPLINK	0x2357		/* TP-Link */
#define	USB_VENDOR_WMR	0x2405		/* West Mountain Radio */
#define	USB_VENDOR_TRIPPLITE	0x2478		/* Tripp-Lite */
#define	USB_VENDOR_ARUBA	0x2626		/* Aruba */
#define	USB_VENDOR_NHJ	0x2770		/* NHJ */
#define	USB_VENDOR_ASUSTEK	0x2821		/* ASUSTeK Computer */
#define	USB_VENDOR_PLANEX	0x2c02		/* Planex Communications */
#define	USB_VENDOR_LINKINSTRUMENTS	0x3195		/* Link Instruments */
#define	USB_VENDOR_AEI	0x3334		/* AEI */
#define	USB_VENDOR_PQI	0x3538		/* PQI */
#define	USB_VENDOR_DAISY	0x3579		/* Daisy Technology */
#define	USB_VENDOR_NI	0x3923		/* National Instruments */
#define	USB_VENDOR_MICRONET	0x3980		/* Micronet Communications */
#define	USB_VENDOR_IODATA2	0x40bb		/* I-O Data */
#define	USB_VENDOR_IRIVER	0x4102		/* iRiver */
#define	USB_VENDOR_DELL	0x413c		/* Dell */
#define	USB_VENDOR_WCH	0x4348		/* QinHeng Electronics */
#define	USB_VENDOR_ACEECA	0x4766		/* Aceeca */
#define	USB_VENDOR_FEIXUN	0x4855		/* FeiXun Communication */
#define	USB_VENDOR_NETWEEN	0x4856		/* NetweeN */
#define	USB_VENDOR_PAPOUCH	0x5050		/* Papouch s.r.o. */
#define	USB_VENDOR_AVERATEC	0x50c2		/* Averatec */
#define	USB_VENDOR_SWEEX	0x5173		/* Sweex */
#define	USB_VENDOR_PROLIFIC2	0x5372		/* Prolific Technology */
#define	USB_VENDOR_ONSPEC2	0x55aa		/* OnSpec */
#define	USB_VENDOR_ACERLABS2	0x5986		/* Acer */
#define	USB_VENDOR_ZINWELL	0x5a57		/* Zinwell */
#define	USB_VENDOR_SITECOM	0x6189		/* Sitecom */
#define	USB_VENDOR_ARKMICRO	0x6547		/* Arkmicro */
#define	USB_VENDOR_3COM2	0x6891		/* 3Com */
#define	USB_VENDOR_EDIMAX	0x7392		/* EDIMAX */
#define	USB_VENDOR_INTEL	0x8086		/* Intel */
#define	USB_VENDOR_INTEL2	0x8087		/* Intel */
#define	USB_VENDOR_ALLWIN	0x8516		/* ALLWIN Tech */
#define	USB_VENDOR_SITECOM2	0x9016		/* Sitecom */
#define	USB_VENDOR_MOSCHIP	0x9710		/* MosChip */
#define	USB_VENDOR_NETGEAR4	0x9846		/* Netgear */
#define	USB_VENDOR_MARVELL	0x9e88		/* Marvell */
#define	USB_VENDOR_3COM3	0xa727		/* 3Com */
#define	USB_VENDOR_CACE	0xcace		/* CACE Technologies */
#define	USB_VENDOR_COMPARE	0xcdab		/* Compare */
#define	USB_VENDOR_DATAAPEX	0xdaae		/* DataApex */
#define	USB_VENDOR_EVOLUTION	0xdeee		/* Evolution Robotics */
#define	USB_VENDOR_EMPIA	0xeb1a		/* eMPIA Technology */
#define	USB_VENDOR_HP2	0xf003		/* Hewlett Packard */

/*
 * List of known products.  Grouped by vendor.
 */

/* 3Com products */
#define	USB_PRODUCT_3COM_HOMECONN	0x009d		/* HomeConnect */
#define	USB_PRODUCT_3COM_3CREB96	0x00a0		/* Bluetooth */
#define	USB_PRODUCT_3COM_3C19250	0x03e8		/* 3C19250 Ethernet */
#define	USB_PRODUCT_3COM_3CRSHEW696	0x0a01		/* 3CRSHEW696 */
#define	USB_PRODUCT_3COM_3C460	0x11f8		/* HomeConnect 3C460 */
#define	USB_PRODUCT_3COM_USR56K	0x3021		/* U.S.Robotics 56000 */
#define	USB_PRODUCT_3COM_3C460B	0x4601		/* HomeConnect 3C460B */

/* 3Com(2) products */
#define	USB_PRODUCT_3COM2_3CRUSB10075	0xa727		/* 3CRUSB10075 */

/* 3Com(3) products */
#define	USB_PRODUCT_3COM3_AR5523_1	0x6893		/* AR5523 */
#define	USB_PRODUCT_3COM3_AR5523_2	0x6895		/* AR5523 */
#define	USB_PRODUCT_3COM3_AR5523_3	0x6897		/* AR5523 */

#define	USB_PRODUCT_3COMUSR_OFFICECONN	0x0082		/* 3Com OfficeConnect Analog Modem */
#define	USB_PRODUCT_3COMUSR_USRISDN	0x008f		/* 3Com U.S. Robotics Pro ISDN TA */
#define	USB_PRODUCT_3COMUSR_HOMECONN	0x009d		/* 3Com HomeConnect */
#define	USB_PRODUCT_3COMUSR_USR56K	0x3021		/* U.S.Robotics 56000 */

#define	USB_PRODUCT_HUAWEI3COM_WUB320G	0x0009		/* Aolynk WUB320g */

/* Abbott products */
#define	USB_PRODUCT_ABBOTT_STEREO_PLUG	0x3410		/* Stereo Plug Cable */

/* AboCom products */
#define	USB_PRODUCT_ABOCOM_XX1	0x110c		/* XX1 */
#define	USB_PRODUCT_ABOCOM_XX2	0x200c		/* XX2 */
#define	USB_PRODUCT_ABOCOM_RT2770	0x2770		/* RT2770 */
#define	USB_PRODUCT_ABOCOM_RT2870	0x2870		/* RT2870 */
#define	USB_PRODUCT_ABOCOM_RT3070	0x3070		/* RT3070 */
#define	USB_PRODUCT_ABOCOM_RT3071	0x3071		/* RT3071 */
#define	USB_PRODUCT_ABOCOM_RT3072	0x3072		/* RT3072 */
#define	USB_PRODUCT_ABOCOM2_RT2870_1	0x3c09		/* RT2870 */
#define	USB_PRODUCT_ABOCOM_URE450	0x4000		/* URE450 Ethernet */
#define	USB_PRODUCT_ABOCOM_UFE1000	0x4002		/* UFE1000 Fast Ethernet */
#define	USB_PRODUCT_ABOCOM_DSB650TX_PNA	0x4003		/* 1/10/100 Ethernet */
#define	USB_PRODUCT_ABOCOM_XX4	0x4004		/* XX4 */
#define	USB_PRODUCT_ABOCOM_XX5	0x4007		/* XX5 */
#define	USB_PRODUCT_ABOCOM_XX6	0x400b		/* XX6 */
#define	USB_PRODUCT_ABOCOM_RTL8151	0x401a		/* RTL8151 */
#define	USB_PRODUCT_ABOCOM_XX7	0x400c		/* XX7 */
#define	USB_PRODUCT_ABOCOM_XX8	0x4102		/* XX8 */
#define	USB_PRODUCT_ABOCOM_XX9	0x4104		/* XX9 */
#define	USB_PRODUCT_ABOCOM_WL54	0x6001		/* WL54 */
#define	USB_PRODUCT_ABOCOM_RTL8192CU	0x8178		/* RTL8192CU */
#define	USB_PRODUCT_ABOCOM_RTL8188CU_1	0x8188		/* RTL8188CU */
#define	USB_PRODUCT_ABOCOM_RTL8188CU_2	0x8189		/* RTL8188CU */
#define	USB_PRODUCT_ABOCOM_XX10	0xabc1		/* XX10 */
#define	USB_PRODUCT_ABOCOM_BWU613	0xb000		/* BWU613 */
#define	USB_PRODUCT_ABOCOM_HWU54DM	0xb21b		/* HWU54DM */
#define	USB_PRODUCT_ABOCOM_RT2573_2	0xb21c		/* RT2573 */
#define	USB_PRODUCT_ABOCOM_RT2573_3	0xb21d		/* RT2573 */
#define	USB_PRODUCT_ABOCOM_RT2573_4	0xb21e		/* RT2573 */
#define	USB_PRODUCT_ABOCOM_WUG2700	0xb21f		/* WUG2700 */

/* Accton products */
#define	USB_PRODUCT_ACCTON_USB320_EC	0x1046		/* USB320-EC Ethernet */
#define	USB_PRODUCT_ACCTON_2664W	0x3501		/* 2664W */
#define	USB_PRODUCT_ACCTON_111	0x3503		/* T-Sinus 111 WLAN */
#define	USB_PRODUCT_ACCTON_SMCWUSBG	0x4505		/* SMCWUSB-G */
#define	USB_PRODUCT_ACCTON_SMCWUSBTG2	0x4506		/* SMCWUSBT-G2 */
#define	USB_PRODUCT_ACCTON_SMCWUSBTG2_NF	0x4507		/* SMCWUSBT-G2 */
#define	USB_PRODUCT_ACCTON_PRISM_GT	0x4521		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_ACCTON_SS1001	0x5046		/* SpeedStream Ethernet */
#define	USB_PRODUCT_ACCTON_RT2870_2	0x6618		/* RT2870 */
#define	USB_PRODUCT_ACCTON_RT3070	0x7511		/* RT3070 */
#define	USB_PRODUCT_ACCTON_RT2770	0x7512		/* RT2770 */
#define	USB_PRODUCT_ACCTON_RT2870_3	0x7522		/* RT2870 */
#define	USB_PRODUCT_ACCTON_RT2870_5	0x8522		/* RT2870 */
#define	USB_PRODUCT_ACCTON_RT3070_4	0xa512		/* RT3070 */
#define	USB_PRODUCT_ACCTON_RT2870_4	0xa618		/* RT2870 */
#define	USB_PRODUCT_ACCTON_RT3070_1	0xa701		/* RT3070 */
#define	USB_PRODUCT_ACCTON_RT3070_2	0xa702		/* RT3070 */
#define	USB_PRODUCT_ACCTON_RT3070_6	0xa703		/* RT3070 */
#define	USB_PRODUCT_ACCTON_AR9280	0xa704		/* AR9280+AR7010 */
#define	USB_PRODUCT_ACCTON_RT2870_1	0xb522		/* RT2870 */
#define	USB_PRODUCT_ACCTON_RTL8192SU	0xc512		/* RTL8192SU */
#define	USB_PRODUCT_ACCTON_RT3070_3	0xc522		/* RT3070 */
#define	USB_PRODUCT_ACCTON_RT3070_5	0xd522		/* RT3070 */
#define	USB_PRODUCT_ACCTON_ZD1211B	0xe501		/* ZD1211B */
#define	USB_PRODUCT_ACCTON_WN4501H_LF_IR	0xe503		/* WN4501H-LF-IR */
#define	USB_PRODUCT_ACCTON_WUS201	0xe506		/* WUS-201 */
#define	USB_PRODUCT_ACCTON_WN7512	0xf522		/* WN7512 */

/* Aceeca products */
#define	USB_PRODUCT_ACEECA_MEZ1000	0x0001		/* MEZ1000 RDA */

/* Acer Labs products */
#define	USB_PRODUCT_ACERLABS_M5632	0x5632		/* USB 2.0 Data Link */

/* Acer Products */
#define	USB_PRODUCT_ACERW_WARPLINK	0x0204		/* Warplink */

/* Acer Peripherals, Inc. products */
#define	USB_PRODUCT_ACERP_ACERSCAN_C310U	0x12a6		/* Acerscan C310U */
#define	USB_PRODUCT_ACERP_ACERSCAN_320U	0x2022		/* Acerscan 320U */
#define	USB_PRODUCT_ACERP_ACERSCAN_640U	0x2040		/* Acerscan 640U */
#define	USB_PRODUCT_ACERP_ACERSCAN_620U	0x2060		/* Acerscan 620U */
#define	USB_PRODUCT_ACERP_ATAPI	0x6003		/* ATA/ATAPI */
#define	USB_PRODUCT_ACERP_AWL300	0x9000		/* AWL300 */
#define	USB_PRODUCT_ACERP_AWL400	0x9001		/* AWL400 */

/* Actiontec products */
#define	USB_PRODUCT_ACTIONTEC_PRISM_25	0x0408		/* Prism2.5 WLAN */
#define	USB_PRODUCT_ACTIONTEC_PRISM_25A	0x0421		/* Prism2.5 WLAN A */
#define	USB_PRODUCT_ACTIONTEC_AR9287	0x1200		/* AR9287+AR7010 */
#define	USB_PRODUCT_ACTIONTEC_FREELAN	0x6106		/* ROPEX FreeLan 802.11b */
#define	USB_PRODUCT_ACTIONTEC_802UAT1	0x7605		/* 802UAT1 */

/* ACTiSYS products */
#define	USB_PRODUCT_ACTISYS_IR2000U	0x0011		/* ACT-IR2000U FIR */

/* Topre Corporation products */
#define	USB_PRODUCT_TOPRE_HHKB	0x0100		/* HHKB Professional */

/* ActiveWire, Inc. products */
#define	USB_PRODUCT_ACTIVEWIRE_IOBOARD	0x0100		/* I/O Board */
#define	USB_PRODUCT_ACTIVEWIRE_IOBOARD_FW1	0x0101		/* I/O Board, rev. 1 */

/* Adaptec products */
#define	USB_PRODUCT_ADAPTEC_AWN8020	0x0020		/* AWN-8020 WLAN */

/* Addonics products */
#define	USB_PRODUCT_ADDONICS2_205	0xa001		/* Cable 205 */

/* Addtron products */
#define	USB_PRODUCT_ADDTRON_AWU120	0xff31		/* AWU-120 */

/* ADMtek products */
#define	USB_PRODUCT_ADMTEK_PEGASUSII_4	0x07c2		/* AN986A Ethernet */
#define	USB_PRODUCT_ADMTEK_PEGASUS	0x0986		/* AN986 Ethernet */
#define	USB_PRODUCT_ADMTEK_PEGASUSII	0x8511		/* AN8511 Ethernet */
#define	USB_PRODUCT_ADMTEK_PEGASUSII_2	0x8513		/* AN8513 Ethernet */
#define	USB_PRODUCT_ADMTEK_PEGASUSII_3	0x8515		/* AN8515 Ethernet */

/* ADS products */
#define	USB_PRODUCT_ADS_UBS10BT	0x0008		/* UBS-10BT Ethernet */
#define	USB_PRODUCT_ADS_UBS10BTX	0x0009		/* UBS-10BT Ethernet */

/* AEI products */
#define	USB_PRODUCT_AEI_FASTETHERNET	0x1701		/* Fast Ethernet */

/* Agate Technologies products */
#define	USB_PRODUCT_AGATE_QDRIVE	0x0378		/* Q-Drive */

/* AGFA products */
#define	USB_PRODUCT_AGFA_SNAPSCAN1212U	0x0001		/* SnapScan 1212U */
#define	USB_PRODUCT_AGFA_SNAPSCAN1236U	0x0002		/* SnapScan 1236U */
#define	USB_PRODUCT_AGFA_SNAPSCANTOUCH	0x0100		/* SnapScan Touch */
#define	USB_PRODUCT_AGFA_SNAPSCAN1212U2	0x2061		/* SnapScan 1212U */
#define	USB_PRODUCT_AGFA_SNAPSCANE40	0x208d		/* SnapScan e40 */
#define	USB_PRODUCT_AGFA_SNAPSCANE50	0x208f		/* SnapScan e50 */
#define	USB_PRODUCT_AGFA_SNAPSCANE20	0x2091		/* SnapScan e20 */
#define	USB_PRODUCT_AGFA_SNAPSCANE25	0x2095		/* SnapScan e25 */
#define	USB_PRODUCT_AGFA_SNAPSCANE26	0x2097		/* SnapScan e26 */
#define	USB_PRODUCT_AGFA_SNAPSCANE52	0x20fd		/* SnapScan e52 */

/* Airprime, Inc. products */
#define	USB_PRODUCT_AIRPRIME_PC5220	0x0112		/* CDMA Wireless EVDO card */
#define	USB_PRODUCT_AIRPRIME_AIRCARD_313U	0x68aa		/* Aircard 313U */
  
/* Aincomm products */
#define	USB_PRODUCT_AINCOMM_AWU2000B	0x1001		/* AWU2000B */

/* AirTies products */
#define	USB_PRODUCT_AIRTIES_RT3070_2	0x2012		/* RT3070 */
#define	USB_PRODUCT_AIRTIES_RT3070	0x2310		/* RT3070 */

/* AirVast Technology products */
#define	USB_PRODUCT_PHEENET_WM168B	0x168b		/* WM-168b */

/* AKS products */
#define	USB_PRODUCT_AKS_USBHASP	0x0001		/* USB-HASP 0.06 */

/* Alcatel products */
#define	USB_PRODUCT_ALCATEL_OT535	0x02df		/* One Touch 535/735 */

/* Alcatel Telecom products */
#define	USB_PRODUCT_ALCATELT_ST120G	0x0120		/* SpeedTouch 120g */
#define	USB_PRODUCT_ALCATELT_ST121G	0x0121		/* SpeedTouch 121g */

/* Alcor Micro, Inc. products */
#define	USB_PRODUCT_ALCOR_MA_KBD_HUB	0x9213		/* MacAlly Kbd Hub */
#define	USB_PRODUCT_ALCOR_AU9814	0x9215		/* AU9814 Hub */
#define	USB_PRODUCT_ALCOR_SM_KBD	0x9410		/* MicroConnectors/StrongMan */
#define	USB_PRODUCT_ALCOR_NEC_KBD_HUB	0x9472		/* NEC Kbd Hub */

/* Alcor Micro, Inc.(2) products */
#define	USB_PRODUCT_ALCOR2_KBD_HUB	0x2802		/* Kbd Hub */

/* Allied Telesyn International products */
#define	USB_PRODUCT_ALLIEDTELESYN_ATUSB100	0xb100		/* AT-USB100 */

/* ALLWIN Tech products */
#define	USB_PRODUCT_ALLWIN_RT2070	0x2070		/* RT2070 */
#define	USB_PRODUCT_ALLWIN_RT2770	0x2770		/* RT2770 */
#define	USB_PRODUCT_ALLWIN_RT2870	0x2870		/* RT2870 */
#define	USB_PRODUCT_ALLWIN_RT3070	0x3070		/* RT3070 */
#define	USB_PRODUCT_ALLWIN_RT3071	0x3071		/* RT3071 */
#define	USB_PRODUCT_ALLWIN_RT3072	0x3072		/* RT3072 */
#define	USB_PRODUCT_ALLWIN_RT3572	0x3572		/* RT3572 */

/* Altec Lansing products */
#define	USB_PRODUCT_ALTEC_ADA70	0x0070		/* ADA70 Speakers */
#define	USB_PRODUCT_ALTEC_ASC495	0xff05		/* ASC495 Speakers */

/* Alti-2 products */
#define	USB_PRODUCT_ALTI2_NEPTUNE3	0x6001		/* Neptune 3 */

/* Ambit Microsystems products */
#define	USB_PRODUCT_AMBIT_WLAN	0x0302		/* WLAN */
#define	USB_PRODUCT_AMBIT_NTL_250	0x6098		/* NTL 250 cable modem */

/* American Power Conversion products */
#define	USB_PRODUCT_APC_UPS	0x0002		/* UPS */
#define	USB_PRODUCT_APC_UPS5G	0x0003		/* 5G UPS */

/* Amigo Technology products */
#define	USB_PRODUCT_AMIGO_RT2870_1	0x9031		/* RT2870 */
#define	USB_PRODUCT_AMIGO_RT2870_2	0x9041		/* RT2870 */

/* AMIT products */
#define	USB_PRODUCT_AMIT_CGWLUSB2GO	0x0002		/* CG-WLUSB2GO */
#define	USB_PRODUCT_AMIT_CGWLUSB2GNR	0x0008		/* CG-WLUSB2GNR */
#define	USB_PRODUCT_AMIT_RT2870_1	0x0012		/* RT2870 */

/* AMIT(2) products */
#define	USB_PRODUCT_AMIT2_RT2870	0x0008		/* RT2870 */

/* Analog Devices, Inc. products */
#define	USB_PRODUCT_ANALOG_EAGLEI	0x900f		/* Eagle I */
#define	USB_PRODUCT_ANALOG_EAGLEI_NF	0x9010		/* Eagle I */
#define	USB_PRODUCT_ANALOG_EAGLEII	0x9021		/* Eagle II */
#define	USB_PRODUCT_ANALOG_EAGLEII_NF	0x9022		/* Eagle II */
#define	USB_PRODUCT_ANALOG_EAGLEIIC	0x9023		/* Eagle IIC */
#define	USB_PRODUCT_ANALOG_EAGLEIIC_NF	0x9024		/* Eagle IIC */
#define	USB_PRODUCT_ANALOG_EAGLEIII	0x9031		/* Eagle III */
#define	USB_PRODUCT_ANALOG_EAGLEIII_NF	0x9032		/* Eagle III */
#define	USB_PRODUCT_ANALOGDEVICES_GNICE	0xf000		/* gnICE */
#define	USB_PRODUCT_ANALOGDEVICES_GNICEPLUS	0xf001		/* gnICE+ */

/* Anchor products */
#define	USB_PRODUCT_ANCHOR_SERIAL	0x2008		/* Serial */
#define	USB_PRODUCT_ANCHOR_EZUSB	0x2131		/* EZUSB */
#define	USB_PRODUCT_ANCHOR_EZLINK	0x2720		/* EZLINK */

/* Anydata products */
#define	USB_PRODUCT_ANYDATA_A2502	0x6202		/* NTT DoCoMo A2502 */
#define	USB_PRODUCT_ANYDATA_ADU_E100H	0x6501		/* ADU-E100H */
#define	USB_PRODUCT_ANYDATA_ADU_500A	0x6502		/* ADU-500A */

/* AOX, Inc. products */
#define	USB_PRODUCT_AOX_USB101	0x0008		/* Ethernet */

/* Apple Computer products */
#define	USB_PRODUCT_APPLE_FOUNTAIN_ANSI	0x020e		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_FOUNTAIN_ISO	0x020f		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_GEYSER_ANSI	0x0214		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_GEYSER_ISO	0x0215		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING_ANSI	0x0223		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING_ISO	0x0224		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING_JIS	0x0225		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING2_ANSI	0x0230		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING2_ISO	0x0231		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING2_JIS	0x0232		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING3_ANSI	0x0236		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING3_ISO	0x0237		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING3_JIS	0x0238		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4_ANSI	0x023f		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4_ISO	0x0240		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4_JIS	0x0241		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4A_ANSI	0x0242		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4A_ISO	0x0243		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING4A_JIS	0x0244		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5_ANSI	0x0245		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5_ISO	0x0246		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5_JIS	0x0247		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6A_ANSI	0x0249		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6A_ISO	0x024a		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6A_JIS	0x024b		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6_ANSI	0x024c		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6_ISO	0x024d		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING6_JIS	0x024e		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5A_ANSI	0x0252		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5A_ISO	0x0253		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING5A_JIS	0x0254		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7_ANSI	0x0262		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7_ISO	0x0263		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7_JIS	0x0264		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7A_ANSI	0x0259		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7A_ISO	0x025a		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING7A_JIS	0x025b		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING8_ANSI	0x0290		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING8_ISO	0x0291		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING8_JIS	0x0292		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING9_ANSI	0x0272		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING9_ISO	0x0273		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_WELLSPRING9_JIS	0x0274		/* Keyboard/Trackpad */
#define	USB_PRODUCT_APPLE_OPTMOUSE	0x0302		/* Optical mouse */
#define	USB_PRODUCT_APPLE_BLUETOOTH_HCI	0x1000		/* HID-proxy */
#define	USB_PRODUCT_APPLE_SPEAKERS	0x1101		/* Speakers */
#define	USB_PRODUCT_APPLE_IPHONE	0x1290		/* iPhone */
#define	USB_PRODUCT_APPLE_IPOD_TOUCH	0x1291		/* iPod Touch */
#define	USB_PRODUCT_APPLE_IPHONE_3G	0x1292		/* iPhone 3G */
#define	USB_PRODUCT_APPLE_IPOD_TOUCH_2G	0x1293		/* iPod Touch 2G */
#define	USB_PRODUCT_APPLE_IPHONE_3GS	0x1294		/* iPhone 3GS */
#define	USB_PRODUCT_APPLE_IPHONE_4_GSM	0x1297		/* iPhone 4 GSM */
#define	USB_PRODUCT_APPLE_IPOD_TOUCH_3G	0x1299		/* iPod Touch 3G */
#define	USB_PRODUCT_APPLE_IPAD	0x129a		/* iPad */
#define	USB_PRODUCT_APPLE_IPHONE_4_CDMA	0x129c		/* iPhone 4 CDMA */
#define	USB_PRODUCT_APPLE_IPOD_TOUCH_4G	0x129e		/* iPod Touch 4G */
#define	USB_PRODUCT_APPLE_IPAD2	0x129f		/* iPad 2 */
#define	USB_PRODUCT_APPLE_IPHONE_4S	0x12a0		/* iPhone 4S */
#define	USB_PRODUCT_APPLE_IPHONE_6	0x12a8		/* iPhone 6 */
#define	USB_PRODUCT_APPLE_ETHERNET	0x1402		/* Ethernet A1277 */
#define	USB_PRODUCT_APPLE_BLUETOOTH2	0x8205		/* Bluetooth */
#define	USB_PRODUCT_APPLE_BLUETOOTH	0x8300		/* Bluetooth */
#define	USB_PRODUCT_APPLE_ISIGHT_1	0x8501		/* iSight */
#define	USB_PRODUCT_APPLE_ISIGHT	0x8502		/* iSight */

/* Araneus Information Systems products */
#define	USB_PRODUCT_ARANEUS_ALEA	0x0001		/* True Random Number Generator */

/* Arduino SA product */
#define	USB_PRODUCT_ARDUINO_LEONARDO	0x8036		/* Leonardo */

/* Arkmicro products */
#define	USB_PRODUCT_ARKMICRO_ARK3116	0x0232		/* ARK3116 Serial */

/* Aruba products */
#define	USB_PRODUCT_ARUBA_CP210X	0xea60		/* CP210x Serial */

/* Asahi Optical products */
#define	USB_PRODUCT_ASAHIOPTICAL_OPTIO230	0x0004		/* PENTAX Optio230 */

/* Asante products */
#define	USB_PRODUCT_ASANTE_EA	0x1427		/* Ethernet */

/* Askey Computer products */
#define	USB_PRODUCT_ASKEY_WLL013I	0x0320		/* WLL013 (Intersil) */
#define	USB_PRODUCT_ASKEY_WLL013	0x0321		/* WLL013 */
#define	USB_PRODUCT_ASKEY_VOYAGER1010	0x0821		/* Voyager 1010 */

/* ASIX Electronics products */
#define	USB_PRODUCT_ASIX_AX88172	0x1720		/* USB 2.0 10/100 Ethernet controller */
#define	USB_PRODUCT_ASIX_AX88178	0x1780		/* AX88178 */
#define	USB_PRODUCT_ASIX_AX88179	0x1790		/* AX88179 */
#define	USB_PRODUCT_ASIX_AX88772	0x7720		/* AX88772 */
#define	USB_PRODUCT_ASIX_AX88772A	0x772a		/* AX88772A */
#define	USB_PRODUCT_ASIX_AX88772B	0x772b		/* AX88772B */
#define	USB_PRODUCT_ASIX_AX88772B_1	0x7e2b		/* AX88772B */

/* ASUS products */
#define	USB_PRODUCT_ASUS2_USBN11	0x0b05		/* USB-N11 */
#define	USB_PRODUCT_ASUS_RT2570	0x1706		/* RT2570 */
#define	USB_PRODUCT_ASUS_RT2570_2	0x1707		/* RT2570 */
#define	USB_PRODUCT_ASUS_RT2573_1	0x1723		/* RT2573 */
#define	USB_PRODUCT_ASUS_RT2573_2	0x1724		/* RT2573 */
#define	USB_PRODUCT_ASUS_WL159G	0x170c		/* WL-159g */
#define	USB_PRODUCT_ASUS_A9T_WIFI	0x171b		/* A9T wireless */
#define	USB_PRODUCT_ASUS_P5B_WIFI	0x171d		/* P5B wireless */
#define	USB_PRODUCT_ASUS_RT2870_1	0x1731		/* RT2870 */
#define	USB_PRODUCT_ASUS_RT2870_2	0x1732		/* RT2870 */
#define	USB_PRODUCT_ASUS_RT2870_3	0x1742		/* RT2870 */
#define	USB_PRODUCT_ASUS_RT2870_4	0x1760		/* RT2870 */
#define	USB_PRODUCT_ASUS_RT2870_5	0x1761		/* RT2870 */
#define	USB_PRODUCT_ASUS_USBN13	0x1784		/* USB-N13 */
#define	USB_PRODUCT_ASUS_USBN10	0x1786		/* USB-N10 */
#define	USB_PRODUCT_ASUS_RT3070_1	0x1790		/* RT3070 */
#define	USB_PRODUCT_ASUS_RTL8192SU_1	0x1791		/* RTL8192SU */
#define	USB_PRODUCT_ASUS_USBN53	0x179d		/* USB-N53 */
#define	USB_PRODUCT_ASUS_RTL8192CU	0x17ab		/* RTL8192CU */
#define	USB_PRODUCT_ASUS_USBN66	0x17ad		/* USB-N66 */
#define	USB_PRODUCT_ASUS_RTL8192CU_2	0x17ba		/* RTL8192CU */
#define	USB_PRODUCT_ASUS_RTL8192CU_3	0x17c0		/* RTL8192CU */
#define	USB_PRODUCT_ASUS_MYPAL_A730	0x4202		/* MyPal A730 */

/* ASUSTeK Computer products */
#define	USB_PRODUCT_ASUSTEK_WL140	0x3300		/* WL-140 */

/* ATen products */
#define	USB_PRODUCT_ATEN_UC1284	0x2001		/* Parallel */
#define	USB_PRODUCT_ATEN_UC10T	0x2002		/* 10Mbps Ethernet */
#define	USB_PRODUCT_ATEN_UC110T	0x2007		/* UC-110T Ethernet */
#define	USB_PRODUCT_ATEN_UC232A	0x2008		/* UC232A Serial */
#define	USB_PRODUCT_ATEN_UC210T	0x2009		/* UC210T Ethernet */
#define	USB_PRODUCT_ATEN_UC2324	0x2011		/* UC2324 Serial */
#define	USB_PRODUCT_ATEN_DSB650C	0x4000		/* DSB-650C */

/* Atheros Communications products */
#define	USB_PRODUCT_ATHEROS_AR5523	0x0001		/* AR5523 */
#define	USB_PRODUCT_ATHEROS_AR5523_NF	0x0002		/* AR5523 */

/* Atheros Communications(2) products */
#define	USB_PRODUCT_ATHEROS2_AR5523_1	0x0001		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_AR5523_1_NF	0x0002		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_AR5523_2	0x0003		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_AR5523_2_NF	0x0004		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_AR5523_3	0x0005		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_AR5523_3_NF	0x0006		/* AR5523 */
#define	USB_PRODUCT_ATHEROS2_TG121N	0x1001		/* TG121N */
#define	USB_PRODUCT_ATHEROS2_WN821NV2	0x1002		/* WN821NV2 */
#define	USB_PRODUCT_ATHEROS2_AR9271_1	0x1006		/* AR9271 */
#define	USB_PRODUCT_ATHEROS2_3CRUSBN275	0x1010		/* 3CRUSBN275 */
#define	USB_PRODUCT_ATHEROS2_WN612	0x1011		/* WN612 */
#define	USB_PRODUCT_ATHEROS2_AR3011	0x3000		/* AR3011 */
#define	USB_PRODUCT_ATHEROS2_AR9280	0x7010		/* AR9280+AR7010 */
#define	USB_PRODUCT_ATHEROS2_AR9287	0x7015		/* AR9287+AR7010 */
#define	USB_PRODUCT_ATHEROS2_AR9170	0x9170		/* AR9170 */
#define	USB_PRODUCT_ATHEROS2_AR9271_2	0x9271		/* AR9271 */
#define	USB_PRODUCT_ATHEROS2_AR9271_3	0xb003		/* AR9271 */

/* ATI products */
#define	USB_PRODUCT_ATI2_205	0xa001		/* USB Cable 205 */

/* Atmel Comp. products */
#define	USB_PRODUCT_ATMEL_STK541	0x2109		/* STK541 Zigbee */
#define	USB_PRODUCT_ATMEL_UHB124	0x3301		/* UHB124 hub */
#define	USB_PRODUCT_ATMEL_WN210	0x4102		/* W-Buddie WN210 */
#define	USB_PRODUCT_ATMEL_DWL900AP	0x5601		/* DWL-900AP Wireless access point */
#define	USB_PRODUCT_ATMEL_AT91_CDC_ACM	0x6119		/* AT91 CDC ACM */
#define	USB_PRODUCT_ATMEL_AT76C503I1	0x7603		/* AT76C503 (Intersil 3861 Radio) */
#define	USB_PRODUCT_ATMEL_AT76C503I2	0x7604		/* AT76C503 (Intersil 3863 Radio) */
#define	USB_PRODUCT_ATMEL_AT76C503RFMD	0x7605		/* AT76C503 (RFMD Radio) */
#define	USB_PRODUCT_ATMEL_AT76C505RFMD	0x7606		/* AT76C505 (RFMD Radio) */
#define	USB_PRODUCT_ATMEL_AT76C505RFMD2958	0x7613		/* AT76C505 (RFMD 2958 Radio) */
#define	USB_PRODUCT_ATMEL_AT76C505A	0x7614		/* AT76C505A (RFMD 2958 Radio) */
#define	USB_PRODUCT_ATMEL_AT76C505AS	0x7617		/* AT76C505AS (RFMD 2958 Radio) */

/* Audio-Technica products */
#define	USB_PRODUCT_AUDIOTECHNICA_ATCHA4USB	0x0009		/* ATC-HA4USB USB headphone */

/* Avago Technologies products */
#define	USB_PRODUCT_AVAGO_MOUSE	0x0000		/* Mouse */

/* Avance Logic products */
#define	USB_PRODUCT_AVANCELOGIC_USBAUDIO	0x0100		/* USB Audio Speaker */

/* Averatec products */
#define	USB_PRODUCT_AVERATEC_USBWLAN	0x4013		/* WLAN */

/* Avision products */
#define	USB_PRODUCT_AVISION_1200U	0x0268		/* 1200U */

/* AVM products */
#define	USB_PRODUCT_AVM_FRITZWLAN	0x8401		/* FRITZ!WLAN N */

/* Axesstel products */
#define	USB_PRODUCT_AXESSTEL_DATAMODEM	0x1000		/* Data Modem */

/* AsureWave products */
#define	USB_PRODUCT_AZUREWAVE_RT2870_1	0x3247		/* RT2870 */
#define	USB_PRODUCT_AZUREWAVE_RT2870_2	0x3262		/* RT2870 */
#define	USB_PRODUCT_AZUREWAVE_RT3070_1	0x3273		/* RT3070 */
#define	USB_PRODUCT_AZUREWAVE_RT3070_2	0x3284		/* RT3070 */
#define	USB_PRODUCT_AZUREWAVE_RT3070_3	0x3305		/* RT3070 */
#define	USB_PRODUCT_AZUREWAVE_RTL8192SU_1	0x3306		/* RTL8192SU */
#define	USB_PRODUCT_AZUREWAVE_RT3070_4	0x3307		/* RT3070 */
#define	USB_PRODUCT_AZUREWAVE_RTL8192SU_2	0x3309		/* RTL8192SU */
#define	USB_PRODUCT_AZUREWAVE_RTL8192SU_3	0x3310		/* RTL8192SU */
#define	USB_PRODUCT_AZUREWAVE_RTL8192SU_4	0x3311		/* RTL8192SU */
#define	USB_PRODUCT_AZUREWAVE_RT3070_5	0x3321		/* RT3070 */
#define	USB_PRODUCT_AZUREWAVE_RTL8192SU_5	0x3325		/* RTL8192SU */
#define	USB_PRODUCT_AZUREWAVE_AR9271_1	0x3327		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_AR9271_2	0x3328		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_AR9271_3	0x3346		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_AR9271_4	0x3348		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_AR9271_5	0x3349		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_AR9271_6	0x3350		/* AR9271 */
#define	USB_PRODUCT_AZUREWAVE_RTL8188CU	0x3357		/* RTL8188CU */
#define	USB_PRODUCT_AZUREWAVE_RTL8188CE_1	0x3358		/* RTL8188CE */
#define	USB_PRODUCT_AZUREWAVE_RTL8188CE_2	0x3359		/* RTL8188CE */

/* Bayer Health Care products */
#define	USB_PRODUCT_BAYER_CONTOUR	0x6001		/* Ascensia Contour */

/* B&B Electronics products */
#define	USB_PRODUCT_BBELECTR_USOTL4	0xac01		/* USOTL4 RS-422/485 */
#define	USB_PRODUCT_BBELECTR_USTL4	0xac02		/* USTL4 RS-422/485 */
#define	USB_PRODUCT_BBELECTR_USO9ML2	0xac03		/* USO9ML2 RS-232 */
#define	USB_PRODUCT_BBELECTR_USOPTL4	0xac11		/* USOPTL4 RS-422/485 */
#define	USB_PRODUCT_BBELECTR_USPTL4	0xac12		/* USPTL4 RS-422/485 */
#define	USB_PRODUCT_BBELECTR_USO9ML2DR2	0xac16		/* USO9ML2DR-2 RS-232 */
#define	USB_PRODUCT_BBELECTR_USO9ML2DR	0xac17		/* USO9ML2DR RS-232 */
#define	USB_PRODUCT_BBELECTR_USOPTL4DR2	0xac18		/* USOPTL4DR-2 RS-422/485 */
#define	USB_PRODUCT_BBELECTR_USOPTL4DR	0xac19		/* USOPTL4DR RS-422/485 */
#define	USB_PRODUCT_BBELECTR_485USB9F2W	0xac25		/* 485USB9F-2W RS-422/485 */
#define	USB_PRODUCT_BBELECTR_485USB9F4W	0xac26		/* 485USB9F-4W RS-422/485 */
#define	USB_PRODUCT_BBELECTR_232USB9M	0xac27		/* 232USB9M RS-232 */
#define	USB_PRODUCT_BBELECTR_485USBTB_2W	0xac33		/* 485USBTB-2W RS-422/485 */
#define	USB_PRODUCT_BBELECTR_485USBTB_4W	0xac34		/* 485USBTB-4W RS-422/485 */
#define	USB_PRODUCT_BBELECTR_TTL5USB9M	0xac49		/* TTL5USB9M */
#define	USB_PRODUCT_BBELECTR_TTL3USB9M	0xac50		/* TTL3USB9M */
#define	USB_PRODUCT_BBELECTR_ZZ_PROG1	0xba02		/* ZZ Programmer */

/* Baltech products */
#define	USB_PRODUCT_BALTECH_CARDREADER	0x9999		/* Card reader */

/* Belkin products */
/*product BELKIN F5U111		0x????	F5U111 Ethernet */
#define	USB_PRODUCT_BELKIN_F5D6050	0x0050		/* F5D6050 802.11b Wireless adapter */
#define	USB_PRODUCT_BELKIN_FBT001V	0x0081		/* Bluetooth */
#define	USB_PRODUCT_BELKIN_F8T003V	0x0083		/* Bluetooth */
#define	USB_PRODUCT_BELKIN_FBT003V	0x0084		/* Bluetooth */
#define	USB_PRODUCT_BELKIN_F5U103	0x0103		/* F5U103 Serial */
#define	USB_PRODUCT_BELKIN_F5U109	0x0109		/* F5U109 Serial */
#define	USB_PRODUCT_BELKIN_SCSI	0x0115		/* SCSI */
#define	USB_PRODUCT_BELKIN_F5D5050	0x0121		/* F5D5050 Ethernet */
#define	USB_PRODUCT_BELKIN_F5U234	0x0234		/* F5U234 USB 2.0 4-Port Hub */
#define	USB_PRODUCT_BELKIN_F5U237	0x0237		/* F5U237 USB 2.0 7-Port Hub */
#define	USB_PRODUCT_BELKIN_F5U257	0x0257		/* F5U257 Serial */
#define	USB_PRODUCT_BELKIN_F6H375	0x0375		/* F6H375 UPS */
#define	USB_PRODUCT_BELKIN_F5U409	0x0409		/* F5U409 Serial */
#define	USB_PRODUCT_BELKIN_F6C550AVR	0x0551		/* F6C550-AVR UPS */
#define	USB_PRODUCT_BELKIN_F6C1250EITWRK	0x0750		/* F6C1250EITW-RK UPS */
#define	USB_PRODUCT_BELKIN_F6C1500EITWRK	0x0751		/* F6C1500EITW-RK UPS */
#define	USB_PRODUCT_BELKIN_F6C900	0x0900		/* F6C900 UPS */
#define	USB_PRODUCT_BELKIN_F6C100	0x0910		/* F6C100 UPS */
#define	USB_PRODUCT_BELKIN_F6C120	0x0912		/* F6C120 UPS */
#define	USB_PRODUCT_BELKIN_F6C800	0x0980		/* F6C800 UPS */
#define	USB_PRODUCT_BELKIN_RTL8192CU_2	0x1004		/* RTL8192CU */
#define	USB_PRODUCT_BELKIN_F6C1100	0x1100		/* F6C1100/1200 UPS */
#define	USB_PRODUCT_BELKIN_RTL8188CU	0x1102		/* RTL8188CU */
#define	USB_PRODUCT_BELKIN_F9L1103	0x1103		/* F9L1103 Wireless Adapter */
#define	USB_PRODUCT_BELKIN_RTL8188CUS	0x11f2		/* RTL8188CUS */
#define	USB_PRODUCT_BELKIN_F5U120	0x1203		/* F5U120-PC Hub */
#define	USB_PRODUCT_BELKIN_RTL8192CU	0x2102		/* RTL8192CU */
#define	USB_PRODUCT_BELKIN_F7D2102	0x2103		/* F7D2102 */
#define	USB_PRODUCT_BELKIN_RTL8192CU_1	0x21f2		/* RTL8192CU */
#define	USB_PRODUCT_BELKIN_F9L1004V1	0x1004		/* F9L1004V1 */
#define	USB_PRODUCT_BELKIN_ZD1211B	0x4050		/* ZD1211B */
#define	USB_PRODUCT_BELKIN_F5D5055	0x5055		/* F5D5055 */
#define	USB_PRODUCT_BELKIN_F5D7050	0x7050		/* F5D7050 54g USB Network Adapter */
#define	USB_PRODUCT_BELKIN_F5D7050A	0x705a		/* F5D705A 54g USB Network Adapter */
#define	USB_PRODUCT_BELKIN_F5D7050C	0x705c		/* F5D705C 54g USB Network Adapter */
#define	USB_PRODUCT_BELKIN_F5D7050E	0x705e		/* F5D705E 54g USB Network Adapter */
#define	USB_PRODUCT_BELKIN_RT2870_1	0x8053		/* RT2870 */
#define	USB_PRODUCT_BELKIN_RT2870_2	0x805c		/* RT2870 */
#define	USB_PRODUCT_BELKIN_F5D8053V3	0x815c		/* F5D8053 v3 */
#define	USB_PRODUCT_BELKIN_RTL8192SU_1	0x815f		/* RTL8192SU */
#define	USB_PRODUCT_BELKIN_F5D8055	0x825a		/* F5D8055 */
#define	USB_PRODUCT_BELKIN_F5D8055V2	0x825b		/* F5D8055 v2 */
#define	USB_PRODUCT_BELKIN_RTL8192SU_2	0x845a		/* RTL8192SU */
#define	USB_PRODUCT_BELKIN_F5D9050C	0x905c		/* F5D9050C */
#define	USB_PRODUCT_BELKIN_F5D9050V3	0x905b		/* F5D9050 ver 3 */
#define	USB_PRODUCT_BELKIN_F6D4050V1	0x935a		/* F6D4050 ver 1 */
#define	USB_PRODUCT_BELKIN_F6D4050V2	0x935b		/* F6D4050 ver 2 */
#define	USB_PRODUCT_BELKIN_RTL8192SU_3	0x945a		/* RTL8192SU */
#define	USB_PRODUCT_BELKIN_F7D1101V2	0x945b		/* F7D1101 v2 */

/* Belkin(2) products */
#define	USB_PRODUCT_BELKIN2_F5U002	0x0002		/* F5U002 Parallel */

/* Bewan products */
#define	USB_PRODUCT_BEWAN_BWIFI_USB54AR	0x1196		/* BWIFI-USB54AR */
#define	USB_PRODUCT_BEWAN_RT3070	0x7712		/* RT3070 */

/* Billionton products */
#define	USB_PRODUCT_BILLIONTON_USB100	0x0986		/* USB100N 10/100 Ethernet */
#define	USB_PRODUCT_BILLIONTON_USBLP100	0x0987		/* USB100LP */
#define	USB_PRODUCT_BILLIONTON_USBEL100	0x0988		/* USB100EL */
#define	USB_PRODUCT_BILLIONTON_USBE100	0x8511		/* USBE100 */
#define	USB_PRODUCT_BILLIONTON_USB2AR	0x90ff		/* USB2AR Ethernet */

/* Broadcom products */
#define	USB_PRODUCT_BROADCOM_BCM2033	0x2000		/* BCM2033 */
#define	USB_PRODUCT_BROADCOM_BCM2033NF	0x2033		/* BCM2033 (no fw) */

/* Brother Industries products */
#define	USB_PRODUCT_BROTHER_HL1050	0x0002		/* HL-1050 laser printer */
#define	USB_PRODUCT_BROTHER_MFC210C	0x0161		/* MFC 210C */

/* Behavior Technology Computer products */
#define	USB_PRODUCT_BTC_BTC7932	0x6782		/* Keyboard/Mouse */

/* Bernd Walter Computer Technology products */
#define	USB_PRODUCT_BWCT_6CHCONSER	0x0001		/* 6ch ConSer */

/* CACE Technologies products */
#define	USB_PRODUCT_CACE_AIRPCAPNX	0x0300		/* AirPcap Nx */

/* Canon, Inc. products */
#define	USB_PRODUCT_CANON_N656U	0x2206		/* CANOSCAN N656U */
#define	USB_PRODUCT_CANON_N1220U	0x2207		/* CANOSCAN N1220U */
#define	USB_PRODUCT_CANON_N670U	0x220d		/* CANOSCAN N670U */
#define	USB_PRODUCT_CANON_N1240U	0x220e		/* CANOSCAN N1240U */
#define	USB_PRODUCT_CANON_LIDE60	0x221c		/* CANOSCAN LiDE60 */
#define	USB_PRODUCT_CANON_S10	0x3041		/* PowerShot S10 */
#define	USB_PRODUCT_CANON_S20	0x3043		/* PowerShot S20 */
#define	USB_PRODUCT_CANON_S100_US	0x3045		/* PowerShot S100 */
#define	USB_PRODUCT_CANON_S100_EU	0x3047		/* PowerShot S100 */
#define	USB_PRODUCT_CANON_G1	0x3048		/* PowerShot G1 */
#define	USB_PRODUCT_CANON_A20	0x304e		/* PowerShot A20 */
#define	USB_PRODUCT_CANON_A540	0x311b		/* PowerShot A540 */
#define	USB_PRODUCT_CANON_SX100	0x315e		/* PowerShot SX100 */

/* CATC products */
#define	USB_PRODUCT_CATC_NETMATE	0x000a		/* Netmate Ethernet */
#define	USB_PRODUCT_CATC_NETMATE2	0x000c		/* Netmate2 Ethernet */
#define	USB_PRODUCT_CATC_CHIEF	0x000d		/* USB Chief Bus & Protocol Analyzer */
#define	USB_PRODUCT_CATC_ANDROMEDA	0x1237		/* Andromeda hub */

/* CASIO products */
#define	USB_PRODUCT_CASIO_QV	0x1001		/* QV */
#define	USB_PRODUCT_CASIO_BE300	0x2002		/* BE-300 PDA */
#define	USB_PRODUCT_CASIO_NAMELAND	0x4001		/* CASIO Nameland EZ-USB */

/* CCYU Technology products */
#define	USB_PRODUCT_CCYU_EASYDISK	0x2136		/* EasyDisk Portable */

/* Cherry products */
#define	USB_PRODUCT_CHERRY_MY3000KBD	0x0001		/* My3000 keyboard */
#define	USB_PRODUCT_CHERRY_MY3000HUB	0x0003		/* My3000 hub */

/* Chen-Source products */
#define	USB_PRODUCT_CHENSOURCE_CM12402	0x933d		/* CM12402 Eagle IR Cam */

/* Chic Technology products */
#define	USB_PRODUCT_CHIC_MOUSE1	0x0001		/* mouse */
#define	USB_PRODUCT_CHIC_CYPRESS	0x0003		/* Cypress */

/* Chicony products */
#define	USB_PRODUCT_CHICONY_KB8933	0x0001		/* KB-8933 keyboard */
#define	USB_PRODUCT_CHICONY_CAMERA	0x480c		/* Integrated Camera */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_1	0xaff7		/* RTL8188CUS */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_2	0xaff8		/* RTL8188CUS */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_3	0xaff9		/* RTL8188CUS */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_4	0xaffa		/* RTL8188CUS */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_5	0xaffb		/* RTL8188CUS */
#define	USB_PRODUCT_CHICONY_RTL8188CUS_6	0xaffc		/* RTL8188CUS */

/* CH Products */
#define	USB_PRODUCT_CHPRODUCTS_PROTHROTTLE	0x00f1		/* Pro Throttle */
#define	USB_PRODUCT_CHPRODUCTS_PROPEDALS	0x00f2		/* Pro Pedals */
#define	USB_PRODUCT_CHPRODUCTS_FIGHTERSTICK	0x00f3		/* Fighterstick */
#define	USB_PRODUCT_CHPRODUCTS_FLIGHTYOKE	0x00ff		/* Flight Sim Yoke */

/* Cisco-Linksys products */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54GV2	0x000a		/* WUSB54G v2 */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54AG	0x000c		/* WUSB54AG */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54G	0x000d		/* RT2570 */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54GP	0x0011		/* RT2570 */
#define	USB_PRODUCT_CISCOLINKSYS_USB200MV2	0x0018		/* USB200M v2 */
#define	USB_PRODUCT_CISCOLINKSYS_HU200TS	0x001a		/* HU200-TS */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54GC	0x0020		/* WUSB54GC */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB54GR	0x0023		/* WUSB54GR */
#define	USB_PRODUCT_CISCOLINKSYS_WUSBF54G	0x0024		/* WUSBF54G */
#define	USB_PRODUCT_CISCOLINKSYS_WUSB200	0x0028		/* WUSB200 */
#define	USB_PRODUCT_CISCOLINKSYS_AE1000	0x002f		/* AE1000 */
#define	USB_PRODUCT_CISCOLINKSYS_AM10	0x0031		/* AM10 */
#define	USB_PRODUCT_CISCOLINKSYS2_RT3070	0x4001		/* RT3070 */
#define	USB_PRODUCT_CISCOLINKSYS3_RT3070	0x0101		/* RT3070 */

/* Clipsal products */
#define	USB_PRODUCT_CLIPSAL_560884	0x0101		/* 560884 C-Bus Switch */
#define	USB_PRODUCT_CLIPSAL_5500PACA	0x0201		/* 5500PACA C-Bus Controller */
#define	USB_PRODUCT_CLIPSAL_5800PC	0x0301		/* 5800PC C-Bus Wireless */
#define	USB_PRODUCT_CLIPSAL_5500PCU	0x0303		/* 5500PCU C-Bus */
#define	USB_PRODUCT_CLIPSAL_5000CT2	0x0304		/* 5000CT2 C-Bus Touch Screen */
#define	USB_PRODUCT_CLIPSAL_C5000CT2	0x0305		/* C5000CT2 C-Bus Touch Screen */
#define	USB_PRODUCT_CLIPSAL_L51xx	0x0401		/* L51xx C-Bus Dimmer */

/* Compaq products */
#define	USB_PRODUCT_COMPAQ_IPAQPOCKETPC	0x0003		/* iPAQ PocketPC */
#define	USB_PRODUCT_COMPAQ_A1500	0x0012		/* A1500 */
#define	USB_PRODUCT_COMPAQ_IPAQWLAN	0x0032		/* iPAQ WLAN */
#define	USB_PRODUCT_COMPAQ_W100	0x0033		/* W100 */
#define	USB_PRODUCT_COMPAQ_W200	0x0076		/* WLAN MultiPort W200 */
#define	USB_PRODUCT_COMPAQ_PJB100	0x504a		/* Personal Jukebox PJB100 */
#define	USB_PRODUCT_COMPAQ_IPAQLINUX	0x505a		/* iPAQ Linux */

/* CONWISE Technology products */
#define	USB_PRODUCT_CTC_CW6622	0x6622		/* CW6622 */

/* CMOTECH CDMA Technologies products */
#define	USB_PRODUCT_CMOTECH_CNU510	0x5141		/* CDMA Technologies USB modem */
#define	USB_PRODUCT_CMOTECH_CM5100P	0x5523		/* CM-5100P EVDO */
#define	USB_PRODUCT_CMOTECH_CCU550	0x5533		/* CCU-550 EVDO */
#define	USB_PRODUCT_CMOTECH_CNU550pro	0x5543		/* CNU-550pro EVDO */
#define	USB_PRODUCT_CMOTECH_CGU628	0x6006		/* CGU-628 */
#define	USB_PRODUCT_CMOTECH_CNU680	0x6803		/* CNU-680 */
#define	USB_PRODUCT_CMOTECH_CGU628_DISK	0xf000		/* CGU-628 disk mode */

/* Compare products */
#define	USB_PRODUCT_COMPARE_RTL8192CU	0x8010		/* RTL8192CU */

/* Conceptronic products */
#define	USB_PRODUCT_CONCEPTRONIC_PRISM_GT	0x3762		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_CONCEPTRONIC_C11U	0x7100		/* C11U */
#define	USB_PRODUCT_CONCEPTRONIC_WL210	0x7110		/* WL-210 */
#define	USB_PRODUCT_CONCEPTRONIC_AR5523_1	0x7801		/* AR5523 */
#define	USB_PRODUCT_CONCEPTRONIC_AR5523_1_NF	0x7802		/* AR5523 */
#define	USB_PRODUCT_CONCEPTRONIC_AR5523_2	0x7811		/* AR5523 */
#define	USB_PRODUCT_CONCEPTRONIC_AR5523_2_NF	0x7812		/* AR5523 */

/* Conceptronic(2) products */
#define	USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_1	0x3300		/* RTL8192SU */
#define	USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_2	0x3301		/* RTL8192SU */
#define	USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_3	0x3302		/* RTL8192SU */
#define	USB_PRODUCT_CONCEPTRONIC2_C54RU	0x3c02		/* C54RU WLAN */
#define	USB_PRODUCT_CONCEPTRONIC2_RT3070_1	0x3c08		/* RT3070 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT3070_2	0x3c11		/* RT3070 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT3070_3	0x3c2c		/* RT3070 */
#define	USB_PRODUCT_CONCEPTRONIC2_C54RU2	0x3c22		/* C54RU */
#define	USB_PRODUCT_CONCEPTRONIC2_VIGORN61	0x3c25		/* VIGORN61 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_1	0x3c06		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_2	0x3c07		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_7	0x3c09		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_8	0x3c12		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_3	0x3c23		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2573	0x3c24		/* RT2573M */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_4	0x3c25		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_5	0x3c27		/* RT2870 */
#define	USB_PRODUCT_CONCEPTRONIC2_RT2870_6	0x3c28		/* RT2870 */

/* Concord Camera products */
#define	USB_PRODUCT_CONCORDCAMERA_EYE_Q_3X	0x0100		/* Eye Q 3x */

/* Connectix products */
#define	USB_PRODUCT_CONNECTIX_QUICKCAM	0x0001		/* QuickCam */

/* Corega products */
#define	USB_PRODUCT_COREGA_ETHER_USB_T	0x0001		/* Ether USB-T */
#define	USB_PRODUCT_COREGA_FETHER_USB_TX	0x0004		/* FEther USB-TX */
#define	USB_PRODUCT_COREGA_WLAN_USB_USB_11	0x000c		/* WirelessLAN USB-11 */
#define	USB_PRODUCT_COREGA_FETHER_USB_TXS	0x000d		/* FEther USB-TXS */
#define	USB_PRODUCT_COREGA_WLANUSB	0x0012		/* Wireless LAN Stick-11 */
#define	USB_PRODUCT_COREGA_FETHER_USB2_TX	0x0017		/* FEther USB2-TX */
#define	USB_PRODUCT_COREGA_WLUSB_11_KEY	0x001a		/* ULUSB-11 Key */
#define	USB_PRODUCT_COREGA_CGWLUSB2GL	0x002d		/* CG-WLUSB2GL */
#define	USB_PRODUCT_COREGA_CGWLUSB2GPX	0x002e		/* CG-WLUSB2GPX */
#define	USB_PRODUCT_COREGA_RT2870_1	0x002f		/* RT2870 */
#define	USB_PRODUCT_COREGA_RT2870_2	0x003c		/* RT2870 */
#define	USB_PRODUCT_COREGA_RT2870_3	0x003f		/* RT2870 */
#define	USB_PRODUCT_COREGA_RT3070	0x0041		/* RT3070 */
#define	USB_PRODUCT_COREGA_CGWLUSB300GNM	0x0042		/* CG-WLUSB300GNM */
#define	USB_PRODUCT_COREGA_CGWLUSB300N	0x0043		/* CG-WLUSB300N */
#define	USB_PRODUCT_COREGA_RTL8192SU	0x0047		/* RTL8192SU */
#define	USB_PRODUCT_COREGA_RTL8192CU	0x0056		/* RTL8192CU */
#define	USB_PRODUCT_COREGA_WLUSB_11_STICK	0x7613		/* WLAN USB Stick 11 */
#define	USB_PRODUCT_COREGA_FETHER_USB_TXC	0x9601		/* FEther USB-TXC */

/* Corsair products */
#define	USB_PRODUCT_CORSAIR_CP210X	0x1c00		/* CP210X */

/* Creative Labs products */
#define	USB_PRODUCT_CREATIVE_NOMAD_II	0x1002		/* Nomad II */
#define	USB_PRODUCT_CREATIVE_NOMAD_IIMG	0x4004		/* Nomad II MG */
#define	USB_PRODUCT_CREATIVE_NOMAD	0x4106		/* Nomad */
#define	USB_PRODUCT_CREATIVE2_VOIP_BLASTER	0x0258		/* Voip Blaster */
#define	USB_PRODUCT_CREATIVE_EMU0202	0x3f02		/* E-Mu 0202 */

/* Cambridge Silicon Radio products */
#define	USB_PRODUCT_CSR_BLUETOOTH	0x0001		/* Bluetooth */
#define	USB_PRODUCT_CSR_BLUECORE	0x1000		/* BlueCore */

/* CTX products */
#define	USB_PRODUCT_CTX_EX1300	0x9999		/* Ex1300 hub */

/* CyberPower products */
#define	USB_PRODUCT_CYBERPOWER_UPS	0x0005		/* UPS */
#define	USB_PRODUCT_CYBERPOWER_1500	0x0501		/* 1500 UPS */
#define	USB_PRODUCT_CYBERPOWER_OR2200	0x0601		/* OR2200 UPS */

/* CyberTAN Technology products */
#define	USB_PRODUCT_CYBERTAN_GIGASET108	0x160c		/* Siemens Gigaset 108 */
#define	USB_PRODUCT_CYBERTAN_TG54USB	0x1666		/* TG54USB */
#define	USB_PRODUCT_CYBERTAN_ZD1211B	0x1667		/* ZD1211B */
#define	USB_PRODUCT_CYBERTAN_RT2870	0x1828		/* RT2870 */

/* Cypress Semiconductor products */
#define	USB_PRODUCT_CYPRESS_MOUSE	0x0001		/* mouse */
#define	USB_PRODUCT_CYPRESS_THERMO	0x0002		/* thermometer */
#define	USB_PRODUCT_CYPRESS_KBDHUB	0x0101		/* Keyboard/Hub */
#define	USB_PRODUCT_CYPRESS_FMRADIO	0x1002		/* FM Radio */
#define	USB_PRODUCT_CYPRESS_USBRS232	0x5500		/* RS232 */
#define	USB_PRODUCT_CYPRESS_HUB2	0x6560		/* USB2 Hub */
#define	USB_PRODUCT_CYPRESS_LPRDK	0xe001		/* CY4636 LP RDK Bridge */
#define	USB_PRODUCT_CYPRESS_SISPM_OLD	0xfd10		/* Sispm - old version */
#define	USB_PRODUCT_CYPRESS_SISPM	0xfd11		/* Sispm */
#define	USB_PRODUCT_CYPRESS_SISPM_FLASH	0xfd12		/* Sispm - flash */

/* Daisy Technology products */
#define	USB_PRODUCT_DAISY_DMC	0x6901		/* PhotoClip */

/* Dallas Semiconductor products */
#define	USB_PRODUCT_DALLAS_USB_FOB_IBUTTON	0x2490		/* USB-FOB/iBUTTON */
#define	USB_PRODUCT_DALLAS_J6502	0x4201		/* J-6502 speakers */

/* DataApex products */
#define	USB_PRODUCT_DATAAPEX_MULTICOM	0xead6		/* MultiCom */

/* Davicom products */
#define	USB_PRODUCT_DAVICOM_WK668	0x0668		/* HenTong WK-668 */
#define	USB_PRODUCT_DAVICOM_DM9601	0x9601		/* DM9601 */

/* Dell products */
#define	USB_PRODUCT_DELL_AXIM	0x4005		/* Axim X51v */
#define	USB_PRODUCT_DELL_BC02	0x8000		/* Bluetooth */
#define	USB_PRODUCT_DELL_TM1180	0x8100		/* TrueMobile 1180 WLAN */
#define	USB_PRODUCT_DELL_PRISM_GT_1	0x8102		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_DELL_BLUETOOTH350	0x8103		/* Bluetooth */
#define	USB_PRODUCT_DELL_PRISM_GT_2	0x8104		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_DELL_W5500	0x8115		/* W5500 HSDPA */
#define	USB_PRODUCT_DELL_U740	0x8135		/* Dell U740 CDMA */
#define	USB_PRODUCT_DELL_EU870D	0x8138		/* EU870D HSDPA */
#define	USB_PRODUCT_DELL_DW700	0x9500		/* DW700 GPS */
#define	USB_PRODUCT_DELL2_UPS	0xFFFF		/* UPS */

/* DeLorme products */
#define	USB_PRODUCT_DELORME_EMUSB	0x0100		/* Earthmate GPS */
#define	USB_PRODUCT_DELORME_EMLT20	0x0200		/* Earthmate LT20 */

/* Diamond products */
#define	USB_PRODUCT_DIAMOND_RIO500USB	0x0001		/* Rio 500 */

/* Dick Smith Electronics (really C-Net) products */
#define	USB_PRODUCT_DICKSMITH_WL200U	0x0002		/* WL-200U */
#define	USB_PRODUCT_DICKSMITH_CHUSB611G	0x0013		/* CHUSB 611G */
#define	USB_PRODUCT_DICKSMITH_WL240U	0x0014		/* WL-240U */
#define	USB_PRODUCT_DICKSMITH_XH1153	0x5743		/* XH1153 802.11b */
#define	USB_PRODUCT_DICKSMITH_RT2573	0x9022		/* RT2573 */
#define	USB_PRODUCT_DICKSMITH_CWD854F	0x9032		/* C-Net CWD-854 rev F */
#define	USB_PRODUCT_DICKSMITH_RTL8187	0x9401		/* RTL8187 */

/* Digi International products */
#define	USB_PRODUCT_DIGI_ACCELEPORT2	0x0002		/* AccelePort 2 */
#define	USB_PRODUCT_DIGI_ACCELEPORT4	0x0004		/* AccelePort 4 */
#define	USB_PRODUCT_DIGI_ACCELEPORT8	0x0008		/* AccelePort 8 */

/* Digianswer A/S products */
#define	USB_PRODUCT_DIGIANSWER_ZIGBEE802154	0x000a		/* ZigBee */

/* Digital Stream Corp. products */
#define	USB_PRODUCT_DIGITALSTREAM_PS2	0x0001		/* PS/2 Active */

/* D-Link products */
/*product DLINK DSBS25		0x0100	DSB-S25 serial */
#define	USB_PRODUCT_DLINK_DUBE100	0x1a00		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DUBE100C1	0x1a02		/* DUB-E100 rev C1 */
#define	USB_PRODUCT_DLINK_DSB650TX4	0x200c		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DWL120E	0x3200		/* DWL-120 rev E */
#define	USB_PRODUCT_DLINK_DWA130C	0x3301		/* DWA-130 rev C */
#define	USB_PRODUCT_DLINK_DWA125D1	0x330f		/* DWA-125 rev D1 */
#define	USB_PRODUCT_DLINK_DWA123D1	0x3310		/* DWA-123 rev D1 */
#define	USB_PRODUCT_DLINK_RTL8192CU_1	0x3307		/* RTL8192CU */
#define	USB_PRODUCT_DLINK_RTL8188CU	0x3308		/* RTL8188CU */
#define	USB_PRODUCT_DLINK_RTL8192CU_2	0x3309		/* RTL8192CU */
#define	USB_PRODUCT_DLINK_RTL8192CU_3	0x330a		/* RTL8192CU */
#define	USB_PRODUCT_DLINK_RTL8192CU_4	0x330b		/* RTL8192CU */
#define	USB_PRODUCT_DLINK_DWA131B	0x330d		/* DWA-131 rev B */
#define	USB_PRODUCT_DLINK_DWL122	0x3700		/* DWL-122 */
#define	USB_PRODUCT_DLINK_DWLG120	0x3701		/* DWL-G120 */
#define	USB_PRODUCT_DLINK_DWL120F	0x3702		/* DWL-120 rev F */
#define	USB_PRODUCT_DLINK_DWLG122A2	0x3704		/* DWL-G122 rev A2 */
#define	USB_PRODUCT_DLINK_DWLAG132	0x3a00		/* DWL-AG132 */
#define	USB_PRODUCT_DLINK_DWLAG132_NF	0x3a01		/* DWL-AG132 */
#define	USB_PRODUCT_DLINK_DWLG132	0x3a02		/* DWL-G132 */
#define	USB_PRODUCT_DLINK_DWLG132_NF	0x3a03		/* DWL-G132 */
#define	USB_PRODUCT_DLINK_DWLAG122	0x3a04		/* DWL-AG122 */
#define	USB_PRODUCT_DLINK_DWLAG122_NF	0x3a05		/* DWL-AG122 */
#define	USB_PRODUCT_DLINK_RT2570	0x3c00		/* RT2570 */
#define	USB_PRODUCT_DLINK_DUBE100B1	0x3c05		/* DUB-E100 rev B1 */
#define	USB_PRODUCT_DLINK_RT2870	0x3c09		/* RT2870 */
#define	USB_PRODUCT_DLINK_RT3072	0x3c0a		/* RT3072 */
#define	USB_PRODUCT_DLINK_DWA140B3	0x3c15		/* DWA-140 rev B3 */
#define	USB_PRODUCT_DLINK_DWA160B2	0x3c1a		/* DWA-160 rev B2 */
#define	USB_PRODUCT_DLINK_DWA127	0x3c1b		/* DWA-127 */
#define	USB_PRODUCT_DLINK_DWA162	0x3c1f		/* DWA-162 Wireless Adapter */
#define	USB_PRODUCT_DLINK_DSB650C	0x4000		/* 10Mbps Ethernet */
#define	USB_PRODUCT_DLINK_DSB650TX1	0x4001		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DSB650TX	0x4002		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DSB650TX_PNA	0x4003		/* 1/10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DSB650TX3	0x400b		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DSB650TX2	0x4102		/* 10/100 Ethernet */
#define	USB_PRODUCT_DLINK_DUB1312	0x4a00		/* DUB-1312 */
#define	USB_PRODUCT_DLINK_DSB650	0xabc1		/* 10/100 Ethernet */

/* D-Link(2) products */
#define	USB_PRODUCT_DLINK2_RTL8192SU_1	0x3300		/* RTL8192SU */
#define	USB_PRODUCT_DLINK2_RTL8192SU_2	0x3302		/* RTL8192SU */
#define	USB_PRODUCT_DLINK2_DWA131A1	0x3303		/* DWA-131 A1 */
#define	USB_PRODUCT_DLINK2_WUA2340	0x3a07		/* WUA-2340 */
#define	USB_PRODUCT_DLINK2_WUA2340_NF	0x3a08		/* WUA-2340 */
#define	USB_PRODUCT_DLINK2_DWA160A2	0x3a09		/* DWA-160 A2 */
#define	USB_PRODUCT_DLINK2_DWA130D1	0x3a0f		/* DWA-130 rev D1 */
#define	USB_PRODUCT_DLINK2_AR9271	0x3a10		/* AR9271 */
#define	USB_PRODUCT_DLINK2_DWLG122C1	0x3c03		/* DWL-G122 rev C1 */
#define	USB_PRODUCT_DLINK2_WUA1340	0x3c04		/* WUA-1340 */
#define	USB_PRODUCT_DLINK2_DWA111	0x3c06		/* DWA-111 */
#define	USB_PRODUCT_DLINK2_DWA110	0x3c07		/* DWA-110 */
#define	USB_PRODUCT_DLINK2_RT2870_1	0x3c09		/* RT2870 */
#define	USB_PRODUCT_DLINK2_RT3072	0x3c0a		/* RT3072 */
#define	USB_PRODUCT_DLINK2_RT3072_1	0x3c0b		/* RT3072 */
#define	USB_PRODUCT_DLINK2_RT3070_1	0x3c0d		/* RT3070 */
#define	USB_PRODUCT_DLINK2_RT3070_2	0x3c0e		/* RT3070 */
#define	USB_PRODUCT_DLINK2_RT3070_3	0x3c0f		/* RT3070 */
#define	USB_PRODUCT_DLINK2_DWA160A1	0x3c10		/* DWA-160 A1 */
#define	USB_PRODUCT_DLINK2_RT2870_2	0x3c11		/* RT2870 */
#define	USB_PRODUCT_DLINK2_DWA130	0x3c13		/* DWA-130 */
#define	USB_PRODUCT_DLINK2_RT3070_4	0x3c15		/* RT3070 */
#define	USB_PRODUCT_DLINK2_RT3070_5	0x3c16		/* RT3070 */

/* D-Link(3) products */
#define	USB_PRODUCT_DLINK3_KVM221	0x020f		/* KVM-221 */

/* DisplayLink products */
#define	USB_PRODUCT_DISPLAYLINK_LCD4300U	0x01ba		/* LCD-4300U */
#define	USB_PRODUCT_DISPLAYLINK_LCD8000U	0x01bb		/* LCD-8000U */
#define	USB_PRODUCT_DISPLAYLINK_LD220	0x0100		/* Samsung LD220 */
#define	USB_PRODUCT_DISPLAYLINK_GUC2020	0x0059		/* IOGEAR DVI GUC2020 */
#define	USB_PRODUCT_DISPLAYLINK_VCUD60	0x0136		/* Rextron DVI */
#define	USB_PRODUCT_DISPLAYLINK_CONV	0x0138		/* StarTech CONV-USB2DVI */
#define	USB_PRODUCT_DISPLAYLINK_DLDVI	0x0141		/* DisplayLink DVI */
#define	USB_PRODUCT_DISPLAYLINK_VGA10	0x015a		/* CMP-USBVGA10 */
#define	USB_PRODUCT_DISPLAYLINK_WSDVI	0x0198		/* WS Tech DVI */
#define	USB_PRODUCT_DISPLAYLINK_EC008	0x019b		/* EasyCAP008 DVI */
#define	USB_PRODUCT_DISPLAYLINK_HPDOCK	0x01d4		/* HP USB Docking */
#define	USB_PRODUCT_DISPLAYLINK_NL571	0x01d7		/* HP USB DVI */
#define	USB_PRODUCT_DISPLAYLINK_M01061	0x01e2		/* Lenovo DVI */
#define	USB_PRODUCT_DISPLAYLINK_SWDVI	0x024c		/* SUNWEIT DVI */
#define	USB_PRODUCT_DISPLAYLINK_NBDOCK	0x0215		/* VideoHome NBdock1920 */
#define	USB_PRODUCT_DISPLAYLINK_LUM70	0x02a9		/* Lilliput UM-70 */
#define	USB_PRODUCT_DISPLAYLINK_UM7X0	0x401a		/* nanovision MiMo */
#define	USB_PRODUCT_DISPLAYLINK_LT1421	0x03e0		/* Lenovo ThinkVision LT1421 */
#define	USB_PRODUCT_DISPLAYLINK_POLARIS2	0x0117		/* Polaris2 USB dock */

/* DMI products */
#define	USB_PRODUCT_DMI_SA2_0	0xb001		/* Storage Adapter */

/* Domain Technologies products */
#define	USB_PRODUCT_DOMAIN_ROCKCHIP	0x3203		/* RockChip Media Player */

/* DrayTek products */
#define	USB_PRODUCT_DRAYTEK_VIGOR550	0x0550		/* Vigor550 */
#define	USB_PRODUCT_DRAYTEK_VIGOR600	0x0600		/* Vigor600 */

/* Dream Link products */
#define	USB_PRODUCT_DREAMLINK_ULMB1	0x0013		/* USB LED Message Board v1.0 */

/* Dresden Elektronic products */
#define	USB_PRODUCT_DRESDENELEC_STB	0x0001		/* Sensor Terminal */
#define	USB_PRODUCT_DRESDENELEC_WHT	0x0004		/* Wireless Terminal */

/* DViCO products */
#define	USB_PRODUCT_DVICO_RT3070	0xb307		/* RT3070 */

/* Dynastream Innovations */
#define	USB_PRODUCT_DYNASTREAM_ANTDEVBOARD	0x1003		/* ANT dev board */
#define	USB_PRODUCT_DYNASTREAM_ANT2USB	0x1004		/* ANT2USB */
#define	USB_PRODUCT_DYNASTREAM_ANTDEVBOARD2	0x1006		/* ANT dev board */

/* EasyDisk products */
#define	USB_PRODUCT_EASYDISK_EASYDISK	0x0005		/* Flash Disk */

/* EDIMAX products */
#define	USB_PRODUCT_EDIMAX_EW7318	0x7318		/* EW-7318 */
#define	USB_PRODUCT_EDIMAX_RTL8192SU_1	0x7611		/* RTL8192SU */
#define	USB_PRODUCT_EDIMAX_RTL8192SU_2	0x7612		/* RTL8192SU */
#define	USB_PRODUCT_EDIMAX_EW7618	0x7618		/* EW-7618 */
#define	USB_PRODUCT_EDIMAX_RTL8192SU_3	0x7622		/* RTL8192SU */
#define	USB_PRODUCT_EDIMAX_RT2870_1	0x7711		/* RT2870 */
#define	USB_PRODUCT_EDIMAX_EW7717	0x7717		/* EW-7717 */
#define	USB_PRODUCT_EDIMAX_EW7718	0x7718		/* EW-7718 */
#define	USB_PRODUCT_EDIMAX_EW7722UTN	0x7722		/* EW-7722UTn */
#define	USB_PRODUCT_EDIMAX_EW7811UN	0x7811		/* EW-7811Un */
#define	USB_PRODUCT_EDIMAX_RTL8192CU	0x7822		/* RTL8192CU */

/* eGalax Products */
#define	USB_PRODUCT_EGALAX_TPANEL	0x0001		/* Touch Panel */
#define	USB_PRODUCT_EGALAX_TPANEL2	0x0002		/* Touch Panel */
#define	USB_PRODUCT_EGALAX2_TPANEL	0x0001		/* Touch Panel */

/* Eicon Networks products */
#define	USB_PRODUCT_EICON_DIVA852	0x4905		/* Diva 852 ISDN TA */

/* EIZO products */
#define	USB_PRODUCT_EIZO_HUB	0x0000		/* hub */
#define	USB_PRODUCT_EIZO_MONITOR	0x0001		/* monitor */

/* Elan Microelectronics products */
#define	USB_PRODUCT_ELAN_BARCODE	0x0001		/* Barcode Scanner */

/* ELCON Systemtechnik products */
#define	USB_PRODUCT_ELCON_PLAN	0x0002		/* Goldpfeil P-LAN */

/* Elecom products */
#define	USB_PRODUCT_ELECOM_MOUSE29UO	0x0002		/* 29UO */
#define	USB_PRODUCT_ELECOM_LDUSBTX0	0x200c		/* LD-USB/TX */
#define	USB_PRODUCT_ELECOM_LDUSBTX1	0x4002		/* LD-USB/TX */
#define	USB_PRODUCT_ELECOM_LDUSBLTX	0x4005		/* LD-USBL/TX */
#define	USB_PRODUCT_ELECOM_WDC150SU2M	0x4008		/* WDC-150SU2M */
#define	USB_PRODUCT_ELECOM_LDUSBTX2	0x400b		/* LD-USB/TX */
#define	USB_PRODUCT_ELECOM_LDUSB20	0x4010		/* LD-USB20 */
#define	USB_PRODUCT_ELECOM_UCSGT	0x5003		/* UC-SGT Serial */
#define	USB_PRODUCT_ELECOM_UCSGT0	0x5004		/* UC-SGT0 Serial */
#define	USB_PRODUCT_ELECOM_LDUSBTX3	0xabc1		/* LD-USB/TX */

/* Elektor Electronics products */
#define	USB_PRODUCT_ELEKTOR_FT323R	0x0005		/* FT323R */

/* Elsa products */
#define	USB_PRODUCT_ELSA_MODEM1	0x2265		/* ELSA */
#define	USB_PRODUCT_ELSA_USB2ETHERNET	0x3000		/* Microlink USB2Ethernet */

/* ELV products */
#define	USB_PRODUCT_ELV_USBI2C	0xe00f		/* USB-I2C */

/* eMPIA products */
#define	USB_PRODUCT_EMPIA_EEEPC701_VIDEO	0x2761		/* EeePC701 camera */

/* Encore products */
#define	USB_PRODUCT_ENCORE_RT3070_1	0x1480		/* RT3070 */
#define	USB_PRODUCT_ENCORE_RT3070_2	0x14a1		/* RT3070 */
#define	USB_PRODUCT_ENCORE_RT3070_3	0x14a9		/* RT3070 */

/* Entrega products */
#define	USB_PRODUCT_ENTREGA_1S	0x0001		/* 1S serial */
#define	USB_PRODUCT_ENTREGA_2S	0x0002		/* 2S serial */
#define	USB_PRODUCT_ENTREGA_1S25	0x0003		/* 1S25 serial */
#define	USB_PRODUCT_ENTREGA_4S	0x0004		/* 4S serial */
#define	USB_PRODUCT_ENTREGA_E45	0x0005		/* E45 Ethernet */
#define	USB_PRODUCT_ENTREGA_CENTRONICS	0x0006		/* Centronics */
#define	USB_PRODUCT_ENTREGA_XX1	0x0008		/* Ethernet */
#define	USB_PRODUCT_ENTREGA_1S9	0x0093		/* 1S9 serial */
#define	USB_PRODUCT_ENTREGA_EZUSB	0x8000		/* EZ-USB */
/*product ENTREGA SERIAL	0x8001	DB25 Serial connector*/
#define	USB_PRODUCT_ENTREGA_2U4S	0x8004		/* 2U4S serial */
#define	USB_PRODUCT_ENTREGA_XX2	0x8005		/* Ethernet */
/*product ENTREGA SERIAL_DB9	0x8093	DB9 Serial connector*/

/* Epson products */
#define	USB_PRODUCT_EPSON_PRINTER1	0x0001		/* USB Printer */
#define	USB_PRODUCT_EPSON_PRINTER2	0x0002		/* ISD Smart Cable for Mac */
#define	USB_PRODUCT_EPSON_PRINTER3	0x0003		/* ISD Smart Cable */
#define	USB_PRODUCT_EPSON_PRINTER5	0x0005		/* USB Printer */
#define	USB_PRODUCT_EPSON_636	0x0101		/* Perfection 636U / 636Photo */
#define	USB_PRODUCT_EPSON_610	0x0103		/* Perfection 610 */
#define	USB_PRODUCT_EPSON_1200	0x0104		/* Perfection 1200U / 1200Photo */
#define	USB_PRODUCT_EPSON_1600	0x0107		/* Expression 1600 */
#define	USB_PRODUCT_EPSON_1640	0x010a		/* Perfection 1640SU */
#define	USB_PRODUCT_EPSON_1240	0x010b		/* Perfection 1240U / 1240Photo */
#define	USB_PRODUCT_EPSON_640U	0x010c		/* Perfection 640U */
#define	USB_PRODUCT_EPSON_1650	0x0110		/* Perfection 1650 */
#define	USB_PRODUCT_EPSON_GT9700F	0x0112		/* GT-9700F */
#define	USB_PRODUCT_EPSON_2400	0x011b		/* Perfection 2400 */
#define	USB_PRODUCT_EPSON_1260	0x011d		/* Perfection 1260 */
#define	USB_PRODUCT_EPSON_1660	0x011e		/* Perfection 1660 */
#define	USB_PRODUCT_EPSON_1670	0x011f		/* Perfection 1670 */
#define	USB_PRODUCT_EPSON_CX3650	0x080e		/* Stylus CX3650 */
#define	USB_PRODUCT_EPSON_DX3800	0x0818		/* Stylus DX3800 */
#define	USB_PRODUCT_EPSON_DX4000	0x082f		/* Stylus DX4000 */
#define	USB_PRODUCT_EPSON_DX5000	0x082b		/* Stylus DX5000 */
#define	USB_PRODUCT_EPSON_DX6000	0x082e		/* Stylus DX6000 */
#define	USB_PRODUCT_EPSON_CX5400	0x0808		/* CX5400 */

/* e-TEK Labs products */
#define	USB_PRODUCT_ETEK_1COM	0x8007		/* Serial */

/* Evolution Robotics products */
#define	USB_PRODUCT_EVOLUTION_ER1	0x0300		/* ER1 Control Module */
#define	USB_PRODUCT_EVOLUTION_RCM4_1	0x0302		/* RCM4 interface */
#define	USB_PRODUCT_EVOLUTION_RCM4_2	0x0303		/* RCM4 interface */

/* Extended Systems products */
#define	USB_PRODUCT_EXTENDED_XTNDACCESS	0x0100		/* XTNDAccess IrDA */

/* Falcom Wireless Communications GmbH products */
#define	USB_PRODUCT_FALCOM_TWIST	0x0001		/* Twist */
#define	USB_PRODUCT_FALCOM_SAMBA	0x0005		/* Samba */

/* FeiXun Communication products */
#define	USB_PRODUCT_FEIXUN_RTL8188CU	0x0090		/* RTL8188CU */
#define	USB_PRODUCT_FEIXUN_RTL8192CU	0x0091		/* RTL8192CU */

/* Festo products */
#define	USB_PRODUCT_FESTO_CPX_USB	0x0102		/* CPX-USB */
#define	USB_PRODUCT_FESTO_CMSP	0x0501		/* CMSP */

/* Fiberline products */
#define	USB_PRODUCT_FIBERLINE_WL430U	0x6003		/* WL-430U */

/* Fossil products */
#define	USB_PRODUCT_FOSSIL_WRISTPDA	0x0002		/* Wrist PDA */

/* Foxconn products */
#define	USB_PRODUCT_FOXCONN_TCOM_TC_300	0xe000		/* T-Com TC 300 */
#define	USB_PRODUCT_FOXCONN_PIRELLI_DP_L10	0xe003		/* Pirelli DP-L10 */

/* Freecom products */
#define	USB_PRODUCT_FREECOM_DVD	0xfc01		/* Connector for DVD drive */

/* Future Technology Devices products */
#define	USB_PRODUCT_FTDI_FT232_1	0x0232		/* Serial */
#define	USB_PRODUCT_FTDI_SERIAL_8U232AM	0x6001		/* 8U232AM Serial */
#define	USB_PRODUCT_FTDI_SERIAL_8U232AM4	0x6004		/* 8U232AM Serial */
#define	USB_PRODUCT_FTDI_FT232_3	0x6006		/* Serial */
#define	USB_PRODUCT_FTDI_FT232_4	0x6007		/* Serial */
#define	USB_PRODUCT_FTDI_FT232_5	0x6008		/* Serial */
#define	USB_PRODUCT_FTDI_FT232_6	0x6009		/* Serial */
#define	USB_PRODUCT_FTDI_SERIAL_2232C	0x6010		/* 2232C Serial */
#define	USB_PRODUCT_FTDI_FT4232H	0x6011		/* FT4232H */
#define	USB_PRODUCT_FTDI_FTX	0x6015		/* FTX */
#define	USB_PRODUCT_FTDI_PS2KBDMS	0x8371		/* PS/2 Keyboard/Mouse */
#define	USB_PRODUCT_FTDI_SERIAL_8U100AX	0x8372		/* Serial */
#define	USB_PRODUCT_FTDI_MJS_SIRIUS_PC_2	0x9379		/* MJS Sirius To PC Interface */
#define	USB_PRODUCT_FTDI_OPENRD	0x9e90		/* OpenRD JTAGKey */
#define	USB_PRODUCT_FTDI_CANDAPTER	0x9f80		/* CANdapter */
#define	USB_PRODUCT_FTDI_NXTCAM	0xabb8		/* Mindstorms NXTCam */
#define	USB_PRODUCT_FTDI_OOCDLINK	0xbaf8		/* OOCDlink */
#define	USB_PRODUCT_FTDI_LM3S_DEVEL	0xbcd8		/* LM3S Devel */
#define	USB_PRODUCT_FTDI_LM3S_EVAL	0xbcd9		/* LM3S Eval */
#define	USB_PRODUCT_FTDI_TURTELIZER_JTAG	0xbdc8		/* JTAG/RS-232 */
#define	USB_PRODUCT_FTDI_OPENDCC	0xbfd8		/* OpenDCC */
#define	USB_PRODUCT_FTDI_OPENDCC_SNIFFER	0xbfd9		/* OpenDCC Sniffer */
#define	USB_PRODUCT_FTDI_OPENDCC_THROTTLE	0xbfda		/* OpenDCC Throttle */
#define	USB_PRODUCT_FTDI_OPENDCC_GATEWAY	0xbfdb		/* OpenDCC Gateway */
#define	USB_PRODUCT_FTDI_LOCOBUFFER	0xc7d0		/* RR-CirKits LocoBuffer */
#define	USB_PRODUCT_FTDI_DMX4ALL	0xc850		/* DMX4ALL DMX interface */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_1	0xc990		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_2	0xc991		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_3	0xc992		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_4	0xc993		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_5	0xc994		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_6	0xc995		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_7	0xc996		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_ASK_RDR4X7_8	0xc997		/* ASK RDR 4X7 */
#define	USB_PRODUCT_FTDI_MJS_SIRIUS_PC_1	0xca81		/* MJS Sirius To PC Interface */
#define	USB_PRODUCT_FTDI_CHAMELEON	0xcaa0		/* uChameleon */
#define	USB_PRODUCT_FTDI_OPENPORT_13M	0xcc48		/* OpenPort 1.3 Mitsubishi */
#define	USB_PRODUCT_FTDI_OPENPORT_13S	0xcc49		/* OpenPort 1.3 Subaru */
#define	USB_PRODUCT_FTDI_OPENPORT_13U	0xcc4a		/* OpenPort 1.3 Universal */
#define	USB_PRODUCT_FTDI_SERIAL_2232L	0xcff8		/* 2232L Serial */
#define	USB_PRODUCT_FTDI_SCS_0	0xd010		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_1	0xd011		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_2	0xd012		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_3	0xd013		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_4	0xd014		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_5	0xd015		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_6	0xd016		/* Radio Modem */
#define	USB_PRODUCT_FTDI_SCS_7	0xd017		/* Radio Modem */
#define	USB_PRODUCT_FTDI_IPLUS	0xd070		/* iPlus */
#define	USB_PRODUCT_FTDI_IPLUS2	0xd071		/* iPlus */
#define	USB_PRODUCT_FTDI_XSENS_1	0xd388		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_2	0xd389		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_3	0xd38a		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_4	0xd38b		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_5	0xd38c		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_6	0xd38d		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_7	0xd38e		/* Serial */
#define	USB_PRODUCT_FTDI_XSENS_8	0xd38f		/* Serial */
#define	USB_PRODUCT_FTDI_GAMMASCOUT	0xd678		/* Gamma Scout Online */
#define	USB_PRODUCT_FTDI_JTAGCABLEII	0xd738		/* Propox JTAG */
#define	USB_PRODUCT_FTDI_WESTREX_777	0xdc00		/* Westrex 777 */
#define	USB_PRODUCT_FTDI_WESTREX_8900F	0xdc01		/* Westrex 8900F */
#define	USB_PRODUCT_FTDI_ACG_HFDUAL	0xdd20		/* HF Dual ISO Reader */
#define	USB_PRODUCT_FTDI_ARTEMIS	0xdf28		/* CCD camera */
#define	USB_PRODUCT_FTDI_ATK16	0xdf30		/* ATK-16 Camera */
#define	USB_PRODUCT_FTDI_ATK16HR	0xdf31		/* ATK-16HR Camera */
#define	USB_PRODUCT_FTDI_ATK16C	0xdf32		/* ATK-16C Camera */
#define	USB_PRODUCT_FTDI_ATK16HRC	0xdf33		/* ATK-16HRC Camera */
#define	USB_PRODUCT_FTDI_ATK16IC	0xdf35		/* ATK-16IC Camera */
#define	USB_PRODUCT_FTDI_YEI_SC31	0xe050		/* ServoCenter3.1 */
#define	USB_PRODUCT_FTDI_ELV_USR	0xe000		/* USR */
#define	USB_PRODUCT_FTDI_ELV_MSM1	0xe001		/* Mini-Sound-Modul */
#define	USB_PRODUCT_FTDI_ELV_KL100	0xe002		/* KL 100 */
#define	USB_PRODUCT_FTDI_ELV_WS550	0xe004		/* WS 550 */
#define	USB_PRODUCT_FTDI_ELV_WS888	0xe008		/* WS 888 */
#define	USB_PRODUCT_FTDI_ELV_TWS550	0xe009		/* WS 550 */
#define	USB_PRODUCT_FTDI_ELV_FEM	0xe00a		/* Funk Energie Monitor */
#define	USB_PRODUCT_FTDI_ELV_FHZ1300PC	0xe0e8		/* FHZ 1300 PC */
#define	USB_PRODUCT_FTDI_ELV_WS500	0xe0e9		/* WS 500 */
#define	USB_PRODUCT_FTDI_ELV_HS485	0xe0ea		/* RS-485 */
#define	USB_PRODUCT_FTDI_ELV_UMS100	0xe0eb		/* UMS 100 */
#define	USB_PRODUCT_FTDI_ELV_TFD128	0xe0ec		/* TFD 128 */
#define	USB_PRODUCT_FTDI_ELV_FM3RX	0xe0ed		/* FM3 RX */
#define	USB_PRODUCT_FTDI_ELV_WS777	0xe0ee		/* WS 777 */
#define	USB_PRODUCT_FTDI_ELV_EM1010PC	0xe0ef		/* EM 1010 PC */
#define	USB_PRODUCT_FTDI_ELV_CSI8	0xe0f0		/* CSI 8 */
#define	USB_PRODUCT_FTDI_ELV_EM1000DL	0xe0f1		/* EM 1000 DL */
#define	USB_PRODUCT_FTDI_ELV_PCK100	0xe0f2		/* PCK 100 */
#define	USB_PRODUCT_FTDI_ELV_RFP500	0xe0f3		/* RFP 500 */
#define	USB_PRODUCT_FTDI_ELV_FS20SIG	0xe0f4		/* FS 20 SIG */
#define	USB_PRODUCT_FTDI_ELV_UTP8	0xe0f5		/* UTP 8 */
#define	USB_PRODUCT_FTDI_ELV_WS300PC	0xe0f6		/* WS 300 PC */
#define	USB_PRODUCT_FTDI_ELV_WS444PC	0xe0f7		/* WS 444 PC */
#define	USB_PRODUCT_FTDI_FISCO	0xe40b		/* Serial */
#define	USB_PRODUCT_FTDI_ECO_PRO	0xe520		/* EVER Eco Pro UPS */
#define	USB_PRODUCT_FTDI_ACTROBOTS	0xe548		/* Active Robots comms */
#define	USB_PRODUCT_FTDI_PYRAMID	0xe6c8		/* Pyramid Display */
#define	USB_PRODUCT_FTDI_UNICOM	0xe700		/* Unicom III */
#define	USB_PRODUCT_FTDI_GUDE_1	0xe808		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_2	0xe809		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_3	0xe80a		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_4	0xe80b		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_5	0xe80c		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_6	0xe80d		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_7	0xe80e		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_8	0xe80f		/* Serial */
#define	USB_PRODUCT_FTDI_EISCOU	0xe888		/* Expert ISDN */
#define	USB_PRODUCT_FTDI_UOPTBR	0xe889		/* RS232 OptoBridge */
#define	USB_PRODUCT_FTDI_DCF	0xe88a		/* Expert mouseCLOCK USB II */
#define	USB_PRODUCT_FTDI_MSF	0xe88b		/* Expert mouseCLOCK USB II MSF */
#define	USB_PRODUCT_FTDI_HBG	0xe88c		/* Expert mouseCLOCK USB II HBG */
#define	USB_PRODUCT_FTDI_GUDE_9	0xe88d		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_A	0xe88e		/* Serial */
#define	USB_PRODUCT_FTDI_GUDE_B	0xe88f		/* Serial */
#define	USB_PRODUCT_FTDI_ECLO_1WIRE	0xea90		/* 1-Wire */
#define	USB_PRODUCT_FTDI_TNCX	0xebe0		/* TNC-X packet-radio */
#define	USB_PRODUCT_FTDI_TERATRONIK_VCP	0xec88		/* VCP */
#define	USB_PRODUCT_FTDI_TERATRONIK_D2XX	0xec89		/* D2XX */
#define	USB_PRODUCT_FTDI_REU_TINY	0xed22		/* RigExpert Tiny */
#define	USB_PRODUCT_FTDI_HO870	0xed71		/* HO870 */
#define	USB_PRODUCT_FTDI_HO820	0xed74		/* HO820 */
#define	USB_PRODUCT_FTDI_SERIAL_232BM	0xee18		/* FT232BM Serial */
#define	USB_PRODUCT_FTDI_MHAM_KW	0xeee8		/* KW */
#define	USB_PRODUCT_FTDI_MHAM_YS	0xeee9		/* YS */
#define	USB_PRODUCT_FTDI_MHAM_Y6	0xeeea		/* Y6 */
#define	USB_PRODUCT_FTDI_MHAM_Y8	0xeeeb		/* Y8 */
#define	USB_PRODUCT_FTDI_MHAM_IC	0xeeec		/* IC */
#define	USB_PRODUCT_FTDI_MHAM_DB9	0xeeed		/* DB9 */
#define	USB_PRODUCT_FTDI_MHAM_RS232	0xeeee		/* RS232 */
#define	USB_PRODUCT_FTDI_MHAM_Y9	0xeeef		/* Y9 */
#define	USB_PRODUCT_FTDI_DGQG	0xef50		/* DGQG */
#define	USB_PRODUCT_FTDI_DUSB	0xef51		/* DUSB */
#define	USB_PRODUCT_FTDI_ELV_UAD8	0xf068		/* UAD 8 */
#define	USB_PRODUCT_FTDI_ELV_UAD7	0xf069		/* UAD 7 */
#define	USB_PRODUCT_FTDI_ELV_USI2	0xf06a		/* USI 2 */
#define	USB_PRODUCT_FTDI_ELV_T1100	0xf06b		/* T 1100 */
#define	USB_PRODUCT_FTDI_ELV_PCD200	0xf06c		/* PCD 200 */
#define	USB_PRODUCT_FTDI_ELV_ULA200	0xf06d		/* ULA 200 */
#define	USB_PRODUCT_FTDI_ELV_ALC8500	0xf06e		/* ALC 8500 Expert */
#define	USB_PRODUCT_FTDI_ELV_FHZ1000PC	0xf06f		/* FHZ 1000 PC */
#define	USB_PRODUCT_FTDI_PERLE_UP	0xf0c0		/* UltraPort */
#define	USB_PRODUCT_FTDI_SPROG_II	0xf0c8		/* Sprog II */
#define	USB_PRODUCT_FTDI_PIEGROUP_IR	0xf208		/* Infrared */
#define	USB_PRODUCT_FTDI_ACTZWAVE	0xf2d0		/* HomePro ZWave */
#define	USB_PRODUCT_FTDI_GALAXY_1	0xf3c0		/* Serial */
#define	USB_PRODUCT_FTDI_GALAXY_2	0xf3c1		/* Serial */
#define	USB_PRODUCT_FTDI_COASTAL_TNCX	0xf448		/* Coastal ChipWorks TNC-X */
#define	USB_PRODUCT_FTDI_LINX_MASTER2	0xf449		/* Master Development 2.0 */
#define	USB_PRODUCT_FTDI_LINX_1	0xf44a		/* Serial */
#define	USB_PRODUCT_FTDI_LINX_2	0xf44b		/* Serial */
#define	USB_PRODUCT_FTDI_LINX_3	0xf44c		/* Serial */
#define	USB_PRODUCT_FTDI_OCEANIC	0xf460		/* Oceanic instrument */
#define	USB_PRODUCT_FTDI_SUUNTO	0xf680		/* Suunto Sports */
#define	USB_PRODUCT_FTDI_USBUIRT	0xf850		/* USB-UIRT */
#define	USB_PRODUCT_FTDI_USBX_707	0xf857		/* USBX-707 */
#define	USB_PRODUCT_FTDI_CCS_ICDU20	0xf9d0		/* ICD-U20 */
#define	USB_PRODUCT_FTDI_CCS_ICDU40	0xf9d1		/* ICD-U40 */
#define	USB_PRODUCT_FTDI_CCS_MACHX	0xf9d2		/* MACH-X */
#define	USB_PRODUCT_FTDI_CCS_LOAD_N_GO	0xf9d3		/* LOAD N GO */
#define	USB_PRODUCT_FTDI_CCS_ICDU64	0xf9d4		/* ICDU64 */
#define	USB_PRODUCT_FTDI_CCS_PRIME8	0xf9d5		/* PRIME8 */
#define	USB_PRODUCT_FTDI_ITM_TOUCH	0xf9e9		/* ITM Touchscreen */
#define	USB_PRODUCT_FTDI_USBSERIAL	0xfa00		/* Matrix Orbital USB Serial */
#define	USB_PRODUCT_FTDI_LCD_MX200	0xfa01		/* Matrix Orbital MX200 Series LCD */
#define	USB_PRODUCT_FTDI_LCD_MTXO	0xfa02		/* Matrix Orbital LCD */
#define	USB_PRODUCT_FTDI_LCD_LK202_24	0xfa03		/* Matrix Orbital LK202-24 LCD */
#define	USB_PRODUCT_FTDI_LCD_LK204_24	0xfa04		/* Matrix Orbital LK204-24 LCD */
#define	USB_PRODUCT_FTDI_MATRIX_2	0xfa05		/* Matrix Orbital LCD */
#define	USB_PRODUCT_FTDI_MATRIX_3	0xfa06		/* Matrix Orbital LCD */
#define	USB_PRODUCT_FTDI_RELAIS	0xfa10		/* Relais */
#define	USB_PRODUCT_FTDI_TIRA1	0xfa78		/* Tira-1 */
#define	USB_PRODUCT_FTDI_PCDJ_DAC2	0xfa88		/* DAC-2 */
#define	USB_PRODUCT_FTDI_ACCESSO	0xfad0		/* Accesso reader */
#define	USB_PRODUCT_FTDI_THORLABS	0xfaf0		/* Serial */
#define	USB_PRODUCT_FTDI_ELV_UR100	0xfb58		/* UR 100 */
#define	USB_PRODUCT_FTDI_ELV_CLI7000	0xfb59		/* CLI 7000 */
#define	USB_PRODUCT_FTDI_ELV_UM100	0xfb5a		/* UM 100 */
#define	USB_PRODUCT_FTDI_ELV_UO100	0xfb5b		/* UO 100 */
#define	USB_PRODUCT_FTDI_ELV_PPS7330	0xfb5c		/* PPS 7330 */
#define	USB_PRODUCT_FTDI_ELV_TFM100	0xfb5d		/* TFM 100 */
#define	USB_PRODUCT_FTDI_ELV_UDF77	0xfb5e		/* UDF 77 */
#define	USB_PRODUCT_FTDI_ELV_UIO88	0xfb5f		/* UIO 88 */
#define	USB_PRODUCT_FTDI_R2000KU_RNG	0xfb80		/* R2000KU RNG */
#define	USB_PRODUCT_FTDI_BCS_SE923	0xfb99		/* BCS SE923 */
#define	USB_PRODUCT_FTDI_FT232RL	0xfbfa		/* FT232RL */
#define	USB_PRODUCT_FTDI_LCD_CFA_632	0xfc08		/* Crystalfontz CFA-632 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_634	0xfc09		/* Crystalfontz CFA-634 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_547	0xfc0a		/* Crystalfontz CFA-547 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_633	0xfc0b		/* Crystalfontz CFA-633 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_631	0xfc0c		/* Crystalfontz CFA-631 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_635	0xfc0d		/* Crystalfontz CFA-635 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_640	0xfc0e		/* Crystalfontz CFA-640 LCD */
#define	USB_PRODUCT_FTDI_LCD_CFA_642	0xfc0f		/* Crystalfontz CFA-642 LCD */
#define	USB_PRODUCT_FTDI_IRTRANS	0xfc60		/* Serial */
#define	USB_PRODUCT_FTDI_PROTEGO_1	0xfc70		/* Protego */
#define	USB_PRODUCT_FTDI_PROTEGO_R200	0xfc71		/* R200-USB TRNG */
#define	USB_PRODUCT_FTDI_PROTEGO_3	0xfc72		/* Protego */
#define	USB_PRODUCT_FTDI_PROTEGO_4	0xfc73		/* Protego */
#define	USB_PRODUCT_FTDI_SEMC_DSS20	0xfc82		/* SEMC DSS-20 SyncStation */
#define	USB_PRODUCT_FTDI_CANVIEW	0xfd60		/* CANview */
#define	USB_PRODUCT_FTDI_VNHC	0xfe38		/* Modem */
#define	USB_PRODUCT_FTDI_AMC232	0xff00		/* AMC-232USB0 */
#define	USB_PRODUCT_FTDI_TTUSB	0xff20		/* TT-USB */
#define	USB_PRODUCT_FTDI_IBS_US485	0xff38		/* US485 */
#define	USB_PRODUCT_FTDI_IBS_PICPRO	0xff39		/* PIC-Programmer */
#define	USB_PRODUCT_FTDI_IBS_PCMCIA	0xff3a		/* PCMCIA SRAM-cards reader */
#define	USB_PRODUCT_FTDI_IBS_PK1	0xff3b		/* Particel counter PK1 */
#define	USB_PRODUCT_FTDI_IBS_RS232MON	0xff3c		/* RS232 */
#define	USB_PRODUCT_FTDI_IBS_APP70	0xff3d		/* APP 70 dust monitoring */
#define	USB_PRODUCT_FTDI_IBS_PEDO	0xff3e		/* IBS PEDO-Modem */
#define	USB_PRODUCT_FTDI_IBS_1	0xff3f		/* Serial */
#define	USB_PRODUCT_FTDI_CANUSB	0xffa8		/* CANUSB */

/* Fuji photo products */
#define	USB_PRODUCT_FUJIPHOTO_MASS0100	0x0100		/* Mass Storage */

/* Fujitsu products */
#define	USB_PRODUCT_FUJITSU_AH_F401U	0x105b		/* AH-F401U Air H device */

/* Fujitsu Component products */
#define	USB_PRODUCT_FUJITSUCOMP_KEYBOARD6	0x0005		/* Type 6 Keyboard */
#define	USB_PRODUCT_FUJITSUCOMP_KEYBOARD7	0x00a2		/* Type 7 Keyboard */
/* XXX The above is a North American PC style keyboard possibly */
#define	USB_PRODUCT_FUJITSUCOMP_MOUSE	0x0100		/* Type 6 Mouse */
#define	USB_PRODUCT_FUJITSUCOMP_FX5204PS	0x0423		/* Smart Power Strip FX-5204PS */
#define	USB_PRODUCT_FUJITSUCOMP_FX5251WB	0x042a		/* Base Station FX-5251WB */
#define	USB_PRODUCT_FUJITSUCOMP_VIRTETH	0xa4a2		/* Virtual Eth Device */

/* Fujitsu Siemens Computers products */
#define	USB_PRODUCT_FSC_E5400	0x1009		/* PrismGT USB 2.0 WLAN */

/* Fushicai */
#define	USB_PRODUCT_FUSHICAI_USBTV007	0x3002		/* Fushicai Audio-Video Grabber */

/* G.Mate */
#define	USB_PRODUCT_GMATE_YP3X00	0x1001		/* YP3X00 PDA */

/* Garmin International products */
#define	USB_PRODUCT_GARMIN_GPSMAP60CSX	0x0003		/* GPSmap 60Csx */
#define	USB_PRODUCT_GARMIN_IQUE3600	0x0004		/* Ique 3600 */
#define	USB_PRODUCT_GARMIN_DAKOTA20	0x23c0		/* Dakota 20 */
#define	USB_PRODUCT_GARMIN_GPSMAP62S	0x2459		/* GPSmap 62s */

/* GCT Semiconductor products */
#define	USB_PRODUCT_GCTSEMICON_INSTALL	0x7f40		/* GDM720x MASS storage mode */

/* GEMPLUS products */
#define	USB_PRODUCT_GEMPLUS_PROXPU	0x5501		/* Prox-PU/CU */

/* Genesys Logic products */
#define	USB_PRODUCT_GENESYS_GL620USB_A	0x0502		/* GL620USB-A GeneLink USB-USB Bridge */
#define	USB_PRODUCT_GENESYS_GENELINK	0x05e3		/* GeneLink Host-Host Bridge */
#define	USB_PRODUCT_GENESYS_GL650	0x0604		/* GL650 Hub */
#define	USB_PRODUCT_GENESYS_GL641USB	0x0700		/* GL641USB CompactFlash */

/* GIGABYTE products */
#define	USB_PRODUCT_GIGABYTE_GNBR402W	0x8002		/* GN-BR402W */
#define	USB_PRODUCT_GIGABYTE_GNWLBM101	0x8003		/* GN-WLBM101 */
#define	USB_PRODUCT_GIGABYTE_GNWBKG	0x8007		/* GN-WBKG */
#define	USB_PRODUCT_GIGABYTE_GNWB01GS	0x8008		/* GN-WB01GS */
#define	USB_PRODUCT_GIGABYTE_GNWI05GS	0x800a		/* GN-WI05GS */
#define	USB_PRODUCT_GIGABYTE_RT2870_1	0x800b		/* RT2870 */
#define	USB_PRODUCT_GIGABYTE_GNWB31N	0x800c		/* GN-WB31N */
#define	USB_PRODUCT_GIGABYTE_GNWB32L	0x800d		/* GN-WB32L */

/* Gigaset products */
#define	USB_PRODUCT_GIGASET_WLAN	0x0701		/* WLAN */
#define	USB_PRODUCT_GIGASET_SMCWUSBTG	0x0710		/* SMCWUSBT-G */
#define	USB_PRODUCT_GIGASET_SMCWUSBTG_NF	0x0711		/* SMCWUSBT-G */
#define	USB_PRODUCT_GIGASET_AR5523	0x0712		/* AR5523 */
#define	USB_PRODUCT_GIGASET_AR5523_NF	0x0713		/* AR5523 */
#define	USB_PRODUCT_GIGASET_RT2573	0x0722		/* RT2573 */
#define	USB_PRODUCT_GIGASET_RT3070_1	0x0740		/* RT3070 */
#define	USB_PRODUCT_GIGASET_RT3070_2	0x0744		/* RT3070 */

/* Global Sun Technology product */
#define	USB_PRODUCT_GLOBALSUN_AR5523_1	0x7801		/* AR5523 */
#define	USB_PRODUCT_GLOBALSUN_AR5523_1_NF	0x7802		/* AR5523 */
#define	USB_PRODUCT_GLOBALSUN_AR5523_2	0x7811		/* AR5523 */
#define	USB_PRODUCT_GLOBALSUN_AR5523_2_NF	0x7812		/* AR5523 */

/* Globespan products */
#define	USB_PRODUCT_GLOBESPAN_PRISM_GT_1	0x2000		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_GLOBESPAN_PRISM_GT_2	0x2002		/* PrismGT USB 2.0 WLAN */

/* GN Otometrics products */
#define	USB_PRODUCT_GNOTOMETRICS_AURICAL	0x0010		/* Aurical */

/* GoHubs products */
#define	USB_PRODUCT_GOHUBS_GOCOM232	0x1001		/* GoCOM232 Serial converter */

/* Good Way Technology products */
#define	USB_PRODUCT_GOODWAY_GWUSB2E	0x6200		/* GWUSB2E */
#define	USB_PRODUCT_GOODWAY_RT2573	0xc019		/* RT2573 */

/* Gravis products */
#define	USB_PRODUCT_GRAVIS_GAMEPADPRO	0x4001		/* GamePad Pro */

/* GREENHOUSE products */
#define	USB_PRODUCT_GREENHOUSE_KANA21	0x0001		/* CF-writer/MP3 Player */

/* Griffin Technology */
#define	USB_PRODUCT_GRIFFIN_IMATE	0x0405		/* iMate, ADB adapter */

/* Gude ADS */
#define	USB_PRODUCT_GUDE_DCF	0xdcf7		/* Expert mouseCLOCK USB */

/* Guillemot Corporation */
#define	USB_PRODUCT_GUILLEMOT_DALEADER	0xa300		/* DA Leader */
#define	USB_PRODUCT_GUILLEMOT_HWGUSB254	0xe000		/* HWGUSB2-54 WLAN */
#define	USB_PRODUCT_GUILLEMOT_HWGUSB254LB	0xe010		/* HWGUSB2-54-LB */
#define	USB_PRODUCT_GUILLEMOT_HWGUSB254V2AP	0xe020		/* HWGUSB2-54V2-AP */
#define	USB_PRODUCT_GUILLEMOT_HWNU300	0xe030		/* HWNU-300 */
#define	USB_PRODUCT_GUILLEMOT_HWNUM300	0xe031		/* HWNUm-300 */
#define	USB_PRODUCT_GUILLEMOT_HWGUN54	0xe032		/* HWGUn-54 */
#define	USB_PRODUCT_GUILLEMOT_HWNUP150	0xe033		/* HWNUP-150 */
#define	USB_PRODUCT_GUILLEMOT_RTL8192CU	0xe035		/* RTL8192CU */

/* Gunze Gunze Electronics USA */
#define	USB_PRODUCT_GUNZE_TOUCHPANEL	0x0001		/* Gunze USB Touch Panel */

/* Hagiwara products */
#define	USB_PRODUCT_HAGIWARA_FGSM	0x0002		/* FlashGate SmartMedia */
#define	USB_PRODUCT_HAGIWARA_FGCF	0x0003		/* FlashGate CompactFlash */
#define	USB_PRODUCT_HAGIWARA_FG	0x0005		/* FlashGate */

/* HAL Corporation products */
#define	USB_PRODUCT_HAL_IMR001	0x0011		/* Crossam2+USB IR commander */

/* Handspring, Inc. */
#define	USB_PRODUCT_HANDSPRING_VISOR	0x0100		/* Handspring Visor */
#define	USB_PRODUCT_HANDSPRING_TREO	0x0200		/* Handspring Treo */
#define	USB_PRODUCT_HANDSPRING_TREO600	0x0300		/* Handspring Treo 600 */

/* Hauppauge Computer Works */
#define	USB_PRODUCT_HAUPPAUGE_WINTV_USB_FM	0x4d12		/* WinTV FM */

/* Hawking Technologies products */
#define	USB_PRODUCT_HAWKING_RT2870_1	0x0001		/* RT2870 */
#define	USB_PRODUCT_HAWKING_RT2870_2	0x0003		/* RT2870 */
#define	USB_PRODUCT_HAWKING_HWUN2	0x0009		/* HWUN2 */
#define	USB_PRODUCT_HAWKING_HWDN2	0x000b		/* HWDN2 */
#define	USB_PRODUCT_HAWKING_RT2870_3	0x0013		/* RT2870 */
#define	USB_PRODUCT_HAWKING_RTL8192SU_1	0x0015		/* RTL8192SU */
#define	USB_PRODUCT_HAWKING_RTL8192SU_2	0x0016		/* RTL8192SU */
#define	USB_PRODUCT_HAWKING_RT2870_4	0x0017		/* RT2870 */
#define	USB_PRODUCT_HAWKING_RT2870_5	0x0018		/* RT2870 */
#define	USB_PRODUCT_HAWKING_RTL8192CU	0x0019		/* RTL8192CU */
#define	USB_PRODUCT_HAWKING_RTL8192CU_2	0x0020		/* RTL8192CU */
#define	USB_PRODUCT_HAWKING_UF100	0x400c		/* 10/100 Ethernet */
#define	USB_PRODUCT_ABOCOM_UF200	0x420a		/* UF200 Ethernet */

/* Hirose products */
#define	USB_PRODUCT_HIROSE_USB100	0x9601		/* USB-100 */

/* Hitachi, Ltd. products */
#define	USB_PRODUCT_HITACHI_DZMV100A	0x0004		/* DVD-CAM DZ-MV100A Camcorder */

/* Holtek Semiconductor, Inc. */
#define	USB_PRODUCT_HOLTEK_MOUSE	0x0499		/* Mouse */

/* HP products */
#define	USB_PRODUCT_HP_895C	0x0004		/* DeskJet 895C */
#define	USB_PRODUCT_HP_4100C	0x0101		/* Scanjet 4100C */
#define	USB_PRODUCT_HP_S20	0x0102		/* Photosmart S20 */
#define	USB_PRODUCT_HP_880C	0x0104		/* DeskJet 880C */
#define	USB_PRODUCT_HP_4200C	0x0105		/* ScanJet 4200C */
#define	USB_PRODUCT_HP_CDWRITERPLUS	0x0107		/* CD-Writer Plus */
#define	USB_PRODUCT_HP_KBDHUB	0x010c		/* Multimedia Keyboard Hub */
#define	USB_PRODUCT_HP_HN210W	0x011c		/* HN210W */
#define	USB_PRODUCT_HP_HPX9GP	0x0121		/* HP-x9G+ */
#define	USB_PRODUCT_HP_6200C	0x0201		/* ScanJet 6200C */
#define	USB_PRODUCT_HP_S20b	0x0202		/* PhotoSmart S20 */
#define	USB_PRODUCT_HP_815C	0x0204		/* DeskJet 815C */
#define	USB_PRODUCT_HP_3300C	0x0205		/* ScanJet 3300C */
#define	USB_PRODUCT_HP_CDW8200	0x0207		/* CD-Writer Plus 8200e */
#define	USB_PRODUCT_HP_1220C	0x0212		/* DeskJet 1220C */
#define	USB_PRODUCT_HP_810C	0x0304		/* DeskJet 810C/812C */
#define	USB_PRODUCT_HP_4300C	0x0305		/* Scanjet 4300C */
#define	USB_PRODUCT_HP_CD4E	0x0307		/* CD-Writer+ CD-4e */
#define	USB_PRODUCT_HP_G85XI	0x0311		/* OfficeJet G85xi */
#define	USB_PRODUCT_HP_1200	0x0317		/* LaserJet 1200 */
#define	USB_PRODUCT_HP_5200C	0x0401		/* Scanjet 5200C */
#define	USB_PRODUCT_HP_830C	0x0404		/* DeskJet 830C */
#define	USB_PRODUCT_HP_3400CSE	0x0405		/* ScanJet 3400cse */
#define	USB_PRODUCT_HP_885C	0x0504		/* DeskJet 885C */
#define	USB_PRODUCT_HP_1000	0x0517		/* LaserJet 1000 */
#define	USB_PRODUCT_HP_6300C	0x0601		/* Scanjet 6300C */
#define	USB_PRODUCT_HP_840C	0x0604		/* DeskJet 840c */
#define	USB_PRODUCT_HP_2200C	0x0605		/* ScanJet 2200C */
#define	USB_PRODUCT_HP_5300C	0x0701		/* Scanjet 5300C */
#define	USB_PRODUCT_HP_816C	0x0804		/* DeskJet 816C */
#define	USB_PRODUCT_HP_970CSE	0x1004		/* Deskjet 970Cse */
#define	USB_PRODUCT_HP_5400C	0x1005		/* Scanjet 5400C */
#define	USB_PRODUCT_HP_2215	0x1016		/* iPAQ 22xx/Jornada 548 */
#define	USB_PRODUCT_HP_959C	0x1104		/* Deskjet 959C */
#define	USB_PRODUCT_HP_568J	0x1116		/* Jornada 568 */
#define	USB_PRODUCT_HP_930C	0x1204		/* DeskJet 930c */
#define	USB_PRODUCT_HP_1005	0x1317		/* LaserJet 1005 */
#define	USB_PRODUCT_HP_P2000U	0x1801		/* Inkjet P-2000U */
#define	USB_PRODUCT_HP_HS2300	0x1e1d		/* HS2300 */
#define	USB_PRODUCT_HP_T750	0x1f06		/* T750 UPS */
#define	USB_PRODUCT_HP_T1000	0x1f08		/* T1000 UPS */
#define	USB_PRODUCT_HP_T1500	0x1f09		/* T1500 UPS */
#define	USB_PRODUCT_HP_RT2200	0x1f0a		/* R/T2200 UPS */
#define	USB_PRODUCT_HP_R1500G2	0x1fe0		/* R1500 G2 UPS */
#define	USB_PRODUCT_HP_T750G2	0x1fe1		/* T750 G2 UPS */
#define	USB_PRODUCT_HP_640C	0x2004		/* DeskJet 640c */
#define	USB_PRODUCT_HP_1020	0x2b17		/* LaserJet 1020 */
#define	USB_PRODUCT_HP_P1100	0x3102		/* Photosmart P1100 */
#define	USB_PRODUCT_HP_1018	0x4117		/* LaserJet 1018 */
#define	USB_PRODUCT_HP_HN210E	0x811c		/* HN210E Ethernet */

/* HP products */
#define	USB_PRODUCT_HP3_RTL8188CU	0x1629		/* RTL8188CU */
#define	USB_PRODUCT_HP2_C500	0x6002		/* PhotoSmart C500 */

/* HTC products */
#define	USB_PRODUCT_HTC_PPC6700MODEM	0x00cf		/* PPC6700 Modem */
#define	USB_PRODUCT_HTC_SMARTPHONE	0x0a51		/* SmartPhone */
#define	USB_PRODUCT_HTC_ANDROID	0x0ffe		/* Android phone */

/* HUAWEI products */
#define	USB_PRODUCT_HUAWEI_E618	0x1001		/* HUAWEI Mobile E618 */
#define	USB_PRODUCT_HUAWEI_E220	0x1003		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_Mobile	0x1008		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_EM770W	0x1404		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_E1750	0x1406		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_E180	0x140c		/* HUAWEI Mobile E180 */
#define	USB_PRODUCT_HUAWEI_E510	0x1411		/* HUAWEI Mobile E510 */
#define	USB_PRODUCT_HUAWEI_E181	0x1414		/* HUAWEI Mobile E181 */
#define	USB_PRODUCT_HUAWEI_E1752	0x1417		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_E182	0x1429		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_E161	0x1446		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_K3765	0x1465		/* HUAWEI Mobile K3765 */
#define	USB_PRODUCT_HUAWEI_E1820	0x14ac		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_K4510	0x14c5		/* HUAWEI Mobile Modem */
#define	USB_PRODUCT_HUAWEI_K4511	0x14b7		/* HUAWEI Mobile Modem K4511 */
#define	USB_PRODUCT_HUAWEI_E353_INIT	0x14fe		/* HUAWEI Mobile E353 Initial */
#define	USB_PRODUCT_HUAWEI_E392_INIT	0x1505		/* HUAWEI Mobile E392 Initial */
#define	USB_PRODUCT_HUAWEI_K3765_INIT	0x1520		/* HUAWEI Mobile K3765 Initial */
#define	USB_PRODUCT_HUAWEI_MU609	0x1573		/* HUAWEI Mobile ME906 */
#define	USB_PRODUCT_HUAWEI_E173S	0x1c05		/* HUAWEI Mobile E173s */
#define	USB_PRODUCT_HUAWEI_E173S_INIT	0x1c0b		/* HUAWEI Mobile E173s Initial */
#define	USB_PRODUCT_HUAWEI_E303	0x1f01		/* HUAWEI Mobile E303 */

/* HUMAX products */
#define	USB_PRODUCT_HUMAX_PVRSMART	0x138c		/* PVR-SMART */

/* Hyundai CuriTel (Audiovox, Pantech) products */
#define	USB_PRODUCT_HYUNDAI_PC5740	0x3701		/* PC5740 EVDO */
#define	USB_PRODUCT_HYUNDAI_UM175	0x3714		/* UM175 EVDO */

/* IBM Corporation */
#define	USB_PRODUCT_IBM_OPTTRAVELMOUSE	0x3107		/* Optical */
#define	USB_PRODUCT_IBM_OPTWHEELMOUSE	0x310b		/* Wheel */
#define	USB_PRODUCT_IBM_USBCDROMDRIVE	0x4427		/* CD-ROM */
#define	USB_PRODUCT_IBM_THINKPADHUB	0x4484		/* Hub */

/* id Quantique */
#define	USB_PRODUCT_IDQUANTIQUE_QUANTISUSB	0x0102		/* Quantis USB */

/* Icom, Inc. */
#define	USB_PRODUCT_ICOM_ID1	0x0004		/* ID-1 */
#define	USB_PRODUCT_ICOM_RP2C1	0x0009		/* ID-RP2C service 1 */
#define	USB_PRODUCT_ICOM_RP2C2	0x000a		/* ID-RP2C service 2 */
#define	USB_PRODUCT_ICOM_RP2D	0x000b		/* ID-RP2D */
#define	USB_PRODUCT_ICOM_RP2VT	0x000c		/* ID-RP2V service T */
#define	USB_PRODUCT_ICOM_RP2VR	0x000d		/* ID-RP2V service R */
#define	USB_PRODUCT_ICOM_RP4000VT	0x0010		/* ID-RP4000V service T */
#define	USB_PRODUCT_ICOM_RP4000VR	0x0011		/* ID-RP4000V service R */
#define	USB_PRODUCT_ICOM_RP2000VT	0x0012		/* ID-RP2000V service T */
#define	USB_PRODUCT_ICOM_RP2000VR	0x0013		/* ID-RP2000V service R */

/* iDowell products */
#define	USB_PRODUCT_IDOWELL_IDOWELL	0x0300		/* UPS */

/* ID TECH products */
#define	USB_PRODUCT_IDTECH_SERIAL	0x0300		/* Serial */

/* Iiyama products */
#define	USB_PRODUCT_IIYAMA_HUB	0x0201		/* Hub */

/* Imation */
#define	USB_PRODUCT_IMATION_FLASHGO	0xb000		/* Flash Go! */

/* Inside Out Networks products */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT4	0x0001		/* EdgePort/4 RS232 */
#define	USB_PRODUCT_INSIDEOUT_HUBPORT7	0x0002		/* Hubport/7 */
#define	USB_PRODUCT_INSIDEOUT_RAPIDPORT4	0x0003		/* Rapidport/4 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT4T	0x0004		/* Edgeport/4 RS232 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT2	0x0005		/* Edgeport/2 RS232 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT4I	0x0006		/* Edgeport/4 RS422 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT2I	0x0007		/* Edgeport/2 RS422/RS485 */
#define	USB_PRODUCT_INSIDEOUT_HUBPORT4	0x0008		/* Hubport/4 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT8HAND	0x0009		/* Hand-built Edgeport/8 */
#define	USB_PRODUCT_INSIDEOUT_MULTIMODEM	0x000A		/* MultiTech version of RP/4 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORTPPORT	0x000B		/* Edgeport/(4)21 Parallel */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT421	0x000C		/* Edgeport/421 Hub+RS232+Parallel */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT21	0x000D		/* Edgeport/21 RS232+Parallel */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT8DC	0x000E		/* 1/2 Edgeport/8 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT8	0x000F		/* Edgeport/8 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT2DIN	0x0010		/* Edgeport/2 RS232/DIN */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT4DIN	0x0011		/* Edgeport/4 RS232/DIN */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT16DC	0x0012		/* 1/2 Edgeport/16 */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORTCOMP	0x0013		/* Edgeport Compatible */
#define	USB_PRODUCT_INSIDEOUT_EDGEPORT8I	0x0014		/* Edgeport/8 RS422 */
#define	USB_PRODUCT_INSIDEOUT_WATCHPORTH	0x0305		/* WatchPort/H */
#define	USB_PRODUCT_INSIDEOUT_MT4X56USB	0x1403		/* OEM device */

/* In-System products */
#define	USB_PRODUCT_INSYSTEM_F5U002	0x0002		/* Parallel */
#define	USB_PRODUCT_INSYSTEM_ATAPI	0x0031		/* ATAPI */
#define	USB_PRODUCT_INSYSTEM_IDEUSB2	0x0060		/* USB2 Storage */
#define	USB_PRODUCT_INSYSTEM_ISD110	0x0200		/* IDE ISD110 */
#define	USB_PRODUCT_INSYSTEM_ISD105	0x0202		/* IDE ISD105 */
#define	USB_PRODUCT_INSYSTEM_DRIVEV2	0x0301		/* Portable USB Harddrive V2 */
#define	USB_PRODUCT_INSYSTEM_DRIVEV2_5	0x0351		/* Portable USB Harddrive V2 */
#define	USB_PRODUCT_INSYSTEM_USBCABLE	0x081a		/* USB cable */
#define	USB_PRODUCT_INSYSTEM_ADAPTERV2	0x5701		/* USB Storage Adapter V2 */

/* Intel products */
#define	USB_PRODUCT_INTEL2_RMH_1	0x0020		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_2	0x0024		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL_EASYPC_CAMERA	0x0110		/* EasyPC */
#define	USB_PRODUCT_INTEL_AP310	0x0200		/* AP310 AnyPoint II */
#define	USB_PRODUCT_INTEL_I2011B	0x1111		/* Wireless 2011B */
#define	USB_PRODUCT_INTEL2_RMH_3	0x8000		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_5	0x8001		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_7	0x8002		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_4	0x8008		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_6	0x8009		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL2_RMH_8	0x800a		/* Rate Matching Hub */
#define	USB_PRODUCT_INTEL_TESTBOARD	0x9890		/* 82930 test board */
#define	USB_PRODUCT_INTEL2_BLUETOOTH	0x0a2a		/* Bluetooth */
#define	USB_PRODUCT_INTEL2_BLUETOOTH2	0x0a2b		/* Bluetooth */

/* InterBiometrics products */
#define	USB_PRODUCT_INTERBIO_IOBOARD	0x1002		/* IO Board */
#define	USB_PRODUCT_INTERBIO_MINIIOBOARD	0x1003		/* Mini IO Board */
#define	USB_PRODUCT_INTERBIO_MINIIOBOARD2	0x1006		/* Mini IO Board */

/* Intersil products */
#define	USB_PRODUCT_INTERSIL_PRISM_GT	0x1000		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_INTERSIL_PRISM_2X	0x3642		/* Prism2.x WLAN */

/* Interpid Control Systems products */
#define	USB_PRODUCT_INTREPIDCS_VALUECAN	0x0601		/* ValueCAN */
#define	USB_PRODUCT_INTREPIDCS_NEOVI	0x0701		/* NeoVI Blue */

/* I/O DATA products */
#define	USB_PRODUCT_IODATA_USBSSMRW	0x0314		/* USB-SSMRW SD-card */
#define	USB_PRODUCT_IODATA_USBSDRW	0x031e		/* USB-SDRW SD-card */
#define	USB_PRODUCT_IODATA_USBETT	0x0901		/* USB ET/T */
#define	USB_PRODUCT_IODATA_USBETTX	0x0904		/* USB ET/TX */
#define	USB_PRODUCT_IODATA_USBETTXS	0x0913		/* USB ET/TX-S */
#define	USB_PRODUCT_IODATA_USBWNB11A	0x0919		/* USB WN-B11 */
#define	USB_PRODUCT_IODATA_USBWNB11	0x0922		/* USB Airport WN-B11 */
#define	USB_PRODUCT_IODATA_USBWNG54US	0x0928		/* USB WN-G54/US */
#define	USB_PRODUCT_IODATA_USBWNG54US_NF	0x0929		/* USB WN-G54/US */
#define	USB_PRODUCT_IODATA_ETXUS2	0x092a		/* ETX-US2 */
#define	USB_PRODUCT_IODATA_ETGUS2	0x0930		/* ETG-US2 */
#define	USB_PRODUCT_IODATA_FT232R	0x093c		/* FT232R */
#define	USB_PRODUCT_IODATA_WNGDNUS2	0x093f		/* WN-GDN/US2 */
#define	USB_PRODUCT_IODATA_RT3072_1	0x0944		/* RT3072 */
#define	USB_PRODUCT_IODATA_RT3072_2	0x0945		/* RT3072 */
#define	USB_PRODUCT_IODATA_RT3072_3	0x0947		/* RT3072 */
#define	USB_PRODUCT_IODATA_RT3072_4	0x0948		/* RT3072 */
#define	USB_PRODUCT_IODATA_WNG150UM	0x094c		/* WN-G150UM */
#define	USB_PRODUCT_IODATA_RTL8192CU	0x0950		/* RTL8192CU */
#define	USB_PRODUCT_IODATA_USBRSAQ	0x0a03		/* RSAQ1 Serial */
#define	USB_PRODUCT_IODATA2_USB2SC	0x0a09		/* USB2.0-SCSI Bridge USB2-SC */
#define	USB_PRODUCT_IODATA_USBRSAQ5	0x0a0e		/* RSAQ5 Serial */

/* Iomega products */
#define	USB_PRODUCT_IOMEGA_ZIP100	0x0001		/* Zip 100 */
#define	USB_PRODUCT_IOMEGA_ZIP250	0x0030		/* Zip 250 */
#define	USB_PRODUCT_IOMEGA_ZIP250_2	0x0032		/* Zip 250 */
#define	USB_PRODUCT_IOMEGA_CDRW	0x0055		/* CDRW 9602 */

/* iRiver products */
#define	USB_PRODUCT_IRIVER_IFP_1XX	0x1101		/* iFP-1xx */
#define	USB_PRODUCT_IRIVER_IFP_3XX	0x1103		/* iFP-3xx */
#define	USB_PRODUCT_IRIVER_IFP_5XX	0x1105		/* iFP-5xx */

/* iTegno products */
#define	USB_PRODUCT_ITEGNO_WM1080A	0x1080		/* WM1080A */

/* Ituner (mini-box.com) products */
#define	USB_PRODUCT_ITUNER_USBLCD20x2	0x0002		/* USB-LCD-20x2 */
#define	USB_PRODUCT_ITUNER_USBLCD256x64	0xc002		/* USB-LCD-256x64 */

/* Jablotron products */
#define	USB_PRODUCT_JABLOTRON_PC60B	0x0001		/* PC-60B */

/* Jaton products */
#define	USB_PRODUCT_JATON_EDA	0x5704		/* Ethernet */

/* Jenoptik products */
#define	USB_PRODUCT_JENOPTIK_JD350	0x5300		/* JD 350 */

/* JETI Technische Instrumente GmbH products */
#define	USB_PRODUCT_JETI_SPC1201	0x04b2		/* SPECBOS 1201 */

/* JRC products */
#define	USB_PRODUCT_JRC_AH_J3001V_J3002V	0x0001		/* AirH\"PHONE AH-J3001V/J3002V */

/* JVC products */
#define	USB_PRODUCT_JVC_MP_XP7250_WL	0x3009		/* MP-XP7250 Builtin WLAN */
#define	USB_PRODUCT_JVC_MP_PRX1	0x3008		/* MP-PRX1 */

/* Kamstrup products */
#define	USB_PRODUCT_KAMSTRUP_OPTICALEYE	0x0001		/* Optical Eye/3-wire */
#define	USB_PRODUCT_KAMSTRUP_MBUS_250D	0x0005		/* M-Bus Master MultiPort 250D */

/* Kawasaki LSI products */
#define	USB_PRODUCT_KLSI_DUH3E10BT	0x0008		/* 10BT Ethernet */
#define	USB_PRODUCT_KLSI_DUH3E10BTN	0x0009		/* 10BT Ethernet */

/* Kawatsu products */
#define	USB_PRODUCT_KAWATSU_MH4000P	0x0003		/* MiniHub 4000P */
#define	USB_PRODUCT_KAWATSU_KC180	0x0180		/* KC-180 IrDA */

/* Keisokugiken products */
#define	USB_PRODUCT_KEISOKUGIKEN_USBDAQ	0x0068		/* HKS-0200 USBDAQ */

/* Kensington products */
#define	USB_PRODUCT_KENSINGTON_ORBIT	0x1003		/* Orbit trackball */
#define	USB_PRODUCT_KENSINGTON_TURBOBALL	0x1005		/* TurboBall */
#define	USB_PRODUCT_KENSINGTON_ORBIT_MAC	0x1009		/* Orbit trackball for Mac */
#define	USB_PRODUCT_KENSINGTON_BT_EDR	0x105e		/* Bluetooth */
#define	USB_PRODUCT_KENSINGTON_VIDEOCAM_VGA	0x5002		/* VideoCAM VGA */

/* Keyspan products */
#define	USB_PRODUCT_KEYSPAN_USA28_NF	0x0101		/* USA-28 serial */
#define	USB_PRODUCT_KEYSPAN_USA28X_NF	0x0102		/* USA-28X serial */
#define	USB_PRODUCT_KEYSPAN_USA19_NF	0x0103		/* USA-19 serial */
#define	USB_PRODUCT_KEYSPAN_USA18_NF	0x0104		/* USA-18 serial */
#define	USB_PRODUCT_KEYSPAN_USA18X_NF	0x0105		/* USA-18X serial */
#define	USB_PRODUCT_KEYSPAN_USA19W_NF	0x0106		/* USA-19W serial */
#define	USB_PRODUCT_KEYSPAN_USA19	0x0107		/* USA-19 serial */
#define	USB_PRODUCT_KEYSPAN_USA19W	0x0108		/* USA-19W serial */
#define	USB_PRODUCT_KEYSPAN_USA49W_NF	0x0109		/* USA-49W serial */
#define	USB_PRODUCT_KEYSPAN_USA49W	0x010a		/* USA-49W serial */
#define	USB_PRODUCT_KEYSPAN_USA19QI_NF	0x010b		/* USA-19QI serial */
#define	USB_PRODUCT_KEYSPAN_USA19QI	0x010c		/* USA-19QI serial */
#define	USB_PRODUCT_KEYSPAN_USA19Q_NF	0x010d		/* USA-19Q serial */
#define	USB_PRODUCT_KEYSPAN_USA19Q	0x010e		/* USA-19Q serial */
#define	USB_PRODUCT_KEYSPAN_USA28	0x010f		/* USA-28 serial */
#define	USB_PRODUCT_KEYSPAN_USA28XXB	0x0110		/* USA-28X/XB serial */
#define	USB_PRODUCT_KEYSPAN_USA18	0x0111		/* USA-18 serial */
#define	USB_PRODUCT_KEYSPAN_USA18X	0x0112		/* USA-18X serial */
#define	USB_PRODUCT_KEYSPAN_USA28XB_NF	0x0113		/* USA-28XB serial */
#define	USB_PRODUCT_KEYSPAN_USA28XA_NF	0x0114		/* USA-28XB serial */
#define	USB_PRODUCT_KEYSPAN_USA28XA	0x0115		/* USA-28XA serial */
#define	USB_PRODUCT_KEYSPAN_USA18XA_NF	0x0116		/* USA-18XA serial */
#define	USB_PRODUCT_KEYSPAN_USA18XA	0x0117		/* USA-18XA serial */
#define	USB_PRODUCT_KEYSPAN_USA19QW_NF	0x0118		/* USA-19WQ serial */
#define	USB_PRODUCT_KEYSPAN_USA19QW	0x0119		/* USA-19WQ serial */
#define	USB_PRODUCT_KEYSPAN_UIA10	0x0201		/* UIA-10 remote control */
#define	USB_PRODUCT_KEYSPAN_UIA11	0x0202		/* UIA-11 remote control */

/* Kingston products */
#define	USB_PRODUCT_KINGSTON_XX1	0x0008		/* Ethernet */
#define	USB_PRODUCT_KINGSTON_KNU101TX	0x000a		/* KNU101TX Ethernet */

/* Kobil Systems products */
#define	USB_PRODUCT_KOBIL_B1	0x2020		/* Konverter for B1 */
#define	USB_PRODUCT_KOBIL_KAAN	0x2021		/* Konverter for KAAN */

/* Kodak products */
#define	USB_PRODUCT_KODAK_DC220	0x0100		/* Digital Science DC220 */
#define	USB_PRODUCT_KODAK_DC260	0x0110		/* Digital Science DC260 */
#define	USB_PRODUCT_KODAK_DC265	0x0111		/* Digital Science DC265 */
#define	USB_PRODUCT_KODAK_DC290	0x0112		/* Digital Science DC290 */
#define	USB_PRODUCT_KODAK_DC240	0x0120		/* Digital Science DC240 */
#define	USB_PRODUCT_KODAK_DC280	0x0130		/* Digital Science DC280 */
#define	USB_PRODUCT_KODAK_DX4900	0x0550		/* EasyShare DX4900 */

/* Konica Corp. Products */
#define	USB_PRODUCT_KONICA_CAMERA	0x0720		/* Camera */

/* KYE products */
#define	USB_PRODUCT_KYE_NICHE	0x0001		/* Niche mouse */
#define	USB_PRODUCT_KYE_NETSCROLL	0x0003		/* Genius NetScroll mouse */
#define	USB_PRODUCT_KYE_FLIGHT2000	0x1004		/* Flight 2000 joystick */
#define	USB_PRODUCT_KYE_VIVIDPRO	0x2001		/* ColorPage Vivid-Pro */

/* Kyocera products */
#define	USB_PRODUCT_KYOCERA_AHK3001V	0x0203		/* AH-K3001V */
#define	USB_PRODUCT_KYOCERA2_KPC650	0x17da		/* KPC650 EVDO */

/* LaCie products */
#define	USB_PRODUCT_LACIE_HD	0xa601		/* Hard Disk */
#define	USB_PRODUCT_LACIE_CDRW	0xa602		/* CD R/W */

/* Lake Shore products */
#define	USB_PRODUCT_LAKESHORE_M121	0x0100		/* Model 121 */
#define	USB_PRODUCT_LAKESHORE_M218A	0x0200		/* Model 218A */
#define	USB_PRODUCT_LAKESHORE_M219	0x0201		/* Model 219 */
#define	USB_PRODUCT_LAKESHORE_M233	0x0202		/* Model 233 */
#define	USB_PRODUCT_LAKESHORE_M235	0x0203		/* Model 235 */
#define	USB_PRODUCT_LAKESHORE_M335	0x0300		/* Model 335 */
#define	USB_PRODUCT_LAKESHORE_M336	0x0301		/* Model 336 */
#define	USB_PRODUCT_LAKESHORE_M350	0x0302		/* Model 350 */
#define	USB_PRODUCT_LAKESHORE_M371	0x0303		/* Model 371 */
#define	USB_PRODUCT_LAKESHORE_M411	0x0400		/* Model 411 */
#define	USB_PRODUCT_LAKESHORE_M425	0x0401		/* Model 425 */
#define	USB_PRODUCT_LAKESHORE_M455A	0x0402		/* Model 455A */
#define	USB_PRODUCT_LAKESHORE_M475A	0x0403		/* Model 475A */
#define	USB_PRODUCT_LAKESHORE_M465	0x0404		/* Model 465 */
#define	USB_PRODUCT_LAKESHORE_M625A	0x0600		/* Model 625A */
#define	USB_PRODUCT_LAKESHORE_M642A	0x0601		/* Model 642A */
#define	USB_PRODUCT_LAKESHORE_M648	0x0602		/* Model 648 */
#define	USB_PRODUCT_LAKESHORE_M737	0x0700		/* Model 737 */
#define	USB_PRODUCT_LAKESHORE_M776	0x0701		/* Model 776 */

/* Larsen and Brusgaard products */
#define	USB_PRODUCT_LARSENBRUSGAARD_ALTITRACK	0x0001		/* AltiTrack */

/* Leadtek products */
#define	USB_PRODUCT_LEADTEK_9531	0x2101		/* 9531 GPS */

/* Lenovo products */
#define	USB_PRODUCT_LENOVO_AX88179	0x304b		/* AX88179 */
#define	USB_PRODUCT_LENOVO_ETHERNET	0x7203		/* USB 2.0 Ethernet */

/* Lexar products */
#define	USB_PRODUCT_LEXAR_JUMPSHOT	0x0001		/* jumpSHOT CompactFlash */
#define	USB_PRODUCT_LEXAR_2662WAR	0xa002		/* 2662W-AR */

/* Lexmark products */
#define	USB_PRODUCT_LEXMARK_S2450	0x0009		/* Optra S 2450 */

/* Liebert products */
#define	USB_PRODUCT_LIEBERT_UPS	0xffff		/* UPS */
#define	USB_PRODUCT_LIEBERT2_PSA	0x0001		/* PowerSure PSA UPS */

/* Link Instruments products */
#define	USB_PRODUCT_LINKINSTRUMENTS_MSO19	0xf190		/* Link Instruments MSO-19 */
#define	USB_PRODUCT_LINKINSTRUMENTS_MSO28	0xf280		/* Link Instruments MSO-28 */
#define	USB_PRODUCT_LINKINSTRUMENTS_MSO28_2	0xf281		/* Link Instruments MSO-28 */

/* Linksys products */
#define	USB_PRODUCT_LINKSYS4_USB1000	0x0039		/* USB1000 */
#define	USB_PRODUCT_LINKSYS4_WUSB100	0x0070		/* WUSB100 */
#define	USB_PRODUCT_LINKSYS4_WUSB600N	0x0071		/* WUSB600N */
#define	USB_PRODUCT_LINKSYS4_WUSB54GCV2	0x0073		/* WUSB54GC v2 */
#define	USB_PRODUCT_LINKSYS4_WUSB54GCV3	0x0077		/* WUSB54GC v3 */
#define	USB_PRODUCT_LINKSYS4_RT3070	0x0078		/* RT3070 */
#define	USB_PRODUCT_LINKSYS4_WUSB600NV2	0x0079		/* WUSB600N v2 */
#define	USB_PRODUCT_LINKSYS_MAUSB2	0x0105		/* Camedia MAUSB-2 */
#define	USB_PRODUCT_LINKSYS_USB10TX1	0x200c		/* USB10TX */
#define	USB_PRODUCT_LINKSYS_HG20F9	0x20f9		/* HG20F9 Ethernet */
#define	USB_PRODUCT_LINKSYS_USB10T	0x2202		/* USB10T Ethernet */
#define	USB_PRODUCT_LINKSYS_USB100TX	0x2203		/* USB100TX Ethernet */
#define	USB_PRODUCT_LINKSYS_USB100H1	0x2204		/* USB100H1 Ethernet/HPNA */
#define	USB_PRODUCT_LINKSYS_USB10TA	0x2206		/* USB10TA Ethernet */
#define	USB_PRODUCT_LINKSYS_WUSB11	0x2211		/* WUSB11 802.11b */
#define	USB_PRODUCT_LINKSYS_WUSB11_25	0x2212		/* WUSB11 802.11b v2.5 */
#define	USB_PRODUCT_LINKSYS_WUSB12_11	0x2213		/* WUSB12 802.11b v1.1 */
#define	USB_PRODUCT_LINKSYS2_USB200M	0x2226		/* USB 2.0 10/100 Ethernet controller */
#define	USB_PRODUCT_LINKSYS2_WUSB11	0x2219		/* WUSB11 */
#define	USB_PRODUCT_LINKSYS2_NWU11B	0x2219		/* Network Everywhere NWU11B */
#define	USB_PRODUCT_LINKSYS3_WUSB11V28	0x2233		/* WUSB11 v2.8 */
#define	USB_PRODUCT_LINKSYS3_WUSB11V30	0x2236		/* WUSB11 v3.0 */
#define	USB_PRODUCT_LINKSYS_USB10TX2	0x400b		/* USB10TX */

/* Lite-On Technology */
#define	USB_PRODUCT_LITEON_AR9271	0x4605		/* AR9271 */

/* Logitec products */
#define	USB_PRODUCT_LOGITEC_LAN_GTJU2	0x0102		/* LAN-GTJ/U2 */
#define	USB_PRODUCT_LOGITEC_LANTX	0x0105		/* LAN-TX */
#define	USB_PRODUCT_LOGITEC_RTL8187	0x010c		/* RTL8187 */
#define	USB_PRODUCT_LOGITEC_RT2870_1	0x0162		/* RT2870 */
#define	USB_PRODUCT_LOGITEC_RT2870_2	0x0163		/* RT2870 */
#define	USB_PRODUCT_LOGITEC_RT2870_3	0x0164		/* RT2870 */
#define	USB_PRODUCT_LOGITEC_LANW300NU2	0x0166		/* LAN-W300N/U2 */
#define	USB_PRODUCT_LOGITEC_LANW150NU2	0x0168		/* LAN-W150N/U2 */
#define	USB_PRODUCT_LOGITEC_LANW300NU2S	0x0169		/* LAN-W300N/U2S */

/* Logitech products */
#define	USB_PRODUCT_LOGITECH_M2452	0x0203		/* M2452 keyboard */
#define	USB_PRODUCT_LOGITECH_M4848	0x0301		/* M4848 mouse */
#define	USB_PRODUCT_LOGITECH_PAGESCAN	0x040f		/* PageScan */
#define	USB_PRODUCT_LOGITECH_QUICKCAMWEB	0x0801		/* QuickCam Web */
#define	USB_PRODUCT_LOGITECH_WEBCAMC200	0x0802		/* Webcam C200 */
#define	USB_PRODUCT_LOGITECH_WEBCAMC500	0x0807		/* Webcam C500 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO	0x0810		/* QuickCam Pro */
#define	USB_PRODUCT_LOGITECH_WEBCAMC310	0x081b		/* Webcam C310 */
#define	USB_PRODUCT_LOGITECH_HDPROC910	0x0821		/* HD Pro Webcam C910 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMEXP	0x0840		/* QuickCam Express */
#define	USB_PRODUCT_LOGITECH_QUICKCAM	0x0850		/* QuickCam */
#define	USB_PRODUCT_LOGITECH_QUICKCAMNBDLX	0x08a9		/* QuickCam Notebook Deluxe */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO3K	0x08b0		/* QuickCam Pro 3000 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMNBPRO_1	0x08b1		/* QuickCam Notebook Pro */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO4K	0x08b2		/* QuickCam Pro 4000 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMZOOM	0x08b3		/* QuickCam Zoom */
#define	USB_PRODUCT_LOGITECH_QUICKCAMFUSION_1	0x08c1		/* QuickCam Fusion */
#define	USB_PRODUCT_LOGITECH_QUICKCAMORBITMP_1	0x08c2		/* QuickCam Orbit MP */
#define	USB_PRODUCT_LOGITECH_QUICKCAMNBPRO	0x08c3		/* QuickCam Notebook Pro */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO5K_1	0x08c5		/* QuickCam Pro 5000 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMOEM_1	0x08c6		/* QuickCam OEM */
#define	USB_PRODUCT_LOGITECH_QUICKCAMOEM_2	0x08c7		/* QuickCam OEM */
#define	USB_PRODUCT_LOGITECH_QUICKCAMULTVIS	0x08c9		/* QuickCam Ultra Vision */
#define	USB_PRODUCT_LOGITECH_QUICKCAMFUSION_2	0x08ca		/* QuickCam Fusion */
#define	USB_PRODUCT_LOGITECH_QUICKCAMNBPRO_2	0x08cb		/* QuickCam Notebook Pro */
#define	USB_PRODUCT_LOGITECH_QUICKCAMORBITMP_2	0x08cc		/* QuickCam Orbit MP */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO5K_2	0x08ce		/* QuickCam Pro 5000 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO9K	0x0990		/* QuickCam Pro 9000 */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRONB	0x0991		/* QuickCam Pro Notebook */
#define	USB_PRODUCT_LOGITECH_QUICKCAMCOMMDLX	0x0992		/* QuickCam Communicate Deluxe */
#define	USB_PRODUCT_LOGITECH_QUICKCAMORBITAF	0x0994		/* QuickCam Orbit AF */
#define	USB_PRODUCT_LOGITECH_QUICKCAMCOMMMP	0x09a1		/* QuickCam Communicate MP */
#define	USB_PRODUCT_LOGITECH_QUICKCAME3500P	0x09a4		/* QuickCam E 3500 Plus */
#define	USB_PRODUCT_LOGITECH_QUICKCAMDLXNB	0x09c1		/* QuickCam Deluxe Notebook */
#define	USB_PRODUCT_LOGITECH_N43	0xc000		/* N43 */
#define	USB_PRODUCT_LOGITECH_N48	0xc001		/* N48 mouse */
#define	USB_PRODUCT_LOGITECH_MBA47	0xc002		/* M-BA47 mouse */
#define	USB_PRODUCT_LOGITECH_WMMOUSE	0xc004		/* WingMan Gaming Mouse */
#define	USB_PRODUCT_LOGITECH_BD58	0xc00c		/* BD58 mouse */
#define	USB_PRODUCT_LOGITECH_UN58A	0xc030		/* iFeel Mouse */
#define	USB_PRODUCT_LOGITECH_WMPAD	0xc208		/* WingMan GamePad Extreme */
#define	USB_PRODUCT_LOGITECH_WMRPAD	0xc20a		/* WingMan RumblePad */
#define	USB_PRODUCT_LOGITECH_WMJOY	0xc281		/* WingMan Force joystick */
#define	USB_PRODUCT_LOGITECH_WMFFGP	0xc293		/* WingMan Formula Force GP (GT-Force) */
#define	USB_PRODUCT_LOGITECH_ITOUCH	0xc303		/* iTouch Keyboard */
#define	USB_PRODUCT_LOGITECH_BB13	0xc401		/* USB-PS/2 Trackball */
#define	USB_PRODUCT_LOGITECH_BB18	0xc404		/* TrackMan Wheel */
#define	USB_PRODUCT_LOGITECH_RK53	0xc501		/* Cordless mouse */
#define	USB_PRODUCT_LOGITECH_RB6	0xc503		/* Cordless keyboard */
#define	USB_PRODUCT_LOGITECH_CDO	0xc504		/* Cordless Desktop Optical */
#define	USB_PRODUCT_LOGITECH_QUICKCAMPRO2	0xd001		/* QuickCam Pro */

/* Longcheer products */
#define	USB_PRODUCT_LONGCHEER_D21LCMASS	0x9401		/* Emobile D21LC Mass only mode */
#define	USB_PRODUCT_LONGCHEER_D21LC	0x9404		/* Emobile D21LC */
#define	USB_PRODUCT_LONGCHEER_510FU	0x9801		/* IIJmobile 510FU */
#define	USB_PRODUCT_LONGCHEER_510FUMASS	0x98ff		/* IIJmobile 510FU Mass only mode */

/* Longshine products */
#define	USB_PRODUCT_ABOCOM_LCS8138TX	0x401a		/* LCS-8138TX */

/* Lucent products */
#define	USB_PRODUCT_LUCENT_EVALKIT	0x1001		/* USS-720 evaluation kit */

/* Macally products */
#define	USB_PRODUCT_MACALLY_MOUSE1	0x0101		/* mouse */

/* Marvell products */
#define	USB_PRODUCT_MARVELL_SHEEVAPLUG	0x9e8f		/* SheevaPlug */

/* Matrix Orbital products */
#define	USB_PRODUCT_MATRIXORB_LCD_0100	0x0100		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0101	0x0101		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0102	0x0102		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0103	0x0103		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0104	0x0104		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0105	0x0105		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0106	0x0106		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0107	0x0107		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0108	0x0108		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0109	0x0109		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010A	0x010a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010B	0x010b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010C	0x010c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010D	0x010d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010E	0x010e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_010F	0x010f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0110	0x0110		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0111	0x0111		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0112	0x0112		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0113	0x0113		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0114	0x0114		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0115	0x0115		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0116	0x0116		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0117	0x0117		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0118	0x0118		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0119	0x0119		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011A	0x011a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011B	0x011b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011C	0x011c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011D	0x011d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011E	0x011e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_011F	0x011f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0120	0x0120		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0121	0x0121		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0122	0x0122		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0123	0x0123		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0124	0x0124		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0125	0x0125		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0126	0x0126		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0127	0x0127		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0128	0x0128		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0129	0x0129		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012A	0x012a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012B	0x012b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012C	0x012c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012D	0x012d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012E	0x012e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_012F	0x012f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0130	0x0130		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0131	0x0131		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0132	0x0132		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0133	0x0133		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0134	0x0134		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0135	0x0135		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0136	0x0136		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0137	0x0137		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0138	0x0138		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0139	0x0139		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013A	0x013a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013B	0x013b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013C	0x013c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013D	0x013d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013E	0x013e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_013F	0x013f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0140	0x0140		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0141	0x0141		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0142	0x0142		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0143	0x0143		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0144	0x0144		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0145	0x0145		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0146	0x0146		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0147	0x0147		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0148	0x0148		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0149	0x0149		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014A	0x014a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014B	0x014b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014C	0x014c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014D	0x014d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014E	0x014e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_014F	0x014f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0150	0x0150		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0151	0x0151		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0152	0x0152		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0153	0x0153		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0154	0x0154		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0155	0x0155		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0156	0x0156		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0157	0x0157		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0158	0x0158		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0159	0x0159		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015A	0x015a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015B	0x015b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015C	0x015c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015D	0x015d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015E	0x015e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_015F	0x015f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0160	0x0160		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0161	0x0161		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0162	0x0162		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0163	0x0163		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0164	0x0164		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0165	0x0165		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0166	0x0166		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0167	0x0167		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0168	0x0168		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0169	0x0169		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016A	0x016a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016B	0x016b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016C	0x016c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016D	0x016d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016E	0x016e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_016F	0x016f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0170	0x0170		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0171	0x0171		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0172	0x0172		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0173	0x0173		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0174	0x0174		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0175	0x0175		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0176	0x0176		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0177	0x0177		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0178	0x0178		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0179	0x0179		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017A	0x017a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017B	0x017b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017C	0x017c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017D	0x017d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017E	0x017e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_017F	0x017f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0180	0x0180		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0181	0x0181		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0182	0x0182		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0183	0x0183		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0184	0x0184		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0185	0x0185		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0186	0x0186		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0187	0x0187		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0188	0x0188		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0189	0x0189		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018A	0x018a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018B	0x018b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018C	0x018c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018D	0x018d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018E	0x018e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_018F	0x018f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0190	0x0190		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0191	0x0191		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0192	0x0192		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0193	0x0193		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0194	0x0194		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0195	0x0195		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0196	0x0196		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0197	0x0197		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0198	0x0198		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_0199	0x0199		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019A	0x019a		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019B	0x019b		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019C	0x019c		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019D	0x019d		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019E	0x019e		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_019F	0x019f		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A0	0x01a0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A1	0x01a1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A2	0x01a2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A3	0x01a3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A4	0x01a4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A5	0x01a5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A6	0x01a6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A7	0x01a7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A8	0x01a8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01A9	0x01a9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AA	0x01aa		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AB	0x01ab		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AC	0x01ac		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AD	0x01ad		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AE	0x01ae		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01AF	0x01af		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B0	0x01b0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B1	0x01b1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B2	0x01b2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B3	0x01b3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B4	0x01b4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B5	0x01b5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B6	0x01b6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B7	0x01b7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B8	0x01b8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01B9	0x01b9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BA	0x01ba		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BB	0x01bb		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BC	0x01bc		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BD	0x01bd		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BE	0x01be		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01BF	0x01bf		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C0	0x01c0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C1	0x01c1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C2	0x01c2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C3	0x01c3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C4	0x01c4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C5	0x01c5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C6	0x01c6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C7	0x01c7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C8	0x01c8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01C9	0x01c9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CA	0x01ca		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CB	0x01cb		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CC	0x01cc		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CD	0x01cd		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CE	0x01ce		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01CF	0x01cf		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D0	0x01d0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D1	0x01d1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D2	0x01d2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D3	0x01d3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D4	0x01d4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D5	0x01d5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D6	0x01d6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D7	0x01d7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D8	0x01d8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01D9	0x01d9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DA	0x01da		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DB	0x01db		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DC	0x01dc		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DD	0x01dd		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DE	0x01de		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01DF	0x01df		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E0	0x01e0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E1	0x01e1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E2	0x01e2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E3	0x01e3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E4	0x01e4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E5	0x01e5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E6	0x01e6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E7	0x01e7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E8	0x01e8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01E9	0x01e9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01EA	0x01ea		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01EB	0x01eb		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01EC	0x01ec		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01ED	0x01ed		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01EE	0x01ee		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01EF	0x01ef		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F0	0x01f0		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F1	0x01f1		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F2	0x01f2		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F3	0x01f3		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F4	0x01f4		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F5	0x01f5		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F6	0x01f6		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F7	0x01f7		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F8	0x01f8		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01F9	0x01f9		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FA	0x01fa		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FB	0x01fb		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FC	0x01fc		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FD	0x01fd		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FE	0x01fe		/* LCD */
#define	USB_PRODUCT_MATRIXORB_LCD_01FF	0x01ff		/* LCD */

/* MCT Corp. */
#define	USB_PRODUCT_MCT_HUB0100	0x0100		/* Hub */
#define	USB_PRODUCT_MCT_DU_H3SP_USB232	0x0200		/* D-Link DU-H3SP BAY Hub */
#define	USB_PRODUCT_MCT_USB232	0x0210		/* RS232 */
#define	USB_PRODUCT_MCT_SITECOM_USB232	0x0230		/* Sitecom RS232 */
#define	USB_PRODUCT_MCT_ML_4500	0x0302		/* ML-4500 */

/* MDS products */
#define	USB_PRODUCT_MDS_ISDBT	0x0001		/* MDS ISDB-T tuner */

/* MediaTek Inc. products */
#define	USB_PRODUCT_MEDIATEK_UMASS	0x0002		/* USB MSM installer */
#define	USB_PRODUCT_MEDIATEK_DC_4COM	0x00a5		/* UMTS USB modem */

/* MEI products */
#define	USB_PRODUCT_MEI_CASHFLOW_SC	0x1100		/* Cashflow-SC */
#define	USB_PRODUCT_MEI_S2000	0x1101		/* Series 2000 */

/* Meinberg Funkuhren products */
#define	USB_PRODUCT_MEINBERG_USB5131	0x0301		/* USB 5131 DCF77 - Radio Clock */

/* Melco, Inc products */
#define	USB_PRODUCT_MELCO_LUATX1	0x0001		/* LUA-TX Ethernet */
#define	USB_PRODUCT_MELCO_LUATX5	0x0005		/* LUA-TX Ethernet */
#define	USB_PRODUCT_MELCO_NINWIFI	0x008b		/* Nintendo Wi-Fi */
#define	USB_PRODUCT_MELCO_LUA2TX5	0x0009		/* LUA2-TX Ethernet */
#define	USB_PRODUCT_MELCO_LUAKTX	0x0012		/* LUA-KTX Ethernet */
#define	USB_PRODUCT_MELCO_S11	0x0016		/* WLI-USB-S11 */
#define	USB_PRODUCT_MELCO_MCRSM2	0x001b		/* MCR-SM2 SmartMedia */
#define	USB_PRODUCT_MELCO_DUBPXXG	0x001c		/* USB-IDE Bridge: DUB-PxxG */
#define	USB_PRODUCT_MELCO_KS11G	0x0027		/* WLI-USB-KS11G wlan */
#define	USB_PRODUCT_MELCO_LUAU2KTX	0x003d		/* LUA-U2-KTX Ethernet */
#define	USB_PRODUCT_MELCO_KB11	0x0044		/* WLI-USB-KB11 WLAN */
#define	USB_PRODUCT_MELCO_KG54YB	0x005e		/* WLI-U2-KG54-YB WLAN */
#define	USB_PRODUCT_MELCO_KG54	0x0066		/* WLI-U2-KG54 WLAN */
#define	USB_PRODUCT_MELCO_KG54AI	0x0067		/* WLI-U2-KG54-AI WLAN */
#define	USB_PRODUCT_MELCO_LUAU2GT	0x006e		/* LUA-U2-GT Ethernet */
#define	USB_PRODUCT_MELCO_WLIU2KAMG54	0x0091		/* WLI-U2-KAMG54 */
#define	USB_PRODUCT_MELCO_WLIU2KAMG54_NF	0x0092		/* WLI-U2-KAMG54 */
#define	USB_PRODUCT_MELCO_PCOPRS1	0x00b3		/* PC-OP-RS1 RemoteStation */
#define	USB_PRODUCT_MELCO_SG54HP	0x00d8		/* WLI-U2-SG54HP */
#define	USB_PRODUCT_MELCO_G54HP	0x00d9		/* WLI-U2-G54HP */
#define	USB_PRODUCT_MELCO_KG54L	0x00da		/* WLI-U2-KG54L */
#define	USB_PRODUCT_MELCO_WLIUCG300N	0x00e8		/* WLI-UC-G300N */
#define	USB_PRODUCT_MELCO_SG54HG	0x00f4		/* WLI-U2-SG54HG */
#define	USB_PRODUCT_MELCO_WLIUCAG300N	0x012e		/* WLI-UC-AG300N */
#define	USB_PRODUCT_MELCO_RT2870_1	0x0148		/* RT2870 */
#define	USB_PRODUCT_MELCO_RT2870_2	0x0150		/* RT2870 */
#define	USB_PRODUCT_MELCO_WLIUCGNHP	0x0158		/* WLI-UC-GNHP */
#define	USB_PRODUCT_MELCO_WLIUCGN	0x015d		/* WLI-UC-GN */
#define	USB_PRODUCT_MELCO_WLIUCG301N	0x016f		/* WLI-UC-G301N */
#define	USB_PRODUCT_MELCO_WLIUCGNM	0x01a2		/* WLI-UC-GNM */
#define	USB_PRODUCT_MELCO_WLIUCGNM2	0x01ee		/* WLI-UC-GNM2 */

/* MetaGeek tagged products */
#define	USB_PRODUCT_MECANIQUE_WISPY	0x083e		/* MetaGeek Wi-Spy */
#define	USB_PRODUCT_MECANIQUE_TELLSTICK	0x0c30		/* Telldus Tellstick */

/* MetaGeek products */
#define	USB_PRODUCT_METAGEEK_WISPY24I	0x2400		/* Wi-Spy 2.4i */

/* Metricom products */
#define	USB_PRODUCT_METRICOM_RICOCHET_GS	0x0001		/* Ricochet GS */

/* MGE UPS Systems products */
#define	USB_PRODUCT_MGE_UPS1	0x0001		/* UPS */
#define	USB_PRODUCT_MGE_UPS2	0xffff		/* UPS */

/* Modacom products */
#define	USB_PRODUCT_MODACOM_MWIMAX	0x1240		/* MODACOM Mobile wimax adaptor */

/* Micro Star International products */
#define	USB_PRODUCT_MSI_WLAN	0x1020		/* WLAN */
#define	USB_PRODUCT_MSI_BLUETOOTH	0x1967		/* Bluetooth */
#define	USB_PRODUCT_MSI_RT3070_1	0x3820		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_2	0x3821		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_8	0x3822		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_3	0x3870		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_9	0x3871		/* RT3070 */
#define	USB_PRODUCT_MSI_RT2570	0x6861		/* RT2570 */
#define	USB_PRODUCT_MSI_RT2570_2	0x6865		/* RT2570 */
#define	USB_PRODUCT_MSI_RT2570_3	0x6869		/* RT2570 */
#define	USB_PRODUCT_MSI_RT2573_1	0x6874		/* RT2573 */
#define	USB_PRODUCT_MSI_RT2573_2	0x6877		/* RT2573 */
#define	USB_PRODUCT_MSI_RT3070_4	0x6899		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_5	0x821a		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_10	0x822a		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_12	0x822b		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_13	0x822c		/* RT3070 */
#define	USB_PRODUCT_MSI_RT2573_3	0xa861		/* RT2573 */
#define	USB_PRODUCT_MSI_RT3070_6	0x870a		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_11	0x871a		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_14	0x871b		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_15	0x871c		/* RT3070 */
#define	USB_PRODUCT_MSI_RT3070_7	0x899a		/* RT3070 */
#define	USB_PRODUCT_MSI_RT2573_4	0xa874		/* RT2573 */
#define	USB_PRODUCT_MSI_AX88772A	0xa877		/* AX88772A */
#define	USB_PRODUCT_MSI_BLUETOOTH_2	0xa970		/* Bluetooth */
#define	USB_PRODUCT_MSI_BLUETOOTH_3	0xa97a		/* Bluetooth */

/* Microdia / Sonix Techonology Co., Ltd. products */
#define	USB_PRODUCT_MICRODIA_YUREX	0x1010		/* YUREX */
#define	USB_PRODUCT_MICRODIA_CAM_1	0x62c0		/* CAM_1 */
#define	USB_PRODUCT_MICRODIA_TEMPER	0x7401		/* TEMPer sensor */
#define	USB_PRODUCT_MICRODIA_TEMPERHUM	0x7402		/* TEMPerHUM sensor */

/* Micronet Communications products */
#define	USB_PRODUCT_MICRONET_SP128AR	0x0003		/* SP128AR EtherFast */

/* Microsoft products */
#define	USB_PRODUCT_MICROSOFT_SIDEPREC	0x0008		/* SideWinder Precision Pro */
#define	USB_PRODUCT_MICROSOFT_INTELLIMOUSE	0x0009		/* IntelliMouse */
#define	USB_PRODUCT_MICROSOFT_NATURALKBD	0x000b		/* Natural */
#define	USB_PRODUCT_MICROSOFT_DDS80	0x0014		/* Digital Sound System 80 */
#define	USB_PRODUCT_MICROSOFT_SIDEWINDER	0x001a		/* Sidewinder Precision Racing Wheel */
#define	USB_PRODUCT_MICROSOFT_INETPRO	0x001c		/* Internet Keyboard Pro */
#define	USB_PRODUCT_MICROSOFT_TBEXPLORER	0x0024		/* Trackball Explorer */
#define	USB_PRODUCT_MICROSOFT_INTELLIEYE	0x0025		/* IntelliEye mouse */
#define	USB_PRODUCT_MICROSOFT_INETPRO2	0x002b		/* Internet Keyboard Pro */
#define	USB_PRODUCT_MICROSOFT_MN510	0x006e		/* MN510 Wireless */
#define	USB_PRODUCT_MICROSOFT_700WX	0x0079		/* Palm 700WX */
#define	USB_PRODUCT_MICROSOFT_MN110	0x007a		/* 10/100 Ethernet */
#define	USB_PRODUCT_MICROSOFT_WLINTELLIMOUSE	0x008c		/* Wireless Optical IntelliMouse */
#define	USB_PRODUCT_MICROSOFT_WLNOTEBOOK	0x00b9		/* Wireless Optical Mouse (Model 1023) */
#define	USB_PRODUCT_MICROSOFT_WLNOTEBOOK3	0x00d2		/* Wireless Optical Mouse 3000 (Model 1049) */
#define	USB_PRODUCT_MICROSOFT_WLNOTEBOOK2	0x00e1		/* Wireless Optical Mouse 3000 (Model 1056) */
#define	USB_PRODUCT_MICROSOFT_XBOX360_CONTROLLER	0x028e		/* XBOX 360 Controller */
#define	USB_PRODUCT_MICROSOFT_XBOX360	0x0292		/* XBOX 360 WLAN */
#define	USB_PRODUCT_MICROSOFT_WLMOBILEMOUSE3500	0x0745		/* Wireless Mobile Mouse 3500 */
#define	USB_PRODUCT_MICROSOFT_LIFECAM	0x074a		/* Microsoft LifeCam */
#define	USB_PRODUCT_MICROSOFT_WLARCMOUSE	0x074f		/* Wireless Arc Mouse (Model 1350) */

/* Microtech products */
#define	USB_PRODUCT_MICROTECH_SCSIDB25	0x0004		/* SCSI-DB25 */
#define	USB_PRODUCT_MICROTECH_SCSIHD50	0x0005		/* SCSI-HD50 */
#define	USB_PRODUCT_MICROTECH_DPCM	0x0006		/* CameraMate */
#define	USB_PRODUCT_MICROTECH_FREECOM	0xfc01		/* Freecom IDE */

/* Microtek products */
#define	USB_PRODUCT_MICROTEK_336CX	0x0094		/* Phantom 336CX - C3 */
#define	USB_PRODUCT_MICROTEK_X6U	0x0099		/* ScanMaker X6 - X6U */
#define	USB_PRODUCT_MICROTEK_C6	0x009a		/* Phantom C6 */
#define	USB_PRODUCT_MICROTEK_336CX2	0x00a0		/* Phantom 336CX - C3 */
#define	USB_PRODUCT_MICROTEK_V6USL	0x00a3		/* ScanMaker V6USL */
#define	USB_PRODUCT_MICROTEK_V6USL2	0x80a3		/* ScanMaker V6USL */
#define	USB_PRODUCT_MICROTEK_V6UL	0x80ac		/* ScanMaker V6UL */

/* Midiman products */
#define	USB_PRODUCT_MIDIMAN_MIDISPORT2X2	0x1001		/* Midisport 2x2 */

/* Minds At Work LLC products */
#define	USB_PRODUCT_MINDSATWORK_DW	0x0001		/* Digital Wallet */

/* Minolta Co., Ltd. */
#define	USB_PRODUCT_MINOLTA_S304	0x4007		/* Dimage S304 */
#define	USB_PRODUCT_MINOLTA_X	0x4009		/* Dimage X */
#define	USB_PRODUCT_MINOLTA_DIMAGE7I	0x400b		/* Dimage 7i */
#define	USB_PRODUCT_MINOLTA_DIMAGEA1	0x401a		/* Dimage A1 */

/* Mitsumi products */
#define	USB_PRODUCT_MITSUMI_CDRRW	0x0000		/* CD-R/RW Drive */
#define	USB_PRODUCT_MITSUMI_MOUSE	0x6407		/* Mouse */
#define	USB_PRODUCT_MITSUMI_BLUETOOTH	0x641f		/* Bluetooth */
#define	USB_PRODUCT_MITSUMI_FDD	0x6901		/* FDD */

/* Mobile Action products */
#define	USB_PRODUCT_MOBILEACTION_MA620	0x0620		/* MA-620 IrDA */

/* Mobility products */
#define	USB_PRODUCT_MOBILITY_ED200H	0x0202		/* EasiDock 200 Serial */
#define	USB_PRODUCT_MOBILITY_EA	0x0204		/* Ethernet */
#define	USB_PRODUCT_MOBILITY_EASIDOCK	0x0304		/* EasiDock Ethernet */

/* MosChip products */
#define	USB_PRODUCT_MOSCHIP_MCS7703	0x7703		/* MCS7703 Serial */
#define	USB_PRODUCT_MOSCHIP_MCS7715	0x7715		/* MCS7715 Serial Parallel */
#define	USB_PRODUCT_MOSCHIP_MCS7730	0x7730		/* MCS7730 Ethernet */
#define	USB_PRODUCT_MOSCHIP_MCS7810	0x7810		/* MCS7810 Serial */
#define	USB_PRODUCT_MOSCHIP_MCS7820	0x7820		/* MCS7820 Serial */
#define	USB_PRODUCT_MOSCHIP_MCS7830	0x7830		/* MCS7830 Ethernet */
#define	USB_PRODUCT_MOSCHIP_MCS7832	0x7832		/* MCS7832 Ethernet */
#define	USB_PRODUCT_MOSCHIP_MCS7840	0x7840		/* MCS7840 Serial */

/* Motorola products */
#define	USB_PRODUCT_MOTOROLA_MC141555	0x1555		/* MC141555 hub controller */

/* Motorola(2) products */
#define	USB_PRODUCT_MOTOROLA2_T720C	0x2822		/* T720c */
#define	USB_PRODUCT_MOTOROLA2_V360	0x4902		/* V360 */
#define	USB_PRODUCT_MOTOROLA2_USBLAN	0x600c		/* USBLAN */
#define	USB_PRODUCT_MOTOROLA2_USBLAN2	0x6027		/* USBLAN */

/* Motorola(3) products */
#define	USB_PRODUCT_MOTOROLA3_SB4100	0x4100		/* SB4100 Cable Modem */
#define	USB_PRODUCT_MOTOROLA3_SB5100	0x5100		/* SB5100 Cable Modem */

/* Motorola(4) products */
#define	USB_PRODUCT_MOTOROLA4_RT2770	0x9031		/* RT2770 */
#define	USB_PRODUCT_MOTOROLA4_RT3070	0x9032		/* RT3070 */

/* Moxa products */
#define	USB_PRODUCT_MOXA_UPORT1110	0x1110		/* UPort 1110 */

/* MultiTech products */
#define	USB_PRODUCT_MULTITECH_ATLAS	0xf101		/* MT5634ZBA modem */

/* Mustek products */
#define	USB_PRODUCT_MUSTEK_1200CU	0x0001		/* 1200 CU */
#define	USB_PRODUCT_MUSTEK_600CU	0x0002		/* 600 CU */
#define	USB_PRODUCT_MUSTEK_1200USB	0x0003		/* 1200 */
#define	USB_PRODUCT_MUSTEK_1200UB	0x0006		/* 1200 UB */
#define	USB_PRODUCT_MUSTEK_1200USBPLUS	0x0007		/* 1200 Plus */
#define	USB_PRODUCT_MUSTEK_1200CUPLUS	0x0008		/* 1200 CU Plus */
#define	USB_PRODUCT_MUSTEK_BEARPAW1200F	0x0010		/* BearPaw 1200F */
#define	USB_PRODUCT_MUSTEK_600USB	0x0873		/* 600 */
#define	USB_PRODUCT_MUSTEK_MDC800	0xa800		/* MDC-800 */
#define	USB_PRODUCT_MUSTEK_DV2000	0xc441		/* DV2000 */
#define	USB_PRODUCT_MUSTEK2_PM800	0x5161		/* PowerMust 800 */

/* M-Systems products */
#define	USB_PRODUCT_MSYSTEMS_DISKONKEY	0x0010		/* DiskOnKey */
#define	USB_PRODUCT_MSYSTEMS_DISKONKEY2	0x0011		/* DiskOnKey */

/* National Instruments */
#define	USB_PRODUCT_NI_GPIB_USB_A	0xc920		/* GPIB-USB-A */

/* National Semiconductor */
#define	USB_PRODUCT_NATIONAL_BEARPAW1200	0x1000		/* BearPaw 1200 */
#define	USB_PRODUCT_NATIONAL_BEARPAW2400	0x1001		/* BearPaw 2400 */

/* NEC products */
#define	USB_PRODUCT_NEC_HUB	0x005a		/* hub */
#define	USB_PRODUCT_NEC_WL300NUG	0x0249		/* WL300NU-G */
#define	USB_PRODUCT_NEC_USB2EXTEND	0x0409		/* Repeater */
#define	USB_PRODUCT_NEC_HUB_B	0x55aa		/* hub */
#define	USB_PRODUCT_NEC_HUB_C	0x55ab		/* hub */
#define	USB_PRODUCT_NEC_PICTY760	0xbef4		/* Picty760 */
#define	USB_PRODUCT_NEC_PICTY900	0xefbe		/* Picty900 */
#define	USB_PRODUCT_NEC_PICTY920	0xf0be		/* Picty920 */
#define	USB_PRODUCT_NEC_PICTY800	0xf1be		/* Picty800 */

/* NEC2 products */
#define	USB_PRODUCT_NEC2_HUB2_0	0x0058		/* USB2.0 Hub */

/* NEODIO products */
#define	USB_PRODUCT_NEODIO_ND3050	0x3050		/* 6-in-1 Flash Device Controller */
#define	USB_PRODUCT_NEODIO_ND3260	0x3260		/* 8-in-1 Flash Device Controller */
#define	USB_PRODUCT_NEODIO_ND5010	0x5010		/* Multi-format Flash Controller */

/* NetChip Technology Products */
#define	USB_PRODUCT_NETCHIP_TURBOCONNECT	0x1080		/* Turbo-Connect */
#define	USB_PRODUCT_NETCHIP_CLIK40	0xa140		/* Clik! 40 */
#define	USB_PRODUCT_NETCHIP_ETHERNETGADGET	0xa4a2		/* EthernetGadget */

/* Netgear products */
#define	USB_PRODUCT_NETGEAR_EA101	0x1001		/* Ethernet */
#define	USB_PRODUCT_NETGEAR_EA101X	0x1002		/* Ethernet */
#define	USB_PRODUCT_NETGEAR_FA101	0x1020		/* 10/100 Ethernet */
#define	USB_PRODUCT_NETGEAR_FA120	0x1040		/* USB 2.0 Fast Ethernet */
#define	USB_PRODUCT_NETGEAR_M7100	0x1100		/* M7100 */
#define	USB_PRODUCT_NETGEAR_MA111NA	0x4110		/* 802.11b */
#define	USB_PRODUCT_NETGEAR_MA111V2	0x4230		/* 802.11b V2 */
#define	USB_PRODUCT_NETGEAR_WG111V2_2	0x4240		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_NETGEAR_WG111V3	0x4260		/* WG111v3 */
#define	USB_PRODUCT_NETGEAR_WG111U	0x4300		/* WG111U */
#define	USB_PRODUCT_NETGEAR_WG111U_NF	0x4301		/* WG111U */
#define	USB_PRODUCT_NETGEAR_WG111V2	0x6a00		/* WG111v2 */
#define	USB_PRODUCT_NETGEAR_WN111V2	0x9001		/* WN111V2 */
#define	USB_PRODUCT_NETGEAR_WNDA3100	0x9010		/* WNDA3100 */
#define	USB_PRODUCT_NETGEAR_WNDA3200	0x9018		/* WNDA3200 */
#define	USB_PRODUCT_NETGEAR_RTL8192CU	0x9021		/* RTL8192CU */
#define	USB_PRODUCT_NETGEAR_WNA1100	0x9030		/* WNA1100 */
#define	USB_PRODUCT_NETGEAR_WNA1000	0x9040		/* WNA1000 */
#define	USB_PRODUCT_NETGEAR_WNA1000M	0x9041		/* WNA1000M */
#define	USB_PRODUCT_NETGEAR_WNA1000Mv2	0x9043		/* WNA1000Mv2 */
#define	USB_PRODUCT_NETGEAR_N300MA	0xf001		/* N300MA */

/* Netgear(2) products */
#define	USB_PRODUCT_NETGEAR2_MA101	0x4100		/* MA101 */
#define	USB_PRODUCT_NETGEAR2_MA101B	0x4102		/* MA101 Rev B */

/* Netgear(3) products */
#define	USB_PRODUCT_NETGEAR3_WG111T	0x4250		/* WG111T */
#define	USB_PRODUCT_NETGEAR3_WG111T_NF	0x4251		/* WG111T */
#define	USB_PRODUCT_NETGEAR3_WG111T_1	0x4252		/* WG111T */
#define	USB_PRODUCT_NETGEAR3_WPN111	0x5f00		/* WPN111 */
#define	USB_PRODUCT_NETGEAR3_WPN111_NF	0x5f01		/* WPN111 */

/* Netgear(4) products */
#define	USB_PRODUCT_NETGEAR4_RTL8188CU	0x9041		/* RTL8188CU */

/* NetweeN products */
#define	USB_PRODUCT_NETWEEN_RTL8192CU	0x0091		/* RTL8192CU */

/* Nikon products */
#define	USB_PRODUCT_NIKON_E990	0x0102		/* E990 */
#define	USB_PRODUCT_NIKON_E880	0x0103		/* E880 */
#define	USB_PRODUCT_NIKON_E885	0x0105		/* E885 */

/* NHJ product */
#define	USB_PRODUCT_NHJ_CAM2	0x9120		/* Camera */

/* Nokia products */
#define	USB_PRODUCT_NOKIA_CA42	0x1234		/* CA-42 Serial */
#define	USB_PRODUCT_NOKIA2_CS15UMASS	0x0610		/* Internet Stick CS-15 (umass mode) */
#define	USB_PRODUCT_NOKIA2_CS15	0x0612		/* Internet Stick CS-15 */

/* Noritake itron corp products */
#define	USB_PRODUCT_NORITAKE_COMEMO	0x11c0		/* Noritake COMEMO */

/* Nova Tech products */
#define	USB_PRODUCT_NOVATECH_NV902W	0x9020		/* NV-902W */
#define	USB_PRODUCT_NOVATECH_RT2573	0x9021		/* RT2573 */
#define	USB_PRODUCT_NOVATECH_RTL8188CU	0x9071		/* RTL8188CU */

/* Novatel Wireless products */
#define	USB_PRODUCT_NOVATEL_EXPRESSCARD	0x1100		/* ExpressCard 3G */
#define	USB_PRODUCT_NOVATEL_MERLINV620	0x1110		/* V620 */
#define	USB_PRODUCT_NOVATEL_MERLINV740	0x1120		/* V740 */
#define	USB_PRODUCT_NOVATEL_V720	0x1130		/* V720 */
#define	USB_PRODUCT_NOVATEL_MERLINU740	0x1400		/* U740 */
#define	USB_PRODUCT_NOVATEL_MERLINU740_2	0x1410		/* U740 */
#define	USB_PRODUCT_NOVATEL_U870	0x1420		/* U870 */
#define	USB_PRODUCT_NOVATEL_XU870	0x1430		/* XU870 */
#define	USB_PRODUCT_NOVATEL_X950D	0x1450		/* X950D */
#define	USB_PRODUCT_NOVATEL_ES620	0x2100		/* ES620 CDMA */
#define	USB_PRODUCT_NOVATEL_U720	0x2110		/* U720 */
#define	USB_PRODUCT_NOVATEL_EU870D	0x2420		/* EU870D */
#define	USB_PRODUCT_NOVATEL_U727	0x4100		/* U727 */
#define	USB_PRODUCT_NOVATEL_MC950D	0x4400		/* MC950D HSUPA */
#define	USB_PRODUCT_NOVATEL_MERLINX950D	0x5010		/* X950D */
#define	USB_PRODUCT_NOVATEL_ZEROCD2	0x5030		/* ZeroCD */
#define	USB_PRODUCT_NOVATEL_MC760CD	0x5031		/* MC760 CD */
#define	USB_PRODUCT_NOVATEL_U760	0x6000		/* U760 */
#define	USB_PRODUCT_NOVATEL_MC760	0x6002		/* MC760 */

/* Novatel Wireless(1) products */
#define	USB_PRODUCT_NOVATEL1_FLEXPACKGPS	0x0100		/* NovAtel FlexPack GPS */

/* O2 Micro products */
#define	USB_PRODUCT_O2MICRO_OZ776HUB	0x7761		/* OZ776 Hub */

/* Olimex products */
#define	USB_PRODUCT_OLIMEX_OPENOCD_JTAG	0x0003		/* OpenOCD JTAG */

/* Olympus products */
#define	USB_PRODUCT_OLYMPUS_C1	0x0102		/* C-1 */
#define	USB_PRODUCT_OLYMPUS_C700	0x0105		/* C-700 Ultra Zoom */

/* Omnidirectional Control Technology products */
#define	USB_PRODUCT_OCT_USBTOETHER	0x0109		/* Ethernet */

/* OmniVision Technologies, Inc. products */
#define	USB_PRODUCT_OMNIVISION_OV511	0x0511		/* OV511 */
#define	USB_PRODUCT_OMNIVISION_OV511PLUS	0xa511		/* OV511+ */

/* OMRON products */
#define	USB_PRODUCT_OMRON_BX50F	0x0057		/* BX50F UPS */
#define	USB_PRODUCT_OMRON_BX35F	0x0058		/* BX35F UPS */
#define	USB_PRODUCT_OMRON_BY35S	0x0080		/* BY35S UPS */

/* OnSpec Electronic, Inc. */
#define	USB_PRODUCT_ONSPEC_MD2	0x0103		/* disk */
#define	USB_PRODUCT_ONSPEC_MDCFEB	0xa000		/* MDCFE-B CF */
#define	USB_PRODUCT_ONSPEC_SIIGMS	0xa001		/* Memory Stick+CF */
#define	USB_PRODUCT_ONSPEC_DATAFAB3	0xa003		/* Datafab-based */
#define	USB_PRODUCT_ONSPEC_DATAFAB4	0xa004		/* Datafab-based */
#define	USB_PRODUCT_ONSPEC_PNYCFSM	0xa005		/* PNY/Datafab CF+SM */
#define	USB_PRODUCT_ONSPEC_STECHCFSM	0xa006		/* Simple Tech/Datafab CF+SM */
#define	USB_PRODUCT_ONSPEC_LC1	0xa109		/* CF + SM Combo (LC1) */
#define	USB_PRODUCT_ONSPEC_MD1II	0xb006		/* Datafab MD1-II PC-Card */

/* OnSpec Electronic, Inc.(2) */
#define	USB_PRODUCT_ONSPEC2_8IN2	0xb012		/* 8In2 */

/* OQO */
#define	USB_PRODUCT_OQO_WIFI01	0x0002		/* model 01 WiFi */
#define	USB_PRODUCT_OQO_BT01	0x0003		/* model 01 Bluetooth */
#define	USB_PRODUCT_OQO_ETHER01PLUS	0x7720		/* model 01+ Ethernet */
#define	USB_PRODUCT_OQO_ETHER01	0x8150		/* model 01 Ethernet */

/*
 * OpenMoko permits other open hardware products to use their
 * product ID allocations
 */
#define	USB_PRODUCT_OPENMOKO2_ONERNG	0x6086		/* Moonbase Otago OneRNG */

/* Oregon Scientific */
#define	USB_PRODUCT_OREGONSCI_OWL_CM160	0xca05		/* OWL CM-160 */

/* Ours Technology Inc. */
#define	USB_PRODUCT_OTI_SOLID	0x6803		/* Solid state disk */
#define	USB_PRODUCT_OTI_DKU5	0x6858		/* DKU-5 Serial */

/* OvisLink product */
#define	USB_PRODUCT_OVISLINK_RT3071	0x3071		/* RT3071 */
#define	USB_PRODUCT_OVISLINK_RT3072	0x3072		/* RT3072 */

/* Owen.ru products */
#define	USB_PRODUCT_OWEN_AC4	0x0004		/* AC4 USB-RS485 */

/* Palm Computing, Inc. product */
#define	USB_PRODUCT_PALM_SERIAL	0x0080		/* USB Serial Adaptor */
#define	USB_PRODUCT_PALM_M500	0x0001		/* Palm m500 */
#define	USB_PRODUCT_PALM_M505	0x0002		/* Palm m505 */
#define	USB_PRODUCT_PALM_M515	0x0003		/* Palm m515 */
#define	USB_PRODUCT_PALM_I705	0x0020		/* Palm i705 */
#define	USB_PRODUCT_PALM_TUNGSTEN_Z	0x0031		/* Palm Tungsten Z */
#define	USB_PRODUCT_PALM_M125	0x0040		/* Palm m125 */
#define	USB_PRODUCT_PALM_M130	0x0050		/* Palm m130 */
#define	USB_PRODUCT_PALM_TUNGSTEN_T	0x0060		/* Palm Tungsten T */
#define	USB_PRODUCT_PALM_ZIRE_31	0x0061		/* Palm Zire 31 */
#define	USB_PRODUCT_PALM_ZIRE	0x0070		/* Palm Zire */

/* Panasonic products */
#define	USB_PRODUCT_PANASONIC_LS120	0x0901		/* LS-120 */
#define	USB_PRODUCT_PANASONIC_SDCAAE	0x1b00		/* MultiMediaCard */
#define	USB_PRODUCT_PANASONIC_TYTP50P6S	0x3900		/* TY-TP50P6-S 50in Touch Panel */
#define	USB_PRODUCT_PANASONIC_N5HBZ0000055	0x3904		/* UB94 */

/* Papouch products */
#define	USB_PRODUCT_PAPOUCH_SB485_1	0x0100		/* SB485 USB-485/422 */
#define	USB_PRODUCT_PAPOUCH_AP485_1	0x0101		/* AP485 USB-RS485 */
#define	USB_PRODUCT_PAPOUCH_SB422_1	0x0102		/* SB422 USB-RS422 */
#define	USB_PRODUCT_PAPOUCH_SB485_2	0x0103		/* SB485 USB-485/422 */
#define	USB_PRODUCT_PAPOUCH_AP485_2	0x0104		/* AP485 USB-RS485 */
#define	USB_PRODUCT_PAPOUCH_SB422_2	0x0105		/* SB422 USB-RS422 */
#define	USB_PRODUCT_PAPOUCH_SB485S	0x0106		/* SB485S USB-485/422 */
#define	USB_PRODUCT_PAPOUCH_SB485C	0x0107		/* SB485C USB-485/422 */
#define	USB_PRODUCT_PAPOUCH_SERIAL	0x0200		/* Serial */
#define	USB_PRODUCT_PAPOUCH_LEC	0x0300		/* Serial */
#define	USB_PRODUCT_PAPOUCH_SB232	0x0301		/* SB232 USB-RS232 */
#define	USB_PRODUCT_PAPOUCH_TMU	0x0400		/* TMU Thermometer */
#define	USB_PRODUCT_PAPOUCH_IRAMP	0x0500		/* IRAmp Duplex */
#define	USB_PRODUCT_PAPOUCH_DRAK5	0x0700		/* DRAK5 */
#define	USB_PRODUCT_PAPOUCH_QUIDO88	0x0800		/* QUIDO USB 8/8 */
#define	USB_PRODUCT_PAPOUCH_QUIDO44	0x0900		/* QUIDO USB 4/4 */
#define	USB_PRODUCT_PAPOUCH_QUIDO22	0x0A00		/* QUIDO USB 2/2 */
#define	USB_PRODUCT_PAPOUCH_QUIDO101	0x0B00		/* QUIDO USB 10/1 */
#define	USB_PRODUCT_PAPOUCH_QUIDO303	0x0C00		/* QUIDO USB 30/3 */
#define	USB_PRODUCT_PAPOUCH_QUIDO603	0x0D00		/* QUIDO USB 60(100)/3 */
#define	USB_PRODUCT_PAPOUCH_QUIDO216	0x0E00		/* QUIDO USB 2/16 */
#define	USB_PRODUCT_PAPOUCH_QUIDO332	0x0F00		/* QUIDO USB 3/32 */
#define	USB_PRODUCT_PAPOUCH_DRAK6	0x1000		/* DRAK6 USB */
#define	USB_PRODUCT_PAPOUCH_STAVOVY	0x8000		/* UPS-USB Stavovy */
#define	USB_PRODUCT_PAPOUCH_MUC	0x8001		/* MU Controller */
#define	USB_PRODUCT_PAPOUCH_SIMUKEY	0x8002		/* SimuKey */
#define	USB_PRODUCT_PAPOUCH_AD4USB	0x8003		/* AD4USB */
#define	USB_PRODUCT_PAPOUCH_GOLIATH_MUX	0x8004		/* GOLIATH MUX */
#define	USB_PRODUCT_PAPOUCH_GOLIATH_MSR	0x8005		/* GOLIATH MSR */

/* PARA Industrial products */
#define	USB_PRODUCT_PARA_RT3070	0x8888		/* RT3070 */

/* Pegatron products */
#define	USB_PRODUCT_PEGATRON_RT2870	0x0002		/* RT2870 */
#define	USB_PRODUCT_PEGATRON_RT3070	0x000c		/* RT3070 */
#define	USB_PRODUCT_PEGATRON_RT3070_2	0x000e		/* RT3070 */
#define	USB_PRODUCT_PEGATRON_RT3070_3	0x0010		/* RT3070 */
#define	USB_PRODUCT_PEGATRON_RT3072	0x0011		/* RT3072 */

/* Pen Driver */
#define	USB_PRODUCT_PEN_USBREADER	0x0240		/* 6 in 1 */
#define	USB_PRODUCT_PEN_MOBILEDRIVE	0x0280		/* 3 in 1 */
#define	USB_PRODUCT_PEN_USBDISK	0x0d7d		/* Disk */

/* Peracom products */
#define	USB_PRODUCT_PERACOM_SERIAL1	0x0001		/* Serial Converter */
#define	USB_PRODUCT_PERACOM_ENET	0x0002		/* Ethernet */
#define	USB_PRODUCT_PERACOM_ENET3	0x0003		/* At-Home Ethernet */
#define	USB_PRODUCT_PERACOM_ENET2	0x0005		/* Ethernet */

/* Pheenet products */
#define	USB_PRODUCT_PHEENET_WL503IA	0x4017		/* WL-503IA */
#define	USB_PRODUCT_PHEENET_GWU513	0x4025		/* GWU513 */

/* Phidgets products */
#define	USB_PRODUCT_PHIDGETS_2X2	0x0036		/* 2x2 Interface Kit */

/* Philips products */
#define	USB_PRODUCT_PHILIPS_DSS350	0x0101		/* DSS 350 Digital Speaker System */
#define	USB_PRODUCT_PHILIPS_DSS	0x0104		/* DSS XXX Digital Speaker System */
#define	USB_PRODUCT_PHILIPS_SNU5630NS05	0x1237		/* SNU5630NS/05 */
#define	USB_PRODUCT_PHILIPS_HUB	0x0201		/* hub */
#define	USB_PRODUCT_PHILIPS_PCA645VC	0x0302		/* PCA645VC */
#define	USB_PRODUCT_PHILIPS_PCA646VC	0x0303		/* PCA646VC */
#define	USB_PRODUCT_PHILIPS_PCVC675K	0x0307		/* PCVC675K Vesta */
#define	USB_PRODUCT_PHILIPS_PCVC680K	0x0308		/* PCVC680K Vesta Pro */
#define	USB_PRODUCT_PHILIPS_PCVC690K	0x030c		/* PCVC690K Vesta Pro Scan Camera */
#define	USB_PRODUCT_PHILIPS_PCVC730K	0x0310		/* PCVC730K ToUCam Fun */
#define	USB_PRODUCT_PHILIPS_PCVC740K	0x0311		/* PCVC740K ToUCam Pro PC */
#define	USB_PRODUCT_PHILIPS_PCVC750K	0x0312		/* PCVC750K ToUCam Pro Scan */
#define	USB_PRODUCT_PHILIPS_DSS150	0x0471		/* DSS 150 Digital Speaker System */
#define	USB_PRODUCT_PHILIPS_ACE1001	0x066a		/* AKTAKOM ACE-1001 */
#define	USB_PRODUCT_PHILIPS_CPWUA054	0x1230		/* CPWUA054 */
#define	USB_PRODUCT_PHILIPS_SNU6500	0x1232		/* SNU6500 */
#define	USB_PRODUCT_PHILIPS_SNU6500_NF	0x1233		/* SNU6500 */
#define	USB_PRODUCT_PHILIPS_SNU5600	0x1236		/* SNU5600 */
#define	USB_PRODUCT_PHILIPS_DIVAUSB	0x1801		/* DIVA mp3 player */
#define	USB_PRODUCT_PHILIPS_RT2870	0x200f		/* RT2870 */

/* Philips Semiconductor products */
#define	USB_PRODUCT_PHILIPSSEMI_HUB1122	0x1122		/* hub */

/* P.I. Engineering products */
#define	USB_PRODUCT_PIENGINEERING_PS2USB	0x020b		/* PS2 to Mac */
#define	USB_PRODUCT_PIENGINEERING_XKEYS	0x0233		/* Xkeys Programmable Keyboard */

/* Pilotech Systems Co., Ltd products */
#define	USB_PRODUCT_PILOTECH_CRW600	0x0001		/* CRW-600 6-in-1 */

/* Planex Communications products */
#define	USB_PRODUCT_PLANEX2_RTL8188CUS	0x1201		/* RTL8188CUS */
#define	USB_PRODUCT_PLANEX_GW_US11H	0x14ea		/* GW-US11H WLAN */
#define	USB_PRODUCT_PLANEX2_GW_US11S	0x3220		/* GW-US11S WLAN */
#define	USB_PRODUCT_PLANEX2_RTL8188CU_3	0x4902		/* RTL8188CU */
#define	USB_PRODUCT_PLANEX4_GWUS54ZGL	0x5301		/* GW-US54ZGL */
#define	USB_PRODUCT_PLANEX4_ZD1211B	0x5302		/* ZD1211B */
#define	USB_PRODUCT_PLANEX2_GW_US54GXS	0x5303		/* GW-US54GXS WLAN */
#define	USB_PRODUCT_PLANEX2_GW_US300	0x5304		/* GW-US300 */
#define	USB_PRODUCT_PLANEX2_GWUS54HP	0xab01		/* GW-US54HP */
#define	USB_PRODUCT_PLANEX3_GWUS54GZ	0xab10		/* GW-US54GZ */
#define	USB_PRODUCT_PLANEX3_GU1000T	0xab11		/* GU-1000T */
#define	USB_PRODUCT_PLANEX3_GWUS54MINI	0xab13		/* GW-US54Mini */
#define	USB_PRODUCT_PLANEX2_GWUS300MINIS	0xab24		/* GW-US300MiniS */
#define	USB_PRODUCT_PLANEX2_RT3070	0xab25		/* RT3070 */
#define	USB_PRODUCT_PLANEX2_GWUSNANO	0xab28		/* GW-USNano */
#define	USB_PRODUCT_PLANEX2_GWUSMICRO300	0xab29		/* GW-USMicro300 */
#define	USB_PRODUCT_PLANEX2_RTL8188CU_1	0xab2a		/* RTL8188CU */
#define	USB_PRODUCT_PLANEX2_RTL8192CU	0xab2b		/* RTL8192CU */
#define	USB_PRODUCT_PLANEX2_RTL8188CU_4	0xab2e		/* RTL8188CU */
#define	USB_PRODUCT_PLANEX2_GWUS54MINI2	0xab50		/* GW-US54Mini2 */
#define	USB_PRODUCT_PLANEX2_GWUS54SG	0xc002		/* GW-US54SG */
#define	USB_PRODUCT_PLANEX2_GWUS54GZL	0xc007		/* GW-US54GZL */
#define	USB_PRODUCT_PLANEX2_GWUS54GD	0xed01		/* GW-US54GD */
#define	USB_PRODUCT_PLANEX2_GWUSMM	0xed02		/* GW-USMM */
#define	USB_PRODUCT_PLANEX2_RT2870	0xed06		/* RT2870 */
#define	USB_PRODUCT_PLANEX2_GWUSMICRON	0xed14		/* GW-USMicroN */
#define	USB_PRODUCT_PLANEX2_GWUSMICRON2W	0xed16		/* GW-USMicroN2W */
#define	USB_PRODUCT_PLANEX2_RTL8188CU_2	0xed17		/* RTL8188CU */

/* Plantronics products */
#define	USB_PRODUCT_PLANTRONICS_HEADSET	0x0ca1		/* DSP-400 Headset */

/* PLX products */
#define	USB_PRODUCT_PLX_TESTBOARD	0x9060		/* test board */
#define	USB_PRODUCT_PLX_CA42	0xac70		/* CA-42 Serial */

/* PortGear products */
#define	USB_PRODUCT_PORTGEAR_EA8	0x0008		/* Ethernet */
#define	USB_PRODUCT_PORTGEAR_EA9	0x0009		/* Ethernet */

/* Portsmith products */
#define	USB_PRODUCT_PORTSMITH_EEA	0x3003		/* Express Ethernet */

/* Posiflex Technologies products */
#define	USB_PRODUCT_POSIFLEX_PP7000_1	0x0300		/* PP7000 series printer */
#define	USB_PRODUCT_POSIFLEX_PP7000_2	0x0400		/* PP7000 series printer */

/* PQI products */
#define	USB_PRODUCT_PQI_TRAVELFLASH	0x0001		/* Travel Flash Drive */

/* Primax products */
#define	USB_PRODUCT_PRIMAX_G2X300	0x0300		/* G2-200 */
#define	USB_PRODUCT_PRIMAX_G2E300	0x0301		/* G2E-300 */
#define	USB_PRODUCT_PRIMAX_G2300	0x0302		/* G2-300 */
#define	USB_PRODUCT_PRIMAX_G2E3002	0x0303		/* G2E-300 */
#define	USB_PRODUCT_PRIMAX_9600	0x0340		/* Colorado 9600 */
#define	USB_PRODUCT_PRIMAX_600U	0x0341		/* Colorado 600u */
#define	USB_PRODUCT_PRIMAX_6200	0x0345		/* Visioneer 6200 */
#define	USB_PRODUCT_PRIMAX_19200	0x0360		/* Colorado 19200 */
#define	USB_PRODUCT_PRIMAX_1200U	0x0361		/* Colorado 1200u */
#define	USB_PRODUCT_PRIMAX_G600	0x0380		/* G2-600 */
#define	USB_PRODUCT_PRIMAX_636I	0x0381		/* ReadyScan 636i */
#define	USB_PRODUCT_PRIMAX_G2600	0x0382		/* G2-600 */
#define	USB_PRODUCT_PRIMAX_G2E600	0x0383		/* G2E-600 */
#define	USB_PRODUCT_PRIMAX_COMFORT	0x4d01		/* Comfort */
#define	USB_PRODUCT_PRIMAX_MOUSEINABOX	0x4d02		/* Mouse-in-a-Box */
#define	USB_PRODUCT_PRIMAX_PCGAUMS1	0x4d04		/* Sony PCGA-UMS1 */

/* Prolific products */
#define	USB_PRODUCT_PROLIFIC_PL2301	0x0000		/* PL2301 Host-Host */
#define	USB_PRODUCT_PROLIFIC_PL2302	0x0001		/* PL2302 Host-Host */
#define	USB_PRODUCT_PROLIFIC_RSAQ2	0x04bb		/* PL2303 Serial */
#define	USB_PRODUCT_PROLIFIC_PL2303	0x2303		/* PL2303 Serial */
#define	USB_PRODUCT_PROLIFIC_PL2305	0x2305		/* Parallel printer */
#define	USB_PRODUCT_PROLIFIC_ATAPI4	0x2307		/* ATAPI-4 Bridge Controller */
#define	USB_PRODUCT_PROLIFIC_PL2501	0x2501		/* PL2501 Host-Host */
#define	USB_PRODUCT_PROLIFIC_PL2303BENQ	0x0609		/* PL2303 Serial */
#define	USB_PRODUCT_PROLIFIC_PL2303X	0xaaa0		/* PL2303 Serial */
#define	USB_PRODUCT_PROLIFIC_PL2303X2	0xaaa2		/* PL2303 Serial */

/* Prolific(2) products */
#define	USB_PRODUCT_PROLIFIC2_PL2303	0x2303		/* PL2303 Serial */

/* Putercom products */
#define	USB_PRODUCT_PUTERCOM_UPA100	0x047e		/* USB-1284 BRIDGE */

/* Qcom products */
#define	USB_PRODUCT_QCOM_RT2573	0x6196		/* RT2573 */
#define	USB_PRODUCT_QCOM_RT2573_2	0x6229		/* RT2573 */
#define	USB_PRODUCT_QCOM_RT2573_3	0x6238		/* RT2573 */
#define	USB_PRODUCT_QCOM_RT2870	0x6259		/* RT2870 */

/* Qtronix products */
#define	USB_PRODUCT_QTRONIX_980N	0x2011		/* Scorpion-980N */

/* Qualcomm products */
#define	USB_PRODUCT_QUALCOMM_MSM_DRIVER	0x1000		/* MSM driver */
#define	USB_PRODUCT_QUALCOMM_MSM_MODEM	0x3196		/* CDMA MSM modem */
#define	USB_PRODUCT_QUALCOMM_MSM_HSDPA2	0x6000		/* HSDPA MSM */
#define	USB_PRODUCT_QUALCOMM_MSM_HSDPA	0x6613		/* HSDPA MSM */
#define	USB_PRODUCT_QUALCOMM_MSM_HSDPA3	0x9000		/* HSDPA MSM */
#define	USB_PRODUCT_QUALCOMM_MSM_DRIVER2	0xf000		/* MSM driver */

/* Qualcomm(2) products */
#define	USB_PRODUCT_QUALCOMM2_MSM_PHONE	0x6000		/* CDMA MSM phone */

/* ZTE products */
#define	USB_PRODUCT_ZTE_CDMA_MSM	0x0001		/* CDMA Technologies MSM modem */
#define	USB_PRODUCT_ZTE_MF633	0x0016		/* ZTE MF633 USUPA USB modem */
#define	USB_PRODUCT_ZTE_MF637	0x0031		/* ZTE MF637 HSUPA USB modem */
#define	USB_PRODUCT_ZTE_K3565Z	0x0063		/* ZTE K3565-Z USB MSM modem */
#define	USB_PRODUCT_ZTE_UMASS_INSTALLER4	0x0083		/* ZTE USB MSM installer */
#define	USB_PRODUCT_ZTE_MSA110UP	0x0091		/* ONDA MSA110UP USB MSM modem */
#define	USB_PRODUCT_ZTE_UMASS_INSTALLER2	0x0103		/* ZTE USB MSM installer */
#define	USB_PRODUCT_ZTE_MF112	0x0117		/* ZTE MF112 HSUPA USB modem */
#define	USB_PRODUCT_ZTE_HSUSB	0x1364		/* ZTE HSUSB */
#define	USB_PRODUCT_ZTE_UMASS_INSTALLER	0x2000		/* ZTE USB MSM installer */
#define	USB_PRODUCT_ZTE_AC2746	0xfff1		/* AC2746 CDMA USB modem */
#define	USB_PRODUCT_ZTE_UMASS_INSTALLER3	0xfff5		/* ZTE USB CDMA installer */
#define	USB_PRODUCT_ZTE_AC8700	0xfffe		/* AC8700 CDMA USB modem */

/* Quanta products */
#define	USB_PRODUCT_QUANTA_RT3070	0x0304		/* RT3070 */
#define	USB_PRODUCT_QUANTA2_UMASS	0x1000		/* Quanta USB MSM (umass mode) */
#define	USB_PRODUCT_QUANTA2_Q101	0xea02		/* Quanta Q101 HSDPA USB modem */

/* Quickshot products */
#define	USB_PRODUCT_QUICKSHOT_STRIKEPAD	0x6238		/* USB StrikePad */

/* Radio Shack products */
#define	USB_PRODUCT_RADIOSHACK_PL2303	0x4026		/* PL2303 Serial */

/* OpenMoko products */
#define	USB_PRODUCT_OPENMOKO_N1793D	0x5118		/* Neo1973 Debug */

/* Rainbow Technologies products */
#define	USB_PRODUCT_RAINBOW_IKEY2000	0x1200		/* i-Key 2000 */

/* Ralink Technology products */
#define	USB_PRODUCT_RALINK_RT2570	0x1706		/* RT2570 */
#define	USB_PRODUCT_RALINK_RT2070	0x2070		/* RT2070 */
#define	USB_PRODUCT_RALINK_RT2570_2	0x2570		/* RT2570 */
#define	USB_PRODUCT_RALINK_RT2573	0x2573		/* RT2573 */
#define	USB_PRODUCT_RALINK_RT2671	0x2671		/* RT2671 */
#define	USB_PRODUCT_RALINK_RT2770	0x2770		/* RT2770 */
#define	USB_PRODUCT_RALINK_RT2870	0x2870		/* RT2870 */
#define	USB_PRODUCT_RALINK_RT3070	0x3070		/* RT3070 */
#define	USB_PRODUCT_RALINK_RT3071	0x3071		/* RT3071 */
#define	USB_PRODUCT_RALINK_RT3072	0x3072		/* RT3072 */
#define	USB_PRODUCT_RALINK_RT3370	0x3370		/* RT3370 */
#define	USB_PRODUCT_RALINK_RT3572	0x3572		/* RT3572 */
#define	USB_PRODUCT_RALINK_RT5370	0x5370		/* RT5370 */
#define	USB_PRODUCT_RALINK_RT3573	0x3573		/* RT3573 */
#define	USB_PRODUCT_RALINK_RT5572	0x5572		/* RT5572 */
#define	USB_PRODUCT_RALINK_MT7601	0x7601		/* MT7601 */
#define	USB_PRODUCT_RALINK_RT8070	0x8070		/* RT8070 */
#define	USB_PRODUCT_RALINK_RT2570_3	0x9020		/* RT2570 */
#define	USB_PRODUCT_RALINK_RT2573_2	0x9021		/* RT2573 */

/* RATOC Systems products */
#define	USB_PRODUCT_RATOC_REXUSB60	0xb000		/* USB serial REX-USB60 */
#define	USB_PRODUCT_RATOC_REXUSB60F	0xb020		/* REX-USB60F */

/* Realtek products */
#define	USB_PRODUCT_REALTEK_RTL8188ETV	0x0179		/* RTL8188ETV */
#define	USB_PRODUCT_REALTEK_RTL8188CTV	0x018a		/* RTL8188CTV */
#define	USB_PRODUCT_REALTEK_RTL8188RU_2	0x317f		/* RTL8188RU */
#define	USB_PRODUCT_REALTEK_RTL8188CU_4	0x5088		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8150	0x8150		/* RTL8150 */
#define	USB_PRODUCT_REALTEK_RTL8151	0x8151		/* RTL8151 PNA */
#define	USB_PRODUCT_REALTEK_RTL8152	0x8152		/* RTL8152 */
#define	USB_PRODUCT_REALTEK_RTL8153	0x8153		/* RTL8153 */
#define	USB_PRODUCT_REALTEK_RTL8188CE_0	0x8170		/* RTL8188CE */
#define	USB_PRODUCT_REALTEK_RTL8171	0x8171		/* RTL8171 */
#define	USB_PRODUCT_REALTEK_RTL8172	0x8172		/* RTL8172 */
#define	USB_PRODUCT_REALTEK_RTL8173	0x8173		/* RTL8173 */
#define	USB_PRODUCT_REALTEK_RTL8174	0x8174		/* RTL8174 */
#define	USB_PRODUCT_REALTEK_RTL8188CU_0	0x8176		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8191CU	0x8177		/* RTL8191CU */
#define	USB_PRODUCT_REALTEK_RTL8192CU	0x8178		/* RTL8192CU */
#define	USB_PRODUCT_REALTEK_RTL8188EU	0x8179		/* RTL8188EU */
#define	USB_PRODUCT_REALTEK_RTL8188CU_1	0x817a		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8188CU_2	0x817b		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8192CE	0x817c		/* RTL8192CE */
#define	USB_PRODUCT_REALTEK_RTL8188RU	0x817d		/* RTL8188RU */
#define	USB_PRODUCT_REALTEK_RTL8188CE_1	0x817e		/* RTL8188CE */
#define	USB_PRODUCT_REALTEK_RTL8188RU_3	0x817f		/* RTL8188RU */
#define	USB_PRODUCT_REALTEK_RTL8192CE_VAU	0x8186		/* RTL8192CE */
#define	USB_PRODUCT_REALTEK_RTL8187	0x8187		/* RTL8187 */
#define	USB_PRODUCT_REALTEK_RTL8187B_0	0x8189		/* RTL8187B */
#define	USB_PRODUCT_REALTEK_RTL8188CUS	0x818a		/* RTL8188CUS */
#define	USB_PRODUCT_REALTEK_RTL8192EU	0x818b		/* RTL8192EU */
#define	USB_PRODUCT_REALTEK_RTL8188CU_3	0x8191		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8187B_1	0x8197		/* RTL8187B */
#define	USB_PRODUCT_REALTEK_RTL8192U	0x8192		/* RTL8192U */
#define	USB_PRODUCT_REALTEK_RTL8187B_2	0x8198		/* RTL8187B */
#define	USB_PRODUCT_REALTEK_RTL8188CU_5	0x819a		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8712	0x8712		/* RTL8712 */
#define	USB_PRODUCT_REALTEK_RTL8713	0x8712		/* RTL8713 */
#define	USB_PRODUCT_REALTEK_RTL8188CU_COMBO	0x8754		/* RTL8188CU */
#define	USB_PRODUCT_REALTEK_RTL8192SU	0xc512		/* RTL8192SU */

/* Renesas products */
#define	USB_PRODUCT_RENESAS_RX610	0x0053		/* RX610 RX-Stick */

/* Research In Motion products */
#define	USB_PRODUCT_RIM_BLACKBERRY	0x0001		/* BlackBerry */
#define	USB_PRODUCT_RIM_PEARL_DUAL	0x0004		/* RIM Mass Storage Device */
#define	USB_PRODUCT_RIM_PEARL	0x0006		/* BlackBerry pearl */

/* Ricoh products */
#define	USB_PRODUCT_RICOH_VGPVCC2	0x1830		/* VGP-VCC2 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC3	0x1832		/* VGP-VCC3 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC2_2	0x1833		/* VGP-VCC2 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC2_3	0x1834		/* VGP-VCC2 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC5	0x1835		/* VGP-VCC5 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC4	0x1836		/* VGP-VCC4 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC4_2	0x1837		/* VGP-VCC4 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC6	0x1839		/* VGP-VCC6 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC7	0x183a		/* VGP-VCC7 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC8	0x183b		/* VGP-VCC8 Camera */
#define	USB_PRODUCT_RICOH_VGPVCC9	0x183e		/* VGP-VCC9 Camera */
#define	USB_PRODUCT_RICOH_VPGVCCX	0x18b2		/* VGP-VCCX Camera */

/* Roland products */
#define	USB_PRODUCT_ROLAND_UA100	0x0000		/* UA-100 Audio I/F */
#define	USB_PRODUCT_ROLAND_UM4	0x0002		/* UM-4 MIDI I/F */
#define	USB_PRODUCT_ROLAND_SC8850	0x0003		/* SC-8850 MIDI Synth */
#define	USB_PRODUCT_ROLAND_U8	0x0004		/* U-8 Audio I/F */
#define	USB_PRODUCT_ROLAND_UM2	0x0005		/* UM-2 MIDI I/F */
#define	USB_PRODUCT_ROLAND_SC8820	0x0007		/* SC-8820 MIDI Synth */
#define	USB_PRODUCT_ROLAND_PC300	0x0008		/* PC-300 MIDI Keyboard */
#define	USB_PRODUCT_ROLAND_UM1	0x0009		/* UM-1 MIDI I/F */
#define	USB_PRODUCT_ROLAND_SK500	0x000b		/* SK-500 MIDI Keyboard */
#define	USB_PRODUCT_ROLAND_SCD70	0x000c		/* SC-D70 MIDI Synth */
#define	USB_PRODUCT_ROLAND_UM880N	0x0014		/* UM-880 MIDI I/F */
#define	USB_PRODUCT_ROLAND_SD90	0x0016		/* SD-90 MIDI Synth */
#define	USB_PRODUCT_ROLAND_UM550	0x0023		/* UM-550 MIDI I/F */
#define	USB_PRODUCT_ROLAND_SD20	0x0027		/* SD-20 MIDI Synth */
#define	USB_PRODUCT_ROLAND_SD80	0x0029		/* SD-80 MIDI Synth */
#define	USB_PRODUCT_ROLAND_UA700	0x002b		/* UA-700 Audio I/F */
#define	USB_PRODUCT_ROLAND_UMONE	0x012a		/* UM-ONE MIDI I/F */

/* Rockfire products */
#define	USB_PRODUCT_ROCKFIRE_GAMEPAD	0x2033		/* Gamepad 203USB */

/* RT Systems */
#define	USB_PRODUCT_RTSYSTEMS_CT57B	0x9e52		/* CT57B Radio Cable */

/* SACOM products */
#define	USB_PRODUCT_SACOM_USB485BL	0x800d		/* USB-485-BL */

/* Sagem products */
#define	USB_PRODUCT_SAGEM_SERIAL	0x0027		/* Serial */
#define	USB_PRODUCT_SAGEM_XG760A	0x004a		/* XG-760A */
#define	USB_PRODUCT_SAGEM_XG76NA	0x0062		/* XG-76NA */

/* Saitek products */
#define	USB_PRODUCT_SAITEK_CYBORG_3D_GOLD	0x0006		/* Cyborg 3D Gold Joystick */

/* SanDisk products */
#define	USB_PRODUCT_SANDISK_SDDR05A	0x0001		/* ImageMate SDDR-05a */
#define	USB_PRODUCT_SANDISK_SDDR31	0x0002		/* ImageMate SDDR-31 */
#define	USB_PRODUCT_SANDISK_SDDR05	0x0005		/* ImageMate SDDR-05 */
#define	USB_PRODUCT_SANDISK_SDDR12	0x0100		/* ImageMate SDDR-12 */
#define	USB_PRODUCT_SANDISK_SDDR09	0x0200		/* ImageMate SDDR-09 */
#define	USB_PRODUCT_SANDISK_SDDR75	0x0810		/* ImageMate SDDR-75 */

/* Sanwa Supply products */
#define	USB_PRODUCT_SANWASUPPLY_JYDV9USB	0x9806		/* JY-DV9USB gamepad */

/* Sanyo Electric products */
#define	USB_PRODUCT_SANYO_SCP4900	0x0701		/* Sanyo SCP-4900 Phone */

/* Samsung products */
#define	USB_PRODUCT_SAMSUNG_WIS09ABGN	0x2018		/* WIS09ABGN Wireless LAN adapter */
#define	USB_PRODUCT_SAMSUNG2_RT2870_1	0x2018		/* RT2870 */
#define	USB_PRODUCT_SAMSUNG2_ANDROID	0x6881		/* Android */
#define	USB_PRODUCT_SAMSUNG2_ANDROID2	0x6863		/* Android v2 */
#define	USB_PRODUCT_SAMSUNG2_I330	0x8001		/* I330 */
#define	USB_PRODUCT_SAMSUNG_SWL2100W	0xa000		/* SWL-2100U */
#define	USB_PRODUCT_SAMSUNG2_AX88179	0xa100		/* AX88179 */

/* ScanLogic products */
#define	USB_PRODUCT_SCANLOGIC_SL11R	0x0002		/* SL11R-IDE */
#define	USB_PRODUCT_SCANLOGIC_336CX	0x0300		/* Phantom 336CX - C3 */

/* Sealevel products */
#define	USB_PRODUCT_SEALEVEL_2101	0x2101		/* SeaLINK+232 (2101/2105) */
#define	USB_PRODUCT_SEALEVEL_2102	0x2102		/* SeaLINK+485 (2102) */
#define	USB_PRODUCT_SEALEVEL_2103	0x2103		/* SeaLINK+232I (2103) */
#define	USB_PRODUCT_SEALEVEL_2104	0x2104		/* SeaLINK+485I (2104) */
#define	USB_PRODUCT_SEALEVEL_2106	0x9020		/* SeaLINK+422 (2106) */
#define	USB_PRODUCT_SEALEVEL_2201_1	0x2211		/* SeaPORT+2/232 (2201) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2201_2	0x2221		/* SeaPORT+2/232 (2201) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2202_1	0x2212		/* SeaPORT+2/485 (2202) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2202_2	0x2222		/* SeaPORT+2/485 (2202) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2203_1	0x2213		/* SeaPORT+2 (2203) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2203_2	0x2223		/* SeaPORT+2 (2203) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2401_1	0x2411		/* SeaPORT+4/232 (2401) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2401_2	0x2421		/* SeaPORT+4/232 (2401) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2401_3	0x2431		/* SeaPORT+4/232 (2401) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2401_4	0x2441		/* SeaPORT+4/232 (2401) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2402_1	0x2412		/* SeaPORT+4/485 (2402) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2402_2	0x2422		/* SeaPORT+4/485 (2402) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2402_3	0x2432		/* SeaPORT+4/485 (2402) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2402_4	0x2442		/* SeaPORT+4/485 (2402) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2403_1	0x2413		/* SeaPORT+4 (2403) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2403_2	0x2423		/* SeaPORT+4 (2403) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2403_3	0x2433		/* SeaPORT+4 (2403) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2403_4	0x2443		/* SeaPORT+4 (2403) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2801_1	0X2811		/* SeaLINK+8/232 (2801) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2801_2	0X2821		/* SeaLINK+8/232 (2801) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2801_3	0X2831		/* SeaLINK+8/232 (2801) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2801_4	0X2841		/* SeaLINK+8/232 (2801) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2801_5	0X2851		/* SeaLINK+8/232 (2801) Port 5 */
#define	USB_PRODUCT_SEALEVEL_2801_6	0X2861		/* SeaLINK+8/232 (2801) Port 6 */
#define	USB_PRODUCT_SEALEVEL_2801_7	0X2871		/* SeaLINK+8/232 (2801) Port 7 */
#define	USB_PRODUCT_SEALEVEL_2801_8	0X2881		/* SeaLINK+8/232 (2801) Port 8 */
#define	USB_PRODUCT_SEALEVEL_2802_1	0X2812		/* SeaLINK+8/485 (2802) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2802_2	0X2822		/* SeaLINK+8/485 (2802) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2802_3	0X2832		/* SeaLINK+8/485 (2802) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2802_4	0X2842		/* SeaLINK+8/485 (2802) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2802_5	0X2852		/* SeaLINK+8/485 (2802) Port 5 */
#define	USB_PRODUCT_SEALEVEL_2802_6	0X2862		/* SeaLINK+8/485 (2802) Port 6 */
#define	USB_PRODUCT_SEALEVEL_2802_7	0X2872		/* SeaLINK+8/485 (2802) Port 7 */
#define	USB_PRODUCT_SEALEVEL_2802_8	0X2882		/* SeaLINK+8/485 (2802) Port 8 */
#define	USB_PRODUCT_SEALEVEL_2803_1	0X2813		/* SeaLINK+8 (2803) Port 1 */
#define	USB_PRODUCT_SEALEVEL_2803_2	0X2823		/* SeaLINK+8 (2803) Port 2 */
#define	USB_PRODUCT_SEALEVEL_2803_3	0X2833		/* SeaLINK+8 (2803) Port 3 */
#define	USB_PRODUCT_SEALEVEL_2803_4	0X2843		/* SeaLINK+8 (2803) Port 4 */
#define	USB_PRODUCT_SEALEVEL_2803_5	0X2853		/* SeaLINK+8 (2803) Port 5 */
#define	USB_PRODUCT_SEALEVEL_2803_6	0X2863		/* SeaLINK+8 (2803) Port 6 */
#define	USB_PRODUCT_SEALEVEL_2803_7	0X2873		/* SeaLINK+8 (2803) Port 7 */
#define	USB_PRODUCT_SEALEVEL_2803_8	0X2883		/* SeaLINK+8 (2803) Port 8 */

/* Schweitzer Engineering Laboratories */
#define	USB_PRODUCT_SEL_C662	0x0001		/* C662 */

/* Seluxit products */
#define	USB_PRODUCT_SELUXIT_RF	0x0010		/* RF Dongle */

/* Senao products */
#define	USB_PRODUCT_SENAO_RT2870_3	0x0605		/* RT2870 */
#define	USB_PRODUCT_SENAO_RT2870_4	0x0615		/* RT2870 */
#define	USB_PRODUCT_SENAO_NUB8301	0x2000		/* NUB-8301 */
#define	USB_PRODUCT_SENAO_NUB862	0x6100		/* NUB-862 */
#define	USB_PRODUCT_SENAO_RTL8192SU_1	0x9603		/* RTL8192SU */
#define	USB_PRODUCT_SENAO_RTL8192SU_2	0x9605		/* RTL8192SU */
#define	USB_PRODUCT_SENAO_RT2870_1	0x9701		/* RT2870 */
#define	USB_PRODUCT_SENAO_RT2870_2	0x9702		/* RT2870 */
#define	USB_PRODUCT_SENAO_RT3070	0x9703		/* RT3070 */
#define	USB_PRODUCT_SENAO_RT3071	0x9705		/* RT3071 */
#define	USB_PRODUCT_SENAO_RT3072_1	0x9706		/* RT3072 */
#define	USB_PRODUCT_SENAO_RT3072_2	0x9707		/* RT3072 */
#define	USB_PRODUCT_SENAO_RT3072_3	0x9708		/* RT3072 */
#define	USB_PRODUCT_SENAO_RT3072_4	0x9709		/* RT3072 */
#define	USB_PRODUCT_SENAO_RT3072_5	0x9801		/* RT3072 */

/* Serverworks */
#define	USB_PRODUCT_SERVERWORKS_HUB	0x0000		/* Root Hub */

/* SGI products */
#define	USB_PRODUCT_SGI_SN1_L1_SC	0x1234		/* SN1 L1 System Controller */

/* ShanTou products */
#define	USB_PRODUCT_SHANTOU_ST268	0x0268		/* ST268 */
#define	USB_PRODUCT_SHANTOU_DM9620A	0x0269		/* DM9620A */
#define	USB_PRODUCT_SHANTOU_DM9621A	0x1269		/* DM9621A */
#define	USB_PRODUCT_SHANTOU_ZT6688	0x6688		/* ZT6688 */
#define	USB_PRODUCT_SHANTOU_ADM8515	0x8515		/* ADM8515 Ethernet */
#define	USB_PRODUCT_SHANTOU_DM9000E	0x9000		/* DM9000E */
#define	USB_PRODUCT_SHANTOU_DM9601	0x9601		/* DM9601 */
#define	USB_PRODUCT_SHANTOU_DM9620	0x9620		/* DM9620 */
#define	USB_PRODUCT_SHANTOU_DM9621	0x9621		/* DM9621 */
#define	USB_PRODUCT_SHANTOU_DM9622	0x9622		/* DM9622 */

/* Shark products */
#define	USB_PRODUCT_SHARK_PA	0x0400		/* Pocket Adapter */

/* Sharp products */
#define	USB_PRODUCT_SHARP_SL5500	0x8004		/* SL5500 */
#define	USB_PRODUCT_SHARP_A300	0x8005		/* A300 */
#define	USB_PRODUCT_SHARP_SL5600	0x8006		/* SL5600 */
#define	USB_PRODUCT_SHARP_C700	0x8007		/* C700 */
#define	USB_PRODUCT_SHARP_C750	0x9031		/* C750 */

/* Shuttle Technology products */
#define	USB_PRODUCT_SHUTTLE_EUSB	0x0001		/* E-USB Bridge */
#define	USB_PRODUCT_SHUTTLE_EUSCSI	0x0002		/* eUSCSI Bridge */
#define	USB_PRODUCT_SHUTTLE_SDDR09	0x0003		/* ImageMate SDDR09 */
#define	USB_PRODUCT_SHUTTLE_EUSBSMCF	0x0005		/* eUSB SmartMedia / CompactFlash */
#define	USB_PRODUCT_SHUTTLE_ZIOMMC	0x0006		/* eUSB MultiMediaCard */
#define	USB_PRODUCT_SHUTTLE_HIFD	0x0007		/* Sony Hifd */
#define	USB_PRODUCT_SHUTTLE_EUSBATAPI	0x0009		/* eUSB ATA/ATAPI */
#define	USB_PRODUCT_SHUTTLE_CF	0x000a		/* eUSB CompactFlash */
#define	USB_PRODUCT_SHUTTLE_EUSCSI_B	0x000b		/* eUSCSI Bridge */
#define	USB_PRODUCT_SHUTTLE_EUSCSI_C	0x000c		/* eUSCSI Bridge */
#define	USB_PRODUCT_SHUTTLE_CDRW	0x0101		/* CD-RW Device */
#define	USB_PRODUCT_SHUTTLE_SCM	0x1010		/* SCM Micro */

/* Siemens products */
#define	USB_PRODUCT_SIEMENS_SPEEDSTREAM	0x1001		/* SpeedStream */
#define	USB_PRODUCT_SIEMENS_SPEEDSTREAM22	0x1022		/* SpeedStream 1022 */

/* Siemens(2) products */
#define	USB_PRODUCT_SIEMENS2_WLL013	0x001b		/* WLL013 */
#define	USB_PRODUCT_SIEMENS2_ES75	0x0034		/* GSM module MC35 */

/* Siemens(3) products */
#define	USB_PRODUCT_SIEMENS3_SX1	0x0001		/* SX1 */
#define	USB_PRODUCT_SIEMENS3_X65	0x0003		/* X65 */
#define	USB_PRODUCT_SIEMENS3_X75	0x0004		/* X75 */

/* Siemens(4) products */
#define	USB_PRODUCT_SIEMENS4_RUGGEDCOM	0x01ff		/* RUGGEDCOM */

/* Sierra Wireless products */
#define	USB_PRODUCT_SIERRA_EM5625	0x0017		/* EM5625 */
#define	USB_PRODUCT_SIERRA_MC5720	0x0018		/* MC5720 */
#define	USB_PRODUCT_SIERRA_AIRCARD_595	0x0019		/* AirCard 595 */
#define	USB_PRODUCT_SIERRA_MC5725	0x0020		/* MC5725 */
#define	USB_PRODUCT_SIERRA_AC597E	0x0021		/* 597E */
#define	USB_PRODUCT_SIERRA_C597	0x0023		/* Compass 597 */
#define	USB_PRODUCT_SIERRA_AC595U	0x0120		/* 595U */
#define	USB_PRODUCT_SIERRA_AIRCARD_580	0x0112		/* Aircard 580 EVDO */
#define	USB_PRODUCT_SIERRA_MC5720_2	0x0218		/* MC5720 */
#define	USB_PRODUCT_SIERRA_MC5725_2	0x0220		/* MC5725 */
#define	USB_PRODUCT_SIERRA_TRUINSTALL	0x0fff		/* Aircard Tru Installer */
#define	USB_PRODUCT_SIERRA_MC8755_2	0x6802		/* MC8755 */
#define	USB_PRODUCT_SIERRA_MC8765	0x6803		/* MC8765 */
#define	USB_PRODUCT_SIERRA_MC8755	0x6804		/* MC8755 */
#define	USB_PRODUCT_SIERRA_MC8775	0x6812		/* MC8775 */
#define	USB_PRODUCT_SIERRA_MC8755_3	0x6813		/* MC8755 */
#define	USB_PRODUCT_SIERRA_MC8775_2	0x6815		/* MC8775 */
#define	USB_PRODUCT_SIERRA_AIRCARD_875	0x6820		/* 875 */
#define	USB_PRODUCT_SIERRA_MC8780	0x6832		/* MC8780 */
#define	USB_PRODUCT_SIERRA_MC8781	0x6833		/* MC8781 */
#define	USB_PRODUCT_SIERRA_MC8790	0x683c		/* MC8790 */
#define	USB_PRODUCT_SIERRA_AC880	0x6850		/* 880 */
#define	USB_PRODUCT_SIERRA_AC881	0x6851		/* 881 */
#define	USB_PRODUCT_SIERRA_AC880E	0x6852		/* 880E */
#define	USB_PRODUCT_SIERRA_AC881E	0x6853		/* 881E */
#define	USB_PRODUCT_SIERRA_AC880U	0x6855		/* 880U */
#define	USB_PRODUCT_SIERRA_AC881U	0x6856		/* 881U */
#define	USB_PRODUCT_SIERRA_AC885U	0x6880		/* 885U */
#define	USB_PRODUCT_SIERRA_C01SW	0x6890		/* C01SW */
#define	USB_PRODUCT_SIERRA_USB305	0x68a3		/* USB305 */
#define	USB_PRODUCT_SIERRA_MC8355	0x9013		/* MC8355 */
#define	USB_PRODUCT_SIERRA_AIRCARD_340U	0x9051		/* Aircard 340U */
#define	USB_PRODUCT_SIERRA_AIRCARD_770S	0x9053		/* Aircard 770S */
#define	USB_PRODUCT_SIERRA_MC7455	0x9071		/* MC7455 */
#define	USB_PRODUCT_SIERRA_EM7455	0x9079		/* EM7455 */

/* Sigmatel products */
#define	USB_PRODUCT_SIGMATEL_IRDA	0x4200		/* IrDA */
#define	USB_PRODUCT_SIGMATEL_DNSSF7X	0x8020		/* Datum Networks SSF-7X Multi Players */

/* SIIG products */
#define	USB_PRODUCT_SIIG_DIGIFILMREADER	0x0004		/* DigiFilm-Combo */
#define	USB_PRODUCT_SIIG_MULTICARDREADER	0x0201		/* MULTICARDREADER */
#define	USB_PRODUCT_OCT_US2308	0x0421		/* Serial */

/* Silicom products */
#define	USB_PRODUCT_SILICOM_U2E	0x0001		/* U2E */
#define	USB_PRODUCT_SILICOM_GPE	0x0002		/* Psion Dacom Gold Port Ethernet */

/* Silicon Labs products */
#define	USB_PRODUCT_SILABS5_EM358X	0x0002		/* EM358x */
#define	USB_PRODUCT_SILABS_VSTABI	0x0f91		/* VStabi Controller */
#define	USB_PRODUCT_SILABS_ARKHAM_DS101_M	0x1101		/* Arkham DS101 Monitor */
#define	USB_PRODUCT_SILABS_ARKHAM_DS101_A	0x1601		/* Arkham DS101 Adapter */
#define	USB_PRODUCT_SILABS_BSM7DUSB	0x800a		/* BSM7-D-USB */
#define	USB_PRODUCT_SILABS_POLOLU	0x803b		/* Pololu Serial */
#define	USB_PRODUCT_SILABS_SB_PARAMOUNT_ME	0x8043		/* Software Bisque Paramount ME */
#define	USB_PRODUCT_SILABS_CYGNAL_DEBUG	0x8044		/* Cygnal Debug Adapter */
#define	USB_PRODUCT_SILABS_SB_PARAMOUNT_ME2	0x804e		/* Software Bisque Paramount ME */
#define	USB_PRODUCT_SILABS_EDG1228	0x8053		/* EDG1228 */
#define	USB_PRODUCT_SILABS_GSM2228	0x8054		/* Enfora GSM2228 */
#define	USB_PRODUCT_SILABS_ARGUSISP	0x8066		/* Argussoft ISP */
#define	USB_PRODUCT_SILABS_IMS_USB_RS422	0x806f		/* IMS USB-RS422 */
#define	USB_PRODUCT_SILABS_CRUMB128	0x807a		/* Crumb128 */
#define	USB_PRODUCT_SILABS_OPTRIS_MSPRO	0x80c4		/* Optris MSpro LT Thermometer */
#define	USB_PRODUCT_SILABS_DEGREECONT	0x80ca		/* Degree Controls */
#define	USB_PRODUCT_SILABS_TRACIENT	0x80dd		/* Tracient RFID */
#define	USB_PRODUCT_SILABS_TRAQMATE	0x80ed		/* Track Systems Traqmate */
#define	USB_PRODUCT_SILABS_SUUNTO	0x80f6		/* Suunto sports */
#define	USB_PRODUCT_SILABS_ARYGON_MIFARE	0x8115		/* Arygon Mifare RFID reader */
#define	USB_PRODUCT_SILABS_DESKTOPMOBILE	0x813d		/* Burnside Desktop mobile */
#define	USB_PRODUCT_SILABS_TAMSMASTER	0x813f		/* Tams Master Easy Control */
#define	USB_PRODUCT_SILABS_RIGBLASTER	0x814a		/* RIGblaster P&P */
#define	USB_PRODUCT_SILABS_RIGTALK	0x814b		/* RIGtalk */
#define	USB_PRODUCT_SILABS_B_G_H3000	0x8156		/* B&G H3000 Data Cable */
#define	USB_PRODUCT_SILABS_IPLINK1220	0x815e		/* IP-Link 1220 */
#define	USB_PRODUCT_SILABS_HAMLINKUSB	0x815f		/* Timewave HamLinkUSB */
#define	USB_PRODUCT_SILABS_AVIT_USB_TTL	0x818b		/* AVIT Research USB-TTL */
#define	USB_PRODUCT_SILABS_MJS_TOSLINK	0x819f		/* MJS USB-TOSLINK */
#define	USB_PRODUCT_SILABS_WAVIT	0x81a6		/* ThinkOptics WavIt */
#define	USB_PRODUCT_SILABS_MULTIPLEX_RC	0x81a9		/* Multiplex RC adapter */
#define	USB_PRODUCT_SILABS_MSD_DASHHAWK	0x81ac		/* MSD DashHawk */
#define	USB_PRODUCT_SILABS_INSYS_MODEM	0x81ad		/* INSYS Modem */
#define	USB_PRODUCT_SILABS_LIPOWSKY_JTAG	0x81c8		/* Lipowsky Baby-JTAG */
#define	USB_PRODUCT_SILABS_LIPOWSKY_LIN	0x81e2		/* Lipowsky Baby-LIN */
#define	USB_PRODUCT_SILABS_AEROCOMM	0x81e7		/* Aerocomm Radio */
#define	USB_PRODUCT_SILABS_ZEPHYR_BIO	0x81e8		/* Zephyr Bioharness */
#define	USB_PRODUCT_SILABS_EMS_C1007	0x81f2		/* EMS C1007 HF RFID reader */
#define	USB_PRODUCT_SILABS_LIPOWSKY_HARP	0x8218		/* Lipowsky HARP-1 */
#define	USB_PRODUCT_SILABS_C2_EDGE_MODEM	0x822b		/* Commander 2 EDGE(GSM) Modem */
#define	USB_PRODUCT_SILABS_CYGNAL_GPS	0x826b		/* Cygnal Fasttrax GPS */
#define	USB_PRODUCT_SILABS_PLUGDRIVE	0x8281		/* Nanotec Plug & Drive */
#define	USB_PRODUCT_SILABS_TELEGESIS_ETRX2	0x8293		/* Telegesis ETRX2USB */
#define	USB_PRODUCT_SILABS_PROCYON_AVS	0x82f9		/* Procyon AVS */
#define	USB_PRODUCT_SILABS_MC35PU	0x8341		/* MC35pu */
#define	USB_PRODUCT_SILABS_CYGNAL	0x8382		/* Cygnal */
#define	USB_PRODUCT_SILABS_AMBER_AMB2560	0x83a8		/* Amber Wireless AMB2560 */
#define	USB_PRODUCT_SILABS_DEKTEK_DTAPLUS	0x83d8		/* DekTec DTA Plus VHF/UHF Booster */
#define	USB_PRODUCT_SILABS_KYOCERA_GPS	0x8411		/* Kyocera GPS */
#define	USB_PRODUCT_SILABS_IRZ_SG10	0x8418		/* IRZ SG-10 GSM/GPRS Modem */
#define	USB_PRODUCT_SILABS_BEI_VCP	0x846e		/* BEI USB Sensor (VCP) */
#define	USB_PRODUCT_SILABS_BALLUFF_RFID	0x8477		/* Balluff RFID reader */
#define	USB_PRODUCT_SILABS_AC_SERV_IBUS	0x85ea		/* AC-Services IBUS */
#define	USB_PRODUCT_SILABS_AC_SERV_CIS	0x85eb		/* AC-Services CIS-IBUS */
#define	USB_PRODUCT_SILABS_PREON32	0x85f8		/* Virtenio Preon32 */
#define	USB_PRODUCT_SILABS_AC_SERV_CAN	0x8664		/* AC-Services CAN */
#define	USB_PRODUCT_SILABS_AC_SERV_OBD	0x8665		/* AC-Services OBD */
#define	USB_PRODUCT_SILABS_EM357LR	0x8856		/* CEL EM357 LR */
#define	USB_PRODUCT_SILABS_EM357	0x8857		/* CEL EM357 */
#define	USB_PRODUCT_SILABS_MMB_ZIGBEE	0x88a4		/* MMB Networks ZigBee */
#define	USB_PRODUCT_SILABS_PII_ZIGBEE	0x88a5		/* Planet Innovation Ingeni ZigBee */
#define	USB_PRODUCT_SILABS_KETRA_N1	0x8946		/* Ketra N1 */
#define	USB_PRODUCT_SILABS_CELDEVKIT	0x8977		/* CEL MeshWorks DevKit */
#define	USB_PRODUCT_SILABS_KCF_PRN	0x8998		/* KCF Technologies PRN */
#define	USB_PRODUCT_SILABS_HUBZ	0x8a2a		/* HubZ ZigBee/Z-Wave */
#define	USB_PRODUCT_SILABS2_DCU11CLONE	0xaa26		/* DCU-11 clone */
#define	USB_PRODUCT_SILABS_CP210X_1	0xea60		/* CP210x Serial */
#define	USB_PRODUCT_SILABS_CP210X_2	0xea61		/* CP210x Serial */
#define	USB_PRODUCT_SILABS3_GPRS_MODEM	0xea61		/* GPRS Modem */
#define	USB_PRODUCT_SILABS4_100EU_MODEM	0xea6a		/* GPRS Modem 100EU */
#define	USB_PRODUCT_SILABS_CP210X_3	0xea70		/* CP210x Serial */
#define	USB_PRODUCT_SILABS_INFINITY_MIC	0xea71		/* Infinity GPS-MIC-1 */
#define	USB_PRODUCT_SILABS_CP2110	0xea80		/* CP2110 USB HID Serial */
#define	USB_PRODUCT_SILABS_USBSCOPE50	0xf001		/* USBscope50 */
#define	USB_PRODUCT_SILABS_USBWAVE12	0xf002		/* USBwave12 */
#define	USB_PRODUCT_SILABS_USBPULSE100	0xf003		/* USBpulse100 */
#define	USB_PRODUCT_SILABS_USBCOUNT50	0xf004		/* USBcount50 */

/* Silicon Portals Inc. */
#define	USB_PRODUCT_SILICONPORTALS_YAPPH_NF	0x0200		/* YAP Phone (no firmware) */
#define	USB_PRODUCT_SILICONPORTALS_YAPPHONE	0x0201		/* YAP Phone */

/* Sirius Technologies products */
#define	USB_PRODUCT_SIRIUS_ROADSTER	0x0001		/* NetComm Roadster II 56 */

/* Sitecom products */
#define	USB_PRODUCT_SITECOM_LN029	0x182d		/* LN029 */
#define	USB_PRODUCT_SITECOM2_WL022	0x182d		/* WL-022 */
#define	USB_PRODUCT_SITECOM_CN104	0x2068		/* CN104 */

/* Sitecom Europe products */
#define	USB_PRODUCT_SITECOMEU_WL168V1	0x000d		/* WL-168 v1 */
#define	USB_PRODUCT_SITECOMEU_RT2870_1	0x0017		/* RT2870 */
#define	USB_PRODUCT_SITECOMEU_LN030	0x0021		/* LN-030 */
#define	USB_PRODUCT_SITECOMEU_WL168V4	0x0028		/* WL-168 v4 */
#define	USB_PRODUCT_SITECOMEU_RT2870_2	0x002b		/* RT2870 */
#define	USB_PRODUCT_SITECOMEU_RT2870_3	0x002c		/* RT2870 */
#define	USB_PRODUCT_SITECOMEU_WL302	0x002d		/* WL-302 */
#define	USB_PRODUCT_SITECOMEU_WL603	0x0036		/* WL-603 */
#define	USB_PRODUCT_SITECOMEU_WL315	0x0039		/* WL-315 */
#define	USB_PRODUCT_SITECOMEU_WL321	0x003b		/* WL-321 */
#define	USB_PRODUCT_SITECOMEU_RT3070_3	0x003c		/* RT3070 */
#define	USB_PRODUCT_SITECOMEU_WL324	0x003d		/* WL-324 */
#define	USB_PRODUCT_SITECOMEU_WL343	0x003e		/* WL-343 */
#define	USB_PRODUCT_SITECOMEU_WL608	0x003f		/* WL-608 */
#define	USB_PRODUCT_SITECOMEU_WL344	0x0040		/* WL-344 */
#define	USB_PRODUCT_SITECOMEU_WL329	0x0041		/* WL-329 */
#define	USB_PRODUCT_SITECOMEU_WL345	0x0042		/* WL-345 */
#define	USB_PRODUCT_SITECOMEU_WL353	0x0045		/* WL-353 */
#define	USB_PRODUCT_SITECOMEU_RT3072_3	0x0047		/* RT3072 */
#define	USB_PRODUCT_SITECOMEU_RT3072_4	0x0048		/* RT3072 */
#define	USB_PRODUCT_SITECOMEU_WL349V1	0x004b		/* WL-349 v1 */
#define	USB_PRODUCT_SITECOMEU_RT3072_6	0x004d		/* RT3072 */
#define	USB_PRODUCT_SITECOMEU_WL349V4	0x0050		/* WL-349 v4 */
#define	USB_PRODUCT_SITECOMEU_RT3070_1	0x0051		/* RT3070 */
#define	USB_PRODUCT_SITECOMEU_RTL8188CU	0x0052		/* RTL8188CU */
#define	USB_PRODUCT_SITECOMEU_RTL8188CU_2	0x005c		/* RTL8188CU */
#define	USB_PRODUCT_SITECOMEU_RT3072_5	0x005f		/* RT3072 */
#define	USB_PRODUCT_SITECOMEU_WLA4000	0x0060		/* WLA-4000 */
#define	USB_PRODUCT_SITECOMEU_RTL8192CU	0x0061		/* RTL8192CU */
#define	USB_PRODUCT_SITECOMEU_WLA5000	0x0062		/* WLA-5000 */
#define	USB_PRODUCT_SITECOMEU_LN028	0x061c		/* LN-028 */
#define	USB_PRODUCT_SITECOMEU_RTL8192CU_2	0x0070		/* RTL8192CU */
#define	USB_PRODUCT_SITECOMEU_LN032	0x0072		/* LN-032 */
#define	USB_PRODUCT_SITECOMEU_WLA2100V2	0x0077		/* WLA-2100 v2 */
#define	USB_PRODUCT_SITECOMEU_WL113	0x9071		/* WL-113 */
#define	USB_PRODUCT_SITECOMEU_ZD1211B	0x9075		/* ZD1211B */
#define	USB_PRODUCT_SITECOMEU_WL172	0x90ac		/* WL-172 */
#define	USB_PRODUCT_SITECOMEU_WL113R2	0x9712		/* WL-113 rev 2 */

/* Smart Technologies products */
#define	USB_PRODUCT_SMART_PL2303	0x2303		/* Serial */

/* SmartBridges products */
#define	USB_PRODUCT_SMARTBRIDGES_SMARTLINK	0x0001		/* SmartLink Ethernet */
#define	USB_PRODUCT_SMARTBRIDGES_SMARTNIC	0x0003		/* smartNIC 2 PnP */

/* SMC products */
#define	USB_PRODUCT_SMC_2102USB	0x0100		/* 10Mbps Ethernet */
#define	USB_PRODUCT_SMC_2202USB	0x0200		/* 10/100 Ethernet */
#define	USB_PRODUCT_SMC_2206USB	0x0201		/* EZ Connect Ethernet */
#define	USB_PRODUCT_SMC2_2020HUB	0x2020		/* Hub */
#define	USB_PRODUCT_SMC2_2504HUB	0x2504		/* Hub */
#define	USB_PRODUCT_SMC2_2513HUB	0x2513		/* Hub */
#define	USB_PRODUCT_SMC2_SMSC9500	0x9500		/* SMSC9500 */
#define	USB_PRODUCT_SMC2_SMSC9505	0x9505		/* SMSC9505 */
#define	USB_PRODUCT_SMC2_SMSC9500A	0x9e00		/* SMSC9500A */
#define	USB_PRODUCT_SMC2_SMSC9505A	0x9e01		/* SMSC9505A */
#define	USB_PRODUCT_SMC2_SMSC9512_14	0xec00		/* SMSC9512/14 */
#define	USB_PRODUCT_SMC2_SMSC9500_SAL10	0x9900		/* SMSC9500 */
#define	USB_PRODUCT_SMC2_SMSC9505_SAL10	0x9901		/* SMSC9505 */
#define	USB_PRODUCT_SMC2_SMSC9500A_SAL10	0x9902		/* SMSC9500A */
#define	USB_PRODUCT_SMC2_SMSC9505A_SAL10	0x9903		/* SMSC9505A */
#define	USB_PRODUCT_SMC2_SMSC9512_14_SAL10	0x9904		/* SMSC9512/14 */
#define	USB_PRODUCT_SMC2_SMSC9500A_HAL	0x9905		/* SMSC9500A */
#define	USB_PRODUCT_SMC2_SMSC9505A_HAL	0x9906		/* SMSC9505A */
#define	USB_PRODUCT_SMC2_SMSC9500_ALT	0x9907		/* SMSC9500 */
#define	USB_PRODUCT_SMC2_SMSC9500A_ALT	0x9908		/* SMSC9500A */
#define	USB_PRODUCT_SMC2_SMSC9512_14_ALT	0x9909		/* SMSC9512 */
#define	USB_PRODUCT_SMC2_LAN9530	0x9530		/* LAN9530 */
#define	USB_PRODUCT_SMC2_LAN9730	0x9730		/* LAN9730 */
#define	USB_PRODUCT_SMC2_LAN89530	0x9e08		/* LAN89530 */
#define	USB_PRODUCT_SMC3_2662WV1	0xa001		/* EZ Connect 11Mbps */
#define	USB_PRODUCT_SMC3_2662WV2	0xa002		/* EZ Connect 11Mbps v2 */
#define	USB_PRODUCT_SMC_2862WG	0xee13		/* EZ Connect 54Mbps */

/* SOHOware products */
#define	USB_PRODUCT_SOHOWARE_NUB100	0x9100		/* NUB100 Ethernet */
#define	USB_PRODUCT_SOHOWARE_NUB110	0x9110		/* NUB110 Ethernet */

/* SOLID YEAR products */
#define	USB_PRODUCT_SOLIDYEAR_KEYBOARD	0x2101		/* Keyboard */

/* SONY products */
#define	USB_PRODUCT_SONY_DSC	0x0010		/* DSC Cameras */
#define	USB_PRODUCT_SONY_NWMS7	0x0025		/* Memorystick NW-MS7 */
#define	USB_PRODUCT_SONY_DRIVEV2	0x002b		/* Harddrive V2 */
#define	USB_PRODUCT_SONY_MSACUS1	0x002d		/* Memorystick MSAC-US1 */
#define	USB_PRODUCT_SONY_HANDYCAM	0x002e		/* Handycam */
#define	USB_PRODUCT_SONY_MSC	0x0032		/* MSC Memorystick */
#define	USB_PRODUCT_SONY_CLIE_35	0x0038		/* Clie v3.5 */
#define	USB_PRODUCT_SONY_PS2KEYBOARD	0x005c		/* PlayStation2 keyboard */
#define	USB_PRODUCT_SONY_PS2KEYBOARDHUB	0x005d		/* PlayStation2 keyboard hub */
#define	USB_PRODUCT_SONY_PS2MOUSE	0x0061		/* PlayStation2 mouse */
#define	USB_PRODUCT_SONY_CLIE_40	0x0066		/* Clie v4.0 */
#define	USB_PRODUCT_SONY_CLIE_40_MS	0x006d		/* Clie v4.0 Memory Stick */
#define	USB_PRODUCT_SONY_CLIE_S360	0x0095		/* Clie s360 */
#define	USB_PRODUCT_SONY_CLIE_41_MS	0x0099		/* Clie v4.1 Memory Stick */
#define	USB_PRODUCT_SONY_CLIE_41	0x009a		/* Clie v4.1 */
#define	USB_PRODUCT_SONY_CLIE_NX60	0x00da		/* Clie nx60 */
#define	USB_PRODUCT_SONY_CLIE_TJ25	0x0169		/* Clie tj25 */
#define	USB_PRODUCT_SONY_IFU_WLM2	0x0257		/* IFU-WLM2 */
#define	USB_PRODUCT_SONY_CXD9192	0x0279		/* 1seg TV tuner */

/* SOURCENEXT products */
#define	USB_PRODUCT_SOURCENEXT_KEIKAI8	0x039f		/* KeikaiDenwa 8 */
#define	USB_PRODUCT_SOURCENEXT_KEIKAI8_CHG	0x012e		/* KeikaiDenwa 8 with charger */

/* SparkLAN products */
#define	USB_PRODUCT_SPARKLAN_RT2573	0x0004		/* RT2573 */
#define	USB_PRODUCT_SPARKLAN_RT2870_1	0x0006		/* RT2870 */
#define	USB_PRODUCT_SPARKLAN_RT3070	0x0010		/* RT3070 */
#define	USB_PRODUCT_SPARKLAN_RT2870_2	0x0012		/* RT2870 */

/* Speed Dragon Multimedia products */
#define	USB_PRODUCT_SPEEDDRAGON_MS3303H	0x110b		/* MS3303H Serial */

/* Sphairon Access Systems GmbH products */
#define	USB_PRODUCT_SPHAIRON_UB801R	0x0110		/* UB801R */
#define	USB_PRODUCT_SPHAIRON_RTL8187	0x0150		/* RTL8187 */

/* StarTech.com products */
#define	USB_PRODUCT_STARTECH_ICUSB232X	0x3410		/* ICUSB2321X/2X/4X */

/* STMicroelectronics products */
#define	USB_PRODUCT_STMICRO_BIOMETRIC_COPR	0x2016		/* Biometric Coprocessor */
#define	USB_PRODUCT_STMICRO_COMMUNICATOR	0x7554		/* Communicator */

/* Stollmann products */
#define	USB_PRODUCT_STOLLMANN_ISDN_TA_USBA	0x4001		/* ISDN TA+USBA */

/* Strawberry Linux products */
#define	USB_PRODUCT_STRAWBERRYLINUX_USBRH	0x1001		/* USBRH sensor */

/* STSN products */
#define	USB_PRODUCT_STSN_STSN0001	0x0001		/* Internet Access Device */

/* Sun Communications products */
#define	USB_PRODUCT_SUNCOMM_MB_ADAPTOR	0x0003		/* Mobile Adaptor */

/* SUN Corporation products */
#define	USB_PRODUCT_SUNTAC_DS96L	0x0003		/* U-Cable type D2 */
#define	USB_PRODUCT_SUNTAC_PS64P1	0x0005		/* U-Cable type P1 */
#define	USB_PRODUCT_SUNTAC_VS10U	0x0009		/* Slipper U */
#define	USB_PRODUCT_SUNTAC_IS96U	0x000a		/* Ir-Trinity */
#define	USB_PRODUCT_SUNTAC_AS64LX	0x000b		/* U-Cable type A3 */
#define	USB_PRODUCT_SUNTAC_AS144L4	0x0011		/* U-Cable type A4 */

/* SuperTop products */
#define	USB_PRODUCT_SUPERTOP_IDEBRIDGE	0x6600		/* SuperTop IDE Bridge */

/* System TALKS, Inc. */
#define	USB_PRODUCT_SYSTEMTALKS_SGCX2UL	0x1920		/* SGC-X2UL */

/* Supra products */
#define	USB_PRODUCT_DIAMOND2_SUPRAEXPRESS56K	0x07da		/* Supra Express 56K */
#define	USB_PRODUCT_DIAMOND2_SUPRA2890	0x0b4a		/* SupraMax 2890 56K */
#define	USB_PRODUCT_DIAMOND2_RIO600USB	0x5001		/* Rio 600 */
#define	USB_PRODUCT_DIAMOND2_RIO800USB	0x5002		/* Rio 800 */
#define	USB_PRODUCT_DIAMOND2_PSAPLAY120	0x5003		/* Nike psa[play 120 */

/* Surecom Technology products */
#define	USB_PRODUCT_ACERCM_EP1427X2	0x0893		/* EP-1427X-2 Ethernet */
#define	USB_PRODUCT_SURECOM_EP9001G2A	0x11f2		/* EP-9001-G rev 2A */
#define	USB_PRODUCT_SURECOM_RT2570	0x11f3		/* RT2570 */
#define	USB_PRODUCT_SURECOM_RT2573	0x31f3		/* RT2573 */

/* Susteen, Inc. products */
#define	USB_PRODUCT_SUSTEEN_DCU11	0x0528		/* Ericsson DCU-10/11 */

/* Sweex products */
#define	USB_PRODUCT_SWEEX2_LW153	0x0153		/* LW153 */
#define	USB_PRODUCT_SWEEX2_LW154	0x0154		/* LW154 */
#define	USB_PRODUCT_SWEEX2_LW303	0x0302		/* LW303 */
#define	USB_PRODUCT_SWEEX2_LW313	0x0313		/* LW313 */
#define	USB_PRODUCT_SWEEX_ZD1211	0x1809		/* ZD1211 */

/* Syntech Information products */
#define	USB_PRODUCT_SYNTECH_SERIAL	0x0001		/* Serial */
#define	USB_PRODUCT_SYNTECH_CIPHERLAB100	0x1000		/* CipherLab Barcode Scanner */

/* TCT Mobile products */
#define	USB_PRODUCT_TCTMOBILE_UMSM	0x0000		/* Modem mode */
#define	USB_PRODUCT_TCTMOBILE_UMSM_2	0x0017		/* Modem mode */
#define	USB_PRODUCT_TCTMOBILE_UMSM_3	0x011e		/* Modem mode */
#define	USB_PRODUCT_TCTMOBILE_UMASS	0xf000		/* Storage mode */
#define	USB_PRODUCT_TCTMOBILE_UMASS_2	0xf017		/* Storage mode */

/* Tangtop products */
#define	USB_PRODUCT_TANGTOP_USBPS2	0x0001		/* USBPS2 */

/* Taugagreining products */
#define	USB_PRODUCT_TAUGA_CAMERAMATE	0x0005		/* CameraMate (DPCM_USB) */

/* Tapwave products */
#define	USB_PRODUCT_TAPWAVE_ZODIAC	0x0100		/* Zodiac */

/* TDK products */
#define	USB_PRODUCT_TDK_UPA9664	0x0115		/* USB-PDC Adapter UPA9664 */
#define	USB_PRODUCT_TDK_UCA1464	0x0116		/* USB-cdmaOne Adapter UCA1464 */
#define	USB_PRODUCT_TDK_UHA6400	0x0117		/* USB-PHS Adapter UHA6400 */
#define	USB_PRODUCT_TDK_UPA6400	0x0118		/* USB-PHS Adapter UPA6400 */
#define	USB_PRODUCT_TDK_BLUETOOTH	0x0309		/* Bluetooth */

/* TEAC products */
#define	USB_PRODUCT_TEAC_FD05PUB	0x0000		/* FD-05PUB */

/* Tekram Technology products */
#define	USB_PRODUCT_TEKRAM_0193	0x1601		/* ALLNET 0193 WLAN */
#define	USB_PRODUCT_TEKRAM_ZYAIR_B200	0x1602		/* ZyXEL ZyAIR B200 WLAN */
#define	USB_PRODUCT_TEKRAM_U300C	0x1612		/* U-300C */
#define	USB_PRODUCT_TEKRAM_QUICKWLAN	0x1630		/* QuickWLAN */
#define	USB_PRODUCT_TEKRAM_ZD1211_1	0x5630		/* ZD1211 */
#define	USB_PRODUCT_TEKRAM_ZD1211_2	0x6630		/* ZD1211 */

/* Telex Communications products */
#define	USB_PRODUCT_TELEX_MIC1	0x0001		/* Microphone */

/* Tenda */
#define	USB_PRODUCT_TENDA_TWL541U	0x1fab		/* TWL541U WLAN */

/* Ten X Technology, Inc. */
#define	USB_PRODUCT_TENX_MISSILE	0x0202		/* Missile Launcher */
#define	USB_PRODUCT_TENX_TEMPER	0x660c		/* TEMPer sensor */

/* TerraTec Electronic GmbH */
#define	USB_PRODUCT_TERRATEC_AUREON	0x0077		/* Aureon Dual USB */

/* Dream Cheeky */
#define	USB_PRODUCT_DREAMCHEEKY_ROCKETBABY	0x0701		/* Missile Launcher */

/* Integrated System Solution Corp. */
#define	USB_PRODUCT_ISSC_KYBT100	0x1001		/* KY-BT100 Bluetooth */

/* Testo AG products */
#define	USB_PRODUCT_TESTO_175	0x0001		/* 175/177 USB interface */
#define	USB_PRODUCT_TESTO_330	0x0002		/* 330 USB interface */
#define	USB_PRODUCT_TESTO_435	0x0003		/* 435/635/735 USB interface */
#define	USB_PRODUCT_TESTO_845	0x0004		/* 845 USB interface */
#define	USB_PRODUCT_TESTO_SERVICE	0x0005		/* Service adapter */
#define	USB_PRODUCT_TESTO_580	0x0006		/* 580 USB interface */
#define	USB_PRODUCT_TESTO_174	0x0007		/* 174 USB interface */
#define	USB_PRODUCT_TESTO_556	0x0009		/* 556/560 USB interface */
#define	USB_PRODUCT_TESTO_SERIAL_1	0x000a		/* USB adapter */
#define	USB_PRODUCT_TESTO_SERIAL_2	0xf001		/* USB to serial converter */

/* Texas Instruments products */
#define	USB_PRODUCT_TI_UTUSB41	0x1446		/* UT-USB41 hub */
#define	USB_PRODUCT_TI_TUSB2046	0x2046		/* TUSB2046 hub */
#define	USB_PRODUCT_TI_TUSB3410	0x3410		/* TUSB3410 */
#define	USB_PRODUCT_TI_NEXII	0x5409		/* Nex II Digital */
#define	USB_PRODUCT_TI_MSP430_JTAG	0xf430		/* MSP-FET430UIF JTAG */
#define	USB_PRODUCT_TI_MSP430	0xf432		/* MSP-FET430UIF */

/* Thrustmaster products */
#define	USB_PRODUCT_THRUST_FUSION_PAD	0xa0a3		/* Fusion Digital Gamepad */

/* Thurlby Thandar Instruments products */
#define	USB_PRODUCT_THURLBY_QL355P	0x03e8		/* QL355P power supply */

/* The Mobility Lab products */
#define	USB_PRODUCT_TML_SERIAL	0x0064		/* Serial */

/* Todos Data System products */
#define	USB_PRODUCT_TODOS_ARGOS_MINI	0x0002		/* Argos Mini Smartcard */

/* Toradex Inc. */
#define	USB_PRODUCT_TORADEX_RH	0x0001		/* Toradex OAK RH sensor */
#define	USB_PRODUCT_TORADEX_P	0x0002		/* Toradex OAK P sensor */
#define	USB_PRODUCT_TORADEX_LUX	0x0003		/* Toradex OAK LUX sensor */
#define	USB_PRODUCT_TORADEX_TILT	0x0004		/* Toradex OAK Tilt sensor */
#define	USB_PRODUCT_TORADEX_DIST	0x0005		/* Toradex OAK DIST sensor */
#define	USB_PRODUCT_TORADEX_MOVE	0x0006		/* Toradex OAK MOVE sensor */
#define	USB_PRODUCT_TORADEX_4_20	0x0009		/* Toradex OAK 4-20mA sensor */
#define	USB_PRODUCT_TORADEX_G	0x000a		/* Toradex OAK G sensor */
#define	USB_PRODUCT_TORADEX_MAGR	0x000b		/* Toradex OAK MAGR sensor */
#define	USB_PRODUCT_TORADEX_RELAY	0x000d		/* Toradex OAK RELAY */
#define	USB_PRODUCT_TORADEX_10V	0x000e		/* Toradex OAK 10V sensor */
#define	USB_PRODUCT_TORADEX_LN	0x000f		/* Toradex OAK LN sensor */
#define	USB_PRODUCT_TORADEX_IO	0x0010		/* Toradex OAK IO */
#define	USB_PRODUCT_TORADEX_ORIENT	0x0015		/* Toradex ORIENT Tilt sensor */

/* Toshiba Corp products */
#define	USB_PRODUCT_TOSHIBA_RT3070	0x0a07		/* RT3070 */
#define	USB_PRODUCT_TOSHIBA_HSDPA	0x1302		/* HSDPA */

/* TP-Link products */
#define	USB_PRODUCT_TPLINK_RTL8192CU	0x0100		/* RTL8192CU */
#define	USB_PRODUCT_TPLINK_RTL8812AU	0x0101		/* RTL8812AU */

/* Trek Technology products */
#define	USB_PRODUCT_TREK_THUMBDRIVE	0x1111		/* ThumbDrive */
#define	USB_PRODUCT_TREK_THUMBDRIVE_8MB	0x9988		/* ThumbDrive 8MB */

/* TRENDnet products */
#define	USB_PRODUCT_TRENDNET_RTL8192CU	0x624d		/* RTL8192CU */
#define	USB_PRODUCT_TRENDNET_RTL8188CU	0x648b		/* RTL8188CU */

/* Tripp-Lite products */
#define	USB_PRODUCT_TRIPPLITE_U209	0x2008		/* U209 Serial */

/* Trumpion products */
#define	USB_PRODUCT_TRUMPION_T33521	0x1003		/* USB/MP3 decoder */
#define	USB_PRODUCT_TRUMPION_XXX1100	0x1100		/* XXX 1100 */

/* Trust products */
#define	USB_PRODUCT_TRUST_OPTMOUSE	0x0a33		/* Optical Mouse */
#define	USB_PRODUCT_TRUST_MOUSE	0x0a37		/* Mouse */

/* Tsunami products */
#define	USB_PRODUCT_TSUNAMI_SM2000	0x1111		/* SM-2000 */

/* TwinMOS products */
#define	USB_PRODUCT_TWINMOS_G240	0xa006		/* G240 */

/* U-blox AG */
#define	USB_PRODUCT_UBLOX_ANTARIS4	0x01a4		/* ANTARIS4 GPS */

/* U-MEDIA Communications products */
#define	USB_PRODUCT_UMEDIA_TEW444UBEU	0x3006		/* TEW-444UB EU */
#define	USB_PRODUCT_UMEDIA_TEW444UBEU_NF	0x3007		/* TEW-444UB EU */
#define	USB_PRODUCT_UMEDIA_TEW429UB_A	0x300a		/* TEW-429UB_A */
#define	USB_PRODUCT_UMEDIA_TEW429UB	0x300b		/* TEW-429UB */
#define	USB_PRODUCT_UMEDIA_TEW429UBC1	0x300d		/* TEW-429UB C1 */
#define	USB_PRODUCT_UMEDIA_RT2870_1	0x300e		/* RT2870 */
#define	USB_PRODUCT_UMEDIA_TEW645UB	0x3013		/* TEW-645UB */
#define	USB_PRODUCT_UMEDIA_ALL0298V2	0x3204		/* ALL0298 v2 */
#define	USB_PRODUCT_UMEDIA_AR5523_2	0x3205		/* AR5523 */
#define	USB_PRODUCT_UMEDIA_AR5523_2_NF	0x3206		/* AR5523 */

/* Ultima products */
#define	USB_PRODUCT_ULTIMA_1200UBPLUS	0x4002		/* 1200 UB Plus */

/* UMAX products */
#define	USB_PRODUCT_UMAX_ASTRA1236U	0x0002		/* Astra 1236U */
#define	USB_PRODUCT_UMAX_ASTRA1220U	0x0010		/* Astra 1220U */
#define	USB_PRODUCT_UMAX_ASTRA2000U	0x0030		/* Astra 2000U */
#define	USB_PRODUCT_UMAX_ASTRA2100U	0x0130		/* Astra 2100U */
#define	USB_PRODUCT_UMAX_ASTRA2200U	0x0230		/* Astra 2200U */
#define	USB_PRODUCT_UMAX_ASTRA3400	0x0060		/* Astra 3400 */

/* Universal Access products */
#define	USB_PRODUCT_UNIACCESS_PANACHE	0x0101		/* Panache Surf ISDN */

/* Unknown vendor 2 */
#define	USB_PRODUCT_UNKNOWN2_ZD1211B	0x0105		/* ZD1211B */
#define	USB_PRODUCT_UNKNOWN2_NW3100	0x145f		/* NW-3100 */

/* Unknown vendor 3 */
#define	USB_PRODUCT_UNKNOWN3_ZD1211B	0x1233		/* ZD1211B */

/* Unknown vendor 4 */
#define	USB_PRODUCT_UNKNOWN4_DM9601	0x8101		/* DM9601 */
#define	USB_PRODUCT_UNKNOWN4_RD9700	0x9700		/* RD9700 */

/* Unknown vendor 5 */
#define	USB_PRODUCT_UNKNOWN5_NF_RIC	0x0001		/* NF RIC */

/* Unknown vendor 6 */
#define	USB_PRODUCT_UNKNOWN6_DM9601	0x9601		/* DM9601 */

/* U.S. Robotics products */
#define	USB_PRODUCT_USR_USR1120	0x00eb		/* USR1120 WLAN */
#define	USB_PRODUCT_USR_MILLER_A	0x00f1		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_MILLER_A_NF	0x00f2		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_HEINEKEN_A	0x00f5		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_HEINEKEN_A_NF	0x00f6		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_HEINEKEN_B	0x00f7		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_HEINEKEN_B_NF	0x00f8		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_MILLER_B	0x00f9		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_MILLER_B_NF	0x00fa		/* USR9000 SureConnect ADSL */
#define	USB_PRODUCT_USR_USR5422	0x0118		/* USR5422 WLAN */
#define	USB_PRODUCT_USR_USR5421A	0x011b		/* USR5421A WLAN */
#define	USB_PRODUCT_USR_USR5423	0x0121		/* USR5423 WLAN */

/* USI products */
#define	USB_PRODUCT_USI_MC60	0x10c5		/* MC60 Serial */

/* Validity Sensors products */
#define	USB_PRODUCT_VALIDITY_VFS101	0x0001		/* VFS101 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS301	0x0005		/* VFS301 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS451	0x0007		/* VFS451 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS300	0x0008		/* VFS300 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS5011	0x0011		/* VFS5011 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS5011_2	0x0017		/* VFS5011 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS5011_3	0x0018		/* VFS5011 Fingerprint Reader */
#define	USB_PRODUCT_VALIDITY_VFS5471	0x003c		/* VFS471 Fingerprint Reader */

/* Van Ooijen Technische Informatica products */
#define	USB_PRODUCT_VOTI_SELETEK_1	0x09b0		/* Lunatico Seletek */
#define	USB_PRODUCT_VOTI_SELETEK_2	0x09b1		/* Lunatico Seletek */

/* Velleman products */
#define	USB_PRODUCT_VELLEMAN_K8055	0x5500		/* K8055 USB Experiment interface board */

/* Vertex Wireless products */
#define	USB_PRODUCT_VERTEX_VW110L	0x0100		/* VW110L */

/* VIA products */
#define	USB_PRODUCT_VIA_AR9271	0x3801		/* AR9271 */

/* ViewSonic products */
#define	USB_PRODUCT_VIEWSONIC_G773HUB	0x00fe		/* G773 Monitor Hub */
#define	USB_PRODUCT_VIEWSONIC_P815HUB	0x00ff		/* P815 Monitor Hub */
#define	USB_PRODUCT_VIEWSONIC_AIRSYNC	0x0f01		/* Airsync */
#define	USB_PRODUCT_VIEWSONIC_G773CTRL	0x4153		/* G773 Monitor Control */

/* Vision products */
#define	USB_PRODUCT_VISION_VC6452V002	0x0002		/* CPiA Camera */

/* Visioneer products */
#define	USB_PRODUCT_VISIONEER_7600	0x0211		/* OneTouch 7600 */
#define	USB_PRODUCT_VISIONEER_5300	0x0221		/* OneTouch 5300 */
#define	USB_PRODUCT_VISIONEER_3000	0x0224		/* Scanport 3000 */
#define	USB_PRODUCT_VISIONEER_6100	0x0231		/* OneTouch 6100 */
#define	USB_PRODUCT_VISIONEER_6200	0x0311		/* OneTouch 6200 */
#define	USB_PRODUCT_VISIONEER_8100	0x0321		/* OneTouch 8100 */
#define	USB_PRODUCT_VISIONEER_8600	0x0331		/* OneTouch 8600 */

/* Vivitar products */
#define	USB_PRODUCT_VIVITAR_DSC350	0x0003		/* DSC350 */

/* VTech products */
#define	USB_PRODUCT_VTECH_RT2570	0x3012		/* RT2570 */
#define	USB_PRODUCT_VTECH_ZD1211B	0x3014		/* ZD1211B */

/* Option products */
#define	USB_PRODUCT_OPTION_VODAFONEMC3G	0x5000		/* Vodafone Mobile Connect 3G */
#define	USB_PRODUCT_OPTION_GT3GFUSION	0x6000		/* GlobeTrotter 3G FUSION */
#define	USB_PRODUCT_OPTION_GT3GQUAD	0x6300		/* GlobeTrotter 3G QUAD */
#define	USB_PRODUCT_OPTION_GT3GQUADPLUS	0x6600		/* GlobeTrotter 3G QUAD PLUS */
#define	USB_PRODUCT_OPTION_GTMAX36	0x6701		/* GlobeTrotter MAX 3.6/7.2 */
#define	USB_PRODUCT_OPTION_GT3GPLUS	0x6721		/* GlobeTrotter 3G PLUS */
#define	USB_PRODUCT_OPTION_SCORPION	0x6901		/* GlobeTrotter HSDPA Modem */
#define	USB_PRODUCT_OPTION_GSICON72	0x6911		/* GlobeSurfer iCON 7.2 */
#define	USB_PRODUCT_OPTION_ICON225	0x6971		/* iCON 225 */
#define	USB_PRODUCT_OPTION_GTHSUPA380E	0x7211		/* GlobeTrotter HSUPA 380E */
#define	USB_PRODUCT_OPTION_ICON322	0xd033		/* iCON 322 */
#define	USB_PRODUCT_OPTION_ICON505	0xd055		/* iCON 505 */

/* Vaisala Products */
#define	USB_PRODUCT_VAISALA_USBINSTCABLE	0x0200		/* USB instrument cable */

/* WCH/QinHeng Electronics */
#define	USB_PRODUCT_WCH_CH341	0x5523		/* CH341 serial/parallel */
#define	USB_PRODUCT_WCH2_CH341A	0x5523		/* CH341A serial/parallel */
#define	USB_PRODUCT_WCH2_CH340	0x7523		/* CH340 serial/parallel */

/* Wacom products */
#define	USB_PRODUCT_WACOM_CT0405U	0x0000		/* CT-0405-U Tablet */
#define	USB_PRODUCT_WACOM_GRAPHIRE	0x0010		/* Graphire */
#define	USB_PRODUCT_WACOM_GRAPHIRE3_4X5	0x0013		/* Graphire3 4x5 */
#define	USB_PRODUCT_WACOM_GRAPHIRE4_4X5	0x0015		/* Graphire4 Classic A6 */
#define	USB_PRODUCT_WACOM_INTUOSA5	0x0021		/* Intuos A5 */
#define	USB_PRODUCT_WACOM_INTUOS_DRAW	0x033b		/* Intuos Draw (CTL-490) */

/* WAGO Kontakttechnik products */
#define	USB_PRODUCT_WAGO_SERVICECABLE	0x07a6		/* Service Cable 750-923 */

/* WaveSense products */
#define	USB_PRODUCT_WAVESENSE_JAZZ	0xaaaa		/* Jazz blood glucose meter */

/* West Mountain Radio products */
#define	USB_PRODUCT_WMR_RIGBLASTER	0x0003		/* RIGblaster */

/* WIENER Plein & Baus products */
#define	USB_PRODUCT_WIENERPLEINBAUS_PL512	0x0010		/* PL512 PSU */
#define	USB_PRODUCT_WIENERPLEINBAUS_RCM	0x0011		/* RCM Remote Control */
#define	USB_PRODUCT_WIENERPLEINBAUS_MPOD	0x0012		/* MPOD PSU */
#define	USB_PRODUCT_WIENERPLEINBAUS_CML	0x0015		/* CML Data Logger */

/* Wistron NeWeb products */
#define	USB_PRODUCT_WISTRONNEWEB_WNC0600	0x0326		/* WNC-0600USB */
#define	USB_PRODUCT_WISTRONNEWEB_UR045G	0x0427		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_WISTRONNEWEB_UR055G	0x0711		/* UR055G */
#define	USB_PRODUCT_WISTRONNEWEB_O8494	0x0804		/* ORiNOCO 802.11n */
#define	USB_PRODUCT_WISTRONNEWEB_AR5523_1	0x0826		/* AR5523 */
#define	USB_PRODUCT_WISTRONNEWEB_AR5523_1_NF	0x0827		/* AR5523 */
#define	USB_PRODUCT_WISTRONNEWEB_AR5523_2	0x082a		/* AR5523 */
#define	USB_PRODUCT_WISTRONNEWEB_AR5523_2_NF	0x0829		/* AR5523 */

/* XIRING products */
#define	USB_PRODUCT_XIRING_XIMAX	0x0005		/* Ximax CDC */

/* Xirlink products */
#define	USB_PRODUCT_XIRLINK_IMAGING	0x800d		/* Imaging Device */
#define	USB_PRODUCT_XIRLINK_PCCAM	0x8080		/* IBM PC Camera */

/* Xyratex products */
#define	USB_PRODUCT_XYRATEX_PRISM_GT_1	0x2000		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_XYRATEX_PRISM_GT_2	0x2002		/* PrismGT USB 2.0 WLAN */

/* Y.C. Cable products */
#define	USB_PRODUCT_YCCABLE_PL2303	0x0fba		/* PL2303 Serial */

/* Y-E Data products */
#define	USB_PRODUCT_YEDATA_FLASHBUSTERU	0x0000		/* Flashbuster-U */

/* Yamaha products */
#define	USB_PRODUCT_YAMAHA_UR22	0x1509		/* UR22 */
#define	USB_PRODUCT_YAMAHA_UX256	0x1000		/* UX256 MIDI I/F */
#define	USB_PRODUCT_YAMAHA_UX96	0x1008		/* UX96 MIDI I/F */
#define	USB_PRODUCT_YAMAHA_RPU200	0x3104		/* RP-U200 */
#define	USB_PRODUCT_YAMAHA_RTA54I	0x4000		/* NetVolante RTA54i */
#define	USB_PRODUCT_YAMAHA_RTW65B	0x4001		/* NetVolante RTW65b */
#define	USB_PRODUCT_YAMAHA_RTW65I	0x4002		/* NetVolante RTW65i */
#define	USB_PRODUCT_YAMAHA_RTA55I	0x4004		/* NetVolante RTA55i */

/* Yano products */
#define	USB_PRODUCT_YANO_U640MO	0x0101		/* U640MO-03 */

/* Yubico products */
#define	USB_PRODUCT_YUBICO_YUBIKEY	0x0010		/* Yubikey */

/* Z-Com products */
#define	USB_PRODUCT_ZCOM_M4Y750	0x0001		/* M4Y-750 */
#define	USB_PRODUCT_ZCOM_XI725	0x0002		/* XI-725/726 */
#define	USB_PRODUCT_ZCOM_XI735	0x0005		/* XI-735 */
#define	USB_PRODUCT_ZCOM_MD40900	0x0006		/* MD40900 */
#define	USB_PRODUCT_ZCOM_XG703A	0x0008		/* PrismGT USB 2.0 WLAN */
#define	USB_PRODUCT_ZCOM_ZD1211	0x0011		/* ZD1211 */
#define	USB_PRODUCT_ZCOM_AR5523	0x0012		/* AR5523 */
#define	USB_PRODUCT_ZCOM_AR5523_NF	0x0013		/* AR5523 */
#define	USB_PRODUCT_ZCOM_ZD1211B	0x001a		/* ZD1211B */
#define	USB_PRODUCT_ZCOM_RT2870_1	0x0022		/* RT2870 */
#define	USB_PRODUCT_ZCOM_UB81	0x0023		/* UB81 */
#define	USB_PRODUCT_ZCOM_RT2870_2	0x0025		/* RT2870 */
#define	USB_PRODUCT_ZCOM_UB82	0x0026		/* UB82 */

/* Zinwell products */
#define	USB_PRODUCT_ZINWELL_RT2570	0x0260		/* RT2570 */
#define	USB_PRODUCT_ZINWELL_RT2870_1	0x0280		/* RT2870 */
#define	USB_PRODUCT_ZINWELL_RT2870_2	0x0282		/* RT2870 */
#define	USB_PRODUCT_ZINWELL_RT3072_1	0x0283		/* RT3072 */
#define	USB_PRODUCT_ZINWELL_RT3072_2	0x0284		/* RT3072 */
#define	USB_PRODUCT_ZINWELL_RT3070	0x5257		/* RT3070 */

/* Zoom Telephonics, Inc. products */
#define	USB_PRODUCT_ZOOM_2986L	0x9700		/* 2986L Fax Modem */

/* ZyDAS Technology products */
#define	USB_PRODUCT_ZYDAS_ZD1201	0x1201		/* ZD1201 */
#define	USB_PRODUCT_ZYDAS_ZD1211	0x1211		/* ZD1211 */
#define	USB_PRODUCT_ZYDAS_ZD1211B	0x1215		/* ZD1211B */
#define	USB_PRODUCT_ZYDAS_ZD1221	0x1221		/* ZD1221 */
#define	USB_PRODUCT_ZYDAS_ALL0298	0xa211		/* ALL0298 */
#define	USB_PRODUCT_ZYDAS_ZD1211B_2	0xb215		/* ZD1211B */

/* ZyXEL Communication Co. products */
#define	USB_PRODUCT_ZYXEL_OMNI56K	0x1500		/* Omni 56K Plus */
#define	USB_PRODUCT_ZYXEL_980N	0x2011		/* Scorpion-980N */
#define	USB_PRODUCT_ZYXEL_G220	0x3401		/* G-220 */
#define	USB_PRODUCT_ZYXEL_G220F	0x3402		/* G-220F */
#define	USB_PRODUCT_ZYXEL_G200V2	0x3407		/* G-200 v2 */
#define	USB_PRODUCT_ZYXEL_AG225H	0x3409		/* AG-225H */
#define	USB_PRODUCT_ZYXEL_M202	0x340a		/* M-202 */
#define	USB_PRODUCT_ZYXEL_G270S	0x340c		/* G-270S */
#define	USB_PRODUCT_ZYXEL_G220V2	0x340f		/* G-220 v2 */
#define	USB_PRODUCT_ZYXEL_G202	0x3410		/* G-202 */
#define	USB_PRODUCT_ZYXEL_AG220	0x3412		/* AG-220 */
#define	USB_PRODUCT_ZYXEL_AG225HV2	0x3413		/* AG-225H v2 */
#define	USB_PRODUCT_ZYXEL_RT2573	0x3415		/* RT2573 */
#define	USB_PRODUCT_ZYXEL_RT2870_1	0x3416		/* RT2870 */
#define	USB_PRODUCT_ZYXEL_NWD271N	0x3417		/* NWD-271N */
#define	USB_PRODUCT_ZYXEL_NWD211AN	0x3418		/* NWD-211AN */
#define	USB_PRODUCT_ZYXEL_RT2870_2	0x341a		/* RT2870 */
#define	USB_PRODUCT_ZYXEL_NWD2105	0x341e		/* NWD2105 */
#define	USB_PRODUCT_ZYXEL_RTL8192CU	0x341f		/* RTL8192CU */
#define	USB_PRODUCT_ZYXEL_RT3070	0x343e		/* RT3070 */
#define	USB_PRODUCT_ZYXEL_PRESTIGE	0x401a		/* Prestige */
